/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.test;

import hep.aida.IAnalysisFactory;
import hep.aida.ICloud1D;
import hep.aida.ICloud2D;
import hep.aida.IHistogramFactory;
import hep.aida.ITree;
import hep.aida.test.AidaTestCase;
import hep.aida.test.TestAnnotation;
import hep.aida.test.TestCloud;
import hep.aida.test.TestFitter;
import hep.aida.test.TestFunctions;
import hep.aida.test.TestHistogram;
import hep.aida.test.TestHistogramFitting;
import hep.aida.test.TestHistogramMath;
import hep.aida.test.TestHistogramSlices;
import hep.aida.test.TestPAW;
import hep.aida.test.TestPathNameTitleConvention;
import hep.aida.test.TestProfile;
import hep.aida.test.TestRoot;
import hep.aida.test.TestSaveRestoreXML;
import hep.aida.test.TestTree;
import hep.aida.test.TestTreeFactory;
import hep.aida.test.TestTuple;
import hep.aida.test.TestXML;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class AIDATestSuite
extends AidaTestCase {
    private TestSuite suite = (TestSuite)AIDATestSuite.suite();
    private static ICloud1D c1;
    private static ICloud2D c2;
    private static ITree tree;

    public AIDATestSuite(String testName) {
        super(testName);
    }

    static ICloud2D cloud2d() {
        return c2;
    }

    static ICloud1D cloud1d() {
        return c1;
    }

    static void commitTree() {
        try {
            tree.commit();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.getMessage());
        }
    }

    private TestSuite getSuite() {
        return this.suite;
    }

    private AidaTestCase getTest(String testName) {
        for (int i = 0; i < this.getSuite().testCount(); ++i) {
            TestSuite testSuite = (TestSuite)this.getSuite().testAt(i);
            for (int j = 0; j < testSuite.testCount(); ++j) {
                AidaTestCase test = (AidaTestCase)testSuite.testAt(j);
                if (!test.getName().equals(testName)) continue;
                return test;
            }
        }
        return null;
    }

    public static void main(String[] args) {
        int nRuns = 1;
        String[] files = null;
        if (args.length != 0) {
            if (args[0].equals("nRuns")) {
                if (args.length != 2) {
                    throw new RuntimeException("Need two arguments: nRuns followed by the number of times the tests have to be ran.");
                }
                nRuns = Integer.parseInt(args[1]);
            } else {
                files = args;
            }
        }
        if (nRuns <= 0) {
            throw new RuntimeException("Negative number of runs!! nRuns cannot be negative!!");
        }
        Vector errors = new Vector();
        Vector failures = new Vector();
        long startRun = System.currentTimeMillis();
        boolean printStat = false;
        int numberOfTests = 0;
        for (int k = 0; k < nRuns; ++k) {
            numberOfTests = 0;
            AIDATestSuite aidaTestSuite = new AIDATestSuite("AIDATestSuite");
            if (args.length == 0) {
                TestRunner.run((Test)aidaTestSuite.getSuite());
                continue;
            }
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    String fileName = files[i];
                    String testName = fileName.substring(0, fileName.indexOf("_"));
                    try {
                        BufferedReader in = new BufferedReader(new FileReader(fileName));
                        String seedS = in.readLine();
                        long seed = Long.parseLong(seedS);
                        AidaTestCase test = aidaTestSuite.getTest(testName);
                        test.setRandomSeed(seed);
                        TestRunner.run((Test)test);
                        continue;
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe.getMessage());
                    }
                }
                continue;
            }
            printStat = true;
            int run = k + 1;
            System.out.print(run + " ");
            for (int i = 0; i < aidaTestSuite.getSuite().testCount(); ++i) {
                TestSuite testSuite = (TestSuite)aidaTestSuite.getSuite().testAt(i);
                for (int j = 0; j < testSuite.testCount(); ++j) {
                    Enumeration e;
                    TestResult testResult = new TestResult();
                    AidaTestCase test = (AidaTestCase)testSuite.testAt(j);
                    ++numberOfTests;
                    test.run(testResult);
                    System.out.print(".");
                    if (testResult.errorCount() <= 0 && testResult.failureCount() <= 0) continue;
                    if (testResult.errorCount() > 0) {
                        e = testResult.errors();
                        while (e.hasMoreElements()) {
                            System.out.print("E");
                            errors.add(e.nextElement());
                        }
                    } else {
                        e = testResult.failures();
                        while (e.hasMoreElements()) {
                            System.out.print("F");
                            failures.add(e.nextElement());
                        }
                    }
                    test.saveRandomSeed();
                }
            }
            System.out.println();
        }
        if (printStat) {
            long endRun = System.currentTimeMillis();
            double totTime = (double)(endRun - startRun) / 1000.0;
            System.out.println("\nDone running.");
            System.out.println("Number of runs : " + nRuns + "  with " + numberOfTests + "  test per run");
            System.out.println("Total number of errors    : " + errors.size());
            System.out.println("Total numbero of failures : " + failures.size());
            System.out.println("Time                      : " + totTime + " sec.");
            if (errors.size() > 0) {
                System.out.println("\n**** Errors ****");
                for (int i = 0; i < errors.size(); ++i) {
                    System.out.println("--" + i + "--");
                    ((TestFailure)errors.get(i)).thrownException().printStackTrace(System.out);
                }
            }
            if (failures.size() > 0) {
                System.out.println("\n**** Failures ****");
                for (int i = 0; i < failures.size(); ++i) {
                    System.out.println("--" + i + "--");
                    ((TestFailure)failures.get(i)).thrownException().printStackTrace(System.out);
                }
            }
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(){

            protected void tearDown() {
                System.out.println("********** Tearing down the test suite ");
            }
        };
        suite.addTestSuite(TestTreeFactory.class);
        suite.addTestSuite(TestAnnotation.class);
        suite.addTestSuite(TestHistogram.class);
        suite.addTestSuite(TestHistogramMath.class);
        suite.addTestSuite(TestHistogramSlices.class);
        suite.addTestSuite(TestProfile.class);
        suite.addTestSuite(TestCloud.class);
        suite.addTestSuite(TestFunctions.class);
        suite.addTestSuite(TestFitter.class);
        suite.addTestSuite(TestPathNameTitleConvention.class);
        suite.addTestSuite(TestTree.class);
        suite.addTestSuite(TestSaveRestoreXML.class);
        if (System.getProperty("hep.aida.test.data") != null) {
            suite.addTestSuite(TestXML.class);
            suite.addTestSuite(TestPAW.class);
            suite.addTestSuite(TestRoot.class);
        } else {
            System.err.println("WARNING: Some tests skipped because hep.aida.test.data not set");
        }
        suite.addTestSuite(TestTuple.class);
        suite.addTestSuite(TestHistogramFitting.class);
        return suite;
    }

    static {
        IAnalysisFactory af = IAnalysisFactory.create();
        try {
            tree = af.createTreeFactory().create("test.aida", "xml", false, true);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.getMessage());
        }
        IHistogramFactory hf = af.createHistogramFactory(tree);
        c1 = hf.createCloud1D("c1");
        c2 = hf.createCloud2D("c2");
    }
}

