/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.test;

import hep.aida.IAnnotation;
import hep.aida.IAxis;
import hep.aida.IBaseHistogram;
import hep.aida.ICloud;
import hep.aida.ICloud1D;
import hep.aida.ICloud2D;
import hep.aida.ICloud3D;
import hep.aida.IDataPoint;
import hep.aida.IDataPointSet;
import hep.aida.IHistogram;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.IManagedObject;
import hep.aida.IMeasurement;
import hep.aida.IProfile;
import hep.aida.IProfile1D;
import hep.aida.IProfile2D;
import hep.aida.ITuple;
import hep.aida.test.AIDATestSuite;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;

public abstract class AidaTestCase
extends TestCase {
    private Random rnd;
    private long rndSeed = System.currentTimeMillis();
    private static double doublePrecision;
    private static float floatPrecision;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$hep$aida$ITuple;
    static /* synthetic */ Class class$java$lang$Object;

    AidaTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.rnd = new Random(this.rndSeed);
    }

    protected void saveRandomSeed() {
        File outFile = new File(this.getName() + "_" + System.currentTimeMillis() + ".seed");
        try {
            FileWriter out = new FileWriter(outFile);
            out.write(String.valueOf(this.rndSeed));
            out.close();
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
    }

    protected void setRandomSeed(long seed) {
        this.rndSeed = seed;
    }

    protected Random getRandomNumberGenerator() {
        return this.rnd;
    }

    static void assertEquals(IManagedObject obj1, IManagedObject obj2) {
        AidaTestCase.assertEquals((String)obj1.name(), (String)obj2.name());
    }

    static void assertEquals(IBaseHistogram h1, IBaseHistogram h2) {
        if (h1 instanceof IManagedObject && h2 instanceof IManagedObject) {
            AidaTestCase.assertEquals((IManagedObject)h1, (IManagedObject)h2);
        }
        AidaTestCase.assertEquals((int)h1.dimension(), (int)h2.dimension());
        AidaTestCase.assertEquals((String)h1.title(), (String)h2.title());
        AidaTestCase.assertEquals((int)h1.entries(), (int)h2.entries());
        AidaTestCase.assertEquals(h1.annotation(), h2.annotation());
    }

    static void assertEquals(IHistogram h1, IHistogram h2) {
        AidaTestCase.assertEquals((IBaseHistogram)h1, (IBaseHistogram)h2);
        AidaTestCase.assertEquals((int)h1.allEntries(), (int)h2.allEntries());
        AidaTestCase.assertEquals((int)h1.extraEntries(), (int)h2.extraEntries());
        AidaTestCase.assertEqualsDouble(h1.sumBinHeights(), h2.sumBinHeights(), h1.sumBinHeights());
        AidaTestCase.assertEqualsDouble(h1.sumExtraBinHeights(), h2.sumExtraBinHeights(), h1.sumExtraBinHeights());
        AidaTestCase.assertEqualsDouble(h1.sumAllBinHeights(), h2.sumAllBinHeights(), h1.sumAllBinHeights());
        AidaTestCase.assertEqualsDouble(h1.minBinHeight(), h2.minBinHeight(), h1.minBinHeight());
        AidaTestCase.assertEqualsDouble(h1.maxBinHeight(), h2.maxBinHeight(), h1.maxBinHeight());
    }

    static void assertEquals(IHistogram1D h1, IHistogram1D h2) {
        AidaTestCase.assertEquals((IHistogram)h1, (IHistogram)h2);
        AidaTestCase.assertEquals(h1.axis(), h2.axis());
        int bins = h1.axis().bins();
        for (int i = -2; i < bins; ++i) {
            double orderX = i == -2 ? Math.abs(h1.axis().binUpperEdge(i)) : Math.abs(h1.axis().binLowerEdge(i));
            if (orderX == 0.0) {
                orderX = h1.axis().binWidth(i);
            }
            AidaTestCase.assertEqualsDouble(h1.binMean(i), h2.binMean(i), orderX, h1.binEntries(i));
            AidaTestCase.assertEqualsDouble(h1.binHeight(i), h2.binHeight(i), h1.binHeight(i));
            AidaTestCase.assertEqualsDouble(h1.binError(i), h2.binError(i), h1.binError(i));
            AidaTestCase.assertEquals((int)h1.binEntries(i), (int)h2.binEntries(i));
        }
        AidaTestCase.assertEqualsDouble(h1.mean(), h2.mean(), h1.rms(), h1.entries());
        AidaTestCase.assertEqualsDouble(h1.rms(), h2.rms(), h1.rms(), h1.entries());
    }

    static void assertEquals(IHistogram2D h1, IHistogram2D h2) {
        AidaTestCase.assertEquals((IHistogram)h1, (IHistogram)h2);
        AidaTestCase.assertEquals(h1.xAxis(), h2.xAxis());
        AidaTestCase.assertEquals(h1.yAxis(), h2.yAxis());
        int xbins = h1.xAxis().bins();
        int ybins = h1.yAxis().bins();
        for (int i = -2; i < xbins; ++i) {
            AidaTestCase.assertEquals((int)h1.binEntriesX(i), (int)h2.binEntriesX(i));
            AidaTestCase.assertEqualsDouble(h1.binHeightX(i), h2.binHeightX(i), h1.binHeightX(i));
            for (int j = -2; j < ybins; ++j) {
                double orderY;
                double orderX;
                if (i == 0) {
                    AidaTestCase.assertTrue((h1.binEntriesY(j) == h2.binEntriesY(j) ? 1 : 0) != 0);
                    AidaTestCase.assertEqualsDouble(h1.binHeightY(j), h2.binHeightY(j), h1.binHeightY(j));
                }
                if ((orderX = i == -2 ? Math.abs(h1.xAxis().binUpperEdge(i)) : Math.abs(h1.xAxis().binLowerEdge(i))) == 0.0) {
                    orderX = h1.xAxis().binWidth(i);
                }
                if ((orderY = j == -2 ? Math.abs(h1.yAxis().binUpperEdge(j)) : Math.abs(h1.yAxis().binLowerEdge(j))) == 0.0) {
                    orderY = h1.yAxis().binWidth(j);
                }
                AidaTestCase.assertEqualsDouble(h1.binMeanX(i, j), h2.binMeanX(i, j), orderX, h1.binEntries(i, j));
                AidaTestCase.assertEqualsDouble(h1.binMeanY(i, j), h2.binMeanY(i, j), orderY, h1.binEntries(i, j));
                AidaTestCase.assertEqualsDouble(h1.binHeight(i, j), h2.binHeight(i, j), h1.binHeight(i, j));
                AidaTestCase.assertEqualsDouble(h1.binError(i, j), h2.binError(i, j), h1.binError(i, j));
                AidaTestCase.assertTrue((h1.binEntries(i, j) == h2.binEntries(i, j) ? 1 : 0) != 0);
            }
        }
        AidaTestCase.assertEqualsDouble(h1.meanX(), h2.meanX(), h1.rmsX(), h1.entries());
        AidaTestCase.assertEqualsDouble(h1.rmsX(), h2.rmsX(), h1.rmsX(), h1.entries());
        AidaTestCase.assertEqualsDouble(h1.meanY(), h2.meanY(), h1.rmsY(), h1.entries());
        AidaTestCase.assertEqualsDouble(h1.rmsY(), h2.rmsY(), h1.rmsY(), h1.entries());
    }

    static void assertEquals(IHistogram3D h1, IHistogram3D h2) {
        AidaTestCase.assertEquals((IHistogram)h1, (IHistogram)h2);
        AidaTestCase.assertEquals(h1.xAxis(), h2.xAxis());
        AidaTestCase.assertEquals(h1.yAxis(), h2.yAxis());
        AidaTestCase.assertEquals(h1.zAxis(), h2.zAxis());
        AidaTestCase.assertEqualsDouble(h1.meanX(), h2.meanX(), h1.rmsX(), h1.entries());
        AidaTestCase.assertEqualsDouble(h1.rmsX(), h2.rmsX(), h1.rmsX(), h1.entries());
        AidaTestCase.assertEqualsDouble(h1.meanY(), h2.meanY(), h1.rmsY(), h1.entries());
        AidaTestCase.assertEqualsDouble(h1.rmsY(), h2.rmsY(), h1.rmsY(), h1.entries());
        AidaTestCase.assertEqualsDouble(h1.meanZ(), h2.meanZ(), h1.rmsZ(), h1.entries());
        AidaTestCase.assertEqualsDouble(h1.rmsZ(), h2.rmsZ(), h1.rmsZ(), h1.entries());
        int xbins = h1.xAxis().bins();
        int ybins = h1.yAxis().bins();
        int zbins = h1.zAxis().bins();
        for (int i = -2; i < xbins; ++i) {
            AidaTestCase.assertTrue((h1.binEntriesX(i) == h2.binEntriesX(i) ? 1 : 0) != 0);
            AidaTestCase.assertEqualsDouble(h1.binHeightX(i), h2.binHeightX(i), h1.binHeightX(i));
            for (int j = -2; j < ybins; ++j) {
                if (i == 0) {
                    AidaTestCase.assertTrue((h1.binEntriesY(j) == h2.binEntriesY(j) ? 1 : 0) != 0);
                    AidaTestCase.assertEqualsDouble(h1.binHeightY(j), h2.binHeightY(j), h1.binHeightY(j));
                }
                for (int k = -2; k < zbins; ++k) {
                    double orderZ;
                    double orderY;
                    double orderX;
                    if (i == 0 && j == 0) {
                        AidaTestCase.assertTrue((h1.binEntriesZ(k) == h2.binEntriesZ(k) ? 1 : 0) != 0);
                        AidaTestCase.assertEqualsDouble(h1.binHeightZ(k), h2.binHeightZ(k), h1.binHeightZ(k));
                    }
                    if ((orderX = i == -2 ? Math.abs(h1.xAxis().binUpperEdge(i)) : Math.abs(h1.xAxis().binLowerEdge(i))) == 0.0) {
                        orderX = h1.xAxis().binWidth(i);
                    }
                    if ((orderY = j == -2 ? Math.abs(h1.yAxis().binUpperEdge(j)) : Math.abs(h1.yAxis().binLowerEdge(j))) == 0.0) {
                        orderY = h1.yAxis().binWidth(j);
                    }
                    if ((orderZ = k == -2 ? Math.abs(h1.zAxis().binUpperEdge(k)) : Math.abs(h1.zAxis().binLowerEdge(k))) == 0.0) {
                        orderZ = h1.zAxis().binWidth(k);
                    }
                    AidaTestCase.assertEqualsDouble(h1.binMeanX(i, j, k), h2.binMeanX(i, j, k), orderX, h1.binEntries(i, j, k));
                    AidaTestCase.assertEqualsDouble(h1.binMeanY(i, j, k), h2.binMeanY(i, j, k), orderY, h1.binEntries(i, j, k));
                    AidaTestCase.assertEqualsDouble(h1.binMeanZ(i, j, k), h2.binMeanZ(i, j, k), orderZ, h1.binEntries(i, j, k));
                    AidaTestCase.assertEqualsDouble(h1.binHeight(i, j, k), h2.binHeight(i, j, k), h1.binHeight(i, j, k));
                    AidaTestCase.assertEqualsDouble(h1.binError(i, j, k), h2.binError(i, j, k), h1.binError(i, j, k));
                    AidaTestCase.assertEquals((int)h1.binEntries(i, j, k), (int)h2.binEntries(i, j, k));
                }
            }
        }
    }

    static void assertEquals(IAxis a1, IAxis a2) {
        AidaTestCase.assertEquals((int)a1.bins(), (int)a2.bins());
        AidaTestCase.assertTrue((a1.lowerEdge() == a2.lowerEdge() ? 1 : 0) != 0);
        AidaTestCase.assertTrue((a1.upperEdge() == a2.upperEdge() ? 1 : 0) != 0);
        int bins = a1.bins();
        for (int i = 0; i < bins; ++i) {
            AidaTestCase.assertEqualsDouble(a1.binLowerEdge(i), a2.binLowerEdge(i), a2.binLowerEdge(i));
            AidaTestCase.assertEqualsDouble(a1.binUpperEdge(i), a2.binUpperEdge(i), a2.binUpperEdge(i));
            AidaTestCase.assertEqualsDouble(a1.binWidth(i), a2.binWidth(i), a2.binWidth(i), 2);
        }
    }

    static void assertEquals(IAnnotation a1, IAnnotation a2) {
        if (a1 != null && a2 != null) {
            int size = a1.size();
            AidaTestCase.assertEquals((int)size, (int)a2.size());
            for (int i = 0; i < size; ++i) {
                String key = a1.key(i);
                AidaTestCase.assertEquals((String)key, (String)a2.key(i));
                AidaTestCase.assertEquals((String)a1.value(i), (String)a2.value(i));
                AidaTestCase.assertEquals((String)a1.value(key), (String)a2.value(key));
            }
        } else {
            AidaTestCase.assertTrue((boolean)false);
        }
    }

    static void assertEquals(ITuple t1, ITuple t2) {
        if (t1 instanceof IManagedObject && t2 instanceof IManagedObject) {
            AidaTestCase.assertEquals((IManagedObject)t1, (IManagedObject)t2);
        }
        AidaTestCase.assertEquals((String)t1.title(), (String)t2.title());
        AidaTestCase.assertEquals((int)t1.rows(), (int)t2.rows());
        AidaTestCase.assertEquals((int)t1.columns(), (int)t2.columns());
        int columns = t1.columns();
        for (int i = 0; i < columns; ++i) {
            AidaTestCase.assertEquals((String)t1.columnName(i), (String)t2.columnName(i));
            AidaTestCase.assertEquals((String)t1.columnType(i).getName(), (String)t2.columnType(i).getName());
            AidaTestCase.assertEqualsDouble(t1.columnMin(i), t2.columnMin(i), 1.0);
            AidaTestCase.assertEqualsDouble(t1.columnMax(i), t2.columnMax(i), 1.0);
            double order = t1.columnRms(i);
            if (Double.isNaN(order) || Double.isInfinite(order)) {
                order = Math.abs(t1.columnMax(i) - t1.columnMin(i));
            }
            AidaTestCase.assertEqualsDouble(t1.columnMean(i), t2.columnMean(i), order, t1.rows());
            AidaTestCase.assertEqualsDouble(t1.columnRms(i), t2.columnRms(i), t1.columnRms(i), t1.rows());
        }
        t1.start();
        t2.start();
        int countRows = 0;
        while (t1.next() && t2.next()) {
            ++countRows;
            for (int i = 0; i < columns; ++i) {
                Class colType = t1.columnType(i);
                if (colType == Integer.TYPE) {
                    AidaTestCase.assertTrue((t1.getInt(i) == t2.getInt(i) ? 1 : 0) != 0);
                    continue;
                }
                if (colType == Short.TYPE) {
                    AidaTestCase.assertTrue((t1.getShort(i) == t2.getShort(i) ? 1 : 0) != 0);
                    continue;
                }
                if (colType == Long.TYPE) {
                    AidaTestCase.assertTrue((t1.getLong(i) == t2.getLong(i) ? 1 : 0) != 0);
                    continue;
                }
                if (colType == Float.TYPE) {
                    AidaTestCase.assertTrue((t1.getFloat(i) == t2.getFloat(i) ? 1 : 0) != 0);
                    continue;
                }
                if (colType == Double.TYPE) {
                    AidaTestCase.assertTrue((t1.getDouble(i) == t2.getDouble(i) ? 1 : 0) != 0);
                    continue;
                }
                if (colType == Boolean.TYPE) {
                    AidaTestCase.assertTrue((t1.getBoolean(i) == t2.getBoolean(i) ? 1 : 0) != 0);
                    continue;
                }
                if (colType == Byte.TYPE) {
                    AidaTestCase.assertTrue((t1.getByte(i) == t2.getByte(i) ? 1 : 0) != 0);
                    continue;
                }
                if (colType == Character.TYPE) {
                    AidaTestCase.assertTrue((t1.getChar(i) == t2.getChar(i) ? 1 : 0) != 0);
                    continue;
                }
                if (colType == (class$java$lang$String == null ? AidaTestCase.class$("java.lang.String") : class$java$lang$String)) {
                    AidaTestCase.assertEquals((String)t1.getString(i), (String)t2.getString(i));
                    continue;
                }
                if (colType == (class$hep$aida$ITuple == null ? AidaTestCase.class$("hep.aida.ITuple") : class$hep$aida$ITuple)) {
                    AidaTestCase.assertEquals((ITuple)t1.getObject(i), (ITuple)t2.getObject(i));
                    continue;
                }
                if (colType != (class$java$lang$Object == null ? AidaTestCase.class$("java.lang.Object") : class$java$lang$Object)) continue;
                AidaTestCase.assertEquals((Object)t1.getObject(i), (Object)t2.getObject(i));
            }
        }
        AidaTestCase.assertEquals((int)countRows, (int)t1.rows());
    }

    static void assertEquals(ICloud c1, ICloud c2) {
        AidaTestCase.assertEquals((IBaseHistogram)c1, (IBaseHistogram)c2);
        AidaTestCase.assertEqualsDouble(c1.sumOfWeights(), c2.sumOfWeights(), 1.0, c1.entries());
        AidaTestCase.assertEquals((boolean)c1.isConverted(), (boolean)c2.isConverted());
    }

    static void assertEquals(ICloud1D c1, ICloud1D c2) {
        AidaTestCase.assertEquals((ICloud)c1, (ICloud)c2);
        AidaTestCase.assertTrue((c1.lowerEdge() == c2.lowerEdge() ? 1 : 0) != 0);
        AidaTestCase.assertTrue((c1.upperEdge() == c2.upperEdge() ? 1 : 0) != 0);
        AidaTestCase.assertEqualsDouble(c1.mean(), c2.mean(), c1.rms(), c1.entries());
        AidaTestCase.assertEqualsDouble(c1.rms(), c2.rms(), c1.rms(), c1.entries());
        IHistogram1D h1 = null;
        IHistogram1D h2 = null;
        try {
            h1 = c1.histogram();
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        try {
            h2 = c2.histogram();
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        if (h1 != null && h2 != null) {
            AidaTestCase.assertEquals(h1, h2);
        } else if (h1 == null && h2 == null) {
            int entries = c1.entries();
            for (int i = 0; i < entries; ++i) {
                AidaTestCase.assertTrue((c1.value(i) == c2.value(i) ? 1 : 0) != 0);
                AidaTestCase.assertTrue((c1.weight(i) == c2.weight(i) ? 1 : 0) != 0);
            }
        } else {
            AidaTestCase.assertTrue((boolean)false);
        }
    }

    static void assertEquals(ICloud2D c1, ICloud2D c2) {
        AidaTestCase.assertEquals((ICloud)c1, (ICloud)c2);
        AidaTestCase.assertTrue((c1.lowerEdgeX() == c2.lowerEdgeX() ? 1 : 0) != 0);
        AidaTestCase.assertTrue((c1.upperEdgeX() == c2.upperEdgeX() ? 1 : 0) != 0);
        AidaTestCase.assertTrue((c1.lowerEdgeY() == c2.lowerEdgeY() ? 1 : 0) != 0);
        AidaTestCase.assertTrue((c1.upperEdgeY() == c2.upperEdgeY() ? 1 : 0) != 0);
        AidaTestCase.assertEqualsDouble(c1.meanX(), c2.meanX(), c1.rmsX(), c1.entries());
        AidaTestCase.assertEqualsDouble(c1.rmsX(), c2.rmsX(), c1.rmsX(), c1.entries());
        AidaTestCase.assertEqualsDouble(c1.meanY(), c2.meanY(), c1.rmsY(), c1.entries());
        AidaTestCase.assertEqualsDouble(c1.rmsY(), c2.rmsY(), c1.rmsY(), c1.entries());
        IHistogram2D h1 = null;
        IHistogram2D h2 = null;
        try {
            h1 = c1.histogram();
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        try {
            h2 = c2.histogram();
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        if (h1 != null && h2 != null) {
            AidaTestCase.assertEquals(h1, h2);
        } else if (h1 == null && h2 == null) {
            int entries = c1.entries();
            for (int i = 0; i < entries; ++i) {
                AidaTestCase.assertTrue((c1.valueX(i) == c2.valueX(i) ? 1 : 0) != 0);
                AidaTestCase.assertTrue((c1.valueY(i) == c2.valueY(i) ? 1 : 0) != 0);
                AidaTestCase.assertTrue((c1.weight(i) == c2.weight(i) ? 1 : 0) != 0);
            }
        } else {
            AidaTestCase.assertTrue((boolean)false);
        }
    }

    static void assertEquals(ICloud3D c1, ICloud3D c2) {
        AidaTestCase.assertEquals((ICloud)c1, (ICloud)c2);
        AidaTestCase.assertTrue((c1.lowerEdgeX() == c2.lowerEdgeX() ? 1 : 0) != 0);
        AidaTestCase.assertTrue((c1.upperEdgeX() == c2.upperEdgeX() ? 1 : 0) != 0);
        AidaTestCase.assertTrue((c1.lowerEdgeY() == c2.lowerEdgeY() ? 1 : 0) != 0);
        AidaTestCase.assertTrue((c1.upperEdgeY() == c2.upperEdgeY() ? 1 : 0) != 0);
        AidaTestCase.assertTrue((c1.lowerEdgeZ() == c2.lowerEdgeZ() ? 1 : 0) != 0);
        AidaTestCase.assertTrue((c1.upperEdgeZ() == c2.upperEdgeZ() ? 1 : 0) != 0);
        AidaTestCase.assertEqualsDouble(c1.meanX(), c2.meanX(), c1.rmsX(), c1.entries());
        AidaTestCase.assertEqualsDouble(c1.rmsX(), c2.rmsX(), c1.rmsX(), c1.entries());
        AidaTestCase.assertEqualsDouble(c1.meanY(), c2.meanY(), c1.rmsY(), c1.entries());
        AidaTestCase.assertEqualsDouble(c1.rmsY(), c2.rmsY(), c1.rmsY(), c1.entries());
        AidaTestCase.assertEqualsDouble(c1.meanZ(), c2.meanZ(), c1.rmsZ(), c1.entries());
        AidaTestCase.assertEqualsDouble(c1.rmsZ(), c2.rmsZ(), c1.rmsZ(), c1.entries());
        IHistogram3D h1 = null;
        IHistogram3D h2 = null;
        try {
            h1 = c1.histogram();
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        try {
            h2 = c2.histogram();
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        if (h1 != null && h2 != null) {
            AidaTestCase.assertEquals(h1, h2);
        } else if (h1 == null && h2 == null) {
            int entries = c1.entries();
            for (int i = 0; i < entries; ++i) {
                AidaTestCase.assertTrue((c1.valueX(i) == c2.valueX(i) ? 1 : 0) != 0);
                AidaTestCase.assertTrue((c1.valueY(i) == c2.valueY(i) ? 1 : 0) != 0);
                AidaTestCase.assertTrue((c1.valueZ(i) == c2.valueZ(i) ? 1 : 0) != 0);
                AidaTestCase.assertTrue((c1.weight(i) == c2.weight(i) ? 1 : 0) != 0);
            }
        } else {
            AidaTestCase.assertTrue((boolean)false);
        }
    }

    static void assertEquals(IProfile p1, IProfile p2) {
        AidaTestCase.assertEquals((IBaseHistogram)p1, (IBaseHistogram)p2);
        AidaTestCase.assertEquals((int)p1.allEntries(), (int)p2.allEntries());
        AidaTestCase.assertEquals((int)p1.extraEntries(), (int)p2.extraEntries());
        AidaTestCase.assertEqualsDouble(p1.sumBinHeights(), p2.sumBinHeights(), p1.sumBinHeights());
        AidaTestCase.assertEqualsDouble(p1.sumExtraBinHeights(), p2.sumExtraBinHeights(), p1.sumExtraBinHeights());
        AidaTestCase.assertEqualsDouble(p1.sumAllBinHeights(), p2.sumAllBinHeights(), p1.sumAllBinHeights());
        AidaTestCase.assertEqualsDouble(p1.minBinHeight(), p2.minBinHeight(), p2.minBinHeight());
        AidaTestCase.assertEqualsDouble(p1.maxBinHeight(), p2.maxBinHeight(), p2.maxBinHeight());
    }

    static void assertEquals(IProfile1D p1, IProfile1D p2) {
        AidaTestCase.assertEquals((IProfile)p1, (IProfile)p2);
        AidaTestCase.assertEquals(p1.axis(), p2.axis());
        int bins = p1.axis().bins();
        for (int i = -2; i < bins; ++i) {
            AidaTestCase.assertEqualsDouble(p1.binMean(i), p2.binMean(i), p1.binRms(i), p1.binEntries(i));
            AidaTestCase.assertEqualsDouble(p1.binHeight(i), p2.binHeight(i), p1.binHeight(i));
            AidaTestCase.assertEqualsDouble(p1.binError(i), p2.binError(i), p1.binError(i));
            AidaTestCase.assertEqualsDouble(p1.binRms(i), p2.binRms(i), p1.axis().binWidth(i), p1.binEntries(i));
            AidaTestCase.assertEquals((int)p1.binEntries(i), (int)p2.binEntries(i));
        }
        AidaTestCase.assertEqualsDouble(p1.mean(), p2.mean(), p1.rms(), p1.entries());
        AidaTestCase.assertEqualsDouble(p1.rms(), p2.rms(), p1.rms(), p1.entries());
    }

    static void assertEquals(IProfile2D p1, IProfile2D p2) {
        AidaTestCase.assertEquals((IProfile)p1, (IProfile)p2);
        AidaTestCase.assertEquals(p1.xAxis(), p2.xAxis());
        AidaTestCase.assertEquals(p1.yAxis(), p2.yAxis());
        int xbins = p1.xAxis().bins();
        int ybins = p1.yAxis().bins();
        for (int i = -2; i < xbins; ++i) {
            AidaTestCase.assertEquals((int)p1.binEntriesX(i), (int)p2.binEntriesX(i));
            AidaTestCase.assertEqualsDouble(p1.binHeightX(i), p2.binHeightX(i), p1.binHeightX(i));
            for (int j = -2; j < ybins; ++j) {
                if (i == 0) {
                    AidaTestCase.assertTrue((p1.binEntriesY(j) == p2.binEntriesY(j) ? 1 : 0) != 0);
                    AidaTestCase.assertEqualsDouble(p1.binHeightY(j), p2.binHeightY(j), p1.binHeightY(j));
                }
                AidaTestCase.assertEqualsDouble(p1.binMeanX(i, j), p2.binMeanX(i, j), p1.binRms(i, j), p1.binEntries(i, j));
                AidaTestCase.assertEqualsDouble(p1.binMeanY(i, j), p2.binMeanY(i, j), p1.binRms(i, j), p1.binEntries(i, j));
                AidaTestCase.assertEqualsDouble(p1.binHeight(i, j), p2.binHeight(i, j), p1.binHeight(i, j));
                AidaTestCase.assertEqualsDouble(p1.binError(i, j), p2.binError(i, j), p1.binError(i, j));
                AidaTestCase.assertEqualsDouble(p1.binRms(i, j), p2.binRms(i, j), p1.binRms(i, j), p1.binEntries(i, j));
                AidaTestCase.assertTrue((p1.binEntries(i, j) == p2.binEntries(i, j) ? 1 : 0) != 0);
            }
        }
        AidaTestCase.assertEqualsDouble(p1.meanX(), p2.meanX(), p1.rmsX(), p1.entries());
        AidaTestCase.assertEqualsDouble(p1.rmsX(), p2.rmsX(), p1.rmsX(), p1.entries());
        AidaTestCase.assertEqualsDouble(p1.meanY(), p2.meanY(), p1.rmsY(), p1.entries());
        AidaTestCase.assertEqualsDouble(p1.rmsY(), p2.rmsY(), p1.rmsY(), p1.entries());
    }

    static void assertEquals(IDataPointSet d1, IDataPointSet d2) {
        if (d1 instanceof IManagedObject && d2 instanceof IManagedObject) {
            AidaTestCase.assertEquals((IManagedObject)d1, (IManagedObject)d2);
        }
        AidaTestCase.assertEquals(d1.annotation(), d2.annotation());
        AidaTestCase.assertEquals((String)d1.title(), (String)d2.title());
        AidaTestCase.assertEquals((int)d1.dimension(), (int)d2.dimension());
        AidaTestCase.assertEquals((int)d1.size(), (int)d2.size());
        for (int i = 0; i < d1.size(); ++i) {
            AidaTestCase.assertEquals(d1.point(i), d2.point(i));
            for (int j = 0; j < d1.dimension(); ++j) {
                AidaTestCase.assertEqualsDouble(d1.lowerExtent(j), d2.lowerExtent(j), 0.0);
                AidaTestCase.assertEqualsDouble(d1.upperExtent(j), d2.upperExtent(j), 0.0);
            }
        }
    }

    static void assertEquals(IDataPoint p1, IDataPoint p2) {
        AidaTestCase.assertEquals((int)p1.dimension(), (int)p2.dimension());
        for (int i = 0; i < p1.dimension(); ++i) {
            AidaTestCase.assertEquals(p1.coordinate(i), p2.coordinate(i));
        }
    }

    static void assertEquals(IMeasurement m1, IMeasurement m2) {
        AidaTestCase.assertEqualsDouble(m1.value(), m2.value(), 0.0);
        AidaTestCase.assertEqualsDouble(m1.errorPlus(), m2.errorPlus(), 0.0);
        AidaTestCase.assertEqualsDouble(m1.errorMinus(), m2.errorMinus(), 0.0);
    }

    static void assertEqualsDouble(double v1, double v2, double orderOfAddend) {
        AidaTestCase.assertEqualsDouble(v1, v2, orderOfAddend, 1, 1.0);
    }

    static void assertEqualsDouble(double v1, double v2, double orderOfAddend, int numberOfSums) {
        AidaTestCase.assertEqualsDouble(v1, v2, orderOfAddend, numberOfSums, 1.0);
    }

    static void assertEqualsFloat(float v1, float v2, float orderOfAddend) {
        AidaTestCase.assertEqualsFloat(v1, v2, orderOfAddend, 1);
    }

    static void assertEqualsFloat(float v1, float v2, float orderOfAddend, int numberOfSums) {
        AidaTestCase.assertEqualsFloat(v1, v2, orderOfAddend, numberOfSums, 1.0f);
    }

    static void assertEqualsFloat(float v1, float v2, float orderOfAddend, int numberOfSums, float orderOfDividend) {
        if (v1 == v2) {
            return;
        }
        if (Float.isNaN(v1) && Float.isNaN(v2)) {
            return;
        }
        AidaTestCase.assertTrue((!(Float.isNaN(v1) && !Float.isNaN(v2) || !Float.isNaN(v1) && Float.isNaN(v2)) ? 1 : 0) != 0);
        if (Float.isInfinite(orderOfAddend) || Float.isNaN(orderOfAddend)) {
            throw new IllegalArgumentException("Incorrect value for orderOfAddend");
        }
        if (Float.isInfinite(numberOfSums) || Float.isNaN(numberOfSums)) {
            throw new IllegalArgumentException("Incorrect value for numberOfSums");
        }
        if (Float.isInfinite(orderOfDividend) || Float.isNaN(orderOfDividend)) {
            throw new IllegalArgumentException("Incorrect value for orderOfDividend");
        }
        if (orderOfAddend == 0.0f) {
            orderOfAddend = 1.0f;
        }
        float delta = Math.abs(floatPrecision * orderOfAddend * (float)numberOfSums / orderOfDividend);
        float actualdelta = Math.abs(v1 - v2);
        float r = delta / actualdelta;
        AIDATestSuite.cloud1d().fill((double)delta);
        AIDATestSuite.cloud2d().fill((double)delta, (double)v1);
        if ((double)r < 0.01) {
            AidaTestCase.assertTrue((String)("\nassertEqualsFloat: Allowed Delta <" + delta + "> Actual Delta <" + (v1 - v2) + "> \nassertEqualsDouble: " + numberOfSums + " " + orderOfAddend + " " + orderOfDividend), (boolean)false);
        }
    }

    static void assertEqualsDouble(double v1, double v2, double orderOfAddend, int numberOfSums, double orderOfDividend) {
        if (v1 == v2) {
            return;
        }
        if (Double.isNaN(v1) && Double.isNaN(v2)) {
            return;
        }
        AidaTestCase.assertTrue((!(Double.isNaN(v1) && !Double.isNaN(v2) || !Double.isNaN(v1) && Double.isNaN(v2)) ? 1 : 0) != 0);
        if (Double.isInfinite(orderOfAddend) || Double.isNaN(orderOfAddend)) {
            throw new IllegalArgumentException("Incorrect value for orderOfAddend");
        }
        if (Double.isInfinite(numberOfSums) || Double.isNaN(numberOfSums)) {
            throw new IllegalArgumentException("Incorrect value for numberOfSums");
        }
        if (Double.isInfinite(orderOfDividend) || Double.isNaN(orderOfDividend)) {
            throw new IllegalArgumentException("Incorrect value for orderOfDividend");
        }
        if (orderOfAddend == 0.0) {
            orderOfAddend = 1.0;
        }
        double delta = Math.abs(doublePrecision * orderOfAddend * (double)numberOfSums / orderOfDividend);
        double actualdelta = Math.abs(v1 - v2);
        double r = delta / actualdelta;
        AIDATestSuite.cloud1d().fill(delta);
        AIDATestSuite.cloud2d().fill(delta, v1);
        if (r < 0.01) {
            AidaTestCase.assertTrue((String)("\nassertEqualsDouble: Allowed Delta <" + delta + "> Actual Delta <" + (v1 - v2) + "> \nassertEqualsDouble: " + numberOfSums + " " + orderOfAddend + " " + orderOfDividend), (boolean)false);
        }
    }

    static {
        double dstart;
        double tol = dstart = 1.0;
        while (tol + dstart != dstart) {
            tol /= 2.0;
        }
        doublePrecision = tol;
        float fstart = 1.0f;
        float ftol = 0.0f;
        ftol = fstart;
        while (ftol + fstart != fstart) {
            ftol /= 2.0f;
        }
        floatPrecision = ftol;
    }
}

