/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.test;

import hep.aida.IAnalysisFactory;
import hep.aida.IAnnotation;
import hep.aida.IHistogram1D;
import hep.aida.IHistogramFactory;
import hep.aida.test.AidaTestCase;

public class TestAnnotation
extends AidaTestCase {
    private int numberOfItems = 4;
    private String[] keys = new String[]{"key0", "key1", "key2", "key3"};
    private String[] vals = new String[]{"val0", "val1", "val2", "val3"};
    private boolean[] sticky = new boolean[]{true, true, false, false};

    public TestAnnotation(String testName) {
        super(testName);
    }

    public void testAnnotation() {
        int i;
        IAnalysisFactory af = IAnalysisFactory.create();
        IHistogramFactory histogramFactory = null;
        histogramFactory = af.createHistogramFactory(af.createTreeFactory().create());
        IHistogram1D h1 = histogramFactory.createHistogram1D("hist", 10, -1.0, 1.0);
        IHistogram1D h2 = histogramFactory.createHistogram1D("hist", 10, -1.0, 1.0);
        IHistogram1D h3 = histogramFactory.createHistogram1D("hist", 10, -1.0, 1.0);
        IAnnotation an1 = h1.annotation();
        IAnnotation an2 = h2.annotation();
        IAnnotation an3 = h3.annotation();
        int numberOfDefaultKeys = an1.size();
        TestAnnotation.assertEquals((int)1, (int)numberOfDefaultKeys);
        an1.value("Title");
        String[] defaultKeys = new String[numberOfDefaultKeys];
        for (i = 0; i < this.numberOfItems; ++i) {
            an1.addItem(this.keys[i], this.vals[i], this.sticky[i]);
            if (!this.sticky[i]) {
                an2.addItem(this.keys[i], this.vals[i]);
                an3.addItem(this.keys[i], this.vals[i]);
                continue;
            }
            an2.addItem(this.keys[i], this.vals[i], this.sticky[i]);
        }
        TestAnnotation.assertEquals((int)an1.size(), (int)(this.numberOfItems + numberOfDefaultKeys));
        for (i = 0; i < this.numberOfItems; ++i) {
            TestAnnotation.assertEquals((String)an1.key(i + numberOfDefaultKeys), (String)this.keys[i]);
            TestAnnotation.assertEquals((String)an1.value(i + numberOfDefaultKeys), (String)this.vals[i]);
            TestAnnotation.assertEquals((String)an1.value(i + numberOfDefaultKeys), (String)an1.value(this.keys[i]));
        }
        an3.reset();
        for (i = 0; i < this.numberOfItems; ++i) {
            an3.addItem(this.keys[i], this.vals[i], this.sticky[i]);
        }
        TestAnnotation.assertEquals(an1, an2);
        TestAnnotation.assertEquals(an1, an3);
    }
}

