/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.test;

import hep.aida.IAnalysisFactory;
import hep.aida.IFunction;
import hep.aida.IFunctionFactory;
import hep.aida.IHistogram1D;
import hep.aida.IHistogramFactory;
import hep.aida.IModelFunction;
import hep.aida.ITree;
import hep.aida.ITreeFactory;
import hep.aida.test.AidaTestCase;
import java.util.Random;

public class TestFunctions
extends AidaTestCase {
    IAnalysisFactory analysisFactory = null;
    ITreeFactory treeFactory = null;
    ITree tree = null;
    IHistogramFactory histogramFactory = null;
    IFunctionFactory functionFactory = null;
    String newName = null;
    IHistogram1D h = null;
    IModelFunction f1 = null;
    IModelFunction f2 = null;
    boolean debug = true;
    int nEntries = 0;
    int xBins = 0;
    int nRep = 0;
    double xmin = 0.0;
    double xmax = 0.0;
    double ymin = 0.0;
    double ymax = 0.0;
    double[] var = null;
    double[] par = null;
    Random r = null;

    public TestFunctions(String testName) {
        super(testName);
    }

    public void testTestFunctions1D() {
        String type = null;
        this.r = this.getRandomNumberGenerator();
        this.init();
        this.par = new double[2];
        this.par[0] = 1.2;
        this.par[1] = -0.5;
        this.nRep = 1000;
        type = "E";
        this.f1 = (IModelFunction)this.functionFactory.createFunctionByName("P-function-1", type);
        this.f2 = (IModelFunction)this.functionFactory.createFunctionByName("P-function-2", type.toLowerCase());
        this.newName = "Exponential: amplitude=" + this.par[0] + ",  exponent=" + this.par[1];
        this.checkPredefinedFunctions1D(this.newName, type, this.f1, this.f2, false);
        this.f1.normalize(false);
        this.f2.normalize(false);
        this.newName = "Exponential: amplitude=" + this.par[0] + ",  exponent=" + this.par[1];
        this.checkPredefinedFunctions1D(this.newName, type, this.f1, this.f2, false);
        this.par = new double[1];
        this.par[0] = -0.5;
        this.f1.normalize(true);
        this.f2.normalize(true);
        this.f1.excludeNormalizationAll();
        this.f1.normalizationRange(0).include(this.xmin, this.xmax);
        this.f2.excludeNormalizationAll();
        this.f2.normalizationRange(0).include(this.xmin, this.xmax);
        this.newName = "Exponential: exponent=" + this.par[0];
        this.checkPredefinedFunctions1D(this.newName, type, this.f1, this.f2, true);
        this.par = new double[2];
        this.par[0] = 1.2;
        this.par[1] = -0.5;
        this.f1.normalize(false);
        this.f2.normalize(false);
        this.newName = "Exponential: amplitude=" + this.par[0] + ",  exponent=" + this.par[1];
        this.checkPredefinedFunctions1D(this.newName, type, this.f1, this.f2, false);
        this.par = new double[3];
        this.par[0] = 1.2;
        this.par[1] = 5.5;
        this.par[2] = -0.5;
        this.nRep = 1000;
        type = "P2";
        this.f2 = (IModelFunction)this.functionFactory.createFunctionByName("P-function-2", "P2");
        this.f1 = (IModelFunction)this.functionFactory.createFunctionByName("P-function-1", "p2");
        this.newName = "Polynomial: p0=" + this.par[0] + ",  p1=" + this.par[1] + ",  p2=" + this.par[2];
        this.checkPredefinedFunctions1D(this.newName, type, this.f1, this.f2, false);
        this.newName = "Polynomial: p0=" + this.par[0] + ",  p1=" + this.par[1] + ",  p2=" + this.par[2];
        this.f1.normalize(false);
        this.f2.normalize(false);
        this.checkPredefinedFunctions1D(this.newName, type, this.f1, this.f2, false);
        this.par = new double[2];
        this.par[0] = 5.5;
        this.par[1] = -0.5;
        this.f1.normalize(true);
        this.f2.normalize(true);
        this.f1.excludeNormalizationAll();
        this.f1.normalizationRange(0).include(this.xmin, this.xmax);
        this.f2.excludeNormalizationAll();
        this.f2.normalizationRange(0).include(this.xmin, this.xmax);
        this.newName = "Polynomial: p0=" + this.par[0] + ",  p1=" + this.par[1];
        this.checkPredefinedFunctions1D(this.newName, type, this.f1, this.f2, true);
        this.par = new double[3];
        this.par[0] = 1.2;
        this.par[1] = 5.5;
        this.par[2] = -0.5;
        this.f1.normalize(false);
        this.f2.normalize(false);
        this.newName = "Polynomial: p0=" + this.par[0] + ",  p1=" + this.par[1] + ",  p2=" + this.par[2];
        this.checkPredefinedFunctions1D(this.newName, type, this.f1, this.f2, false);
        this.par = new double[3];
        this.par[0] = 1.75;
        this.par[1] = -0.71;
        this.par[2] = 0.987;
        this.nRep = 1000;
        type = "G";
        this.f1 = (IModelFunction)this.functionFactory.createFunctionByName("G-function-1", type);
        this.f2 = (IModelFunction)this.functionFactory.createFunctionByName("G-function-2", type.toLowerCase());
        this.newName = "Gaussian: p0=" + this.par[0] + ",  p1=" + this.par[1] + ",  p2=" + this.par[2];
        this.checkPredefinedFunctions1D(this.newName, type, this.f1, this.f2, false);
        this.newName = "Gaussian: p0=" + this.par[0] + ",  p1=" + this.par[1] + ",  p2=" + this.par[2];
        this.f1.normalize(false);
        this.f2.normalize(false);
        this.checkPredefinedFunctions1D(this.newName, type, this.f1, this.f2, false);
        this.par = new double[3];
        this.par[0] = 1.2;
        this.par[1] = 5.5;
        this.par[2] = -0.5;
        this.f1.normalize(false);
        this.f2.normalize(false);
        this.newName = "Gaussian: p0=" + this.par[0] + ",  p1=" + this.par[1] + ",  p2=" + this.par[2];
        this.checkPredefinedFunctions1D(this.newName, type, this.f1, this.f2, false);
    }

    public void init() {
        this.debug = false;
        this.xBins = 10;
        this.xmin = -10.0;
        this.xmax = 10.0;
        this.analysisFactory = IAnalysisFactory.create();
        this.treeFactory = this.analysisFactory.createTreeFactory();
        this.tree = this.analysisFactory.createTreeFactory().create();
        this.histogramFactory = this.analysisFactory.createHistogramFactory(this.tree);
        this.functionFactory = this.analysisFactory.createFunctionFactory(this.tree);
    }

    public void checkPredefinedFunctions1D(String name, String type, IModelFunction f1, IModelFunction f2, boolean norm) {
        int i;
        int i2;
        if (this.debug) {
            System.out.println("\n\n\t ***** " + name + ",  Normalization = " + norm);
        }
        TestFunctions.assertEquals((boolean)norm, (boolean)f1.isNormalized());
        TestFunctions.assertEquals((boolean)norm, (boolean)f2.isNormalized());
        TestFunctions.assertEquals((int)1, (int)f1.dimension());
        TestFunctions.assertEquals((int)1, (int)f2.dimension());
        for (i2 = 0; i2 < f1.dimension(); ++i2) {
            TestFunctions.assertEquals((String)new String("x" + i2), (String)f1.variableName(i2));
            TestFunctions.assertEquals((String)new String("x" + i2), (String)f2.variableName(i2));
            TestFunctions.assertEquals((String)new String("x" + i2), (String)f1.variableNames()[i2]);
            TestFunctions.assertEquals((String)new String("x" + i2), (String)f2.variableNames()[i2]);
        }
        TestFunctions.assertEquals((int)this.par.length, (int)f1.numberOfParameters());
        TestFunctions.assertEquals((int)this.par.length, (int)f2.numberOfParameters());
        TestFunctions.assertEquals((int)this.par.length, (int)f1.parameterNames().length);
        TestFunctions.assertEquals((int)this.par.length, (int)f2.parameterNames().length);
        for (i2 = 0; i2 < this.par.length; ++i2) {
            if (this.debug) {
                System.out.println("Parameter names: ref=" + this.names(norm, type)[i2] + ", \tf1: " + f1.parameterNames()[i2] + ", \tf2: " + f2.parameterNames()[i2]);
            }
            TestFunctions.assertEquals((String)this.names(norm, type)[i2], (String)f1.parameterNames()[i2]);
            TestFunctions.assertEquals((String)this.names(norm, type)[i2], (String)f2.parameterNames()[i2]);
        }
        for (i2 = 0; i2 < this.par.length; ++i2) {
            TestFunctions.assertEquals((int)i2, (int)f1.indexOfParameter(this.names(norm, type)[i2]));
            TestFunctions.assertEquals((int)i2, (int)f2.indexOfParameter(this.names(norm, type)[i2]));
        }
        f1.setParameters(this.par);
        f2.setParameters(this.par);
        this.checkParameters(type, (IFunction)f1, (IFunction)f2, norm);
        double scale = 1.7651;
        for (i = 0; i < this.par.length; ++i) {
            this.par[i] = this.par[i] * scale;
            f1.setParameter(this.names(norm, type)[i], this.par[i]);
            f2.setParameter(this.names(norm, type)[i], this.par[i]);
        }
        this.checkParameters(type, (IFunction)f1, (IFunction)f2, norm);
        f1.setParameters(this.par);
        f2.setParameters(this.par);
        for (i = 0; i < this.xBins; ++i) {
            double x = this.xmin + ((double)i + 0.5) * (this.xmax - this.xmin) / (double)this.xBins;
            if (this.debug) {
                System.out.println("Values for x=" + x + "\tExpected=" + this.value(x, type, norm) + "\tf1=" + f1.value(new double[]{x}) + "\tf2=" + f2.value(new double[]{x}));
            }
            double val = f1.value(new double[]{x});
            TestFunctions.assertEqualsDouble(this.value(x, type, norm), val, val, 100);
            val = f2.value(new double[]{x});
            TestFunctions.assertEqualsDouble(this.value(x, type, norm), val, val, 100);
        }
    }

    private void checkParameters(String type, IFunction f1, IFunction f2, boolean norm) {
        int i;
        TestFunctions.assertEquals((int)this.par.length, (int)f1.parameters().length);
        TestFunctions.assertEquals((int)this.par.length, (int)f2.parameters().length);
        for (i = 0; i < this.par.length; ++i) {
            if (this.debug) {
                System.out.println("Parameter values (array): ref=" + this.par[i] + ", \tf1: " + f1.parameters()[i] + ", \tf2: " + f2.parameters()[i]);
            }
            TestFunctions.assertEqualsDouble(this.par[i], f1.parameters()[i], this.par[i]);
            TestFunctions.assertEqualsDouble(this.par[i], f2.parameters()[i], this.par[i]);
        }
        for (i = 0; i < this.par.length; ++i) {
            if (this.debug) {
                System.out.println("Parameter values (indiv): ref=" + this.par[i] + ", \tf1: " + f1.parameter(this.names(norm, type)[i]) + ", \tf2: " + f2.parameter(this.names(norm, type)[i]));
            }
            TestFunctions.assertEqualsDouble(this.par[i], f1.parameter(this.names(norm, type)[i]), this.par[i]);
            TestFunctions.assertEqualsDouble(this.par[i], f2.parameter(this.names(norm, type)[i]), this.par[i]);
        }
    }

    private double value(double x, String type, boolean norm) {
        double v = Double.NaN;
        if (!norm) {
            if (type == "G") {
                v = this.par[0] * Math.exp(-Math.pow((x - this.par[1]) / this.par[2], 2.0) / 2.0);
            } else if (type == "E") {
                v = this.par[0] * Math.exp(x * this.par[1]);
            } else if (type == "BW") {
                double gamma2 = this.par[2] * this.par[2] / 4.0;
                v = this.par[0] * gamma2 / ((x - this.par[1]) * (x - this.par[1]) + gamma2);
            } else if (type.startsWith("P")) {
                int order = this.par.length;
                v = 0.0;
                for (int i = 0; i < order; ++i) {
                    v += this.par[i] * Math.pow(x, i);
                }
            }
        } else {
            if (type == "G") {
                v = 0.5 * this.par[1] * Math.pow(Math.PI * 2, 0.5) * Math.exp(-Math.pow((x - this.par[0]) / this.par[1], 2.0) / 2.0);
            } else if (type == "E") {
                double n = (Math.exp(this.xmax * this.par[0]) - Math.exp(this.xmin * this.par[0])) / this.par[0];
                v = Math.exp(x * this.par[0]);
                v /= n;
            } else if (type == "BW") {
                double gamma2 = this.par[2] * this.par[2] / 4.0;
                v = this.par[0] * gamma2 / ((x - this.par[1]) * (x - this.par[1]) + gamma2);
            } else if (type.startsWith("P")) {
                int i;
                int order = this.par.length;
                v = 1.0;
                double n = this.xmax - this.xmin;
                for (i = 0; i < order; ++i) {
                    n += this.par[i] * (Math.pow(this.xmax, i + 2) - Math.pow(this.xmin, i + 2)) / (double)(i + 2);
                }
                for (i = 0; i < order; ++i) {
                    v += this.par[i] * Math.pow(x, i + 1);
                }
                v /= n;
            }
            if (v < 0.0) {
                v = 0.0;
            }
        }
        return v;
    }

    private String[] names(boolean norm, String type) {
        String[] str;
        block11: {
            block9: {
                block13: {
                    block12: {
                        block10: {
                            str = null;
                            if (norm) break block9;
                            if (type != "G") break block10;
                            str = new String[]{"amplitude", "mean", "sigma"};
                            break block11;
                        }
                        if (type != "E") break block12;
                        str = new String[]{"amplitude", "exponent"};
                        break block11;
                    }
                    if (type != "BW") break block13;
                    str = new String[]{"amplitude", "origin", "width"};
                    break block11;
                }
                if (!type.startsWith("P")) break block11;
                int order = this.par.length;
                str = new String[order];
                for (int i = 0; i < order; ++i) {
                    str[i] = new String("p" + i);
                }
                break block11;
            }
            if (type == "G") {
                str = new String[]{"mean", "sigma"};
            } else if (type == "E") {
                str = new String[]{"exponent"};
            } else if (type == "BW") {
                str = new String[]{"origin", "width"};
            } else if (type.startsWith("P")) {
                int order = this.par.length;
                str = new String[order];
                for (int i = 0; i < order; ++i) {
                    str[i] = new String("p" + (i + 1));
                }
            }
        }
        return str;
    }
}

