/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.test;

import hep.aida.IAnalysisFactory;
import hep.aida.ICloud1D;
import hep.aida.ICloud2D;
import hep.aida.ICloud3D;
import hep.aida.IDataPointSet;
import hep.aida.IDataPointSetFactory;
import hep.aida.IFunction;
import hep.aida.IFunctionFactory;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.IHistogramFactory;
import hep.aida.IManagedObject;
import hep.aida.ITree;
import hep.aida.ITuple;
import hep.aida.ITupleFactory;
import hep.aida.test.AidaTestCase;
import java.io.IOException;

public class TestPathNameTitleConvention
extends AidaTestCase {
    private String outputName = "testPathNameTitleConvention.aida";
    private String options = "compress=no";

    public TestPathNameTitleConvention(String testName) {
        super(testName);
    }

    public void testPathNameTitle() throws IOException {
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree = af.createTreeFactory().create(this.outputName, null, false, true, this.options);
        IHistogramFactory hf = af.createHistogramFactory(tree);
        IDataPointSetFactory dpsf = af.createDataPointSetFactory(tree);
        IFunctionFactory ff = af.createFunctionFactory(tree);
        ITupleFactory tf = af.createTupleFactory(tree);
        tree.mkdir("/histograms");
        tree.mkdir("/clouds");
        tree.mkdir("/dataPointSets");
        tree.mkdir("/functions");
        tree.mkdir("/tuples");
        IHistogram1D hist1DWithTitle = hf.createHistogram1D("/histograms/hist1DWithTitle", "hist1D title", 10, 0.0, 10.0);
        IHistogram1D hist1DWithoutTitle = hf.createHistogram1D("/histograms/hist1DWithoutTitle", 10, 0.0, 10.0);
        IHistogram2D hist2DWithTitle = hf.createHistogram2D("/histograms/hist2DWithTitle", "hist2D title", 10, 0.0, 10.0, 10, 0.0, 10.0);
        IHistogram2D hist2DWithoutTitle = hf.createHistogram2D("/histograms/hist2DWithoutTitle", 10, 0.0, 10.0, 10, 0.0, 10.0);
        IHistogram3D hist3DWithTitle = hf.createHistogram3D("/histograms/hist3DWithTitle", "hist3D title", 10, 0.0, 10.0, 10, 0.0, 10.0, 10, 0.0, 10.0);
        IHistogram3D hist3DWithoutTitle = hf.createHistogram3D("/histograms/hist3DWithoutTitle", 10, 0.0, 10.0, 10, 0.0, 10.0, 10, 0.0, 10.0);
        TestPathNameTitleConvention.assertEquals((String)hist1DWithTitle.title(), (String)"hist1D title");
        TestPathNameTitleConvention.assertEquals((String)((IManagedObject)hist1DWithTitle).name(), (String)"hist1DWithTitle");
        TestPathNameTitleConvention.assertEquals((String)hist1DWithoutTitle.title(), (String)((IManagedObject)hist1DWithoutTitle).name());
        TestPathNameTitleConvention.assertEquals((String)hist2DWithoutTitle.title(), (String)((IManagedObject)hist2DWithoutTitle).name());
        TestPathNameTitleConvention.assertEquals((String)hist2DWithTitle.title(), (String)"hist2D title");
        TestPathNameTitleConvention.assertEquals((String)((IManagedObject)hist2DWithTitle).name(), (String)"hist2DWithTitle");
        TestPathNameTitleConvention.assertEquals((String)hist3DWithoutTitle.title(), (String)((IManagedObject)hist3DWithoutTitle).name());
        TestPathNameTitleConvention.assertEquals((String)hist3DWithTitle.title(), (String)"hist3D title");
        TestPathNameTitleConvention.assertEquals((String)((IManagedObject)hist3DWithTitle).name(), (String)"hist3DWithTitle");
        ICloud1D cloud1DWithTitle = hf.createCloud1D("/clouds/cloud1DWithTitle", "cloud1D title");
        ICloud1D cloud1DWithoutTitle = hf.createCloud1D("/clouds/cloud1DWithoutTitle");
        ICloud2D cloud2DWithTitle = hf.createCloud2D("/clouds/cloud2DWithTitle", "cloud2D title");
        ICloud2D cloud2DWithoutTitle = hf.createCloud2D("/clouds/cloud2DWithoutTitle");
        ICloud3D cloud3DWithTitle = hf.createCloud3D("/clouds/cloud3DWithTitle", "cloud3D title");
        ICloud3D cloud3DWithoutTitle = hf.createCloud3D("/clouds/cloud3DWithoutTitle");
        TestPathNameTitleConvention.assertEquals((String)cloud1DWithTitle.title(), (String)"cloud1D title");
        TestPathNameTitleConvention.assertEquals((String)((IManagedObject)cloud1DWithTitle).name(), (String)"cloud1DWithTitle");
        TestPathNameTitleConvention.assertEquals((String)cloud1DWithoutTitle.title(), (String)((IManagedObject)cloud1DWithoutTitle).name());
        TestPathNameTitleConvention.assertEquals((String)cloud2DWithoutTitle.title(), (String)((IManagedObject)cloud2DWithoutTitle).name());
        TestPathNameTitleConvention.assertEquals((String)cloud2DWithTitle.title(), (String)"cloud2D title");
        TestPathNameTitleConvention.assertEquals((String)((IManagedObject)cloud2DWithTitle).name(), (String)"cloud2DWithTitle");
        TestPathNameTitleConvention.assertEquals((String)cloud3DWithoutTitle.title(), (String)((IManagedObject)cloud3DWithoutTitle).name());
        TestPathNameTitleConvention.assertEquals((String)cloud3DWithTitle.title(), (String)"cloud3D title");
        TestPathNameTitleConvention.assertEquals((String)((IManagedObject)cloud3DWithTitle).name(), (String)"cloud3DWithTitle");
        IDataPointSet dpsWithTitle = dpsf.create("/dataPointSets/dpsWithTitle", "dps Title", 12);
        IDataPointSet dpsWithoutTitle = dpsf.create("/dataPointSets/dpsWithoutTitle", 1);
        TestPathNameTitleConvention.assertEquals((String)dpsWithTitle.title(), (String)"dps Title");
        TestPathNameTitleConvention.assertEquals((String)((IManagedObject)dpsWithTitle).name(), (String)"dpsWithTitle");
        TestPathNameTitleConvention.assertEquals((String)dpsWithoutTitle.title(), (String)((IManagedObject)dpsWithoutTitle).name());
        IFunction function = ff.createFunctionByName("/functions/gauss", "g");
        ITuple tupleWithTitle = tf.create("/tuples/tupleWithTitle", "tuple Title", "double x");
        TestPathNameTitleConvention.assertEquals((String)tupleWithTitle.title(), (String)"tuple Title");
        TestPathNameTitleConvention.assertEquals((String)((IManagedObject)tupleWithTitle).name(), (String)"tupleWithTitle");
        try {
            hf.createHistogram1D("/abc/hist1DWithTitle", "hist1D title", 10, 0.0, 10.0);
            TestPathNameTitleConvention.assertTrue((boolean)false);
        }
        catch (Throwable t) {
            // empty catch block
        }
        tree.commit();
    }
}

