/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.test;

import hep.aida.IAnalysisFactory;
import hep.aida.IBaseHistogram;
import hep.aida.IFitFactory;
import hep.aida.IFitResult;
import hep.aida.IFunction;
import hep.aida.IHistogram1D;
import hep.aida.IHistogramFactory;
import hep.aida.ITree;
import hep.aida.test.AidaTestCase;
import java.util.Random;

public class TestFitter
extends AidaTestCase {
    private String[] fitterNames = new String[]{"minuit", "uncmin"};

    public TestFitter(String testName) {
        super(testName);
    }

    public void testFitters() {
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree temp = af.createTreeFactory().create();
        IFitFactory ff = af.createFitFactory();
        IHistogramFactory hf = af.createHistogramFactory(temp);
        IHistogram1D hist = hf.createHistogram1D("test", 100, -5.0, 5.0);
        Random r = this.getRandomNumberGenerator();
        for (int j = 0; j < 10000; ++j) {
            hist.fill(r.nextGaussian());
        }
        for (int i = 0; i < this.fitterNames.length; ++i) {
            String fitterName = this.fitterNames[i];
            double[] initPars = new double[]{hist.maxBinHeight(), hist.mean(), hist.rms()};
            IFitResult result = ff.createFitter("chi2", fitterName).fit((IBaseHistogram)hist, "g", initPars);
            IFunction fitted = result.fittedFunction();
            String str = "** " + fitterName + " : ";
            TestFitter.assertTrue((String)str, (boolean)result.isValid());
            TestFitter.assertEquals((String)str, (double)fitted.parameter("mean"), (double)hist.mean(), (double)0.1);
            TestFitter.assertEquals((String)str, (double)Math.abs(fitted.parameter("sigma")), (double)hist.rms(), (double)0.1);
            TestFitter.assertEquals((String)str, (double)fitted.parameter("amplitude"), (double)hist.maxBinHeight(), (double)(0.1 * hist.maxBinHeight()));
        }
    }
}

