/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.test;

import hep.aida.IAnalysisFactory;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.IHistogramFactory;
import hep.aida.ITree;
import hep.aida.ITreeFactory;
import hep.aida.test.AidaTestCase;
import java.util.Random;

public class TestHistogramSlices
extends AidaTestCase {
    Random r = null;

    public TestHistogramSlices(String testName) {
        super(testName);
    }

    public void testTestSlices2D() {
        IHistogram1D h;
        int tmpIndex;
        this.r = this.getRandomNumberGenerator();
        int xBins = this.r.nextInt(39) + 1;
        int yBins = this.r.nextInt(24) + 1;
        int nEntries = this.r.nextInt(3000);
        double xmin = -18.5;
        double xmax = 10.9;
        double ymin = 12.0;
        double ymax = 43.0;
        int indexX2 = this.r.nextInt(xBins + 2);
        int indexX1 = indexX2 == 0 ? 0 : this.r.nextInt(indexX2);
        int indexY2 = this.r.nextInt(yBins + 2);
        int indexY1 = indexY2 == 0 ? 0 : this.r.nextInt(indexY2);
        IAnalysisFactory analysisFactory = IAnalysisFactory.create();
        ITreeFactory treeFactory = analysisFactory.createTreeFactory();
        ITree tree = analysisFactory.createTreeFactory().create();
        IHistogramFactory histogramFactory = analysisFactory.createHistogramFactory(tree);
        IHistogram1D h11 = histogramFactory.createHistogram1D("Projection X", xBins, xmin, xmax);
        IHistogram1D h12 = histogramFactory.createHistogram1D("Projection Y", yBins, ymin, ymax);
        IHistogram1D h13 = histogramFactory.createHistogram1D("Slice X", xBins, xmin, xmax);
        IHistogram1D h14 = histogramFactory.createHistogram1D("Slice Y", yBins, ymin, ymax);
        IHistogram2D h2D = histogramFactory.createHistogram2D("Hist2D 1", xBins, xmin, xmax, yBins, ymin, ymax);
        for (int i = 0; i < nEntries; ++i) {
            double xv = this.value(xmin, xmax);
            double yv = this.value(ymin, ymax);
            double wv = this.r.nextDouble();
            int nx = h2D.xAxis().coordToIndex(xv);
            int ny = h2D.yAxis().coordToIndex(yv);
            nx = this.convertIndex(nx, xBins);
            ny = this.convertIndex(ny, yBins);
            h2D.fill(xv, yv, wv);
            h11.fill(xv, wv);
            h12.fill(yv, wv);
            if (ny >= indexY1 && ny <= indexY2) {
                h13.fill(xv, wv);
            }
            if (nx < indexX1 || nx > indexX2) continue;
            h14.fill(yv, wv);
        }
        indexX1 = this.convertBackIndex(indexX1, xBins);
        indexX2 = this.convertBackIndex(indexX2, xBins);
        indexY1 = this.convertBackIndex(indexY1, yBins);
        indexY2 = this.convertBackIndex(indexY2, yBins);
        if (indexX1 == -1) {
            tmpIndex = indexX1;
            indexX1 = indexX2;
            indexX2 = tmpIndex;
        }
        if (indexY1 == -1) {
            tmpIndex = indexY1;
            indexY1 = indexY2;
            indexY2 = tmpIndex;
        }
        IHistogram1D h21 = histogramFactory.projectionX("Projection X", h2D);
        IHistogram1D h22 = histogramFactory.projectionY("Projection Y", h2D);
        IHistogram1D h23 = histogramFactory.sliceX("Slice X", h2D, indexY1, indexY2);
        IHistogram1D h24 = histogramFactory.sliceY("Slice Y", h2D, indexX1, indexX2);
        TestHistogramSlices.assertEquals(h21, h11);
        TestHistogramSlices.assertEquals(h22, h12);
        TestHistogramSlices.assertEquals(h23, h13);
        TestHistogramSlices.assertEquals(h24, h14);
        try {
            h = histogramFactory.sliceX("ValidSliceX1", h2D, -2, -2);
        }
        catch (IllegalArgumentException iae) {
            TestHistogramSlices.assertTrue((boolean)false);
        }
        try {
            h = histogramFactory.sliceX("ValidSliceX2", h2D, -2, -1);
        }
        catch (IllegalArgumentException iae) {
            TestHistogramSlices.assertTrue((boolean)false);
        }
        try {
            h = histogramFactory.sliceX("ValidSliceX3", h2D, -2, 0);
        }
        catch (IllegalArgumentException iae) {
            TestHistogramSlices.assertTrue((boolean)false);
        }
        try {
            h = histogramFactory.sliceX("ValidSliceX4", h2D, 0, -1);
        }
        catch (IllegalArgumentException iae) {
            TestHistogramSlices.assertTrue((boolean)false);
        }
        try {
            h = histogramFactory.sliceX("ValidSliceX5", h2D, -1, -1);
        }
        catch (IllegalArgumentException iae) {
            TestHistogramSlices.assertTrue((boolean)false);
        }
        try {
            h = histogramFactory.sliceY("ValidSliceY1", h2D, -2, -2);
        }
        catch (IllegalArgumentException iae) {
            TestHistogramSlices.assertTrue((boolean)false);
        }
        try {
            h = histogramFactory.sliceY("ValidSliceY2", h2D, -2, -1);
        }
        catch (IllegalArgumentException iae) {
            TestHistogramSlices.assertTrue((boolean)false);
        }
        try {
            h = histogramFactory.sliceY("ValidSliceY3", h2D, -2, 0);
        }
        catch (IllegalArgumentException iae) {
            TestHistogramSlices.assertTrue((boolean)false);
        }
        try {
            h = histogramFactory.sliceY("ValidSliceY4", h2D, 0, -1);
        }
        catch (IllegalArgumentException iae) {
            TestHistogramSlices.assertTrue((boolean)false);
        }
        try {
            h = histogramFactory.sliceY("ValidSliceY5", h2D, -1, -1);
        }
        catch (IllegalArgumentException iae) {
            TestHistogramSlices.assertTrue((boolean)false);
        }
        try {
            h = histogramFactory.sliceX("InvalidSliceX1", h2D, -1, 0);
            TestHistogramSlices.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            h = histogramFactory.sliceX("InvalidSliceX2", h2D, -1, -2);
            TestHistogramSlices.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            h = histogramFactory.sliceX("InvalidSliceX3", h2D, 1, 0);
            TestHistogramSlices.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            h = histogramFactory.sliceY("InvalidSliceY1", h2D, -1, 0);
            TestHistogramSlices.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            h = histogramFactory.sliceY("InvalidSliceY2", h2D, -1, -2);
            TestHistogramSlices.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            h = histogramFactory.sliceY("InvalidSliceY3", h2D, 1, 0);
            TestHistogramSlices.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
    }

    public void testTestSlices3D() {
        IHistogram2D h;
        int tmpIndex;
        this.r = this.getRandomNumberGenerator();
        int xBins = this.r.nextInt(39) + 1;
        int yBins = this.r.nextInt(24) + 1;
        int zBins = this.r.nextInt(53) + 1;
        int nEntries = this.r.nextInt(3000);
        double xmin = -18.5;
        double xmax = 10.9;
        double ymin = 12.0;
        double ymax = 43.0;
        double zmin = -1.15;
        double zmax = -0.01;
        int indexX2 = this.r.nextInt(xBins + 2);
        int indexX1 = indexX2 == 0 ? 0 : this.r.nextInt(indexX2);
        int indexY2 = this.r.nextInt(yBins + 2);
        int indexY1 = indexY2 == 0 ? 0 : this.r.nextInt(indexY2);
        int indexZ2 = this.r.nextInt(zBins + 2);
        int indexZ1 = indexZ2 == 0 ? 0 : this.r.nextInt(indexZ2);
        IAnalysisFactory analysisFactory = IAnalysisFactory.create();
        ITreeFactory treeFactory = analysisFactory.createTreeFactory();
        ITree tree = analysisFactory.createTreeFactory().create();
        IHistogramFactory histogramFactory = analysisFactory.createHistogramFactory(tree);
        IHistogram2D h2D11 = histogramFactory.createHistogram2D("Projection XY", xBins, xmin, xmax, yBins, ymin, ymax);
        IHistogram2D h2D12 = histogramFactory.createHistogram2D("Projection YZ", yBins, ymin, ymax, zBins, zmin, zmax);
        IHistogram2D h2D13 = histogramFactory.createHistogram2D("Projection XZ", xBins, xmin, xmax, zBins, zmin, zmax);
        IHistogram2D h2D14 = histogramFactory.createHistogram2D("Slice XY", xBins, xmin, xmax, yBins, ymin, ymax);
        IHistogram2D h2D15 = histogramFactory.createHistogram2D("Slice YZ", yBins, ymin, ymax, zBins, zmin, zmax);
        IHistogram2D h2D16 = histogramFactory.createHistogram2D("Slice XZ", xBins, xmin, xmax, zBins, zmin, zmax);
        IHistogram3D h3D = histogramFactory.createHistogram3D("Hist3D 1", xBins, xmin, xmax, yBins, ymin, ymax, zBins, zmin, zmax);
        for (int i = 0; i < nEntries; ++i) {
            double xv = this.value(xmin, xmax);
            double yv = this.value(ymin, ymax);
            double zv = this.value(zmin, zmax);
            double wv = this.r.nextDouble();
            int nx = h3D.xAxis().coordToIndex(xv);
            int ny = h3D.yAxis().coordToIndex(yv);
            int nz = h3D.zAxis().coordToIndex(zv);
            nx = this.convertIndex(nx, xBins);
            ny = this.convertIndex(ny, yBins);
            nz = this.convertIndex(nz, zBins);
            h3D.fill(xv, yv, zv, wv);
            h2D11.fill(xv, yv, wv);
            h2D12.fill(yv, zv, wv);
            h2D13.fill(xv, zv, wv);
            if (nz >= indexZ1 && nz <= indexZ2) {
                h2D14.fill(xv, yv, wv);
            }
            if (nx >= indexX1 && nx <= indexX2) {
                h2D15.fill(yv, zv, wv);
            }
            if (ny < indexY1 || ny > indexY2) continue;
            h2D16.fill(xv, zv, wv);
        }
        indexX1 = this.convertBackIndex(indexX1, xBins);
        indexX2 = this.convertBackIndex(indexX2, xBins);
        indexY1 = this.convertBackIndex(indexY1, yBins);
        indexY2 = this.convertBackIndex(indexY2, yBins);
        indexZ1 = this.convertBackIndex(indexZ1, zBins);
        indexZ2 = this.convertBackIndex(indexZ2, zBins);
        if (indexX1 == -1) {
            tmpIndex = indexX1;
            indexX1 = indexX2;
            indexX2 = tmpIndex;
        }
        if (indexY1 == -1) {
            tmpIndex = indexY1;
            indexY1 = indexY2;
            indexY2 = tmpIndex;
        }
        if (indexZ1 == -1) {
            tmpIndex = indexZ1;
            indexZ1 = indexZ2;
            indexZ2 = tmpIndex;
        }
        IHistogram2D h2D21 = histogramFactory.projectionXY("Projection XY", h3D);
        IHistogram2D h2D22 = histogramFactory.projectionYZ("Projection YZ", h3D);
        IHistogram2D h2D23 = histogramFactory.projectionXZ("Projection XZ", h3D);
        IHistogram2D h2D24 = histogramFactory.sliceXY("Slice XY", h3D, indexZ1, indexZ2);
        IHistogram2D h2D25 = histogramFactory.sliceYZ("Slice YZ", h3D, indexX1, indexX2);
        IHistogram2D h2D26 = histogramFactory.sliceXZ("Slice XZ", h3D, indexY1, indexY2);
        TestHistogramSlices.assertEquals(h2D11, h2D21);
        TestHistogramSlices.assertEquals(h2D12, h2D22);
        TestHistogramSlices.assertEquals(h2D13, h2D23);
        TestHistogramSlices.assertEquals(h2D14, h2D24);
        TestHistogramSlices.assertEquals(h2D15, h2D25);
        TestHistogramSlices.assertEquals(h2D16, h2D26);
        try {
            h = histogramFactory.sliceXY("ValidSliceXY1", h3D, -2, -2);
        }
        catch (IllegalArgumentException iae) {
            TestHistogramSlices.assertTrue((boolean)false);
        }
        try {
            h = histogramFactory.sliceXY("ValidSliceXY2", h3D, -2, -1);
        }
        catch (IllegalArgumentException iae) {
            TestHistogramSlices.assertTrue((boolean)false);
        }
        try {
            h = histogramFactory.sliceXY("ValidSliceXY3", h3D, -2, 0);
        }
        catch (IllegalArgumentException iae) {
            TestHistogramSlices.assertTrue((boolean)false);
        }
        try {
            h = histogramFactory.sliceXY("ValidSliceXY4", h3D, 0, -1);
        }
        catch (IllegalArgumentException iae) {
            TestHistogramSlices.assertTrue((boolean)false);
        }
        try {
            h = histogramFactory.sliceXY("ValidSliceXY5", h3D, -1, -1);
        }
        catch (IllegalArgumentException iae) {
            TestHistogramSlices.assertTrue((boolean)false);
        }
        try {
            h = histogramFactory.sliceXZ("ValidSliceXZ1", h3D, -2, -2);
        }
        catch (IllegalArgumentException iae) {
            TestHistogramSlices.assertTrue((boolean)false);
        }
        try {
            h = histogramFactory.sliceXZ("ValidSliceXZ2", h3D, -2, -1);
        }
        catch (IllegalArgumentException iae) {
            TestHistogramSlices.assertTrue((boolean)false);
        }
        try {
            h = histogramFactory.sliceXZ("ValidSliceXZ3", h3D, -2, 0);
        }
        catch (IllegalArgumentException iae) {
            TestHistogramSlices.assertTrue((boolean)false);
        }
        try {
            h = histogramFactory.sliceXZ("ValidSliceXZ4", h3D, 0, -1);
        }
        catch (IllegalArgumentException iae) {
            TestHistogramSlices.assertTrue((boolean)false);
        }
        try {
            h = histogramFactory.sliceXZ("ValidSliceXZ5", h3D, -1, -1);
        }
        catch (IllegalArgumentException iae) {
            TestHistogramSlices.assertTrue((boolean)false);
        }
        try {
            h = histogramFactory.sliceYZ("ValidSliceYZ1", h3D, -2, -2);
        }
        catch (IllegalArgumentException iae) {
            TestHistogramSlices.assertTrue((boolean)false);
        }
        try {
            h = histogramFactory.sliceYZ("ValidSliceYZ2", h3D, -2, -1);
        }
        catch (IllegalArgumentException iae) {
            TestHistogramSlices.assertTrue((boolean)false);
        }
        try {
            h = histogramFactory.sliceYZ("ValidSliceYZ3", h3D, -2, 0);
        }
        catch (IllegalArgumentException iae) {
            TestHistogramSlices.assertTrue((boolean)false);
        }
        try {
            h = histogramFactory.sliceYZ("ValidSliceYZ4", h3D, 0, -1);
        }
        catch (IllegalArgumentException iae) {
            TestHistogramSlices.assertTrue((boolean)false);
        }
        try {
            h = histogramFactory.sliceYZ("ValidSliceYZ5", h3D, -1, -1);
        }
        catch (IllegalArgumentException iae) {
            TestHistogramSlices.assertTrue((boolean)false);
        }
        try {
            h = histogramFactory.sliceXY("InvalidSliceXY1", h3D, -1, 0);
            TestHistogramSlices.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            h = histogramFactory.sliceXY("InvalidSliceXY2", h3D, -1, -2);
            TestHistogramSlices.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            h = histogramFactory.sliceXY("InvalidSliceXY3", h3D, 1, 0);
            TestHistogramSlices.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            h = histogramFactory.sliceXZ("InvalidSliceXZ1", h3D, -1, 0);
            TestHistogramSlices.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            h = histogramFactory.sliceXZ("InvalidSliceXZ2", h3D, -1, -2);
            TestHistogramSlices.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            h = histogramFactory.sliceXZ("InvalidSliceXZ3", h3D, 1, 0);
            TestHistogramSlices.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            h = histogramFactory.sliceYZ("InvalidSliceYZ1", h3D, -1, 0);
            TestHistogramSlices.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            h = histogramFactory.sliceYZ("InvalidSliceYZ2", h3D, -1, -2);
            TestHistogramSlices.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            h = histogramFactory.sliceYZ("InvalidSliceYZ3", h3D, 1, 0);
            TestHistogramSlices.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
    }

    private double value(double vmin, double vmax) {
        return this.r.nextGaussian() * (vmax - vmin) / 3.0 + (vmin + vmax) / 2.0;
    }

    private int convertIndex(int index, int nBins) {
        if (index >= 0) {
            return index + 1;
        }
        if (index == -2) {
            return 0;
        }
        return nBins + 1;
    }

    private int convertBackIndex(int index, int nBins) {
        if (index == 0) {
            return -2;
        }
        if (index == nBins + 1) {
            return -1;
        }
        return index - 1;
    }
}

