/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.test;

import hep.aida.IAnalysisFactory;
import hep.aida.IBaseHistogram;
import hep.aida.IEvaluator;
import hep.aida.IFitFactory;
import hep.aida.IFitResult;
import hep.aida.IFunction;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogramFactory;
import hep.aida.ITree;
import hep.aida.ITreeFactory;
import hep.aida.ITuple;
import hep.aida.ITupleFactory;
import hep.aida.test.AidaTestCase;
import java.io.File;
import java.io.IOException;

public class TestRoot
extends AidaTestCase {
    protected ITree tree;
    private double relPrecision;

    public TestRoot(String testName) {
        super(testName);
        this.setRelPrecision(1.0E-4);
    }

    protected void setRelPrecision(double relPrecision) {
        this.relPrecision = relPrecision;
    }

    protected void tearDown() throws Exception {
        try {
            this.tree.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.getMessage());
        }
        super.tearDown();
    }

    protected String convertName(int id) {
        return id >= 0 ? "/h" + id : "/h_" + id;
    }

    public void test1DHistogramAccess() {
        IHistogram1D hist = (IHistogram1D)this.tree.find(this.convertName(110));
        TestRoot.assertNotNull((Object)hist);
        TestRoot.assertEquals((String)hist.title().trim(), (String)"TEST OF HBOOK1");
        TestRoot.assertEquals((int)hist.entries(), (int)5000);
        TestRoot.assertEquals((int)hist.extraEntries(), (int)0);
        TestRoot.assertEquals((double)hist.mean(), (double)0.49817, (double)this.relPrecision);
        TestRoot.assertEquals((double)hist.rms(), (double)0.22046, (double)this.relPrecision);
    }

    public void test2DHistogramAccess() {
        IHistogram2D hist = (IHistogram2D)this.tree.find(this.convertName(210));
        TestRoot.assertNotNull((Object)hist);
        TestRoot.assertEquals((String)hist.title().trim(), (String)"TEST OF HBOOK2");
        TestRoot.assertEquals((int)hist.entries(), (int)5000);
        TestRoot.assertEquals((int)hist.extraEntries(), (int)0);
        TestRoot.assertEquals((double)hist.meanX(), (double)0.4806, (double)this.relPrecision);
        TestRoot.assertEquals((double)hist.meanY(), (double)0.48094, (double)this.relPrecision);
        TestRoot.assertEquals((double)hist.rmsX(), (double)0.21781, (double)this.relPrecision);
        TestRoot.assertEquals((double)hist.rmsY(), (double)0.21768, (double)this.relPrecision);
    }

    public void testSimpleFit() throws Exception {
        ITuple tuple = (ITuple)this.tree.find(this.convertName(30));
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree temp = af.createTreeFactory().create();
        IHistogramFactory hf = af.createHistogramFactory(temp);
        ITupleFactory tf = af.createTupleFactory(temp);
        IHistogram1D hist = hf.createHistogram1D("test", 50, -4.0, 4.0);
        IEvaluator x = tf.createEvaluator("X");
        tuple.project(hist, x);
        TestRoot.assertEquals((int)hist.entries(), (int)10000);
        IFitFactory ff = af.createFitFactory();
        IFitResult result = ff.createFitter().fit((IBaseHistogram)hist, "g");
        IFunction fitted = result.fittedFunction();
        TestRoot.assertEquals((double)result.quality(), (double)0.579, (double)0.01);
        TestRoot.assertEquals((int)result.ndf(), (int)43);
        TestRoot.assertTrue((boolean)result.isValid());
        TestRoot.assertEquals((double)fitted.parameter("mean"), (double)0.0, (double)0.01);
        TestRoot.assertEquals((double)fitted.parameter("sigma"), (double)1.0, (double)0.03);
        TestRoot.assertEquals((double)fitted.parameter("amplitude"), (double)643.0, (double)0.2);
        temp.close();
    }

    public void testFolderAccess() {
        IHistogram1D hist = (IHistogram1D)this.tree.find("BS" + this.convertName(100));
        TestRoot.assertNotNull((Object)hist);
        TestRoot.assertEquals((String)hist.title().trim(), (String)"BREM P M");
        TestRoot.assertEquals((int)hist.entries(), (int)15896);
        TestRoot.assertEquals((int)hist.extraEntries(), (int)0);
        TestRoot.assertEquals((double)hist.mean(), (double)0.28203, (double)1.0E-4);
        TestRoot.assertEquals((double)hist.rms(), (double)0.10821, (double)1.0E-4);
    }

    public void testTuple() {
        ITuple tuple = (ITuple)this.tree.find(this.convertName(30));
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree temp = af.createTreeFactory().create();
        IHistogramFactory hf = af.createHistogramFactory(temp);
        ITupleFactory tf = af.createTupleFactory(temp);
        IHistogram1D hist = hf.createHistogram1D("test", 40, 0.0, 10.0);
        IEvaluator x = tf.createEvaluator("Z");
        tuple.project(hist, x);
        TestRoot.assertEquals((int)9934, (int)hist.entries());
        TestRoot.assertEquals((double)1.907, (double)hist.mean(), (double)1.0E-4);
        TestRoot.assertEquals((double)1.8271, (double)hist.rms(), (double)1.0E-4);
    }

    public void testTupleAge() {
        ITuple tuple = (ITuple)this.tree.find("STAFF" + this.convertName(10));
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree temp = af.createTreeFactory().create();
        IHistogramFactory hf = af.createHistogramFactory(temp);
        ITupleFactory tf = af.createTupleFactory(temp);
        IHistogram1D hist = hf.createHistogram1D("test", 44, 20.5, 64.5);
        IEvaluator x = tf.createEvaluator("Age");
        tuple.project(hist, x);
        TestRoot.assertEquals((int)3354, (int)hist.entries());
        TestRoot.assertEquals((double)47.153, (double)hist.mean(), (double)1.0E-4);
        TestRoot.assertEquals((double)8.643, (double)hist.rms(), (double)1.0E-4);
    }

    public void testTupleNation() {
        ITuple tuple = (ITuple)this.tree.find("STAFF" + this.convertName(10));
        int nationIndex = tuple.findColumn("Nation");
        int n = 0;
        tuple.start();
        while (tuple.next()) {
            String nation = tuple.getString(nationIndex);
            if (!nation.equals("CH")) continue;
            ++n;
        }
        TestRoot.assertEquals((int)465, (int)n);
    }

    public void testWalkTree() {
        String[] names = this.tree.listObjectNames("/", true);
        TestRoot.assertEquals((int)266, (int)names.length);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.openFile();
    }

    protected void openFile() throws Exception {
        String testDataDir = System.getProperty("hep.aida.test.data");
        File f = new File(testDataDir, "pawdemo.root");
        IAnalysisFactory af = IAnalysisFactory.create();
        ITreeFactory tf = af.createTreeFactory();
        this.tree = tf.create(f.getAbsolutePath(), "root", true, false, null);
    }
}

