/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.test;

import hep.aida.IAnalysisFactory;
import hep.aida.ICloud1D;
import hep.aida.ICloud2D;
import hep.aida.ICloud3D;
import hep.aida.IDataPoint;
import hep.aida.IDataPointSet;
import hep.aida.IDataPointSetFactory;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.IHistogramFactory;
import hep.aida.IManagedObject;
import hep.aida.IMeasurement;
import hep.aida.IProfile1D;
import hep.aida.IProfile2D;
import hep.aida.ITree;
import hep.aida.ITreeFactory;
import hep.aida.ITuple;
import hep.aida.ITupleFactory;
import hep.aida.test.AidaTestCase;
import java.io.IOException;
import java.util.Random;

public class TestSaveRestoreXML
extends AidaTestCase {
    private String histOutputName = "testHistogram.aida";
    private String histOptions = "compress=no";
    private String tupleOutputName = "testTuple.aida";
    private String tupleOptions = "compress=no";

    public TestSaveRestoreXML(String testName) {
        super(testName);
    }

    public void testHistogramSaveRestore() throws IOException {
        int nEntries = 1234;
        int xbins = 40;
        int ybins = 20;
        int zbins = 10;
        double xLowerEdge = -2.3;
        double xUpperEdge = 4.2;
        double yLowerEdge = -6.1;
        double yUpperEdge = 1.2;
        double zLowerEdge = -0.6;
        double zUpperEdge = 7.5;
        Random r = this.getRandomNumberGenerator();
        IAnalysisFactory analysisFactory = IAnalysisFactory.create();
        ITreeFactory treeFactory = analysisFactory.createTreeFactory();
        ITree tree = treeFactory.create(this.histOutputName, null, false, true, this.histOptions);
        IHistogramFactory histogramFactory = analysisFactory.createHistogramFactory(tree);
        IHistogram1D h1 = histogramFactory.createHistogram1D("Aida 1D Histogram", xbins, xLowerEdge, xUpperEdge);
        IHistogram2D h2 = histogramFactory.createHistogram2D("Aida 2D Histogram", xbins, xLowerEdge, xUpperEdge, ybins, yLowerEdge, yUpperEdge);
        IHistogram3D h3 = histogramFactory.createHistogram3D("Aida 3D Histogram", xbins, xLowerEdge, xUpperEdge, ybins, yLowerEdge, yUpperEdge, zbins, zLowerEdge, zUpperEdge);
        double[] xVarAxis = new double[]{-12.0, -3.0, -1.0, 0.0, 0.23, 2.67, 8.0};
        double[] yVarAxis = new double[]{-34.0, 0.0, 12.0, 78.0};
        double[] zVarAxis = new double[]{-0.345, 0.89, 1.123, 4.3432, 7.234};
        IHistogram1D h1Var = histogramFactory.createHistogram1D("h1Var", "h1VarAxis", xVarAxis, "");
        IHistogram2D h2Var = histogramFactory.createHistogram2D("h2Var", "h2VarAxis", xVarAxis, yVarAxis, "");
        IHistogram3D h3Var = histogramFactory.createHistogram3D("h3Var", "h3VarAxis", xVarAxis, yVarAxis, zVarAxis, "");
        for (int i = 0; i < nEntries; ++i) {
            double xval = r.nextGaussian();
            double yval = r.nextGaussian();
            double zval = r.nextGaussian();
            double w = r.nextDouble();
            if (w > r.nextDouble()) {
                h1.fill(xval, w);
                h2.fill(xval, yval, w);
                h3.fill(xval, yval, zval, w);
                h1Var.fill(xval, w);
                h2Var.fill(xval, yval, w);
                h3Var.fill(xval, yval, zval, w);
                continue;
            }
            h1.fill(xval);
            h2.fill(xval, yval);
            h3.fill(xval, yval, zval);
            h1Var.fill(xval, w);
            h2Var.fill(xval, yval, w);
            h3Var.fill(xval, yval, zval, w);
        }
        TestSaveRestoreXML.assertEquals((int)nEntries, (int)h1.allEntries());
        TestSaveRestoreXML.assertEquals((int)nEntries, (int)h2.allEntries());
        TestSaveRestoreXML.assertEquals((int)nEntries, (int)h3.allEntries());
        tree.commit();
        ITree newTree = treeFactory.create(this.histOutputName);
        newTree.cd("/");
        IHistogram1D h1New = (IHistogram1D)newTree.find(((IManagedObject)h1).name());
        IHistogram2D h2New = (IHistogram2D)newTree.find(((IManagedObject)h2).name());
        IHistogram3D h3New = (IHistogram3D)newTree.find(((IManagedObject)h3).name());
        IHistogram1D h1VarNew = (IHistogram1D)newTree.find(((IManagedObject)h1Var).name());
        IHistogram2D h2VarNew = (IHistogram2D)newTree.find(((IManagedObject)h2Var).name());
        IHistogram3D h3VarNew = (IHistogram3D)newTree.find(((IManagedObject)h3Var).name());
        TestSaveRestoreXML.assertEquals(h1, h1New);
        TestSaveRestoreXML.assertEquals(h2, h2New);
        TestSaveRestoreXML.assertEquals(h3, h3New);
        TestSaveRestoreXML.assertEquals(h1Var, h1VarNew);
        TestSaveRestoreXML.assertEquals(h2Var, h2VarNew);
        TestSaveRestoreXML.assertEquals(h3Var, h3VarNew);
    }

    public void testHistogramZipSaveRestore1D() throws IOException {
        this.histOutputName = "testHistogramZipped.aida";
        this.histOptions = "compress=yes";
        this.testHistogramSaveRestore();
    }

    public void testCloudSaveRestore() throws IOException {
        String cloud2DOpts = " Some= asdf, options = false , for= true, cloud2D = maybe, autoConvert";
        String cloud3DOpts = " Some = sdf, options = False , for = TRUE, cloud3D = maybe, autoconvert = true";
        int maxEntries = 10000000;
        Random r = this.getRandomNumberGenerator();
        String cloudOutputName = "testCloud.aida";
        IAnalysisFactory af = IAnalysisFactory.create();
        ITreeFactory tf = af.createTreeFactory();
        ITree tree = tf.create(cloudOutputName, null, false, true);
        IHistogramFactory hf = af.createHistogramFactory(tree);
        ICloud1D cl1Da = hf.createCloud1D("cl1Da", "Cloud1d Not Converted", maxEntries, "");
        ICloud1D cl1Db = hf.createCloud1D("cl1Db", "Cloud1D Converted", 5, "");
        ICloud2D cl2Da = hf.createCloud2D("cl2Da", "Cloud2D Not Converted", maxEntries, cloud2DOpts);
        ICloud2D cl2Db = hf.createCloud2D("cl2Db", "Cloud2D Converted", 5, cloud2DOpts);
        ICloud3D cl3Da = hf.createCloud3D("cl3Da", "Cloud3D Not Converted", maxEntries, cloud3DOpts);
        ICloud3D cl3Db = hf.createCloud3D("cl3Db", "Cloud3D Converted", 5, cloud3DOpts);
        int entries = 37;
        for (int i = 0; i < entries; ++i) {
            double xval = r.nextGaussian();
            double yval = r.nextGaussian();
            double zval = r.nextGaussian();
            double w = r.nextDouble();
            if (w < r.nextDouble()) {
                cl1Da.fill(xval, w);
                cl1Db.fill(xval, w);
                cl2Da.fill(xval, yval, w);
                cl2Db.fill(xval, yval, w);
                cl3Da.fill(xval, yval, zval, w);
                cl3Db.fill(xval, yval, zval, w);
                continue;
            }
            cl1Da.fill(xval);
            cl1Db.fill(xval);
            cl2Da.fill(xval, yval);
            cl2Db.fill(xval, yval);
            cl3Da.fill(xval, yval, zval);
            cl3Db.fill(xval, yval, zval);
        }
        TestSaveRestoreXML.assertTrue((!cl1Da.isConverted() ? 1 : 0) != 0);
        TestSaveRestoreXML.assertTrue((!cl2Da.isConverted() ? 1 : 0) != 0);
        TestSaveRestoreXML.assertTrue((!cl3Da.isConverted() ? 1 : 0) != 0);
        TestSaveRestoreXML.assertTrue((boolean)cl1Db.isConverted());
        TestSaveRestoreXML.assertTrue((boolean)cl2Db.isConverted());
        TestSaveRestoreXML.assertTrue((boolean)cl3Db.isConverted());
        tree.commit();
        ITree newTree = tf.create(cloudOutputName);
        ICloud1D cl1DaNew = (ICloud1D)newTree.find(((IManagedObject)cl1Da).name());
        ICloud1D cl1DbNew = (ICloud1D)newTree.find(((IManagedObject)cl1Db).name());
        ICloud2D cl2DaNew = (ICloud2D)newTree.find(((IManagedObject)cl2Da).name());
        ICloud2D cl2DbNew = (ICloud2D)newTree.find(((IManagedObject)cl2Db).name());
        ICloud3D cl3DaNew = (ICloud3D)newTree.find(((IManagedObject)cl3Da).name());
        ICloud3D cl3DbNew = (ICloud3D)newTree.find(((IManagedObject)cl3Db).name());
        TestSaveRestoreXML.assertEquals(cl1Da, cl1DaNew);
        TestSaveRestoreXML.assertEquals(cl1Db, cl1DbNew);
        TestSaveRestoreXML.assertEquals(cl2Da, cl2DaNew);
        TestSaveRestoreXML.assertEquals(cl2Db, cl2DbNew);
        TestSaveRestoreXML.assertEquals(cl3Da, cl3DaNew);
        TestSaveRestoreXML.assertEquals(cl3Db, cl3DbNew);
    }

    public void testProfileSaveRestore() throws IOException {
        Random r = this.getRandomNumberGenerator();
        String outputName = "testProfile.aida";
        String options = "compress=no";
        IAnalysisFactory af = IAnalysisFactory.create();
        ITreeFactory tf = af.createTreeFactory();
        ITree tree = tf.create(outputName, null, false, true, options);
        IHistogramFactory hf = af.createHistogramFactory(tree);
        IProfile1D p1 = hf.createProfile1D("p1", "Test Profile 1d", 36, -4.3, 5.0);
        IProfile2D p2 = hf.createProfile2D("p2", "Test Profile 2d", 36, -4.3, 5.0, 3, -1.0, 1.0);
        int entries = 100;
        for (int i = 0; i < entries; ++i) {
            double xval = r.nextGaussian();
            double yval = r.nextDouble();
            double zval = r.nextGaussian();
            p1.fill(xval, zval);
            p2.fill(xval, yval, zval);
        }
        tree.commit();
        ITree newTree = tf.create(outputName);
        TestSaveRestoreXML.assertEquals(p1, (IProfile1D)newTree.find("p1"));
        TestSaveRestoreXML.assertEquals(p2, (IProfile2D)newTree.find("p2"));
    }

    public void testDataPointSetSaveRestore() throws IOException {
        Random r = this.getRandomNumberGenerator();
        String dpsOutputName = "testDataPointSet.aida";
        String options = "compress=no";
        IAnalysisFactory af = IAnalysisFactory.create();
        ITreeFactory tf = af.createTreeFactory();
        ITree tree = tf.create(dpsOutputName, "", false, true, options);
        IDataPointSetFactory df = af.createDataPointSetFactory(tree);
        IDataPointSet ps = df.create("ps", "Test for DataPointSet", 5);
        int nPoints = 10;
        for (int i = 0; i < nPoints; ++i) {
            ps.addPoint();
            IDataPoint point = ps.point(i);
            for (int j = 0; j < point.dimension(); ++j) {
                IMeasurement m = point.coordinate(j);
                m.setValue(r.nextDouble());
                m.setErrorPlus(r.nextDouble());
                m.setErrorMinus(r.nextDouble());
            }
        }
        tree.commit();
        ITree newTree = tf.create(dpsOutputName, null, true, false);
        TestSaveRestoreXML.assertEquals(ps, (IDataPointSet)newTree.find("ps"));
        TestSaveRestoreXML.assertEquals((int)ps.size(), (int)nPoints);
    }

    public void testSaveRestoreTuple() throws IOException {
        String[] allColNames = new String[]{"col1_Int= 1", " col2_Short=2", "col3_Long = 5", "col4_Float   =0.3", " col5_Double =-0.5", "   col6_Boolean=true", "col7_Byte   =23", "col8_Character=f   ", "col9_String = de", "col10_Object", " col11_ITuple = { double px = .2, py = 3., pz = 0., ITuple xyz = {int x,y,z}, float ipx, ipy,ipz, int track=-1}"};
        Class[] allColClasses = new Class[]{Integer.TYPE, Short.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE, Byte.TYPE, Character.TYPE, String.class, Object.class, ITuple.class};
        String tupleName = "myTupleName";
        String tupleTitle = "mytupleTitle";
        String tuple1Opts = "These= are; options = for; the, first= tuple";
        int rows = 5;
        Random r = this.getRandomNumberGenerator();
        IAnalysisFactory analysisFactory = IAnalysisFactory.create();
        ITreeFactory treeFactory = analysisFactory.createTreeFactory();
        ITree tree = treeFactory.create(this.tupleOutputName, null, false, true, this.tupleOptions);
        ITupleFactory tupleFactory = analysisFactory.createTupleFactory(tree);
        ITuple tuple = tupleFactory.create(tupleName, tupleTitle, allColNames, allColClasses, tuple1Opts);
        for (int i = 0; i < rows; ++i) {
            tuple.fill(0, r.nextInt(20));
            tuple.fill(1, (short)r.nextInt(20));
            tuple.fill(2, r.nextLong());
            tuple.fill(3, r.nextFloat());
            tuple.fill(4, r.nextDouble());
            tuple.fill(5, r.nextBoolean());
            byte[] b = new byte[1];
            r.nextBytes(b);
            tuple.fill(6, b[0]);
            tuple.fill(7, Character.forDigit(r.nextInt(36), 36));
            String rndString = String.valueOf(Character.forDigit(r.nextInt(36), 36)) + String.valueOf(Character.forDigit(r.nextInt(36), 36));
            tuple.fill(8, rndString);
            tuple.fill(9, (Object)rndString);
            ITuple folder = tuple.getTuple(10);
            int folderrows = r.nextInt(2);
            for (int j = 0; j < folderrows; ++j) {
                folder.fill(0, r.nextDouble());
                folder.fill(1, r.nextDouble());
                folder.fill(2, r.nextDouble());
                ITuple xyzfolder = folder.getTuple(3);
                int xyzrows = r.nextInt(3);
                for (int k = 0; k < xyzrows; ++k) {
                    xyzfolder.fill(0, r.nextInt(234));
                    xyzfolder.fill(1, r.nextInt(234));
                    xyzfolder.fill(2, r.nextInt(234));
                    xyzfolder.addRow();
                }
                folder.fill(4, r.nextFloat());
                folder.fill(5, r.nextFloat());
                folder.fill(6, r.nextFloat());
                folder.fill(7, r.nextInt(23));
                folder.addRow();
            }
            tuple.addRow();
        }
        tree.commit();
        ITree newTree = treeFactory.create(this.tupleOutputName);
        ITuple tupleNew = (ITuple)newTree.find("/" + ((IManagedObject)tuple).name());
        tuple.fill(9, (Object)"obj");
        tuple.addRow();
        tupleNew.fill(9, (Object)"obj");
        tupleNew.addRow();
        TestSaveRestoreXML.assertEquals(tuple, tupleNew);
    }

    public void testZipSaveRestoreTuple() throws IOException {
        this.tupleOutputName = "testTupleZipped.aida";
        this.tupleOptions = "compress=yes";
        this.testSaveRestoreTuple();
    }
}

