/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.test;

import hep.aida.IAnalysisFactory;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.IHistogramFactory;
import hep.aida.ITree;
import hep.aida.ITreeFactory;
import hep.aida.test.AidaTestCase;
import java.util.Random;

public class TestHistogramMath
extends AidaTestCase {
    IAnalysisFactory analysisFactory = null;
    ITreeFactory treeFactory = null;
    ITree tree = null;
    IHistogramFactory histogramFactory = null;
    String newName = null;
    IHistogram1D h = null;
    IHistogram1D h1 = null;
    IHistogram1D h2 = null;
    IHistogram1D h3 = null;
    IHistogram1D h1Add = null;
    IHistogram1D h1Sub = null;
    IHistogram1D h1Mul = null;
    IHistogram1D h1Div = null;
    IHistogram2D h2D = null;
    IHistogram2D h2D1 = null;
    IHistogram2D h2D2 = null;
    IHistogram2D h2D3 = null;
    IHistogram2D h2Add = null;
    IHistogram2D h2Sub = null;
    IHistogram2D h2Mul = null;
    IHistogram2D h2Div = null;
    IHistogram3D h3D = null;
    IHistogram3D h3D1 = null;
    IHistogram3D h3D2 = null;
    IHistogram3D h3D3 = null;
    IHistogram3D h3Add = null;
    IHistogram3D h3Sub = null;
    IHistogram3D h3Mul = null;
    IHistogram3D h3Div = null;
    double xResult = 0.0;
    double xResultError = 0.0;
    double xResultTrue = 0.0;
    double xResultErrorTrue = 0.0;
    double sumEntry = 0.0;
    double sum = 0.0;
    double sum2 = 0.0;
    double sumY = 0.0;
    double sum2Y = 0.0;
    double sumZ = 0.0;
    double sum2Z = 0.0;
    double d = 0.0;
    double dY = 0.0;
    double dZ = 0.0;
    double meanTrue = 0.0;
    double rmsTrue = 0.0;
    double meanTrueY = 0.0;
    double rmsTrueY = 0.0;
    double meanTrueZ = 0.0;
    double rmsTrueZ = 0.0;
    boolean debug = true;
    double deviation = 1.0E7;
    int xBins = 0;
    int yBins = 0;
    int zBins = 0;
    int indexX1 = 0;
    int indexX2 = 0;
    int indexY1 = 0;
    int indexY2 = 0;
    int indexZ1 = 0;
    int indexZ2 = 0;
    int nEntries = 0;
    double xmin = 0.0;
    double xmax = 0.0;
    double ymin = 0.0;
    double ymax = 0.0;
    double zmin = 0.0;
    double zmax = 0.0;
    Random r = null;

    public TestHistogramMath(String testName) {
        super(testName);
    }

    public void testTest1D() {
        double l2;
        double e2;
        double l1;
        double e1;
        int i;
        this.r = this.getRandomNumberGenerator();
        this.init1D();
        this.newName = "Add";
        this.h = this.histogramFactory.add(this.newName, this.h1, this.h2);
        TestHistogramMath.assertEquals(this.h, this.h1Add);
        this.newName = "Sub";
        this.h = this.histogramFactory.subtract(this.newName, this.h1, this.h2);
        for (i = -2; i < this.h1.axis().bins(); ++i) {
            e1 = this.h1.binError(i);
            double e22 = this.h2.binError(i);
            TestHistogramMath.assertEqualsDouble(this.h.binHeight(i), this.h1Sub.binHeight(i), this.h1Sub.binHeight(i));
            TestHistogramMath.assertEqualsDouble(this.h.binError(i), this.errorSub(e1, e22), 1.0, this.h.binEntries(i));
        }
        this.newName = "Mul";
        this.h = this.histogramFactory.multiply(this.newName, this.h1, this.h3);
        for (i = -2; i < this.h1.axis().bins(); ++i) {
            e1 = this.h1.binError(i);
            l1 = this.h1.binHeight(i);
            e2 = this.h3.binError(i);
            l2 = this.h3.binHeight(i);
            TestHistogramMath.assertEqualsDouble(this.h.binHeight(i), this.h1Mul.binHeight(i), this.h1Mul.binHeight(i));
            TestHistogramMath.assertEqualsDouble(this.h.binError(i), this.errorMul(e1, l1, e2, l2), 1.0, this.h.binEntries(i));
        }
        this.newName = "Div";
        this.h = this.histogramFactory.divide(this.newName, this.h1, this.h3);
        for (i = -2; i < this.h1.axis().bins(); ++i) {
            e1 = this.h1.binError(i);
            l1 = this.h1.binHeight(i);
            e2 = this.h3.binError(i);
            l2 = this.h3.binHeight(i);
            TestHistogramMath.assertEqualsDouble(this.h.binHeight(i), this.h1Div.binHeight(i), this.h1Div.binHeight(i));
            if (l2 == 0.0) continue;
            TestHistogramMath.assertEqualsDouble(this.h.binError(i), this.errorDiv(e1, l1, e2, l2), 1.0, this.h.binEntries(i));
        }
    }

    public void testTest2D() {
        double l2;
        double e2;
        double l1;
        double e1;
        int j;
        int i;
        this.r = this.getRandomNumberGenerator();
        this.init2D();
        this.newName = "Add";
        this.h2D = this.histogramFactory.add(this.newName, this.h2D1, this.h2D2);
        TestHistogramMath.assertEquals(this.h2D, this.h2Add);
        this.newName = "Sub";
        this.h2D = this.histogramFactory.subtract(this.newName, this.h2D1, this.h2D2);
        for (i = -2; i < this.h2D1.xAxis().bins(); ++i) {
            for (j = -2; j < this.h2D1.yAxis().bins(); ++j) {
                e1 = this.h2D1.binError(i, j);
                double e22 = this.h2D2.binError(i, j);
                TestHistogramMath.assertEqualsDouble(this.h2D.binHeight(i, j), this.h2Sub.binHeight(i, j), this.h2Sub.binHeight(i, j));
                TestHistogramMath.assertEqualsDouble(this.h2D.binError(i, j), this.errorSub(e1, e22), 1.0, this.h2D.binEntries(i, j));
            }
        }
        this.newName = "Mul";
        this.h2D = this.histogramFactory.multiply(this.newName, this.h2D1, this.h2D3);
        for (i = -2; i < this.h2D1.xAxis().bins(); ++i) {
            for (j = -2; j < this.h2D1.yAxis().bins(); ++j) {
                e1 = this.h2D1.binError(i, j);
                l1 = this.h2D1.binHeight(i, j);
                e2 = this.h2D3.binError(i, j);
                l2 = this.h2D3.binHeight(i, j);
                TestHistogramMath.assertEqualsDouble(this.h2D.binHeight(i, j), this.h2Mul.binHeight(i, j), this.h2Mul.binHeight(i, j));
                TestHistogramMath.assertEqualsDouble(this.h2D.binError(i, j), this.errorMul(e1, l1, e2, l2), 1.0, this.h2D.binEntries(i, j));
            }
        }
        this.newName = "Div";
        this.h2D = this.histogramFactory.divide(this.newName, this.h2D1, this.h2D3);
        for (i = -2; i < this.h2D1.xAxis().bins(); ++i) {
            for (j = -2; j < this.h2D1.yAxis().bins(); ++j) {
                e1 = this.h2D1.binError(i, j);
                l1 = this.h2D1.binHeight(i, j);
                e2 = this.h2D3.binError(i, j);
                l2 = this.h2D3.binHeight(i, j);
                TestHistogramMath.assertEqualsDouble(this.h2D.binHeight(i, j), this.h2Div.binHeight(i, j), this.h2Div.binHeight(i, j));
                if (l2 == 0.0) continue;
                TestHistogramMath.assertEqualsDouble(this.h2D.binError(i, j), this.errorDiv(e1, l1, e2, l2), 1.0, this.h2D.binEntries(i, j));
            }
        }
    }

    public void testTest3D() {
        double l2;
        double e2;
        double l1;
        double e1;
        int k;
        int j;
        int i;
        this.r = this.getRandomNumberGenerator();
        this.init3D();
        this.newName = "Add";
        this.h3D = this.histogramFactory.add(this.newName, this.h3D1, this.h3D2);
        TestHistogramMath.assertEquals(this.h3D, this.h3Add);
        this.newName = "Sub";
        this.h3D = this.histogramFactory.subtract(this.newName, this.h3D1, this.h3D2);
        for (i = -2; i < this.h3D1.xAxis().bins(); ++i) {
            for (j = -2; j < this.h3D1.yAxis().bins(); ++j) {
                for (k = -2; k < this.h3D1.zAxis().bins(); ++k) {
                    e1 = this.h3D1.binError(i, j, k);
                    double e22 = this.h3D2.binError(i, j, k);
                    TestHistogramMath.assertEqualsDouble(this.h3D.binHeight(i, j, k), this.h3Sub.binHeight(i, j, k), this.h3D1.binHeight(i, j, k));
                    TestHistogramMath.assertEqualsDouble(this.h3D.binError(i, j, k), this.errorSub(e1, e22), 1.0, this.h3D1.binEntries(i, j, k));
                }
            }
        }
        this.newName = "Mul";
        this.h3D = this.histogramFactory.multiply(this.newName, this.h3D1, this.h3D3);
        for (i = -2; i < this.h3D1.xAxis().bins(); ++i) {
            for (j = -2; j < this.h3D1.yAxis().bins(); ++j) {
                for (k = -2; k < this.h3D1.zAxis().bins(); ++k) {
                    e1 = this.h3D1.binError(i, j, k);
                    l1 = this.h3D1.binHeight(i, j, k);
                    e2 = this.h3D3.binError(i, j, k);
                    l2 = this.h3D3.binHeight(i, j, k);
                    TestHistogramMath.assertEqualsDouble(this.h3D.binHeight(i, j, k), this.h3Mul.binHeight(i, j, k), this.h3Mul.binHeight(i, j, k));
                    TestHistogramMath.assertEqualsDouble(this.h3D.binError(i, j, k), this.errorMul(e1, l1, e2, l2), 1.0, this.h3D.binEntries(i, j, k));
                }
            }
        }
        this.newName = "Div";
        this.h3D = this.histogramFactory.divide(this.newName, this.h3D1, this.h3D3);
        for (i = -2; i < this.h3D1.xAxis().bins(); ++i) {
            for (j = -2; j < this.h3D1.yAxis().bins(); ++j) {
                for (k = -2; k < this.h3D1.zAxis().bins(); ++k) {
                    e1 = this.h3D1.binError(i, j, k);
                    l1 = this.h3D1.binHeight(i, j, k);
                    e2 = this.h3D3.binError(i, j, k);
                    l2 = this.h3D3.binHeight(i, j, k);
                    TestHistogramMath.assertEqualsDouble(this.h3D.binHeight(i, j, k), this.h3Div.binHeight(i, j, k), this.h3Div.binHeight(i, j, k));
                    if (l2 == 0.0) continue;
                    TestHistogramMath.assertEqualsDouble(this.h3D.binError(i, j, k), this.errorDiv(e1, l1, e2, l2), 1.0, this.h3D.binEntries(i, j, k));
                }
            }
        }
    }

    public void init1D() {
        double w;
        double x;
        int i;
        this.debug = false;
        this.xBins = 53;
        this.nEntries = 1600;
        this.xmin = -5.0;
        this.xmax = 7.0;
        this.analysisFactory = IAnalysisFactory.create();
        this.treeFactory = this.analysisFactory.createTreeFactory();
        this.tree = this.analysisFactory.createTreeFactory().create();
        this.histogramFactory = this.analysisFactory.createHistogramFactory(this.tree);
        this.h1 = this.histogramFactory.createHistogram1D("Hist 1", this.xBins, this.xmin, this.xmax);
        this.h2 = this.histogramFactory.createHistogram1D("Hist 2", this.xBins, this.xmin, this.xmax);
        this.h3 = this.histogramFactory.createHistogram1D("Hist 3", this.xBins, this.xmin, this.xmax);
        this.h1Add = this.histogramFactory.createHistogram1D("Add", this.xBins, this.xmin, this.xmax);
        this.h1Sub = this.histogramFactory.createHistogram1D("Sub", this.xBins, this.xmin, this.xmax);
        this.h1Mul = this.histogramFactory.createHistogram1D("Mul", this.xBins, this.xmin, this.xmax);
        this.h1Div = this.histogramFactory.createHistogram1D("Div", this.xBins, this.xmin, this.xmax);
        double[] xval = new double[this.nEntries];
        double[] weight = new double[this.nEntries];
        for (i = 0; i < this.nEntries; ++i) {
            x = this.gaussValue(this.xmin, this.xmax);
            w = this.r.nextDouble();
            this.h3.fill(this.flatValue(this.xmin, this.xmax), this.flatValue(0.0, 1.0));
            xval[i] = x;
            weight[i] = w;
            this.h1.fill(x, w);
            this.h1Add.fill(x, w);
            if (this.r.nextDouble() > 0.5) {
                this.h2.fill(x, w);
                this.h1Add.fill(x, w);
                continue;
            }
            this.h1Sub.fill(x, w);
        }
        for (i = 0; i < this.nEntries; ++i) {
            x = xval[i];
            w = weight[i];
            int bin = this.h1.coordToIndex(x);
            double height = this.h3.binHeight(bin);
            this.h1Mul.fill(x, w * height);
            if (height == 0.0) continue;
            this.h1Div.fill(x, w / height);
        }
    }

    public void init2D() {
        double w;
        double y;
        double x;
        int i;
        this.debug = false;
        this.xBins = 15;
        this.yBins = 9;
        this.nEntries = 20000;
        this.xmin = -6.0;
        this.xmax = 12.0;
        this.ymin = 1.0;
        this.ymax = 3.5;
        this.analysisFactory = IAnalysisFactory.create();
        this.treeFactory = this.analysisFactory.createTreeFactory();
        this.tree = this.analysisFactory.createTreeFactory().create();
        this.histogramFactory = this.analysisFactory.createHistogramFactory(this.tree);
        this.h2D1 = this.histogramFactory.createHistogram2D("Hist2D 1", this.xBins, this.xmin, this.xmax, this.yBins, this.ymin, this.ymax);
        this.h2D2 = this.histogramFactory.createHistogram2D("Hist2D 2", this.xBins, this.xmin, this.xmax, this.yBins, this.ymin, this.ymax);
        this.h2D3 = this.histogramFactory.createHistogram2D("Hist2D 3", this.xBins, this.xmin, this.xmax, this.yBins, this.ymin, this.ymax);
        this.h2Add = this.histogramFactory.createHistogram2D("Add", this.xBins, this.xmin, this.xmax, this.yBins, this.ymin, this.ymax);
        this.h2Sub = this.histogramFactory.createHistogram2D("Sub", this.xBins, this.xmin, this.xmax, this.yBins, this.ymin, this.ymax);
        this.h2Mul = this.histogramFactory.createHistogram2D("Mul", this.xBins, this.xmin, this.xmax, this.yBins, this.ymin, this.ymax);
        this.h2Div = this.histogramFactory.createHistogram2D("Div", this.xBins, this.xmin, this.xmax, this.yBins, this.ymin, this.ymax);
        double[] xval = new double[this.nEntries];
        double[] yval = new double[this.nEntries];
        double[] weight = new double[this.nEntries];
        for (i = 0; i < this.nEntries; ++i) {
            x = this.gaussValue(this.xmin, this.xmax);
            y = this.gaussValue(this.ymin, this.ymax);
            w = this.r.nextDouble();
            xval[i] = x;
            yval[i] = y;
            weight[i] = w;
            this.h2D3.fill(this.flatValue(this.xmin, this.xmax), this.flatValue(this.ymin, this.ymax), this.flatValue(0.0, 1.0));
            this.h2D1.fill(x, y, w);
            this.h2Add.fill(x, y, w);
            if (this.r.nextDouble() > 0.5) {
                this.h2D2.fill(x, y, w);
                this.h2Add.fill(x, y, w);
                continue;
            }
            this.h2Sub.fill(x, y, w);
        }
        for (i = 0; i < this.nEntries; ++i) {
            x = xval[i];
            y = yval[i];
            w = weight[i];
            int binx = this.h2D1.coordToIndexX(x);
            int biny = this.h2D1.coordToIndexY(y);
            double height = this.h2D3.binHeight(binx, biny);
            this.h2Mul.fill(x, y, w * height);
            if (height == 0.0) continue;
            this.h2Div.fill(x, y, w / height);
        }
    }

    public void init3D() {
        double w;
        double z;
        double y;
        double x;
        int i;
        this.debug = false;
        this.xBins = 9;
        this.yBins = 11;
        this.zBins = 4;
        this.nEntries = 20000;
        this.xmin = -3.0;
        this.xmax = -1.56;
        this.ymin = 1.0;
        this.ymax = 6.2;
        this.zmin = -8.1;
        this.zmax = 5.6;
        this.analysisFactory = IAnalysisFactory.create();
        this.treeFactory = this.analysisFactory.createTreeFactory();
        this.tree = this.analysisFactory.createTreeFactory().create();
        this.histogramFactory = this.analysisFactory.createHistogramFactory(this.tree);
        this.h3D1 = this.histogramFactory.createHistogram3D("Hist3D 1", this.xBins, this.xmin, this.xmax, this.yBins, this.ymin, this.ymax, this.zBins, this.zmin, this.zmax);
        this.h3D2 = this.histogramFactory.createHistogram3D("Hist3D 2", this.xBins, this.xmin, this.xmax, this.yBins, this.ymin, this.ymax, this.zBins, this.zmin, this.zmax);
        this.h3D3 = this.histogramFactory.createHistogram3D("Hist3D 3", this.xBins, this.xmin, this.xmax, this.yBins, this.ymin, this.ymax, this.zBins, this.zmin, this.zmax);
        this.h3Add = this.histogramFactory.createHistogram3D("Add", this.xBins, this.xmin, this.xmax, this.yBins, this.ymin, this.ymax, this.zBins, this.zmin, this.zmax);
        this.h3Sub = this.histogramFactory.createHistogram3D("Sub", this.xBins, this.xmin, this.xmax, this.yBins, this.ymin, this.ymax, this.zBins, this.zmin, this.zmax);
        this.h3Mul = this.histogramFactory.createHistogram3D("Mul", this.xBins, this.xmin, this.xmax, this.yBins, this.ymin, this.ymax, this.zBins, this.zmin, this.zmax);
        this.h3Div = this.histogramFactory.createHistogram3D("Div", this.xBins, this.xmin, this.xmax, this.yBins, this.ymin, this.ymax, this.zBins, this.zmin, this.zmax);
        double[] xval = new double[this.nEntries];
        double[] yval = new double[this.nEntries];
        double[] zval = new double[this.nEntries];
        double[] weight = new double[this.nEntries];
        for (i = 0; i < this.nEntries; ++i) {
            x = this.gaussValue(this.xmin, this.xmax);
            y = this.gaussValue(this.ymin, this.ymax);
            z = this.gaussValue(this.zmin, this.zmax);
            w = this.r.nextDouble();
            this.h3D3.fill(this.flatValue(this.xmin, this.xmax), this.flatValue(this.ymin, this.ymax), this.flatValue(this.zmin, this.zmax), this.flatValue(0.0, 1.0));
            xval[i] = x;
            yval[i] = y;
            zval[i] = z;
            weight[i] = w;
            this.h3D1.fill(x, y, z, w);
            this.h3Add.fill(x, y, z, w);
            if (this.r.nextDouble() > 0.5) {
                this.h3D2.fill(x, y, z, w);
                this.h3Add.fill(x, y, z, w);
                continue;
            }
            this.h3Sub.fill(x, y, z, w);
        }
        for (i = 0; i < this.nEntries; ++i) {
            x = xval[i];
            y = yval[i];
            z = zval[i];
            w = weight[i];
            int binx = this.h3D1.coordToIndexX(x);
            int biny = this.h3D1.coordToIndexY(y);
            int binz = this.h3D1.coordToIndexZ(z);
            double height = this.h3D3.binHeight(binx, biny, binz);
            this.h3Mul.fill(x, y, z, w * height);
            if (height == 0.0) continue;
            this.h3Div.fill(x, y, z, w / height);
        }
    }

    private double gaussValue(double vmin, double vmax) {
        return this.r.nextGaussian() * (vmax - vmin) / 3.0 + (vmin + vmax) / 2.0;
    }

    private double flatValue(double vmin, double vmax) {
        return vmin + (vmax - vmin) * this.r.nextDouble();
    }

    public double errorAdd(double e1, double e2) {
        return Math.sqrt(e1 * e1 + e2 * e2);
    }

    public double errorSub(double e1, double e2) {
        return this.errorAdd(e1, e2);
    }

    public double errorMul(double e1, double l1, double e2, double l2) {
        return Math.sqrt(Math.pow(e1 * l2, 2.0) + Math.pow(e2 * l1, 2.0));
    }

    public double errorDiv(double e1, double l1, double e2, double l2) {
        return Math.sqrt(Math.pow(e1 / l2, 2.0) + Math.pow(e2 * l1 / (l2 * l2), 2.0));
    }
}

