/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.doublealgo;

import cern.colt.Timer;
import cern.colt.function.DoubleDoubleFunction;
import cern.colt.list.DoubleArrayList;
import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.DoubleMatrix3D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.jet.math.Functions;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.sampling.RandomSampler;
import cern.jet.stat.Descriptive;
import edu.cornell.lassp.houle.RngPack.RandomElement;
import hep.aida.IAxis;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.bin.BinFunction1D;
import hep.aida.bin.DynamicBin1D;
import hep.aida.ref.Histogram2D;
import hep.aida.ref.Histogram3D;
import hep.aida.ref.VariableAxis;

public class Statistic {
    private static final Functions F = Functions.functions;
    public static final VectorVectorFunction EUCLID = new VectorVectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            F;
            F;
            F;
            F;
            return Math.sqrt(doubleMatrix1D.aggregate(doubleMatrix1D2, Functions.plus, Functions.chain(Functions.square, Functions.minus)));
        }
    };
    public static final VectorVectorFunction BRAY_CURTIS = new VectorVectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            F;
            F;
            F;
            F;
            double d = doubleMatrix1D.aggregate(doubleMatrix1D2, Functions.plus, Functions.chain(Functions.abs, Functions.minus));
            F;
            F;
            return d / doubleMatrix1D.aggregate(doubleMatrix1D2, Functions.plus, Functions.plus);
        }
    };
    public static final VectorVectorFunction CANBERRA = new VectorVectorFunction(){
        DoubleDoubleFunction fun = new DoubleDoubleFunction(this){
            private final /* synthetic */ 3 this$0;
            {
                this.this$0 = var1_1;
            }

            public final double apply(double d, double d2) {
                return Math.abs(d - d2) / Math.abs(d + d2);
            }
        };

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            F;
            return doubleMatrix1D.aggregate(doubleMatrix1D2, Functions.plus, this.fun);
        }
    };
    public static final VectorVectorFunction MAXIMUM = new VectorVectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            F;
            F;
            F;
            F;
            return doubleMatrix1D.aggregate(doubleMatrix1D2, Functions.max, Functions.chain(Functions.abs, Functions.minus));
        }
    };
    public static final VectorVectorFunction MANHATTAN = new VectorVectorFunction(){

        public final double apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            F;
            F;
            F;
            F;
            return doubleMatrix1D.aggregate(doubleMatrix1D2, Functions.plus, Functions.chain(Functions.abs, Functions.minus));
        }
    };

    protected Statistic() {
    }

    public static DoubleMatrix2D aggregate(DoubleMatrix2D doubleMatrix2D, BinFunction1D[] binFunction1DArray, DoubleMatrix2D doubleMatrix2D2) {
        DynamicBin1D dynamicBin1D = new DynamicBin1D();
        double[] dArray = new double[doubleMatrix2D.rows()];
        DoubleArrayList doubleArrayList = new DoubleArrayList(dArray);
        int n = doubleMatrix2D.columns();
        while (--n >= 0) {
            doubleMatrix2D.viewColumn(n).toArray(dArray);
            dynamicBin1D.clear();
            dynamicBin1D.addAllOf(doubleArrayList);
            int n2 = binFunction1DArray.length;
            while (--n2 >= 0) {
                doubleMatrix2D2.set(n2, n, binFunction1DArray[n2].apply(dynamicBin1D));
            }
        }
        return doubleMatrix2D2;
    }

    public static DynamicBin1D bin(DoubleMatrix1D doubleMatrix1D) {
        DynamicBin1D dynamicBin1D = new DynamicBin1D();
        dynamicBin1D.addAllOf(DoubleFactory1D.dense.toList(doubleMatrix1D));
        return dynamicBin1D;
    }

    public static DoubleMatrix2D correlation(DoubleMatrix2D doubleMatrix2D) {
        int n;
        int n2 = doubleMatrix2D.columns();
        while (--n2 >= 0) {
            n = n2;
            while (--n >= 0) {
                double d = Math.sqrt(doubleMatrix2D.getQuick(n2, n2));
                double d2 = Math.sqrt(doubleMatrix2D.getQuick(n, n));
                double d3 = doubleMatrix2D.getQuick(n2, n);
                double d4 = d3 / (d * d2);
                doubleMatrix2D.setQuick(n2, n, d4);
                doubleMatrix2D.setQuick(n, n2, d4);
            }
        }
        n = doubleMatrix2D.columns();
        while (--n >= 0) {
            doubleMatrix2D.setQuick(n, n, 1.0);
        }
        return doubleMatrix2D;
    }

    public static DoubleMatrix2D covariance(DoubleMatrix2D doubleMatrix2D) {
        int n = doubleMatrix2D.rows();
        int n2 = doubleMatrix2D.columns();
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(n2, n2);
        double[] dArray = new double[n2];
        DoubleMatrix1D[] doubleMatrix1DArray = new DoubleMatrix1D[n2];
        int n3 = n2;
        while (--n3 >= 0) {
            doubleMatrix1DArray[n3] = doubleMatrix2D.viewColumn(n3);
            dArray[n3] = doubleMatrix1DArray[n3].zSum();
        }
        int n4 = n2;
        while (--n4 >= 0) {
            int n5 = n4 + 1;
            while (--n5 >= 0) {
                double d = doubleMatrix1DArray[n4].zDotProduct(doubleMatrix1DArray[n5]);
                double d2 = (d - dArray[n4] * dArray[n5] / (double)n) / (double)n;
                ((DoubleMatrix2D)denseDoubleMatrix2D).setQuick(n4, n5, d2);
                ((DoubleMatrix2D)denseDoubleMatrix2D).setQuick(n5, n4, d2);
            }
        }
        return denseDoubleMatrix2D;
    }

    public static IHistogram2D cube(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, DoubleMatrix1D doubleMatrix1D3) {
        if (doubleMatrix1D.size() != doubleMatrix1D2.size() || doubleMatrix1D2.size() != doubleMatrix1D3.size()) {
            throw new IllegalArgumentException("vectors must have same size");
        }
        double d = 1.0E-9;
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        double[] dArray = new double[doubleMatrix1D.size()];
        DoubleArrayList doubleArrayList2 = new DoubleArrayList(dArray);
        doubleMatrix1D.toArray(dArray);
        doubleArrayList2.sort();
        Descriptive.frequencies(doubleArrayList2, doubleArrayList, null);
        if (doubleArrayList.size() > 0) {
            doubleArrayList.add(doubleArrayList.get(doubleArrayList.size() - 1) + d);
        }
        doubleArrayList.trimToSize();
        VariableAxis variableAxis = new VariableAxis(doubleArrayList.elements());
        doubleMatrix1D2.toArray(dArray);
        doubleArrayList2.sort();
        Descriptive.frequencies(doubleArrayList2, doubleArrayList, null);
        if (doubleArrayList.size() > 0) {
            doubleArrayList.add(doubleArrayList.get(doubleArrayList.size() - 1) + d);
        }
        doubleArrayList.trimToSize();
        VariableAxis variableAxis2 = new VariableAxis(doubleArrayList.elements());
        Histogram2D histogram2D = new Histogram2D("Cube", (IAxis)variableAxis, (IAxis)variableAxis2);
        return Statistic.histogram((IHistogram2D)histogram2D, doubleMatrix1D, doubleMatrix1D2, doubleMatrix1D3);
    }

    public static IHistogram3D cube(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, DoubleMatrix1D doubleMatrix1D3, DoubleMatrix1D doubleMatrix1D4) {
        if (doubleMatrix1D.size() != doubleMatrix1D2.size() || doubleMatrix1D.size() != doubleMatrix1D3.size() || doubleMatrix1D.size() != doubleMatrix1D4.size()) {
            throw new IllegalArgumentException("vectors must have same size");
        }
        double d = 1.0E-9;
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        double[] dArray = new double[doubleMatrix1D.size()];
        DoubleArrayList doubleArrayList2 = new DoubleArrayList(dArray);
        doubleMatrix1D.toArray(dArray);
        doubleArrayList2.sort();
        Descriptive.frequencies(doubleArrayList2, doubleArrayList, null);
        if (doubleArrayList.size() > 0) {
            doubleArrayList.add(doubleArrayList.get(doubleArrayList.size() - 1) + d);
        }
        doubleArrayList.trimToSize();
        VariableAxis variableAxis = new VariableAxis(doubleArrayList.elements());
        doubleMatrix1D2.toArray(dArray);
        doubleArrayList2.sort();
        Descriptive.frequencies(doubleArrayList2, doubleArrayList, null);
        if (doubleArrayList.size() > 0) {
            doubleArrayList.add(doubleArrayList.get(doubleArrayList.size() - 1) + d);
        }
        doubleArrayList.trimToSize();
        VariableAxis variableAxis2 = new VariableAxis(doubleArrayList.elements());
        doubleMatrix1D3.toArray(dArray);
        doubleArrayList2.sort();
        Descriptive.frequencies(doubleArrayList2, doubleArrayList, null);
        if (doubleArrayList.size() > 0) {
            doubleArrayList.add(doubleArrayList.get(doubleArrayList.size() - 1) + d);
        }
        doubleArrayList.trimToSize();
        VariableAxis variableAxis3 = new VariableAxis(doubleArrayList.elements());
        Histogram3D histogram3D = new Histogram3D("Cube", (IAxis)variableAxis, (IAxis)variableAxis2, (IAxis)variableAxis3);
        return Statistic.histogram((IHistogram3D)histogram3D, doubleMatrix1D, doubleMatrix1D2, doubleMatrix1D3, doubleMatrix1D4);
    }

    public static void demo1() {
        double[][] dArrayArray = new double[][]{{1.0, 2.0, 3.0}, {2.0, 4.0, 6.0}, {3.0, 6.0, 9.0}, {4.0, -8.0, -10.0}};
        DoubleFactory2D doubleFactory2D = DoubleFactory2D.dense;
        DoubleMatrix2D doubleMatrix2D = doubleFactory2D.make(dArrayArray);
        System.out.println("\n\nmatrix=" + doubleMatrix2D);
        System.out.println("\ncovar1=" + Statistic.covariance(doubleMatrix2D));
    }

    public static void demo2(int n, int n2, boolean bl) {
        System.out.println("\n\ninitializing...");
        DoubleFactory2D doubleFactory2D = DoubleFactory2D.dense;
        DoubleMatrix2D doubleMatrix2D = doubleFactory2D.ascending(n, n2);
        System.out.println("benchmarking correlation...");
        Timer timer = new Timer().start();
        DoubleMatrix2D doubleMatrix2D2 = Statistic.correlation(Statistic.covariance(doubleMatrix2D));
        timer.stop().display();
        if (bl) {
            System.out.println("printing result...");
            System.out.println(doubleMatrix2D2);
        }
        System.out.println("done.");
    }

    public static void demo3(VectorVectorFunction vectorVectorFunction) {
        double[][] dArrayArray = new double[][]{{-0.9611052, -0.25421095}, {0.4308269, -0.69932648}, {-1.2071029, 0.62030596}, {1.5345166, 0.02135884}, {-1.1341542, 0.2038843}};
        System.out.println("\n\ninitializing...");
        DoubleFactory2D doubleFactory2D = DoubleFactory2D.dense;
        DoubleMatrix2D doubleMatrix2D = doubleFactory2D.make(dArrayArray).viewDice();
        System.out.println("\nA=" + doubleMatrix2D.viewDice());
        System.out.println("\ndist=" + Statistic.distance(doubleMatrix2D, vectorVectorFunction).viewDice());
    }

    public static DoubleMatrix2D distance(DoubleMatrix2D doubleMatrix2D, VectorVectorFunction vectorVectorFunction) {
        int n = doubleMatrix2D.columns();
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(n, n);
        DoubleMatrix1D[] doubleMatrix1DArray = new DoubleMatrix1D[n];
        int n2 = n;
        while (--n2 >= 0) {
            doubleMatrix1DArray[n2] = doubleMatrix2D.viewColumn(n2);
        }
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n3;
            while (--n4 >= 0) {
                double d = vectorVectorFunction.apply(doubleMatrix1DArray[n3], doubleMatrix1DArray[n4]);
                ((DoubleMatrix2D)denseDoubleMatrix2D).setQuick(n3, n4, d);
                ((DoubleMatrix2D)denseDoubleMatrix2D).setQuick(n4, n3, d);
            }
        }
        return denseDoubleMatrix2D;
    }

    public static IHistogram1D histogram(IHistogram1D iHistogram1D, DoubleMatrix1D doubleMatrix1D) {
        int n = doubleMatrix1D.size();
        while (--n >= 0) {
            iHistogram1D.fill(doubleMatrix1D.getQuick(n));
        }
        return iHistogram1D;
    }

    public static IHistogram2D histogram(IHistogram2D iHistogram2D, DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        if (doubleMatrix1D.size() != doubleMatrix1D2.size()) {
            throw new IllegalArgumentException("vectors must have same size");
        }
        int n = doubleMatrix1D.size();
        while (--n >= 0) {
            iHistogram2D.fill(doubleMatrix1D.getQuick(n), doubleMatrix1D2.getQuick(n));
        }
        return iHistogram2D;
    }

    public static IHistogram2D histogram(IHistogram2D iHistogram2D, DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, DoubleMatrix1D doubleMatrix1D3) {
        if (doubleMatrix1D.size() != doubleMatrix1D2.size() || doubleMatrix1D2.size() != doubleMatrix1D3.size()) {
            throw new IllegalArgumentException("vectors must have same size");
        }
        int n = doubleMatrix1D.size();
        while (--n >= 0) {
            iHistogram2D.fill(doubleMatrix1D.getQuick(n), doubleMatrix1D2.getQuick(n), doubleMatrix1D3.getQuick(n));
        }
        return iHistogram2D;
    }

    public static IHistogram3D histogram(IHistogram3D iHistogram3D, DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, DoubleMatrix1D doubleMatrix1D3, DoubleMatrix1D doubleMatrix1D4) {
        if (doubleMatrix1D.size() != doubleMatrix1D2.size() || doubleMatrix1D.size() != doubleMatrix1D3.size() || doubleMatrix1D.size() != doubleMatrix1D4.size()) {
            throw new IllegalArgumentException("vectors must have same size");
        }
        int n = doubleMatrix1D.size();
        while (--n >= 0) {
            iHistogram3D.fill(doubleMatrix1D.getQuick(n), doubleMatrix1D2.getQuick(n), doubleMatrix1D3.getQuick(n), doubleMatrix1D4.getQuick(n));
        }
        return iHistogram3D;
    }

    public static void main(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        boolean bl = stringArray[2].equals("print");
        Statistic.demo2(n, n2, bl);
    }

    public static DoubleMatrix1D viewSample(DoubleMatrix1D doubleMatrix1D, double d, RandomElement randomElement) {
        int n;
        double d2 = 1.0E-9;
        if (d < 0.0 - d2 || d > 1.0 + d2) {
            throw new IllegalArgumentException();
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        if (randomElement == null) {
            randomElement = new MersenneTwister((int)System.currentTimeMillis());
        }
        int n2 = n = (int)Math.round((double)doubleMatrix1D.size() * d);
        long[] lArray = new long[n2];
        int n3 = n;
        int n4 = doubleMatrix1D.size();
        RandomSampler.sample(n3, n4, n3, 0L, lArray, 0, randomElement);
        int[] nArray = new int[n3];
        int n5 = 0;
        while (n5 < n3) {
            nArray[n5] = (int)lArray[n5];
            ++n5;
        }
        return doubleMatrix1D.viewSelection(nArray);
    }

    public static DoubleMatrix2D viewSample(DoubleMatrix2D doubleMatrix2D, double d, double d2, RandomElement randomElement) {
        double d3 = 1.0E-9;
        if (d < 0.0 - d3 || d > 1.0 + d3) {
            throw new IllegalArgumentException();
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        if (d2 < 0.0 - d3 || d2 > 1.0 + d3) {
            throw new IllegalArgumentException();
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        if (randomElement == null) {
            randomElement = new MersenneTwister((int)System.currentTimeMillis());
        }
        int n = (int)Math.round((double)doubleMatrix2D.rows() * d);
        int n2 = (int)Math.round((double)doubleMatrix2D.columns() * d2);
        int n3 = Math.max(n, n2);
        long[] lArray = new long[n3];
        int n4 = n;
        int n5 = doubleMatrix2D.rows();
        RandomSampler.sample(n4, n5, n4, 0L, lArray, 0, randomElement);
        int[] nArray = new int[n4];
        int n6 = 0;
        while (n6 < n4) {
            nArray[n6] = (int)lArray[n6];
            ++n6;
        }
        n4 = n2;
        n5 = doubleMatrix2D.columns();
        RandomSampler.sample(n4, n5, n4, 0L, lArray, 0, randomElement);
        int[] nArray2 = new int[n4];
        int n7 = 0;
        while (n7 < n4) {
            nArray2[n7] = (int)lArray[n7];
            ++n7;
        }
        return doubleMatrix2D.viewSelection(nArray, nArray2);
    }

    public static DoubleMatrix3D viewSample(DoubleMatrix3D doubleMatrix3D, double d, double d2, double d3, RandomElement randomElement) {
        double d4 = 1.0E-9;
        if (d < 0.0 - d4 || d > 1.0 + d4) {
            throw new IllegalArgumentException();
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        if (d2 < 0.0 - d4 || d2 > 1.0 + d4) {
            throw new IllegalArgumentException();
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        if (d3 < 0.0 - d4 || d3 > 1.0 + d4) {
            throw new IllegalArgumentException();
        }
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        if (d3 > 1.0) {
            d3 = 1.0;
        }
        if (randomElement == null) {
            randomElement = new MersenneTwister((int)System.currentTimeMillis());
        }
        int n = (int)Math.round((double)doubleMatrix3D.slices() * d);
        int n2 = (int)Math.round((double)doubleMatrix3D.rows() * d2);
        int n3 = (int)Math.round((double)doubleMatrix3D.columns() * d3);
        int n4 = Math.max(n, Math.max(n2, n3));
        long[] lArray = new long[n4];
        int n5 = n;
        int n6 = doubleMatrix3D.slices();
        RandomSampler.sample(n5, n6, n5, 0L, lArray, 0, randomElement);
        int[] nArray = new int[n5];
        int n7 = 0;
        while (n7 < n5) {
            nArray[n7] = (int)lArray[n7];
            ++n7;
        }
        n5 = n2;
        n6 = doubleMatrix3D.rows();
        RandomSampler.sample(n5, n6, n5, 0L, lArray, 0, randomElement);
        int[] nArray2 = new int[n5];
        int n8 = 0;
        while (n8 < n5) {
            nArray2[n8] = (int)lArray[n8];
            ++n8;
        }
        n5 = n3;
        n6 = doubleMatrix3D.columns();
        RandomSampler.sample(n5, n6, n5, 0L, lArray, 0, randomElement);
        int[] nArray3 = new int[n5];
        int n9 = 0;
        while (n9 < n5) {
            nArray3[n9] = (int)lArray[n9];
            ++n9;
        }
        return doubleMatrix3D.viewSelection(nArray, nArray2, nArray3);
    }

    private static DoubleMatrix2D xdistanceOld(DoubleMatrix2D doubleMatrix2D, int n) {
        return null;
    }

    private static DoubleMatrix2D xdistanceOld2(DoubleMatrix2D doubleMatrix2D, int n) {
        return null;
    }

    public static interface VectorVectorFunction {
        public double apply(DoubleMatrix1D var1, DoubleMatrix1D var2);
    }
}

