/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractDistribution;
import cern.jet.random.BreitWigner;
import cern.jet.random.Uniform;
import edu.cornell.lassp.houle.RngPack.RandomElement;

public class BreitWignerMeanSquare
extends BreitWigner {
    protected Uniform uniform;
    protected static BreitWigner shared = new BreitWignerMeanSquare(1.0, 0.2, 1.0, AbstractDistribution.makeDefaultGenerator());

    public BreitWignerMeanSquare(double d, double d2, double d3, RandomElement randomElement) {
        super(d, d2, d3, randomElement);
        this.uniform = new Uniform(randomElement);
    }

    public Object clone() {
        BreitWignerMeanSquare breitWignerMeanSquare = (BreitWignerMeanSquare)super.clone();
        if (this.uniform != null) {
            breitWignerMeanSquare.uniform = new Uniform(breitWignerMeanSquare.randomGenerator);
        }
        return breitWignerMeanSquare;
    }

    public double nextDouble(double d, double d2, double d3) {
        if (d2 == 0.0) {
            return d;
        }
        if (d3 == Double.NEGATIVE_INFINITY) {
            double d4 = Math.atan(-d / d2);
            double d5 = this.uniform.nextDoubleFromTo(d4, 1.5707963267948966);
            double d6 = d2 * Math.tan(d5);
            return Math.sqrt(d * d + d * d6);
        }
        double d7 = Math.max(0.0, d - d3);
        double d8 = Math.atan((d7 * d7 - d * d) / (d * d2));
        double d9 = Math.atan(((d + d3) * (d + d3) - d * d) / (d * d2));
        double d10 = this.uniform.nextDoubleFromTo(d8, d9);
        double d11 = d2 * Math.tan(d10);
        return Math.sqrt(Math.max(0.0, d * d + d * d11));
    }

    public static double staticNextDouble(double d, double d2, double d3) {
        BreitWigner breitWigner = shared;
        synchronized (breitWigner) {
            double d4 = shared.nextDouble(d, d2, d3);
            return d4;
        }
    }

    private static void xstaticSetRandomGenerator(RandomElement randomElement) {
        BreitWigner breitWigner = shared;
        synchronized (breitWigner) {
            shared.setRandomGenerator(randomElement);
        }
    }
}

