/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dk.dps.io;

import com.ibm.dk.dps.io.PreProcessorException;
import com.ibm.dk.dps.io.PreProcessorLine;
import com.ibm.dk.dps.util.StringUtility;
import java.io.IOException;
import java.util.Stack;

abstract class StackElement {
    public static final int s_iCONDITIONAL_NONE = 0;
    public static final int s_iCONDITIONAL_PARSE_PROCESSING = 1;
    public static final int s_iCONDITIONAL_PARSE_IGNORING = 2;
    private int d_iConditionalParseState = 0;
    private Stack d_stackConditionalParse = new Stack();
    private Stack d_stackPushedLines = new Stack();
    private int d_iLineCounter;
    private boolean d_fBlockCommentAtPrevEnd = false;
    private String d_strNextLineStart;

    public abstract void close() throws IOException;

    abstract String getNextLine() throws IOException;

    public abstract String getName();

    public abstract boolean isParsingC();

    public void setIsProcessingIfStatement() {
        this.d_stackConditionalParse.push(new Integer(this.d_iConditionalParseState));
        this.d_iConditionalParseState = 1;
    }

    public void setIsIgnoringIfStatement() {
        this.d_stackConditionalParse.push(new Integer(this.d_iConditionalParseState));
        this.d_iConditionalParseState = 2;
    }

    public void dropParseCondition() throws PreProcessorException {
        if (this.d_stackConditionalParse.isEmpty()) {
            throw new PreProcessorException("Unmatched #endif, #else or #elif");
        }
        this.d_iConditionalParseState = (Integer)this.d_stackConditionalParse.pop();
    }

    public boolean isProcessingCondition() {
        return this.d_iConditionalParseState == 1;
    }

    public boolean isIgnoringCondition() {
        return this.d_iConditionalParseState == 2;
    }

    public final void pushLine(PreProcessorLine line) {
        this.d_stackPushedLines.push(line);
        --this.d_iLineCounter;
    }

    public final void pushNextLineStart(String str) throws PreProcessorException {
        if (!this.d_stackPushedLines.empty()) {
            throw new PreProcessorException("Internal error. Did not expect 'push' of next line start");
        }
        this.d_strNextLineStart = str;
    }

    public final PreProcessorLine getLine() throws IOException {
        if (!this.d_stackPushedLines.empty()) {
            ++this.d_iLineCounter;
            return (PreProcessorLine)this.d_stackPushedLines.pop();
        }
        String strLine = this.getNextLine();
        String strStartComment = "";
        String strEndComment = "";
        if (strLine == null) {
            return null;
        }
        if (this.d_strNextLineStart != null) {
            strLine = String.valueOf(this.d_strNextLineStart) + " " + strLine;
            this.d_strNextLineStart = null;
        }
        boolean fEndIsBlockComment = false;
        if (this.d_fBlockCommentAtPrevEnd) {
            int iIndex = strLine.indexOf("*/");
            if (iIndex >= 0) {
                strStartComment = strLine.substring(0, iIndex + 2);
                strLine = strLine.substring(iIndex + 2);
            } else {
                strStartComment = strLine;
                strLine = "";
                fEndIsBlockComment = true;
            }
        }
        boolean fExitLoop = false;
        while (!fExitLoop) {
            int iIndexStartComment = strLine.indexOf("/*");
            if (iIndexStartComment >= 0) {
                int iIndexAnyChar = StringUtility.indexOfAnyBut(strLine, " ");
                if (iIndexAnyChar < iIndexStartComment) {
                    fExitLoop = true;
                    continue;
                }
                int iIndexEndComment = strLine.indexOf("*/", iIndexStartComment + 2);
                if (iIndexEndComment < 0) {
                    strStartComment = String.valueOf(strStartComment) + " " + strLine;
                    strLine = "";
                    fEndIsBlockComment = true;
                    fExitLoop = true;
                    continue;
                }
                strStartComment = String.valueOf(strStartComment) + " " + strLine.substring(0, iIndexEndComment + 2);
                strLine = strLine.substring(iIndexEndComment + 2);
                continue;
            }
            fExitLoop = true;
        }
        fExitLoop = false;
        while (!fExitLoop) {
            int iIndexBlockEnd;
            int iIndexBlockStart = strLine.indexOf("/*");
            int iIndexLineComment = strLine.indexOf("//");
            if (iIndexLineComment >= 0) {
                if (iIndexBlockStart < 0 || iIndexLineComment < iIndexBlockStart) {
                    strEndComment = strLine.substring(iIndexLineComment);
                    strLine = strLine.substring(0, iIndexLineComment);
                    fExitLoop = true;
                    continue;
                }
                iIndexBlockEnd = strLine.indexOf("*/", iIndexBlockStart + 2);
                if (iIndexBlockEnd < 0) {
                    strEndComment = strLine.substring(iIndexBlockStart);
                    strLine = strLine.substring(0, iIndexBlockStart);
                    fEndIsBlockComment = true;
                    fExitLoop = true;
                    continue;
                }
                strLine = String.valueOf(strLine.substring(0, iIndexBlockStart)) + " " + strLine.substring(iIndexBlockEnd + 2);
                continue;
            }
            if (iIndexBlockStart < 0) {
                fExitLoop = true;
                continue;
            }
            iIndexBlockEnd = strLine.indexOf("*/", iIndexBlockStart + 2);
            if (iIndexBlockEnd < 0) {
                strEndComment = strLine.substring(iIndexBlockStart);
                strLine = strLine.substring(0, iIndexBlockStart);
                fEndIsBlockComment = true;
                fExitLoop = true;
                continue;
            }
            if (StringUtility.indexOfAnyBut(strLine, iIndexBlockEnd + 2, " ") < 0) {
                strEndComment = strLine.substring(iIndexBlockStart, iIndexBlockEnd + 2);
            }
            strLine = (String.valueOf(strLine.substring(0, iIndexBlockStart)) + " " + strLine.substring(iIndexBlockEnd + 2)).trim();
        }
        this.d_fBlockCommentAtPrevEnd = fEndIsBlockComment;
        ++this.d_iLineCounter;
        return new PreProcessorLine(strStartComment, strEndComment, strLine);
    }

    public final int getLastLine() {
        return this.d_iLineCounter;
    }

    public boolean hasOpenBlockComment() {
        return this.d_fBlockCommentAtPrevEnd;
    }

    StackElement() {
    }
}

