/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dk.dps.io;

import com.ibm.dk.dps.io.Buffer;
import com.ibm.dk.dps.io.FileStackElement;
import com.ibm.dk.dps.io.FileTracker;
import com.ibm.dk.dps.io.MacroDefinition;
import com.ibm.dk.dps.io.PreProcessorConstants;
import com.ibm.dk.dps.io.PreProcessorErrors;
import com.ibm.dk.dps.io.PreProcessorException;
import com.ibm.dk.dps.io.PreProcessorLine;
import com.ibm.dk.dps.io.StackElement;
import com.ibm.dk.dps.msg.InformationalMessageOutput;
import com.ibm.dk.dps.util.BooleanContainer;
import com.ibm.dk.dps.util.IntContainer;
import com.ibm.dk.dps.util.StringBufferUtility;
import com.ibm.dk.dps.util.StringContainer;
import com.ibm.dk.dps.util.StringUtility;
import com.ibm.dk.dps.util.VectorUtility;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class CPreProcessorStream
extends InputStream {
    private static final String s_INCLUDE1 = "#include";
    private static final String s_INCLUDE2 = "INCLUDE";
    private static final String s_INCLUDE3 = "CINCLUDE";
    private static final String s_DEFINE = "#define";
    private static final String s_IFDEF = "#ifdef";
    private static final String s_IFNDEF = "#ifndef";
    private static final String s_ELSE = "#else";
    private static final String s_ELIF = "#elif";
    private static final String s_ENDIF = "#endif";
    private static final String s_IF = "#if";
    private static final String s_MACROS = "MACROS";
    private static final String s_END_MACROS = "END_MACROS";
    private static final String[] s_astrIfExprSpecials = new String[]{"||", "&&", "!=", "<=", ">=", "=="};
    private String d_strIncludeWithoutFilter = "INCLUDE";
    private String d_strIncludeWithFilter = "CINCLUDE";
    private Stack d_fileStack = new Stack();
    private Hashtable d_macroTable = new Hashtable();
    private boolean d_fReportMacroRedefinition = false;
    private boolean d_fEOF = false;
    private boolean d_fFilterCFiles = false;
    private boolean d_fEnableDpsExtensions = false;
    private boolean d_fEnableExtendedIncludeKeywords = false;
    private int d_iLineCounter;
    private StackElement d_currentFile;
    private Buffer d_buffer = new Buffer();
    private FileTracker d_fileTracker = new FileTracker();
    private InformationalMessageOutput d_informationalOutput;
    private String[] d_arrayStrReservedKeywords;
    private String[] d_arrayStrFilterFiles;
    private String[] astrFilterFiles;
    private String d_strIncludeEnvironment;
    private PreProcessorException d_excPreProcessor;

    public CPreProcessorStream(String strFileName) throws FileNotFoundException {
        this(strFileName, null, null, null, false, false, false);
    }

    public CPreProcessorStream(String strFileName, String[] arrayStrFilterFiles, boolean fFilterStartFile) throws FileNotFoundException {
        this(strFileName, null, null, arrayStrFilterFiles, false, false, fFilterStartFile);
    }

    public CPreProcessorStream(String strFileName, InformationalMessageOutput informationalOutput, String[] arrayStrReservedKeywords, String[] arrayStrFilterFiles, boolean fFilterCCode, boolean fReportMacroRedefinition, boolean fFilterStartFile) throws FileNotFoundException {
        this.d_fileStack = new Stack();
        this.d_fReportMacroRedefinition = fReportMacroRedefinition;
        this.d_arrayStrFilterFiles = arrayStrFilterFiles;
        this.d_fFilterCFiles = fFilterCCode;
        this.setReservedKeywords(arrayStrReservedKeywords);
        this.setInformationalMessageOutput(informationalOutput);
        boolean fStartInCMode = fFilterStartFile ? this.testFilterFile(strFileName) : false;
        this.d_currentFile = new FileStackElement(strFileName, fStartInCMode);
        this.d_fileTracker.add(this.d_currentFile, this.d_iLineCounter);
        this.setSearchPath(System.getProperty("include"));
    }

    public int read() throws IOException {
        byte[] abData = new byte[1];
        if (this.read(abData, 0, 1) == -1) {
            return -1;
        }
        return abData[0];
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public long skip(long n) throws IOException {
        byte[] abSkipData = new byte[(int)n];
        int iByteCount = this.read(abSkipData);
        if (iByteCount == -1) {
            return n;
        }
        return iByteCount;
    }

    public int available() throws IOException {
        return 0;
    }

    public void close() throws IOException {
        if (this.d_currentFile != null) {
            this.d_currentFile.close();
            while (!this.d_fileStack.isEmpty()) {
                StackElement e = (StackElement)this.d_fileStack.pop();
                e.close();
            }
            this.d_currentFile = null;
        }
    }

    public void mark(int readlimit) {
    }

    public void reset(int readlimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.d_fEOF) {
            return -1;
        }
        try {
            int iCount = this.processRead(b, off, len);
            if (len > 0 && iCount == 0) {
                this.d_fEOF = true;
                b[off] = 26;
                return 1;
            }
            return iCount;
        }
        catch (PreProcessorException exc) {
            if (this.d_currentFile != null) {
                exc.setLineNumber(this.d_currentFile.getLastLine());
                exc.setFileName(this.d_currentFile.getName());
            }
            this.d_excPreProcessor = exc;
            throw new IOException(exc.toString());
        }
        catch (Exception exc) {
            this.d_excPreProcessor = new PreProcessorException(exc.toString());
            if (this.d_currentFile != null) {
                this.d_excPreProcessor.setLineNumber(this.d_currentFile.getLastLine());
                this.d_excPreProcessor.setFileName(this.d_currentFile.getName());
            }
            throw new IOException(exc.toString());
        }
    }

    public void setReservedKeywords(String[] arrayStrReservedKeywords) {
        this.d_arrayStrReservedKeywords = arrayStrReservedKeywords;
    }

    String[] getReservedKeywords() {
        return this.d_arrayStrReservedKeywords;
    }

    public void setFilesToFilter(String[] arrayStrFilterFiles) {
        this.d_arrayStrFilterFiles = arrayStrFilterFiles;
    }

    public boolean hasPreProcessorExceptionOccurred() {
        return this.d_excPreProcessor != null;
    }

    public PreProcessorException getPreProcessorException() {
        return this.d_excPreProcessor;
    }

    public void setUseDpsExtensions(boolean fValue) {
        if (fValue) {
            this.setIncludeKeywords(s_INCLUDE2, s_INCLUDE3);
        } else {
            this.setIncludeKeywords(null, null);
        }
        this.d_fEnableExtendedIncludeKeywords = fValue;
    }

    public void setInformationalMessageOutput(InformationalMessageOutput informationalOutput) {
        this.d_informationalOutput = informationalOutput;
        if (this.d_informationalOutput != null) {
            this.d_informationalOutput.setMessages(PreProcessorErrors.s_MESSAGES);
        }
    }

    public void setSearchPath(String strPath) {
        this.d_strIncludeEnvironment = strPath;
        if (this.d_strIncludeEnvironment != null) {
            this.d_strIncludeEnvironment = this.d_strIncludeEnvironment.replace('\\', '/');
        }
    }

    public String getSearchPath() {
        return this.d_strIncludeEnvironment;
    }

    public void setIncludeKeywords(String strIncludeWithoutFilter, String strIncludeWithFilter) {
        if (strIncludeWithoutFilter != null && strIncludeWithFilter != null) {
            this.d_strIncludeWithoutFilter = strIncludeWithoutFilter;
            this.d_strIncludeWithFilter = strIncludeWithFilter;
            this.d_fEnableExtendedIncludeKeywords = true;
        } else {
            this.d_fEnableExtendedIncludeKeywords = false;
        }
    }

    private boolean testFilterFile(String strFile) {
        if (this.d_arrayStrFilterFiles == null) {
            return false;
        }
        int i = 0;
        while (i < this.d_arrayStrFilterFiles.length) {
            if (this.d_arrayStrFilterFiles[0] != null && StringUtility.isLike(strFile, this.d_arrayStrFilterFiles[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int processRead(byte[] b, int iIndex, int iCount) throws IOException, PreProcessorException {
        int iReturnCount = 0;
        while (iCount > 0) {
            String strNextLine;
            if (this.d_buffer.isDataLeft()) {
                int iBytesReturned = this.d_buffer.getData(b, iIndex, iCount);
                iCount -= iBytesReturned;
                iIndex += iBytesReturned;
                iReturnCount += iBytesReturned;
                continue;
            }
            boolean fParsingBlockComment = false;
            boolean fParsingC = this.d_currentFile.isParsingC();
            boolean fIsProcessingCondition = this.d_currentFile.isProcessingCondition();
            boolean fIsIgnoringCondition = this.d_currentFile.isIgnoringCondition();
            PreProcessorLine nextLine = this.d_currentFile.getLine();
            String string = strNextLine = nextLine == null ? null : nextLine.getText();
            if (strNextLine == null) {
                if (this.d_currentFile.hasOpenBlockComment()) {
                    throw new PreProcessorException("Unmatched */ in file : " + this.d_currentFile.getName());
                }
                if (this.d_fileStack.isEmpty()) {
                    return iReturnCount;
                }
                this.d_currentFile = (StackElement)this.d_fileStack.pop();
                this.d_fileTracker.add(this.d_currentFile, this.d_iLineCounter);
                return iReturnCount + this.processRead(b, iIndex, iCount);
            }
            ++this.d_iLineCounter;
            strNextLine = CPreProcessorStream.adjustForPreProcessingStatements(strNextLine);
            int iLeadingSpaces = StringUtility.countLeadingSpaces(strNextLine);
            String strNextLineUpperCase = strNextLine.toUpperCase();
            if (fParsingC) {
                if (!fIsIgnoringCondition && strNextLine.startsWith(s_INCLUDE1, iLeadingSpaces)) {
                    int iLength = s_INCLUDE1.length();
                    BooleanContainer boolCtrStatementsAfterInclude = new BooleanContainer(false);
                    String strNextFileName = this.extractIncludeFileName(strNextLine.substring(iLeadingSpaces + iLength), boolCtrStatementsAfterInclude);
                    if (boolCtrStatementsAfterInclude.getValue()) {
                        throw new PreProcessorException("Specifications found behind include statement");
                    }
                    this.d_fileStack.push(this.d_currentFile);
                    this.d_buffer.addLineData(nextLine.getStartComment(), "");
                    this.d_currentFile.pushNextLineStart(nextLine.getEndComment());
                    this.d_currentFile = new FileStackElement(strNextFileName, true);
                    this.d_fileTracker.add(this.d_currentFile, this.d_iLineCounter);
                    return iReturnCount + this.processRead(b, iIndex, iCount);
                }
            } else {
                boolean fFoundIncludeStatement = false;
                boolean fIncludingCFile = false;
                int iLength = -1;
                if (strNextLine.startsWith(s_INCLUDE1, iLeadingSpaces)) {
                    fFoundIncludeStatement = true;
                    fIncludingCFile = true;
                    iLength = s_INCLUDE1.length();
                } else if (this.d_fEnableExtendedIncludeKeywords && (strNextLineUpperCase.startsWith(s_INCLUDE2, iLeadingSpaces) || strNextLineUpperCase.startsWith(s_INCLUDE3, iLeadingSpaces))) {
                    fFoundIncludeStatement = true;
                    iLength = StringUtility.lengthOfMatchingStringAtString(strNextLineUpperCase, s_INCLUDE2, s_INCLUDE3);
                    fIncludingCFile = strNextLineUpperCase.startsWith(s_INCLUDE3, iLeadingSpaces);
                }
                if (fFoundIncludeStatement && !fIsIgnoringCondition) {
                    BooleanContainer boolCtrStatementsAfterInclude = new BooleanContainer(false);
                    String strNextFileName = this.extractIncludeFileName(strNextLine.substring(iLeadingSpaces + iLength), boolCtrStatementsAfterInclude);
                    if (boolCtrStatementsAfterInclude.getValue()) {
                        throw new PreProcessorException("Specifications found behind include statement");
                    }
                    if (fIncludingCFile && !this.d_fEnableExtendedIncludeKeywords) {
                        fIncludingCFile = this.testFilterFile(strNextFileName);
                    }
                    this.d_fileStack.push(this.d_currentFile);
                    this.d_buffer.addLineData(nextLine.getStartComment(), "");
                    this.d_currentFile.pushNextLineStart(nextLine.getEndComment());
                    this.d_currentFile = new FileStackElement(strNextFileName, fIncludingCFile || this.d_fFilterCFiles);
                    this.d_fileTracker.add(this.d_currentFile, this.d_iLineCounter);
                    return iReturnCount + this.processRead(b, iIndex, iCount);
                }
            }
            if (strNextLine.startsWith(s_IFDEF, iLeadingSpaces)) {
                this.d_buffer.addLineData(nextLine.getStartComment(), "", nextLine.getEndComment());
                if (fIsIgnoringCondition) {
                    this.d_currentFile.setIsIgnoringIfStatement();
                    continue;
                }
                this.processIfdefStatement(strNextLine.substring(iLeadingSpaces + s_IFDEF.length()), true);
                continue;
            }
            if (strNextLine.startsWith(s_IFNDEF, iLeadingSpaces)) {
                this.d_buffer.addLineData(nextLine.getStartComment(), "", nextLine.getEndComment());
                if (fIsIgnoringCondition) {
                    this.d_currentFile.setIsIgnoringIfStatement();
                    continue;
                }
                this.processIfdefStatement(strNextLine.substring(iLeadingSpaces + s_IFNDEF.length()), false);
                continue;
            }
            if (strNextLine.startsWith(s_IF, iLeadingSpaces)) {
                this.d_buffer.addLineData(nextLine.getStartComment(), "", nextLine.getEndComment());
                if (fIsIgnoringCondition) {
                    this.d_currentFile.setIsIgnoringIfStatement();
                    continue;
                }
                this.processIfStatement(strNextLine.substring(iLeadingSpaces + s_IF.length()));
                continue;
            }
            if (strNextLine.startsWith(s_ENDIF, iLeadingSpaces)) {
                this.d_buffer.addLineData(nextLine.getStartComment(), "", nextLine.getEndComment());
                this.d_currentFile.dropParseCondition();
                continue;
            }
            if (strNextLine.startsWith(s_ELSE, iLeadingSpaces)) {
                this.d_buffer.addLineData(nextLine.getStartComment(), "", nextLine.getEndComment());
                this.d_currentFile.dropParseCondition();
                if (this.d_currentFile.isIgnoringCondition()) {
                    this.d_currentFile.setIsIgnoringIfStatement();
                    continue;
                }
                if (fIsIgnoringCondition) {
                    this.d_currentFile.setIsProcessingIfStatement();
                    continue;
                }
                this.d_currentFile.setIsIgnoringIfStatement();
                continue;
            }
            if (strNextLine.startsWith(s_ELIF, iLeadingSpaces)) {
                this.d_buffer.addLineData(nextLine.getStartComment(), "", nextLine.getEndComment());
                this.d_currentFile.dropParseCondition();
                if (this.d_currentFile.isIgnoringCondition()) {
                    this.d_currentFile.setIsIgnoringIfStatement();
                    continue;
                }
                if (fIsIgnoringCondition) {
                    this.d_currentFile.setIsIgnoringIfStatement();
                    continue;
                }
                this.processIfStatement(strNextLine.substring(iLeadingSpaces + s_IF.length()));
                continue;
            }
            if (!fIsIgnoringCondition) {
                if (!fParsingC && this.d_fEnableExtendedIncludeKeywords && strNextLine.startsWith(s_MACROS, iLeadingSpaces)) {
                    this.d_buffer.addLineData(nextLine.getStartComment(), "", nextLine.getEndComment());
                    this.processDpsMacroDefinitions();
                    continue;
                }
                if (strNextLine.startsWith(s_DEFINE, iLeadingSpaces)) {
                    this.d_buffer.addLineData(nextLine.getStartComment(), "", nextLine.getEndComment());
                    String strDefineStatement = strNextLine.substring(iLeadingSpaces + s_DEFINE.length());
                    strDefineStatement = strDefineStatement.trim();
                    while (strDefineStatement.endsWith("\\")) {
                        String s = this.d_currentFile.getLine().getText();
                        if (s == null) {
                            throw new PreProcessorException("Error in #define statement");
                        }
                        ++this.d_iLineCounter;
                        this.d_buffer.addLineData("");
                        strDefineStatement = String.valueOf(strDefineStatement.substring(0, strDefineStatement.length() - 1)) + " " + s.trim();
                    }
                    this.processDefineStatement(strDefineStatement);
                    continue;
                }
                if (fParsingC) {
                    this.d_buffer.addLineData("");
                    continue;
                }
                this.d_buffer.addLineData(nextLine.getStartComment(), this.expandMacros(strNextLine, new Vector()), nextLine.getEndComment());
                continue;
            }
            this.d_buffer.addLineData("");
        }
        return iReturnCount;
    }

    private void processIfdefStatement(String strLine, boolean fDontNegate) throws PreProcessorException {
        boolean fTest;
        Vector vector = StringUtility.nonEmptyWordsSeparatedBy(strLine, ' ');
        switch (vector.size()) {
            case 0: {
                throw new PreProcessorException("Expected expression after #ifdef");
            }
            default: {
                throw new PreProcessorException("Could not evaluate #ifdef expression");
            }
            case 1: 
        }
        String strTestDefinition = (String)vector.firstElement();
        boolean bl = fDontNegate ? this.isMacroDefined(strTestDefinition) : (fTest = !this.isMacroDefined(strTestDefinition));
        if (fTest) {
            this.d_currentFile.setIsProcessingIfStatement();
        } else {
            this.d_currentFile.setIsIgnoringIfStatement();
        }
    }

    private void processIfStatement(String strLine) throws PreProcessorException {
        String[] astrTokens = StringUtility.cutIntoTokens(strLine, " ()!<>", s_astrIfExprSpecials);
        int iLength = this.evaluateDefinedTokens(astrTokens);
        this.evaluateRemainingTokens(astrTokens, iLength);
        while (iLength > 1) {
            BooleanContainer boolContainerAndExpressions;
            boolean fAndExpressionsEvaulated = false;
            do {
                iLength = this.evaluateParenteses(astrTokens, iLength);
                iLength = this.evaulateNegations(astrTokens, iLength);
                iLength = this.evaulateRelations(astrTokens, iLength);
                boolContainerAndExpressions = new BooleanContainer(false);
                iLength = this.evaluateAndExpressions(astrTokens, iLength, boolContainerAndExpressions);
            } while ((fAndExpressionsEvaulated = boolContainerAndExpressions.getValue()) && iLength != 1);
            if (iLength == 1) continue;
            iLength = this.evaluateOrExpressions(astrTokens, iLength);
        }
        if (iLength == 0) {
            throw new PreProcessorException("Error in #if expression");
        }
        if (StringUtility.integerValue(astrTokens[0]) != 0) {
            this.d_currentFile.setIsProcessingIfStatement();
        } else {
            this.d_currentFile.setIsIgnoringIfStatement();
        }
    }

    int evaulateRelations(String[] astrTokens, int iLength) throws PreProcessorException {
        try {
            int i = 1;
            while (i < iLength - 1) {
                if (StringUtility.isNumeric(astrTokens[i - 1]) && StringUtility.isNumeric(astrTokens[i + 1])) {
                    int iValue1 = StringUtility.integerValue(astrTokens[i - 1]);
                    int iValue2 = StringUtility.integerValue(astrTokens[i + 1]);
                    String strResult = null;
                    if (astrTokens[i].equals("==")) {
                        strResult = iValue1 == iValue2 ? "1" : "0";
                    } else if (astrTokens[i].equals("!=")) {
                        strResult = iValue1 != iValue2 ? "1" : "0";
                    } else if (astrTokens[i].equals("<=")) {
                        strResult = iValue1 <= iValue2 ? "1" : "0";
                    } else if (astrTokens[i].equals(">=")) {
                        strResult = iValue1 >= iValue2 ? "1" : "0";
                    } else if (astrTokens[i].equals("<")) {
                        strResult = iValue1 < iValue2 ? "1" : "0";
                    } else if (astrTokens[i].equals(">")) {
                        String string = strResult = iValue1 > iValue2 ? "1" : "0";
                    }
                    if (strResult != null) {
                        astrTokens[i - 1] = strResult;
                        int j = i + 2;
                        while (j < iLength) {
                            astrTokens[j - 2] = astrTokens[j];
                            ++j;
                        }
                        iLength -= 2;
                    }
                }
                ++i;
            }
            return iLength;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new PreProcessorException("Error in #if statement");
        }
    }

    int evaluateParenteses(String[] astrTokens, int iLength) throws PreProcessorException {
        try {
            boolean fRetry = false;
            int i = 0;
            while (i < iLength) {
                if (astrTokens[i].equals("(") && astrTokens[i + 2].equals(")")) {
                    astrTokens[i] = astrTokens[i + 1];
                    int j = i + 3;
                    while (j < iLength) {
                        astrTokens[j - 2] = astrTokens[j];
                        ++j;
                    }
                    iLength -= 2;
                    fRetry = true;
                }
                ++i;
            }
            if (fRetry) {
                return this.evaluateParenteses(astrTokens, iLength);
            }
            return iLength;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new PreProcessorException("Error in #if statement");
        }
    }

    int evaulateNegations(String[] astrTokens, int iLength) throws PreProcessorException {
        try {
            boolean fRetry = false;
            do {
                fRetry = false;
                int i = 0;
                while (i < iLength) {
                    if (astrTokens[i].equals("!") && StringUtility.isNumeric(astrTokens[i + 1])) {
                        boolean fResult = StringUtility.integerValue(astrTokens[i + 1]) == 0;
                        astrTokens[i] = fResult ? "1" : "0";
                        int j = i + 2;
                        while (j < iLength) {
                            astrTokens[j - 1] = astrTokens[j];
                            ++j;
                        }
                        --iLength;
                        fRetry = true;
                    }
                    ++i;
                }
            } while (fRetry);
            return iLength;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new PreProcessorException("Error in #if statement");
        }
    }

    void evaluateRemainingTokens(String[] astrTokens, int iLength) {
        int i = 0;
        while (i < iLength) {
            char chTest = astrTokens[i].charAt(0);
            if (Character.isJavaIdentifierStart(chTest)) {
                String str;
                MacroDefinition definition = (MacroDefinition)this.d_macroTable.get(astrTokens[i]);
                astrTokens[i] = definition != null ? (StringUtility.isNumeric(str = definition.expand(null)) ? str : "0") : "0";
            }
            ++i;
        }
    }

    int evaluateAndExpressions(String[] astrTokens, int iLength, BooleanContainer boolCntExpressionsEvaulated) throws PreProcessorException {
        try {
            int i = 0;
            while (i < iLength) {
                if (astrTokens[i].equals("&&") && StringUtility.isNumeric(astrTokens[i - 1]) && StringUtility.isNumeric(astrTokens[i + 1])) {
                    boolean fResult = StringUtility.integerValue(astrTokens[i - 1]) != 0 && StringUtility.integerValue(astrTokens[i + 1]) != 0;
                    astrTokens[i - 1] = fResult ? "1" : "0";
                    boolCntExpressionsEvaulated.setValue(true);
                    int j = --i + 3;
                    while (j < iLength) {
                        astrTokens[j - 2] = astrTokens[j];
                        ++j;
                    }
                    iLength -= 2;
                }
                ++i;
            }
            return iLength;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new PreProcessorException("Error in #if statement");
        }
    }

    int evaluateOrExpressions(String[] astrTokens, int iLength) throws PreProcessorException {
        try {
            int i = 0;
            while (i < iLength) {
                if (astrTokens[i].equals("||") && StringUtility.isNumeric(astrTokens[i - 1]) && StringUtility.isNumeric(astrTokens[i + 1])) {
                    boolean fResult = StringUtility.integerValue(astrTokens[i - 1]) != 0 || StringUtility.integerValue(astrTokens[i + 1]) != 0;
                    astrTokens[i - 1] = fResult ? "1" : "0";
                    int j = --i + 3;
                    while (j < iLength) {
                        astrTokens[j - 2] = astrTokens[j];
                        ++j;
                    }
                    iLength -= 2;
                }
                ++i;
            }
            return iLength;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new PreProcessorException("Error in #if statement");
        }
    }

    int evaluateDefinedTokens(String[] astrTokens) throws PreProcessorException {
        try {
            int iLength = astrTokens.length;
            int i = 0;
            while (i < iLength) {
                if (astrTokens[i].equals("defined")) {
                    int j;
                    if (astrTokens[i + 1].equals("(") && astrTokens[i + 3].equals(")")) {
                        astrTokens[i] = this.isMacroDefined(astrTokens[i + 2]) ? "1" : "0";
                        j = i + 4;
                        while (j < astrTokens.length) {
                            astrTokens[j - 3] = astrTokens[j];
                            ++j;
                        }
                        iLength -= 3;
                    } else if (StringUtility.isJavaIdentifier(astrTokens[i + 1])) {
                        astrTokens[i] = this.isMacroDefined(astrTokens[i]) ? "1" : "0";
                        j = i + 2;
                        while (j < iLength) {
                            astrTokens[j - 1] = astrTokens[j];
                            ++j;
                        }
                        --iLength;
                    }
                }
                ++i;
            }
            return iLength;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new PreProcessorException("Error in #if statement");
        }
    }

    private void processDpsMacroDefinitions() throws IOException, PreProcessorException {
        boolean fEndFound = false;
        do {
            PreProcessorLine nextLine;
            if ((nextLine = this.d_currentFile.getLine()) == null) {
                throw new PreProcessorException("Unexpected end for MACROS");
            }
            ++this.d_iLineCounter;
            String strLine = nextLine.getText();
            if (strLine.startsWith(s_END_MACROS)) {
                this.d_buffer.addLineData("", "", nextLine.getEndComment());
                return;
            }
            this.d_buffer.addLineData("");
            if (strLine.length() <= 0) continue;
            int iIndex = strLine.indexOf(32);
            if (iIndex < 0) {
                this.addMacro(strLine);
                continue;
            }
            this.addMacro(strLine.substring(0, iIndex), strLine.substring(iIndex + 1).trim());
        } while (!fEndFound);
    }

    private String expandMacros(String strLine, Vector vecRecursiveMacroExpansion) throws PreProcessorException, IOException {
        return this.expandMacros(strLine, vecRecursiveMacroExpansion, new BooleanContainer(false));
    }

    private String expandMacros(String strLine, Vector vecRecursiveMacroExpansion, BooleanContainer boolCtrReturnRecursiveExpansion) throws PreProcessorException, IOException {
        boolCtrReturnRecursiveExpansion.setValue(false);
        if (strLine.equals("")) {
            return strLine;
        }
        boolean fMacrosFound = false;
        boolean fFoundMacro = false;
        do {
            fFoundMacro = false;
            String[] astrTokens = StringUtility.cutIntoTokens(strLine, null, PreProcessorConstants.s_astrSEPARATORS);
            int iUpdatedLength = astrTokens.length;
            int i = 0;
            while (i < iUpdatedLength && !fFoundMacro) {
                String strTestName = astrTokens[i];
                String strSpaceBefore = StringUtility.leadingSpaces(strTestName);
                String strSpaceAfter = StringUtility.trailingSpaces(strTestName);
                if (vecRecursiveMacroExpansion.contains(strTestName = strTestName.trim())) {
                    boolCtrReturnRecursiveExpansion.setValue(true);
                    return strLine;
                }
                if (this.d_macroTable.containsKey(strTestName)) {
                    MacroDefinition definition = (MacroDefinition)this.d_macroTable.get(strTestName);
                    if (definition.numberOfParameters() == 0) {
                        BooleanContainer boolCtrRecursiveExpansion = new BooleanContainer(false);
                        Vector vecNewRecursion = (Vector)vecRecursiveMacroExpansion.clone();
                        vecNewRecursion.addElement(strTestName);
                        astrTokens[i] = String.valueOf(strSpaceBefore) + this.expandMacros(definition.expand(null), vecNewRecursion, boolCtrRecursiveExpansion) + strSpaceAfter + " ";
                        if (!boolCtrRecursiveExpansion.getValue()) {
                            fMacrosFound = true;
                            fFoundMacro = true;
                        }
                    } else {
                        if (!astrTokens[i + 1].equals("(")) {
                            throw new PreProcessorException("Error in macro parameters");
                        }
                        IntContainer intContainer = new IntContainer(i + 2);
                        Vector vecParameters = this.extractAllMacroParameters(astrTokens, intContainer);
                        Enumeration enumeration = vecParameters.elements();
                        Vector vecNewRecursion = (Vector)vecRecursiveMacroExpansion.clone();
                        vecNewRecursion.addElement(strTestName.trim());
                        astrTokens[i] = String.valueOf(strSpaceBefore) + this.expandMacros(definition.expand(vecParameters), vecNewRecursion) + strSpaceAfter + " ";
                        iUpdatedLength = astrTokens.length - (intContainer.getValue() - ++i);
                        int j = intContainer.getValue();
                        while (j < astrTokens.length) {
                            astrTokens[i++] = astrTokens[j];
                            ++j;
                        }
                        fMacrosFound = true;
                        fFoundMacro = true;
                    }
                }
                ++i;
            }
            if (!fFoundMacro) continue;
            StringBuffer strBufNewLine = new StringBuffer();
            int i2 = 0;
            while (i2 < iUpdatedLength) {
                if (i2 != 0) {
                    strBufNewLine.append(" ");
                }
                strBufNewLine.append(astrTokens[i2]);
                ++i2;
            }
            strLine = strBufNewLine.toString();
        } while (fFoundMacro);
        return strLine;
    }

    Vector extractAllMacroParameters(String[] astrTokens, IntContainer intCtrStartIndex) throws PreProcessorException, IOException {
        IntContainer intCtrParenteseCount = new IntContainer(0);
        Vector vecResult = this.extractMacroParametersInLine(astrTokens, intCtrStartIndex, intCtrParenteseCount);
        if (intCtrParenteseCount.getValue() < 0) {
            return this.separateMacroParameters(vecResult);
        }
        Stack<PreProcessorLine> stackLines = new Stack<PreProcessorLine>();
        while (intCtrParenteseCount.getValue() >= 0) {
            PreProcessorLine line = this.d_currentFile.getLine();
            String[] astrMoreTokens = StringUtility.cutIntoTokens(line.getText(), null, PreProcessorConstants.s_astrSEPARATORS);
            IntContainer intCtrEndIndex = new IntContainer(0);
            Vector vecMoreParameters = this.extractMacroParametersInLine(astrMoreTokens, intCtrEndIndex, intCtrParenteseCount);
            VectorUtility.addAllFrom(vecMoreParameters, vecResult);
            String[] astrModifiedLine = StringUtility.copyStringArray(astrMoreTokens, intCtrEndIndex.getValue());
            line.setText(StringUtility.concatStringArray(astrModifiedLine));
            stackLines.push(line);
        }
        while (!stackLines.empty()) {
            this.d_currentFile.pushLine((PreProcessorLine)stackLines.pop());
        }
        return this.separateMacroParameters(vecResult);
    }

    Vector separateMacroParameters(Vector vecTokens) {
        Vector<String> vecResult = new Vector<String>();
        Enumeration enumeration = vecTokens.elements();
        StringBuffer strBuf = new StringBuffer();
        int iParenteseCount = 0;
        while (enumeration.hasMoreElements()) {
            String s = (String)enumeration.nextElement();
            if (s.equals("(")) {
                StringBufferUtility.addWord(strBuf, s);
                ++iParenteseCount;
                continue;
            }
            if (s.equals(")")) {
                StringBufferUtility.addWord(strBuf, s);
                --iParenteseCount;
                continue;
            }
            if (iParenteseCount == 0) {
                if (s.equals(",")) {
                    vecResult.addElement(strBuf.toString());
                    strBuf.setLength(0);
                    continue;
                }
                StringBufferUtility.addWord(strBuf, s);
                continue;
            }
            StringBufferUtility.addWord(strBuf, s);
        }
        vecResult.addElement(strBuf.toString());
        return vecResult;
    }

    Vector extractMacroParametersInLine(String[] astrTokens, IntContainer intCtrStartIndex, IntContainer intCtrParenteseCount) {
        Vector<String> vecResult = new Vector<String>();
        int iParenteseCount = intCtrParenteseCount.getValue();
        int i = 0;
        i = intCtrStartIndex.getValue();
        while (iParenteseCount >= 0 && i < astrTokens.length) {
            if (astrTokens[i].equals("(")) {
                ++iParenteseCount;
            } else if (astrTokens[i].equals(")")) {
                --iParenteseCount;
            }
            vecResult.addElement(astrTokens[i]);
            ++i;
        }
        if (iParenteseCount < 0) {
            vecResult.setSize(vecResult.size() - 1);
        }
        intCtrStartIndex.setValue(i);
        intCtrParenteseCount.setValue(iParenteseCount);
        return vecResult;
    }

    static String adjustForPreProcessingStatements(String strLine) {
        if (strLine.length() == 0 || strLine.charAt(0) != '#') {
            return strLine;
        }
        return "#" + strLine.substring(1).trim();
    }

    private void addMacro(String strMacroName) throws PreProcessorException {
        this.addMacro(strMacroName, "");
    }

    private void addMacro(String strMacroName, String strMacroExpression) throws PreProcessorException {
        this.addMacro(strMacroName, new String[0], strMacroExpression);
    }

    private void addMacro(String strMacroName, String[] astrParameter, String strMacroExpression) throws PreProcessorException {
        if (strMacroName.length() == 0) {
            throw new PreProcessorException("Empty macro name");
        }
        if (StringUtility.binarySearchStringInArray(strMacroName, this.d_arrayStrReservedKeywords)) {
            this.putInformationalOutput(1, strMacroName, this.d_currentFile.getName(), this.d_currentFile.getLastLine());
            return;
        }
        if (this.d_fReportMacroRedefinition && this.d_macroTable.containsKey(strMacroName)) {
            this.putInformationalOutput(0, strMacroName, this.d_currentFile.getName(), this.d_currentFile.getLastLine());
        }
        this.d_macroTable.put(strMacroName, new MacroDefinition(astrParameter, strMacroExpression));
    }

    void putInformationalOutput(int iMessageNumber, String str1, String str2, int iValue3) {
        if (this.d_informationalOutput != null) {
            this.d_informationalOutput.putMessage(iMessageNumber, str1, str2, iValue3);
        }
    }

    public boolean addMacro(String strMacroName, Vector vecParameters, String strExpression) {
        try {
            if (this.isMacroDefined(strMacroName)) {
                return false;
            }
            if (strExpression == null) {
                strExpression = "";
            }
            if (vecParameters == null || vecParameters.size() == 0) {
                this.addMacro(strMacroName, strExpression);
            } else {
                String[] astrParameters = new String[vecParameters.size()];
                int i = 0;
                while (i < vecParameters.size()) {
                    astrParameters[i] = (String)vecParameters.elementAt(i);
                    ++i;
                }
                this.addMacro(strMacroName, astrParameters, strExpression);
            }
            return true;
        }
        catch (PreProcessorException preProcessorException) {
            return false;
        }
    }

    public boolean isMacroDefined(String strName) {
        return this.d_macroTable.containsKey(strName);
    }

    private void processDefineStatement(String defineSpec) throws PreProcessorException {
        int iIndex = StringUtility.indexOfAnyOf(defineSpec = defineSpec.trim(), " (");
        if (iIndex < 0) {
            this.addMacro(defineSpec);
        } else if (defineSpec.charAt(iIndex) == '(') {
            int iEndIndex = defineSpec.indexOf(41);
            String[] parameterList = this.extractMacroParameterNames(defineSpec.substring(iIndex + 1, iEndIndex));
            this.addMacro(defineSpec.substring(0, iIndex), parameterList, defineSpec.substring(iEndIndex + 1).trim());
        } else {
            this.addMacro(defineSpec.substring(0, iIndex), defineSpec.substring(iIndex + 1).trim());
        }
    }

    private String[] extractMacroParameterNames(String macroList) {
        Vector<String> result = new Vector<String>();
        while (macroList.length() > 0) {
            String nextName;
            int iIndex = macroList.indexOf(44);
            if (iIndex < 0) {
                nextName = macroList;
                macroList = "";
            } else {
                nextName = macroList.substring(0, iIndex);
                macroList = macroList.substring(iIndex + 1);
            }
            result.addElement(nextName);
        }
        String[] resultArray = new String[result.size()];
        int i = 0;
        while (i < result.size()) {
            resultArray[i] = ((String)result.elementAt(i)).trim();
            ++i;
        }
        return resultArray;
    }

    private String extractIncludeFileName(String includeSpec, BooleanContainer boolCtrStatementsAfterInclude) throws PreProcessorException {
        includeSpec = includeSpec.trim();
        switch (includeSpec.charAt(0)) {
            case '\"': {
                int iIndex = includeSpec.indexOf(34, 1);
                if (iIndex < 0) {
                    throw new PreProcessorException("Invalid include specification");
                }
                String fileName = includeSpec.substring(1, iIndex);
                boolCtrStatementsAfterInclude.setValue(includeSpec.substring(iIndex + 1).trim().length() != 0);
                if (boolCtrStatementsAfterInclude.getValue()) {
                    return null;
                }
                File test = new File(fileName);
                if (test.exists() && test.isFile()) {
                    return fileName;
                }
                return this.searchGlobalFileName(fileName);
            }
            case '<': {
                int iIndex = includeSpec.indexOf(62, 1);
                if (iIndex < 0) {
                    throw new PreProcessorException("Invalid include specification");
                }
                String fileName = includeSpec.substring(1, iIndex);
                boolCtrStatementsAfterInclude.setValue(includeSpec.substring(iIndex + 1).trim().length() != 0);
                if (boolCtrStatementsAfterInclude.getValue()) {
                    return null;
                }
                return this.searchGlobalFileName(fileName);
            }
        }
        throw new PreProcessorException("Invalid include specification");
    }

    private String searchGlobalFileName(String strFileName) throws PreProcessorException {
        String strSearchPath = this.getSearchPath();
        if (strSearchPath == null) {
            throw new PreProcessorException("Include file " + strFileName + " not found.");
        }
        strFileName = strFileName.replace('\\', '/');
        while (strSearchPath.length() > 0) {
            File test;
            String strTestPath;
            int iIndex = strSearchPath.indexOf(59);
            if (iIndex < 0) {
                strTestPath = strSearchPath;
                strSearchPath = "";
            } else {
                strTestPath = strSearchPath.substring(0, iIndex);
                strSearchPath = strSearchPath.substring(iIndex + 1);
            }
            if (strTestPath.length() <= 0 || !(test = new File(strTestPath = strTestPath.charAt(strTestPath.length() - 1) == '/' ? String.valueOf(strTestPath) + strFileName : String.valueOf(strTestPath) + "/" + strFileName)).exists() || !test.isFile()) continue;
            return strTestPath;
        }
        throw new PreProcessorException("Include file " + strFileName + " not found.");
    }

    void dumpFileTracking() {
        this.d_fileTracker.dump();
    }

    public void getFileAndLine(int iCumulativeLine, StringContainer strCtrFileDescription, IntContainer intCtrLineNumber) {
        this.d_fileTracker.getLineDescription(iCumulativeLine, strCtrFileDescription, intCtrLineNumber);
    }

    public String getFile(int iCumulativeLine) {
        StringContainer strCtrFile = new StringContainer("");
        IntContainer intCtrLine = new IntContainer(-1);
        this.getFileAndLine(iCumulativeLine, strCtrFile, intCtrLine);
        String strResult = strCtrFile.getValue();
        if (strResult.length() > 0) {
            return strResult;
        }
        return null;
    }

    public int getLine(int iCumulativeLine) {
        StringContainer strCtrFile = new StringContainer("");
        IntContainer intCtrLine = new IntContainer(-1);
        this.getFileAndLine(iCumulativeLine, strCtrFile, intCtrLine);
        return intCtrLine.getValue();
    }

    void dumpMacros() {
        Enumeration enumeration = this.d_macroTable.keys();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            System.out.print(">" + name);
            MacroDefinition definition = (MacroDefinition)this.d_macroTable.get(name);
            System.out.println(" " + definition);
        }
    }

    int getLastLineNumber() throws PreProcessorException {
        if (this.d_currentFile != null) {
            return this.d_currentFile.getLastLine();
        }
        throw new PreProcessorException("No file was in used");
    }

    String getLastFileName() throws PreProcessorException {
        if (this.d_currentFile != null) {
            return this.d_currentFile.getName();
        }
        throw new PreProcessorException("No file was in used");
    }

    public static void test1(String[] args) {
        String strConstructor = args.length > 0 ? args[0] : null;
        String strFile = args.length > 1 ? args[1] : null;
        String strOutput = args.length > 2 ? args[2] : null;
        CPreProcessorStream preProcessor = null;
        InformationalMessageOutput informationalOutput = new InformationalMessageOutput("PRE:");
        boolean fExcludeCFiles = args.length > 1 ? args[1].equals("n") : false;
        System.out.println("# Filtering C code : " + fExcludeCFiles);
        String[] arrayStrFilters = new String[]{"*.h*", "*.c*"};
        try {
            switch (Integer.valueOf(strConstructor)) {
                case 0: {
                    preProcessor = new CPreProcessorStream(strFile);
                    break;
                }
                case 1: {
                    preProcessor = new CPreProcessorStream(strFile, arrayStrFilters, true);
                    break;
                }
                default: {
                    preProcessor = new CPreProcessorStream(strFile, informationalOutput, null, arrayStrFilters, fExcludeCFiles, true, false);
                }
            }
            BufferedReader bufReader = new BufferedReader(new InputStreamReader(preProcessor));
            if (strOutput != null) {
                String line;
                FileWriter fileWriter = new FileWriter(strOutput);
                BufferedWriter bufWriter = new BufferedWriter(fileWriter);
                while ((line = bufReader.readLine()) != null) {
                    System.out.println(line);
                    bufWriter.write(line, 0, line.length());
                    bufWriter.newLine();
                }
                System.out.println("# END");
                bufWriter.close();
            } else {
                String line;
                int iCounter = 0;
                while ((line = bufReader.readLine()) != null) {
                    System.out.println(line);
                    ++iCounter;
                }
            }
        }
        catch (IOException exc) {
            System.out.println("IOException : " + exc);
            if (preProcessor.hasPreProcessorExceptionOccurred()) {
                System.out.println("PreProcessorException : " + preProcessor.getPreProcessorException());
            }
        }
        catch (NumberFormatException exc) {
            System.out.println(exc);
        }
    }

    public static void test2(String[] args) {
        if (args.length < 1) {
            return;
        }
        String strInputFile = args[0];
        String strOutputFile = args.length > 1 ? args[1] : null;
        int iLineCounter = 0;
        CPreProcessorStream istream = null;
        BufferedReader bufReader = null;
        BufferedWriter bufWriter = null;
        String strLine = null;
        try {
            istream = new CPreProcessorStream(strInputFile);
            bufReader = new BufferedReader(new InputStreamReader(istream));
            bufWriter = strOutputFile != null ? new BufferedWriter(new FileWriter(strOutputFile)) : null;
            istream.addMacro("__DEBUG__", (Vector)null, "1");
            while ((strLine = bufReader.readLine()) != null) {
                if (bufWriter != null) {
                    bufWriter.write(strLine, 0, strLine.length());
                    bufWriter.newLine();
                } else {
                    System.out.println(strLine);
                }
                ++iLineCounter;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("The file " + strInputFile + " was not found");
        }
        catch (IOException exc) {
            if (istream != null && istream.hasPreProcessorExceptionOccurred()) {
                System.out.println(istream.getPreProcessorException());
            }
            System.out.println(exc);
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            return;
        }
        String strInputFile = args[0];
        String strOutputFile = args.length > 1 ? args[1] : null;
        int iLineCounter = 0;
        CPreProcessorStream istream = null;
        BufferedReader bufReader = null;
        BufferedWriter bufWriter = null;
        String strLine = null;
        try {
            istream = new CPreProcessorStream(strInputFile);
            bufReader = new BufferedReader(new InputStreamReader(istream));
            bufWriter = strOutputFile != null ? new BufferedWriter(new FileWriter(strOutputFile)) : null;
            istream.addMacro("__DEBUG__", (Vector)null, "1");
            istream.setIncludeKeywords(s_INCLUDE2, s_INCLUDE3);
            istream.setReservedKeywords(new String[]{"RESERVED"});
            while ((strLine = bufReader.readLine()) != null) {
                if (bufWriter != null) {
                    bufWriter.write(strLine, 0, strLine.length());
                    bufWriter.newLine();
                } else {
                    System.out.println(strLine);
                }
                ++iLineCounter;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("The file " + strInputFile + " was not found");
        }
        catch (IOException exc) {
            if (istream != null && istream.hasPreProcessorExceptionOccurred()) {
                System.out.println(istream.getPreProcessorException());
            }
            System.out.println(exc);
        }
    }
}

