/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dk.dps.io;

import com.ibm.dk.dps.io.PreProcessorConstants;
import com.ibm.dk.dps.util.StringUtility;
import java.util.Vector;

class MacroDefinition {
    private String[] d_arrayStringParameters;
    private String d_stringExpression;
    private String[] d_arrayStringTokenizedExpression;

    public MacroDefinition(String[] parameterArray, String macroExpression) {
        this.d_arrayStringParameters = parameterArray;
        this.d_stringExpression = macroExpression;
        this.d_arrayStringTokenizedExpression = StringUtility.cutIntoTokens(this.d_stringExpression, "()#", PreProcessorConstants.s_astrSEPARATORS);
    }

    public String toString() {
        String result = "(";
        int i = 0;
        while (i < this.d_arrayStringParameters.length) {
            if (i > 0) {
                result = String.valueOf(result) + ",";
            }
            result = String.valueOf(result) + this.d_arrayStringParameters[i];
            ++i;
        }
        result = String.valueOf(result) + ") : " + this.d_stringExpression;
        return result;
    }

    public String expand(Vector vecParameters) {
        if (this.numberOfParameters() == 0) {
            String[] astrTokens = StringUtility.cloneStringArray(this.d_arrayStringTokenizedExpression);
            int iNewLength = MacroDefinition.reduceMacroOperators(astrTokens, astrTokens.length);
            if (iNewLength == astrTokens.length) {
                return this.d_stringExpression;
            }
            return StringUtility.concatStringArray(astrTokens, iNewLength);
        }
        String[] astrTokens = StringUtility.cloneStringArray(this.d_arrayStringTokenizedExpression);
        int i = 0;
        while (i < this.d_arrayStringTokenizedExpression.length) {
            int iParameterIndex = StringUtility.findStringInArray(astrTokens[i], this.d_arrayStringParameters);
            if (iParameterIndex >= 0) {
                astrTokens[i] = (String)vecParameters.elementAt(iParameterIndex);
            }
            ++i;
        }
        return StringUtility.concatStringArray(astrTokens, MacroDefinition.reduceMacroOperators(astrTokens, astrTokens.length));
    }

    public int numberOfParameters() {
        return this.d_arrayStringParameters == null ? 0 : this.d_arrayStringParameters.length;
    }

    private static int reduceMacroOperators(String[] astrTokens, int iLength) {
        iLength = MacroDefinition.reduceConcatenations(astrTokens, iLength);
        return MacroDefinition.reduceMacroToString(astrTokens, iLength);
    }

    private static int reduceConcatenations(String[] astrTokens, int iLength) {
        int i = 0;
        while (i < iLength) {
            if (astrTokens[i].equals("##")) {
                try {
                    astrTokens[i - 1] = String.valueOf(astrTokens[i - 1]) + astrTokens[i + 1];
                    int j = i + 2;
                    while (j < iLength) {
                        astrTokens[j - 2] = astrTokens[j];
                        ++j;
                    }
                    iLength -= 2;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            }
            ++i;
        }
        return iLength;
    }

    private static int reduceMacroToString(String[] astrTokens, int iLength) {
        int i = 0;
        while (i < iLength - 1) {
            if (astrTokens[i].equals("#")) {
                astrTokens[i] = "\"" + astrTokens[i + 1] + "\"";
                int j = i + 2;
                while (j < iLength) {
                    astrTokens[j - 1] = astrTokens[j];
                    ++j;
                }
                --iLength;
            }
            ++i;
        }
        return iLength;
    }
}

