/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dk.dps.util;

import com.ibm.dk.dps.util.VectorUtility;
import java.util.Enumeration;
import java.util.Vector;

public class StringUtility {
    public static int countLeadingSpaces(String s) {
        int iCount = 0;
        int iLength = s.length();
        int i = 0;
        while (i < iLength && s.charAt(i) == ' ') {
            ++iCount;
            ++i;
        }
        return iCount;
    }

    public static int indexOfAnyOf(String testString, String searchChars) {
        return StringUtility.indexOfAnyOf(testString, 0, searchChars);
    }

    public static int indexOfAnyOf(String testString, int iStartIndex, String searchChars) {
        int iIndex = -1;
        int i = 0;
        while (i < searchChars.length()) {
            int iTest = testString.indexOf(searchChars.charAt(i), iStartIndex);
            if (iIndex < 0) {
                iIndex = iTest;
            } else if (iTest >= 0 && iTest < iIndex) {
                iIndex = iTest;
            }
            ++i;
        }
        return iIndex;
    }

    public static int indexOfAnyBut(String testString, String searchChars) {
        return StringUtility.indexOfAnyBut(testString, 0, searchChars);
    }

    public static int indexOfAnyBut(String testString, int iStartIndex, String searchChars) {
        int i = iStartIndex;
        while (i < testString.length()) {
            if (searchChars.indexOf(testString.charAt(i)) < 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int lengthOfMatchingStringAtString(String testString, String searchString1, String searchString2) {
        if (testString.startsWith(searchString1)) {
            return searchString1.length();
        }
        if (testString.startsWith(searchString2)) {
            return searchString2.length();
        }
        return -1;
    }

    public static int lengthOfMatchingStringAtString(String testString, String searchString1, String searchString2, String searchString3) {
        if (testString.startsWith(searchString1)) {
            return searchString1.length();
        }
        if (testString.startsWith(searchString2)) {
            return searchString2.length();
        }
        if (testString.startsWith(searchString3)) {
            return searchString3.length();
        }
        return -1;
    }

    public static String leadingSpaces(String str) {
        if (str.length() == 0) {
            return "";
        }
        int iIndex = 0;
        while (iIndex < str.length() && str.charAt(iIndex) == ' ') {
            ++iIndex;
        }
        if (iIndex == 0) {
            return "";
        }
        return str.substring(0, iIndex - 1);
    }

    public static String trailingSpaces(String str) {
        if (str.length() == 0) {
            return "";
        }
        int iIndex = str.length() - 1;
        while (iIndex > 0 && str.charAt(iIndex) == ' ') {
            --iIndex;
        }
        if (++iIndex < 0 || iIndex == str.length()) {
            return "";
        }
        return str.substring(iIndex, str.length());
    }

    public static int integerValue(String s) {
        return (int)StringUtility.longValue(s);
    }

    public static long longValue(String s) {
        if (s.startsWith("0x") || s.startsWith("0X")) {
            return StringUtility.longFromHexString(s);
        }
        return Long.valueOf(s);
    }

    private static long longFromHexString(String s) {
        s = s.substring(2);
        long lResult = 0L;
        int i = 0;
        while (i < s.length()) {
            lResult *= 16L;
            lResult += (long)StringUtility.integerFromHexDigit(s.charAt(i));
            ++i;
        }
        return lResult;
    }

    private static int integerFromHexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return c - 97 + 10;
    }

    public static String generateStringOfLength(char c, int iLength) {
        String result = "";
        int i = 0;
        while (i < iLength) {
            result = String.valueOf(result) + c;
            ++i;
        }
        return result;
    }

    public static String centerJustify(String s, int iLength, char chPad) {
        if (s.length() >= iLength) {
            return s;
        }
        int iLength2 = iLength / 2;
        return String.valueOf(StringUtility.generateStringOfLength(chPad, iLength - iLength2)) + s + StringUtility.generateStringOfLength(chPad, iLength2);
    }

    public static String centerJustify(String s, int iLength) {
        return StringUtility.centerJustify(s, iLength);
    }

    public static String leftJustify(String s, int iLength, char chPad) {
        if (s.length() >= iLength) {
            return s;
        }
        String strTail = StringUtility.generateStringOfLength(chPad, iLength - s.length());
        return String.valueOf(s) + strTail;
    }

    public static String leftJustify(String s, int iLength) {
        return StringUtility.leftJustify(s, iLength, ' ');
    }

    public static String rightJustify(String s, int iLength, char chPad) {
        if (s.length() > iLength) {
            return s;
        }
        String strHead = StringUtility.generateStringOfLength(chPad, iLength - s.length());
        return String.valueOf(strHead) + s;
    }

    public static String rightJustify(String s, int iLength) {
        return StringUtility.rightJustify(s, iLength, ' ');
    }

    public static String spaces(int iLength) {
        return StringUtility.rightJustify("", iLength, ' ');
    }

    public static String remove(String s, int iStartPos, int iCharCount) {
        return String.valueOf(s.substring(0, iStartPos)) + s.substring(iStartPos + iCharCount);
    }

    public static String remove(String s, int iStartPos) {
        return s.substring(0, iStartPos);
    }

    public static int[] allIndexesOf(String s, char c) {
        Vector<Integer> vecResult = new Vector<Integer>();
        int i = 0;
        while (i < s.length()) {
            int p = s.indexOf(c, i);
            if (p != -1) {
                vecResult.addElement(new Integer(p));
                i = p + 1;
                continue;
            }
            i = s.length();
        }
        return VectorUtility.convertIntegerVectorToArray(vecResult);
    }

    public static Vector wordsSeparatedBy(String s, char c) {
        int[] aiSeparators = StringUtility.allIndexesOf(s, c);
        Vector<String> vecResult = new Vector<String>();
        if (aiSeparators.length == 0) {
            vecResult.addElement(s);
            return vecResult;
        }
        String w = s.substring(0, aiSeparators[0]);
        vecResult.addElement(w);
        int i = 0;
        while (i < aiSeparators.length - 1) {
            w = s.substring(aiSeparators[i] + 1, aiSeparators[i + 1]);
            vecResult.addElement(w);
            ++i;
        }
        w = s.substring(aiSeparators[aiSeparators.length - 1] + 1);
        vecResult.addElement(w);
        return vecResult;
    }

    public static Vector nonEmptyWordsSeparatedBy(String s, char c) {
        Vector vecWords = StringUtility.wordsSeparatedBy(s, c);
        Vector<String> vecResult = new Vector<String>();
        Enumeration enumeration = vecWords.elements();
        while (enumeration.hasMoreElements()) {
            String w = (String)enumeration.nextElement();
            if (w.length() == 0) continue;
            vecResult.addElement(w);
        }
        return vecResult;
    }

    public static boolean isNumeric(String s) {
        return StringUtility.indexOfAnyBut(s, "0123456789") == -1;
    }

    public static String generateNewFileName(String strOldName, String strOldExtension, String strNewExtension) {
        if (strOldName.toUpperCase().endsWith(strOldExtension.toUpperCase())) {
            return String.valueOf(strOldName.substring(0, strOldName.length() - strOldExtension.length())) + strNewExtension;
        }
        return String.valueOf(strOldName) + strNewExtension;
    }

    public static String useFileNameExtension(String strFileName, String strExtension) {
        if (strFileName.toUpperCase().endsWith(strExtension.toUpperCase())) {
            return strFileName;
        }
        return String.valueOf(strFileName) + strExtension;
    }

    public static boolean binarySearchStringInArray(String strTest, String[] arrayStr) {
        if (arrayStr == null) {
            return false;
        }
        int iStartIndex = 0;
        int iTestIndex = arrayStr.length / 2;
        int iEndIndex = arrayStr.length - 1;
        do {
            int iTest;
            if ((iTest = strTest.compareTo(arrayStr[iTestIndex])) == 0) {
                return true;
            }
            if (iTest < 0) {
                iEndIndex = iTestIndex;
                if ((iTestIndex = iStartIndex + (iEndIndex - iStartIndex) / 2) != iEndIndex) continue;
                iEndIndex = --iTestIndex;
                continue;
            }
            iStartIndex = iTestIndex;
            if (iStartIndex != (iTestIndex = iStartIndex + (iEndIndex - iStartIndex) / 2)) continue;
            iStartIndex = ++iTestIndex;
        } while (iStartIndex < iEndIndex);
        return false;
    }

    public static int findPrefixInArray(String s, int iSearchOffset, String[] astr) {
        if (astr == null) {
            return -1;
        }
        int i = 0;
        while (i < astr.length) {
            if (s.startsWith(astr[i], iSearchOffset)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOfAnyInArray(String s, int iSearchOffset, String[] astr) {
        int iResult = -1;
        int i = 0;
        while (i < astr.length) {
            int iIndex = s.indexOf(astr[i], iSearchOffset);
            if (iIndex >= 0) {
                if (iResult < 0) {
                    iResult = iIndex;
                } else if (iIndex < iResult) {
                    iResult = iIndex;
                }
            }
            ++i;
        }
        return iResult;
    }

    public static int findStringInArray(String s, String[] astr) {
        if (astr == null) {
            return -1;
        }
        int i = 0;
        while (i < astr.length) {
            if (astr[i].equals(s)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String[] splitIntoStringArray(String s, int iStringLength) {
        if (s == null) {
            return new String[0];
        }
        int iSize = (s.length() + iStringLength - 1) / iStringLength;
        String[] astrResult = new String[iSize];
        int iStringIndex = 0;
        int iArrayIndex = 0;
        while (iStringIndex < s.length()) {
            astrResult[iArrayIndex++] = s.substring(iStringIndex, iStringIndex + iStringLength);
            iStringIndex += iStringLength;
        }
        return astrResult;
    }

    public static void addToStringArray(String[] astrTarget, int iTargetIndex, String[] astrSource) {
        if (astrSource != null) {
            int i = 0;
            while (i < astrSource.length) {
                astrTarget[iTargetIndex++] = astrSource[i];
                ++i;
            }
        }
    }

    public static String[] combineStringArrays(String[] astr1, String[] astr2) {
        int iLength1 = astr1 != null ? astr1.length : 0;
        int iLength2 = astr2 != null ? astr2.length : 0;
        String[] astrResult = new String[iLength1 + iLength2];
        StringUtility.addToStringArray(astrResult, 0, astr1);
        StringUtility.addToStringArray(astrResult, iLength1, astr2);
        return astrResult;
    }

    public static String removeAnyOf(String s, String strCharacters) {
        int iIndex;
        while ((iIndex = StringUtility.indexOfAnyOf(s, strCharacters)) >= 0) {
            s = iIndex == 0 ? s.substring(iIndex + 1) : String.valueOf(s.substring(0, iIndex)) + s.substring(iIndex + 1);
        }
        return s;
    }

    public static String removeChar(String s, char c) {
        int iIndex;
        while ((iIndex = s.indexOf(c)) >= 0) {
            s = iIndex == 0 ? s.substring(iIndex + 1) : String.valueOf(s.substring(0, iIndex)) + s.substring(iIndex + 1);
        }
        return s;
    }

    public static boolean isJavaIdentifier(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        if (Character.isJavaIdentifierStart(s.charAt(0))) {
            int i = 1;
            while (i < s.length()) {
                if (!Character.isJavaIdentifierPart(s.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static String[] cutIntoTokens(String line, String strCharDelimiters, String[] astrSpecialWordDelimiters) {
        String[] astrCharacters = StringUtility.splitIntoStringArray(strCharDelimiters, 1);
        String[] astrDelimiters = StringUtility.combineStringArrays(astrSpecialWordDelimiters, astrCharacters);
        return StringUtility.cutIntoTokens(line, astrDelimiters);
    }

    public static String[] cutIntoTokens(String line, String strCharDelimiters) {
        return StringUtility.cutIntoTokens(line, StringUtility.splitIntoStringArray(strCharDelimiters, 1));
    }

    public static String[] cutIntoTokens(String line, String[] astrDelimiters) {
        Vector<String> result = new Vector<String>();
        while (line.length() > 0) {
            int iStartIndex = StringUtility.indexOfAnyBut(line, " ");
            if (iStartIndex < 0) {
                line = "";
                continue;
            }
            int iDelimiterIndex = StringUtility.findPrefixInArray(line, iStartIndex, astrDelimiters);
            if (iDelimiterIndex < 0) {
                int iSpaceIndex = line.indexOf(32, iStartIndex);
                if ((iSpaceIndex > (iDelimiterIndex = StringUtility.indexOfAnyInArray(line, iStartIndex, astrDelimiters)) || iSpaceIndex < 0) && iDelimiterIndex >= 0) {
                    result.addElement(line.substring(iStartIndex, iDelimiterIndex));
                    line = line.substring(iDelimiterIndex);
                    continue;
                }
                if (iSpaceIndex >= 0) {
                    result.addElement(line.substring(iStartIndex, iSpaceIndex));
                    line = line.substring(iSpaceIndex);
                    continue;
                }
                result.addElement(line.substring(iStartIndex));
                line = "";
                continue;
            }
            result.addElement(astrDelimiters[iDelimiterIndex]);
            line = line.substring(iStartIndex + astrDelimiters[iDelimiterIndex].length());
        }
        String[] resultArray = new String[result.size()];
        int i = 0;
        while (i < resultArray.length) {
            resultArray[i] = (String)result.elementAt(i);
            ++i;
        }
        return resultArray;
    }

    public static String[] cloneStringArray(String[] astr) {
        if (astr == null) {
            return null;
        }
        String[] astrResult = new String[astr.length];
        int i = 0;
        while (i < astr.length) {
            astrResult[i] = astr[i];
            ++i;
        }
        return astrResult;
    }

    public static String[] copyStringArray(String[] astr, int iStartIndex) {
        int iLength = astr.length - iStartIndex;
        if (iLength > 0) {
            String[] astrResult = new String[iLength];
            int iIndex = 0;
            while (iStartIndex < astr.length) {
                astrResult[iIndex++] = astr[iStartIndex++];
            }
            return astrResult;
        }
        return new String[0];
    }

    public static String concatStringArray(String[] astr) {
        return StringUtility.concatStringArray(astr, astr.length);
    }

    public static String concatStringArray(String[] astr, int iLength) {
        if (astr == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int i = 0;
        while (i < iLength) {
            if (i != 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(astr[i]);
            ++i;
        }
        return stringBuffer.toString();
    }

    public static String replace(String str, String strTest, String strReplace) {
        int iIndex;
        while ((iIndex = str.indexOf(strTest)) >= 0) {
            str = String.valueOf(str.substring(0, iIndex)) + strReplace + str.substring(iIndex + strTest.length());
        }
        return str;
    }

    public static boolean isLike(String str, String strPattern) {
        return StringUtility.isLike(str, strPattern, '*', '?');
    }

    public static boolean isLike(String str, String strPattern, char chZeroOrMore, char chAnyChar) {
        strPattern = StringUtility.replace(strPattern, String.valueOf(chAnyChar) + "" + chZeroOrMore, String.valueOf(chZeroOrMore));
        strPattern = StringUtility.replace(strPattern, String.valueOf(chZeroOrMore) + "" + chAnyChar, String.valueOf(chZeroOrMore));
        strPattern = StringUtility.replace(strPattern, String.valueOf(chZeroOrMore) + "" + chZeroOrMore, String.valueOf(chZeroOrMore));
        int iIndex = 0;
        int iIndexPattern = 0;
        boolean fTestingZeroOrMore = false;
        char chNextChar = '\u0000';
        while (iIndex < str.length() && (fTestingZeroOrMore || iIndexPattern < strPattern.length())) {
            if (!fTestingZeroOrMore) {
                char chPattern;
                if ((chPattern = strPattern.charAt(iIndexPattern++)) == chZeroOrMore) {
                    fTestingZeroOrMore = true;
                    if (iIndexPattern < strPattern.length()) {
                        chNextChar = strPattern.charAt(iIndexPattern++);
                        continue;
                    }
                    return true;
                }
                if (chPattern == chAnyChar) {
                    ++iIndex;
                    continue;
                }
                if (chPattern != str.charAt(iIndex)) {
                    return false;
                }
                ++iIndex;
                continue;
            }
            if (str.charAt(iIndex++) != chNextChar) continue;
            fTestingZeroOrMore = false;
        }
        if (iIndexPattern + 1 == strPattern.length()) {
            return strPattern.charAt(iIndexPattern) == chZeroOrMore;
        }
        return iIndexPattern >= strPattern.length() && iIndex >= str.length();
    }

    public static void test1(String[] args) {
        String s = ".123.455..678,99.";
        System.out.println("# " + StringUtility.removeAnyOf(s, "."));
    }

    public static void main(String[] args) {
        System.out.println(StringUtility.isLike(args[0], args[1]));
    }
}

