/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.BinnedDataManager;
import jas.hist.DataManagerException;
import jas.hist.DataSource;
import jas.hist.JASHist;
import jas.hist.JASHistData;
import jas.hist.Rebinnable1DHistogramData;
import jas.hist.StatisticsBlock;
import jas.hist.XYDataSource;
import jas.plot.DataArea;
import jas.plot.DateAxis;
import jas.plot.DoubleAxis;
import jas.plot.Legend;
import java.io.IOException;
import java.io.ObjectInputStream;

final class DateDataManager
extends BinnedDataManager {
    private DateAxis xAxis = new DateAxis();

    DateDataManager(JASHist jASHist, DataArea dataArea, Legend legend, StatisticsBlock statisticsBlock, int n) {
        super(jASHist, dataArea, legend, statisticsBlock, n);
        DoubleAxis doubleAxis = new DoubleAxis();
        doubleAxis.setUseSuggestedRange(true);
        this.xm.setDataManager(this, true, this.xAxis);
        this.ym[0].setDataManager(this, false, doubleAxis);
        new BinnedDataManager.DateAxisListener(this.xm);
        this.xm.setBins(n);
    }

    JASHistData add(DataSource dataSource) {
        if (dataSource instanceof Rebinnable1DHistogramData) {
            Rebinnable1DHistogramData rebinnable1DHistogramData = (Rebinnable1DHistogramData)dataSource;
            if (rebinnable1DHistogramData.getAxisType() != 3) {
                throw new DataManagerException("Incompatible data type for axis");
            }
        } else {
            XYDataSource xYDataSource = (XYDataSource)dataSource;
            if (xYDataSource.getAxisType() != 3) {
                throw new DataManagerException("Incompatible data type for axis");
            }
        }
        return super.add(dataSource);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        new BinnedDataManager.DateAxisListener(this.xm);
    }

    protected void calcMinMaxBins(double d, double d2) {
        long l = (long)(d * 1000.0);
        long l2 = (long)(d2 * 1000.0);
        long l3 = this.xAxis.getAxisMin();
        long l4 = this.xAxis.getAxisMax();
        if (l != l3 || l2 != l4) {
            this.xAxis.setMin(l);
            this.xAxis.setMax(l2);
            this.xAxis.getAxis().invalidate();
        }
    }
}

