/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DateTransformationConverter;
import jas.hist.JASHist2DScatterData;
import jas.hist.JASHistScatterPlotStyle;
import jas.hist.ScatterEnumeration;
import jas.hist.TwoDOverlay;
import jas.plot.CoordinateTransformation;
import jas.plot.DateCoordinateTransformation;
import jas.plot.DoubleCoordinateTransformation;
import jas.plot.OverlayContainer;
import jas.plot.PlotGraphics;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;

class ScatterOverlay
extends TwoDOverlay
implements ImageObserver {
    private Image imageCache = null;
    private Image newImage = null;
    private JASHist2DScatterData parent;
    private boolean async = false;

    ScatterOverlay(JASHist2DScatterData jASHist2DScatterData) {
        super(jASHist2DScatterData);
        this.parent = jASHist2DScatterData;
    }

    public void containerNotify(OverlayContainer overlayContainer) {
        if (overlayContainer == null) {
            Image image = this.imageCache;
            if (image != null) {
                ((ScatterImage)image.getSource()).abort();
            }
            if ((image = this.newImage) != null) {
                ((ScatterImage)image.getSource()).abort();
            }
        }
        super.containerNotify(overlayContainer);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if (image == this.imageCache) {
            if ((n & 0x80) != 0) {
                this.imageCache = null;
            } else if ((n & 0x10) != 0) {
                this.container.repaint();
            }
        } else if (image == this.newImage && (n & 0x80) != 0) {
            this.newImage = null;
        }
        return true;
    }

    public void paint(PlotGraphics plotGraphics, boolean bl) {
        this.async = !bl;
        JASHistScatterPlotStyle jASHistScatterPlotStyle = (JASHistScatterPlotStyle)this.parent.style;
        if (jASHistScatterPlotStyle.getDisplayAsScatterPlot()) {
            CoordinateTransformation coordinateTransformation = this.container.getXTransformation();
            CoordinateTransformation coordinateTransformation2 = this.container.getYTransformation();
            if (coordinateTransformation instanceof DateCoordinateTransformation) {
                coordinateTransformation = new DateTransformationConverter((DateCoordinateTransformation)coordinateTransformation);
            }
            if (coordinateTransformation instanceof DoubleCoordinateTransformation && coordinateTransformation2 instanceof DoubleCoordinateTransformation) {
                DoubleCoordinateTransformation doubleCoordinateTransformation = (DoubleCoordinateTransformation)coordinateTransformation;
                DoubleCoordinateTransformation doubleCoordinateTransformation2 = (DoubleCoordinateTransformation)coordinateTransformation2;
                double d = doubleCoordinateTransformation.convert(doubleCoordinateTransformation.getPlotMin());
                double d2 = doubleCoordinateTransformation.convert(doubleCoordinateTransformation.getPlotMax());
                double d3 = doubleCoordinateTransformation2.convert(doubleCoordinateTransformation2.getPlotMin());
                double d4 = doubleCoordinateTransformation2.convert(doubleCoordinateTransformation2.getPlotMax());
                int n = (int)(d3 - d4);
                int n2 = (int)(d2 - d);
                Image image = this.imageCache;
                if (image == null) {
                    this.imageCache = image = this.container.createImage(new ScatterImage(n2, n, doubleCoordinateTransformation, doubleCoordinateTransformation2));
                    plotGraphics.drawImage(image, d, d4, this);
                } else {
                    int n3 = image.getWidth(null);
                    int n4 = image.getHeight(null);
                    if (n3 == n2 && n4 == n) {
                        plotGraphics.drawImage(image, d, d4, this);
                    } else if (n3 > 0 && n4 > 0) {
                        Image image2 = this.newImage;
                        if (image2 == null) {
                            this.newImage = image2 = this.container.createImage(new ScatterImage(n2, n, doubleCoordinateTransformation, doubleCoordinateTransformation2));
                            this.container.prepareImage(image2, this);
                        } else {
                            int n5 = image2.getWidth(null);
                            int n6 = image2.getHeight(null);
                            if (n5 <= 0 || n6 <= 0 || n5 != n2 || n6 != n) {
                                // empty if block
                            }
                        }
                        plotGraphics.drawImage(image, d, d4, n2, n, this);
                    }
                }
            }
        } else {
            super.paint(plotGraphics, bl);
        }
    }

    public void paintIcon(PlotGraphics plotGraphics, int n, int n2) {
        JASHistScatterPlotStyle jASHistScatterPlotStyle = (JASHistScatterPlotStyle)this.parent.style;
        if (jASHistScatterPlotStyle.getDisplayAsScatterPlot()) {
            plotGraphics.setColor(jASHistScatterPlotStyle.getDataPointColor());
            plotGraphics.fillRect(1.0, 1.0, n - 2, n2 - 2);
        } else {
            super.paintIcon(plotGraphics, n, n2);
        }
    }

    void continueImage() {
        Image image = this.imageCache;
        if (image != null) {
            ((ScatterImage)image.getSource()).continueDrawing();
        }
        if ((image = this.newImage) != null) {
            ((ScatterImage)image.getSource()).continueDrawing();
        }
    }

    void restartImage(boolean bl) {
        Image image = this.imageCache;
        if (image != null) {
            ((ScatterImage)image.getSource()).restart(bl);
        }
        if ((image = this.newImage) != null) {
            ((ScatterImage)image.getSource()).restart(bl);
        }
    }

    private void imageReallyComplete(ImageProducer imageProducer) {
        Image image = this.newImage;
        if (image != null && image.getSource() == imageProducer) {
            Image image2 = this.imageCache;
            this.imageCache = image;
            image2.flush();
            this.newImage = null;
            this.container.repaint();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    final class ScatterImage
    implements ImageProducer,
    Runnable {
        private final DoubleCoordinateTransformation xt;
        private final DoubleCoordinateTransformation yt;
        private ImageConsumer consumer;
        private ScatterEnumeration enum;
        private Thread thread;
        private boolean abort = false;
        private boolean pastPointOfNoContinue = false;
        private final int height;
        private final int width;

        ScatterImage(int n, int n2, DoubleCoordinateTransformation doubleCoordinateTransformation, DoubleCoordinateTransformation doubleCoordinateTransformation2) {
            this.width = n;
            this.height = n2;
            this.xt = doubleCoordinateTransformation;
            this.yt = doubleCoordinateTransformation2;
        }

        public boolean isConsumer(ImageConsumer imageConsumer) {
            return this.consumer.equals(imageConsumer);
        }

        public void addConsumer(ImageConsumer imageConsumer) {
            if (this.consumer != null) {
                throw new RuntimeException("Only single consumer supported");
            }
            this.consumer = imageConsumer;
        }

        public void removeConsumer(ImageConsumer imageConsumer) {
            this.consumer = null;
        }

        public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        }

        public void run() {
            ImageConsumer imageConsumer = this.consumer;
            if (imageConsumer != null) {
                this.deliverImage(imageConsumer);
            }
            this.thread = null;
        }

        public void startProduction(ImageConsumer imageConsumer) {
            this.consumer = imageConsumer;
            if (ScatterOverlay.this.async) {
                this.thread = new Thread(this);
                this.thread.start();
            } else {
                this.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void abort() {
            try {
                Thread thread = this.thread;
                if (thread != null) {
                    this.abort = true;
                    thread.join();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.abort = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void continueDrawing() {
            Thread thread = this.thread;
            if (thread != null) {
                ScatterImage scatterImage = this;
                synchronized (scatterImage) {
                    if (!this.pastPointOfNoContinue) {
                        return;
                    }
                }
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (ScatterOverlay.this.async) {
                this.thread = new Thread(this);
                this.thread.start();
            } else {
                this.run();
            }
        }

        void restart(boolean bl) {
            this.abort();
            if (bl) {
                this.enum = null;
            } else if (this.enum != null) {
                this.enum.restart();
            }
            if (ScatterOverlay.this.async) {
                this.thread = new Thread(this);
                this.thread.start();
            } else {
                this.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deliverImage(ImageConsumer imageConsumer) {
            JASHistScatterPlotStyle jASHistScatterPlotStyle = (JASHistScatterPlotStyle)((ScatterOverlay)ScatterOverlay.this).parent.style;
            Color color = jASHistScatterPlotStyle.getDataPointColor();
            byte[] byArray = new byte[]{0, (byte)color.getRed()};
            byte[] byArray2 = new byte[]{0, (byte)color.getGreen()};
            byte[] byArray3 = new byte[]{0, (byte)color.getBlue()};
            byte[] byArray4 = new byte[]{0, -2};
            IndexColorModel indexColorModel = new IndexColorModel(1, 2, byArray, byArray2, byArray3, byArray4);
            byte[] byArray5 = new byte[this.width * this.height];
            imageConsumer.setDimensions(this.width, this.height);
            imageConsumer.setColorModel(indexColorModel);
            double[] dArray = new double[2];
            int n = jASHistScatterPlotStyle.getDataPointStyle();
            int n2 = jASHistScatterPlotStyle.getDataPointSize();
            int n3 = n2 / 2;
            double d = this.xt.convert(this.xt.getPlotMin());
            double d2 = this.yt.convert(this.yt.getPlotMax());
            if (this.enum == null) {
                double d3 = ((ScatterOverlay)ScatterOverlay.this).parent.dataSource.getXMin();
                double d4 = ((ScatterOverlay)ScatterOverlay.this).parent.dataSource.getXMax();
                double d5 = ((ScatterOverlay)ScatterOverlay.this).parent.dataSource.getYMin();
                double d6 = ((ScatterOverlay)ScatterOverlay.this).parent.dataSource.getYMax();
                double d7 = this.xt.getPlotMin();
                double d8 = this.xt.getPlotMax();
                double d9 = this.yt.getPlotMin();
                double d10 = this.yt.getPlotMax();
                if (d3 < d7 || d4 > d8 || d5 < d9 || d6 > d10) {
                    double d11 = Math.max(d3, d7);
                    double d12 = Math.min(d4, d8);
                    double d13 = Math.max(d5, d9);
                    double d14 = Math.min(d6, d10);
                    double d15 = (double)n3 * (d8 - d7) / (this.xt.convert(d8) - d);
                    double d16 = (double)n3 * (d10 - d9) / (this.yt.convert(d9) - d2);
                    this.enum = d3 + d15 < d7 || d4 - d15 > d8 || d5 + d16 < d9 || d6 - d16 > d10 ? ((ScatterOverlay)ScatterOverlay.this).parent.dataSource.startEnumeration(d11 - d15, d12 + d15, d13 - d16, d14 + d16) : ((ScatterOverlay)ScatterOverlay.this).parent.dataSource.startEnumeration();
                } else {
                    this.enum = ((ScatterOverlay)ScatterOverlay.this).parent.dataSource.startEnumeration();
                }
            }
            long l = System.currentTimeMillis() + 200L;
            int n4 = 0;
            while (!this.abort) {
                block80: {
                    block81: {
                        int n5;
                        int n6;
                        block79: {
                            boolean bl = this.enum.getNextPoint(dArray);
                            if (!bl) {
                                ScatterImage scatterImage = this;
                                synchronized (scatterImage) {
                                    bl = this.enum.getNextPoint(dArray);
                                    if (!bl) {
                                        this.pastPointOfNoContinue = true;
                                        break;
                                    }
                                }
                            }
                            n6 = Math.round((float)(this.xt.convert(dArray[0]) - d));
                            n5 = Math.round((float)(this.yt.convert(dArray[1]) - d2));
                            if (n2 >= 2) break block79;
                            if (n6 < 0 || n6 >= this.width) break block80;
                            try {
                                byArray5[n5 * this.width + n6] = 1;
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                            break block81;
                        }
                        switch (n) {
                            case 0: {
                                int n7;
                                int n8;
                                int n9 = Math.min(this.width, n6 + n3);
                                int n10 = Math.min(this.height, n5 + n3);
                                int n11 = n8 * this.width;
                                for (n8 = Math.max(0, n5 - n3); n8 < n10; ++n8) {
                                    for (n7 = Math.max(0, n6 - n3); n7 < n9; ++n7) {
                                        try {
                                            byArray5[n11 + n7] = 1;
                                            continue;
                                        }
                                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                            // empty catch block
                                        }
                                    }
                                    n11 += this.width;
                                }
                                break;
                            }
                            case 1: {
                                int n7;
                                int n8 = n5 - n2 * 64 / 100;
                                int n12 = Math.max(0, n8) * this.width;
                                int n13 = Math.max(0, -n8);
                                while (n13 < n2) {
                                    int n14 = n13 / 2;
                                    int n15 = Math.min(this.width - 1, n6 + n14);
                                    for (n7 = Math.max(0, n6 - n14); n7 <= n15; ++n7) {
                                        try {
                                            byArray5[n12 + n7] = 1;
                                            continue;
                                        }
                                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                            // empty catch block
                                        }
                                    }
                                    ++n13;
                                    n12 += this.width;
                                }
                                break;
                            }
                            case 2: {
                                int n7;
                                int n8 = Math.max(0, n5 - n3);
                                int n16 = Math.min(this.height, n5 + n3);
                                int n17 = n8 * this.width;
                                int n18 = Math.max(n3 - n5, 0);
                                while (n18 < n3) {
                                    int n19 = Math.min(this.width - 1, n6 + n18);
                                    for (n7 = Math.max(0, n6 - n18); n7 <= n19; ++n7) {
                                        try {
                                            byArray5[n17 + n7] = 1;
                                            continue;
                                        }
                                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                            // empty catch block
                                        }
                                    }
                                    ++n18;
                                    n17 += this.width;
                                }
                                n18 = n3;
                                while (n18 >= 0) {
                                    int n20 = Math.min(this.width - 1, n6 + n18);
                                    for (n7 = Math.max(0, n6 - n18); n7 <= n20; ++n7) {
                                        try {
                                            byArray5[n17 + n7] = 1;
                                            continue;
                                        }
                                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                            // empty catch block
                                        }
                                    }
                                    --n18;
                                    n17 += this.width;
                                }
                                break;
                            }
                            case 3: {
                                int n7;
                                int n21 = n5 * this.width;
                                int n22 = Math.min(this.width - 1, n6 + n3);
                                for (n7 = Math.max(0, n6 - n3); n7 <= n22; ++n7) {
                                    try {
                                        byArray5[n21 + n7] = 1;
                                        continue;
                                    }
                                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                        // empty catch block
                                    }
                                }
                                n21 -= n3 * this.width;
                                int n23 = -n3;
                                while (n23 <= n3) {
                                    if (n6 >= 0 && n6 < this.width) {
                                        try {
                                            byArray5[n21 + n6] = 1;
                                        }
                                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                            // empty catch block
                                        }
                                    }
                                    if (n6 + n23 >= 0 && n6 + n23 < this.width) {
                                        try {
                                            byArray5[n21 + n6 + n23] = 1;
                                        }
                                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                            // empty catch block
                                        }
                                    }
                                    if (n6 - n23 >= 0 && n6 - n23 < this.width) {
                                        try {
                                            byArray5[n21 + n6 - n23] = 1;
                                        }
                                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                            // empty catch block
                                        }
                                    }
                                    ++n23;
                                    n21 += this.width;
                                }
                                break;
                            }
                            case 4: {
                                if (n6 < 0 || n6 >= this.width) break;
                                int n8 = Math.max(0, n5 - n3);
                                int n24 = Math.min(this.height, n5 + n3);
                                int n25 = n8 * this.width + n6;
                                while (n8 < n24) {
                                    try {
                                        byArray5[n25] = 1;
                                    }
                                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                        // empty catch block
                                    }
                                    ++n8;
                                    n25 += this.width;
                                }
                                break;
                            }
                            case 5: {
                                int n7;
                                if (n5 < 0 || n5 >= this.height) break;
                                int n26 = n5 * this.width;
                                int n27 = Math.min(this.width, n6 + n3);
                                for (n7 = Math.max(0, n6 - n3); n7 < n27; ++n7) {
                                    try {
                                        byArray5[n26 + n7] = 1;
                                        continue;
                                    }
                                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                        // empty catch block
                                    }
                                }
                                break;
                            }
                            case 6: {
                                int n7;
                                int n28 = n5 * this.width;
                                int n29 = Math.min(this.width - 1, n6 + n3);
                                for (n7 = Math.max(0, n6 - n3); n7 <= n29; ++n7) {
                                    try {
                                        byArray5[n28 + n7] = 1;
                                        continue;
                                    }
                                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                        // empty catch block
                                    }
                                }
                                int n8 = Math.max(0, n5 - n3);
                                int n30 = Math.min(this.height - 1, n5 + n3);
                                n28 -= (n5 - n8) * this.width - n6;
                                while (n8 <= n30) {
                                    try {
                                        byArray5[n28] = 1;
                                    }
                                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                        // empty catch block
                                    }
                                    ++n8;
                                    n28 += this.width;
                                }
                                break;
                            }
                            case 7: {
                                int n7;
                                int n8 = Math.max(0, n5 - n3);
                                int n31 = Math.min(this.height, n5 + n3);
                                int n32 = Math.min(this.width, n6 + n3);
                                int n33 = n8 * this.width;
                                if (n8 > 0) {
                                    for (n7 = Math.max(0, n6 - n3); n7 < n32; ++n7) {
                                        try {
                                            byArray5[n33 + n7] = 1;
                                            continue;
                                        }
                                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                            // empty catch block
                                        }
                                    }
                                }
                                boolean bl = n6 - n3 >= 0;
                                boolean bl2 = n6 + n3 < this.width;
                                n33 += n6;
                                while (n8 < n31) {
                                    if (bl) {
                                        try {
                                            byArray5[n33 - n3] = 1;
                                        }
                                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                            // empty catch block
                                        }
                                    }
                                    if (bl2) {
                                        try {
                                            byArray5[n33 + n3] = 1;
                                        }
                                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                            // empty catch block
                                        }
                                    }
                                    ++n8;
                                    n33 += this.width;
                                }
                                n33 -= n6;
                                for (n7 = Math.max(0, n6 - n3); n7 <= n32; ++n7) {
                                    try {
                                        byArray5[n33 + n7] = 1;
                                        continue;
                                    }
                                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                        // empty catch block
                                    }
                                }
                                break;
                            }
                        }
                    }
                    long l2 = System.currentTimeMillis();
                    if (l2 > l) {
                        imageConsumer.setPixels(0, 0, this.width, this.height, (ColorModel)indexColorModel, byArray5, 0, this.width);
                        imageConsumer.imageComplete(2);
                        l = l2 + 200L;
                    }
                }
                ++n4;
            }
            if (this.abort) {
                imageConsumer.imageComplete(4);
            } else {
                imageConsumer.setPixels(0, 0, this.width, this.height, (ColorModel)indexColorModel, byArray5, 0, this.width);
                imageConsumer.imageComplete(2);
                ScatterOverlay.this.imageReallyComplete(this);
            }
        }
    }
}

