/*
 * Decompiled with CFR 0.152.
 */
package jas.plot;

import jas.plot.HasPopupItems;
import jas.plot.JASPlotMouseListener;
import jas.plot.PlotComponent;
import jas.plot.PrintHelper;
import jas.util.ColorMenu;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.colorchooser.DefaultColorSelectionModel;

public abstract class MovableObject
extends PlotComponent
implements HasPopupItems,
JASPlotMouseListener {
    private String prefix;
    boolean moveWithParent = true;
    private int currentCursor;
    private Point dragOffset;
    private Cursor saveCursor;
    private boolean handlesVisible;
    private static final HandleBorder border = new HandleBorder(Color.blue);
    public static final Color[] bgcolors = new Color[]{null, Color.pink, Color.orange, Color.yellow, Color.green, Color.cyan, new Color(164, 207, 255), new Color(225, 170, 255), new Color(255, 170, 210)};
    public static final String[] bgnames = new String[]{"default", "pink", "light orange", "yellow", "light green", "cyan", "sky blue", "violet", "light magenta"};

    public MovableObject(String string) {
        this.prefix = string;
        super.setBorder(border);
    }

    protected String getPrefix() {
        return this.prefix;
    }

    public void setMovableObjectBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.moveWithParent = false;
    }

    public void setMovableObjectBounds(Rectangle rectangle) {
        super.setBounds(rectangle);
        this.moveWithParent = false;
    }

    public void setBorder(Border border) {
        Border border2 = super.getBorder();
        if (border2 instanceof CompoundBorder) {
            border2 = ((CompoundBorder)border2).getOutsideBorder();
        }
        super.setBorder(border == null ? border2 : new CompoundBorder(border2, border));
    }

    public int getBorderType() {
        return MovableObject.getBorderType(this.getInsideBorder());
    }

    public Border getInsideBorder() {
        Border border = super.getBorder();
        if (border instanceof CompoundBorder) {
            return ((CompoundBorder)border).getInsideBorder();
        }
        if (border instanceof HandleBorder) {
            return null;
        }
        return border;
    }

    public void modifyPopupMenu(JPopupMenu jPopupMenu, Component component) {
        jPopupMenu.add(new BorderMenu(this.prefix));
        DefaultColorSelectionModel defaultColorSelectionModel = new DefaultColorSelectionModel(){

            public Color getSelectedColor() {
                if (!MovableObject.this.isPaintingBackground()) {
                    return null;
                }
                return MovableObject.this.getBackground();
            }

            public void setSelectedColor(Color color) {
                MovableObject.this.setBackground(color);
            }
        };
        jPopupMenu.add(new BackgroundColorMenu(this.prefix, defaultColorSelectionModel));
    }

    final void showHandles() {
        this.handlesVisible = true;
        this.paintBorder(this.getGraphics());
        this.saveCursor = this.getCursor();
        this.currentCursor = 0;
    }

    final void hideHandles() {
        this.handlesVisible = false;
        this.setCursor(this.saveCursor);
        Container container = this.getParent();
        if (container != null) {
            container.repaint();
        }
    }

    public final void mouseEventNotify(MouseEvent mouseEvent) {
        if (this.handlesVisible) {
            if (mouseEvent.getID() == 504) {
                this.saveCursor = this.getCursor();
            } else if (mouseEvent.getID() == 505) {
                this.setCursor(this.saveCursor);
            } else if (mouseEvent.getID() == 501) {
                if (this.currentCursor == 13) {
                    this.dragOffset = mouseEvent.getPoint();
                }
            } else if (mouseEvent.getID() == 502) {
                this.dragOffset = null;
            }
        }
    }

    final void mouseMotionEventNotify(MouseEvent mouseEvent) {
        if (!this.handlesVisible) {
            return;
        }
        if (mouseEvent.getID() == 506) {
            if (this.currentCursor == 13) {
                Point point = mouseEvent.getPoint();
                Point point2 = this.getLocation();
                point.translate(point2.x, point2.y);
                if (this.dragOffset != null) {
                    point.translate(-this.dragOffset.x, -this.dragOffset.y);
                }
                this.setLocation(point);
                this.moveWithParent = false;
            } else {
                Rectangle rectangle = this.getBounds();
                Point point = mouseEvent.getPoint();
                if (this.currentCursor == 11) {
                    rectangle.width = point.x;
                } else if (this.currentCursor == 10) {
                    rectangle.width -= point.x;
                    rectangle.x += point.x;
                } else if (this.currentCursor == 8) {
                    rectangle.height -= point.y;
                    rectangle.y += point.y;
                } else if (this.currentCursor == 9) {
                    rectangle.height = point.y;
                } else if (this.currentCursor == 7) {
                    rectangle.height -= point.y;
                    rectangle.y += point.y;
                    rectangle.width = point.x;
                } else if (this.currentCursor == 6) {
                    rectangle.height -= point.y;
                    rectangle.y += point.y;
                    rectangle.width -= point.x;
                    rectangle.x += point.x;
                } else if (this.currentCursor == 5) {
                    rectangle.height = point.y;
                    rectangle.width = point.x;
                } else if (this.currentCursor == 4) {
                    rectangle.height = point.y;
                    rectangle.width -= point.x;
                    rectangle.x += point.x;
                } else {
                    return;
                }
                this.moveWithParent = false;
                this.setBounds(rectangle);
                this.validate();
            }
        } else if (mouseEvent.getID() == 503) {
            this.currentCursor = border.getCursor(this.getBounds(), mouseEvent.getPoint());
            ((Component)mouseEvent.getSource()).setCursor(Cursor.getPredefinedCursor(this.currentCursor));
        }
    }

    public boolean hasDefaultPosition() {
        return this.moveWithParent;
    }

    public void print(Graphics graphics) {
        try {
            if (System.getProperty("java.version").compareTo("1.3") >= 0) {
                super.print(graphics);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private final class BorderMenu
    extends JMenu {
        BorderMenu(String string) {
            super(string + " Border");
            this.addItem("None", 0);
            this.addItem("Bevel In", 1);
            this.addItem("Bevel Out", 2);
            this.addItem("Ethched", 3);
            this.addItem("Shadow", 5);
            DefaultColorSelectionModel defaultColorSelectionModel = new DefaultColorSelectionModel(this, MovableObject.this){
                private final /* synthetic */ MovableObject val$this$0;
                private final /* synthetic */ BorderMenu this$1;
                {
                    this.this$1 = borderMenu;
                    this.val$this$0 = movableObject;
                }

                public Color getSelectedColor() {
                    Border border = BorderMenu.access$100(this.this$1).getBorder();
                    if (border instanceof CompoundBorder) {
                        border = ((CompoundBorder)border).getInsideBorder();
                    }
                    if (border instanceof LineBorder) {
                        return ((LineBorder)border).getLineColor();
                    }
                    return null;
                }

                public void setSelectedColor(Color color) {
                    BorderMenu.access$100(this.this$1).setBorder(BorderFactory.createLineBorder(color));
                }
            };
            this.add(new ColorMenu("Line", defaultColorSelectionModel, false));
        }

        private void addItem(String string, int n) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
            this.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.addActionListener(new ActionListener(this, n){
                private final /* synthetic */ int val$btype;
                private final /* synthetic */ BorderMenu this$1;
                {
                    this.this$1 = borderMenu;
                    this.val$btype = n;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    BorderMenu.access$100(this.this$1).setBorderType(this.val$btype);
                }
            });
            jRadioButtonMenuItem.setSelected(MovableObject.this.getBorderType() == n);
        }

        static /* synthetic */ MovableObject access$100(BorderMenu borderMenu) {
            return borderMenu.MovableObject.this;
        }
    }

    private final class BackgroundColorMenu
    extends ColorMenu {
        BackgroundColorMenu(String string, ColorSelectionModel colorSelectionModel) {
            super(string + " Background", colorSelectionModel, bgcolors, bgnames);
        }
    }

    private static final class HandleBorder
    extends AbstractBorder {
        private Color lineColor;
        private static final int thickness = 5;
        private static final Insets insets = new Insets(5, 5, 5, 5);
        private static final int thick2 = 2;
        private static Handle[] handles = new Handle[8];

        HandleBorder(Color color) {
            this.lineColor = color;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (((MovableObject)component).handlesVisible && !PrintHelper.isPrinting()) {
                Color color = graphics.getColor();
                int n5 = n + 2;
                int n6 = n2 + 2;
                int n7 = n3 - 5;
                int n8 = n4 - 5;
                Handle[] handleArray = this.getHandles(n5, n6, n7, n8);
                graphics.setColor(this.lineColor);
                graphics.drawRect(n5, n6, n7, n8);
                for (int i = 0; i < handleArray.length; ++i) {
                    graphics.fillRect(handleArray[i].x, handleArray[i].y, handleArray[i].width, handleArray[i].height);
                }
                graphics.setColor(color);
            }
        }

        private Handle[] getHandles(int n, int n2, int n3, int n4) {
            handles[0].set(6, n, n2);
            handles[1].set(7, n + n3, n2);
            handles[2].set(5, n + n3, n2 + n4);
            handles[3].set(4, n, n2 + n4);
            handles[4].set(8, n + n3 / 2, n2);
            handles[5].set(9, n + n3 / 2, n2 + n4);
            handles[6].set(10, n, n2 + n4 / 2);
            handles[7].set(11, n + n3, n2 + n4 / 2);
            return handles;
        }

        int getCursor(Rectangle rectangle, Point point) {
            int n = 2;
            int n2 = 2;
            int n3 = rectangle.width - 5;
            int n4 = rectangle.height - 5;
            Handle[] handleArray = this.getHandles(n, n2, n3, n4);
            for (int i = 0; i < handleArray.length; ++i) {
                if (!handleArray[i].contains(point)) continue;
                return handleArray[i].getCursor();
            }
            if (point.x <= 5 && point.x >= -1 || point.y <= 5 && point.y >= -1 || point.x >= rectangle.width - 2 - 3 && point.x <= rectangle.width - 2 + 3 || point.y >= rectangle.height - 2 - 3 && point.y <= rectangle.height - 2 + 3) {
                return 13;
            }
            return 0;
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        public Color getLineColor() {
            return this.lineColor;
        }

        public boolean isBorderOpaque() {
            return false;
        }

        static {
            for (int i = 0; i < handles.length; ++i) {
                HandleBorder.handles[i] = new Handle(5);
            }
        }

        private static final class Handle
        extends Rectangle {
            private int thick2;
            private int type;

            Handle(int n) {
                this.setSize(n - 1, n - 1);
                this.thick2 = n / 2;
            }

            void set(int n, int n2, int n3) {
                this.setLocation(n2 - this.thick2, n3 - this.thick2);
                this.type = n;
            }

            int getCursor() {
                return this.type;
            }
        }
    }
}

