/*
 * Decompiled with CFR 0.152.
 */
package jas.plot;

import jas.plot.AxisLabel;
import jas.plot.AxisType;
import jas.plot.CoordinateTransformation;
import jas.plot.PlotGraphics;
import jas.plot.TimeCoordinateTransformation;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class TimeAxis
extends AxisType
implements TimeCoordinateTransformation {
    public static final int MILLISECONDS = 0;
    public static final int SECONDS = 1;
    public static final int MINUTES = 2;
    public static final int HOURS = 3;
    public static final int DAYS = 4;
    public static final int WEEKS = 5;
    public static final int MONTHS = 6;
    public static final int YEARS = 7;
    public static final long OMIT = 0L;
    private long[] unitLengths = new long[]{1L, 1000L, 60000L, 3600000L, 86400000L, 604800000L, 0L, 31536000000L};
    private final String[] unitNames = new String[]{"milliseconds", "seconds", "minutes", "hours", "days", "weeks", "months", "years"};
    private boolean useSuggestedRange = false;
    private int unitIndex;
    private long dataMin;
    private long dataMax;
    private long axisMin;
    private long axisMax;
    private AxisLabel[] labels;
    private final int majorTickLength = 5;
    private final int minSpaceBetweenLabels = 4;
    private final int maxCharsPerLabel = 6;

    public void setUnitLength(int n, long l) {
        if (l < 0L || l != 0L && (n != 0 && l <= this.unitLengths[n - 1] || n != 7 && l >= this.unitLengths[n + 1])) {
            throw new IllegalArgumentException();
        }
        if (l == 0L && this.unitIndex == n) {
            this.labelsValid = false;
        }
        this.unitLengths[n] = l;
    }

    public long getUnitLength(int n) {
        return this.unitLengths[n];
    }

    public String getUnits() {
        return this.unitNames[this.unitIndex];
    }

    public void setUseSuggestedRange(boolean bl) {
        if (this.useSuggestedRange != bl) {
            this.labelsValid = false;
        }
        this.useSuggestedRange = bl;
    }

    public void setMin(long l) {
        if (this.dataMin != l) {
            this.labelsValid = false;
        }
        this.dataMin = l;
    }

    public void setMax(long l) {
        if (this.dataMax != l) {
            this.labelsValid = false;
        }
        this.dataMax = l;
    }

    public long getAxisMin() {
        return this.axisMin;
    }

    public long getAxisMax() {
        return this.axisMax;
    }

    public long getDataMin() {
        return this.dataMin;
    }

    public long getDataMax() {
        return this.dataMax;
    }

    CoordinateTransformation getCoordinateTransformation() {
        return this;
    }

    void paintAxis(PlotGraphics plotGraphics, double d, double d2, double d3, Color color, Color color2, Color color3) {
        FontMetrics fontMetrics = plotGraphics.getFontMetrics();
        if (this.axis.getAxisOrientation() == 2) {
            double d4 = d2 + (double)fontMetrics.getMaxAscent() + 7.0;
            for (int i = 0; i < this.labels.length; ++i) {
                String string = this.labels[i].text;
                double d5 = d + this.labels[i].position * d3;
                plotGraphics.setColor(color);
                plotGraphics.drawString(string, d5 - (double)(fontMetrics.stringWidth(string) / 2), d4);
                plotGraphics.setColor(color2);
                plotGraphics.drawLine(d5, d2 + 5.0, d5, d2 - 5.0);
            }
        } else {
            double d6 = this.axis.onLeftSide ? d - 7.0 : d + 7.0;
            double d7 = fontMetrics.getAscent() / 2;
            for (int i = 0; i < this.labels.length; ++i) {
                String string = this.labels[i].text;
                double d8 = d2 - this.labels[i].position * d3;
                plotGraphics.setColor(color);
                plotGraphics.drawString(string, this.axis.onLeftSide ? d6 - (double)fontMetrics.stringWidth(string) : d6, d8 + d7);
                plotGraphics.setColor(color2);
                plotGraphics.drawLine(d - 5.0, d8, d + 5.0, d8);
            }
        }
    }

    void assumeAxisLength(int n) {
        Font font = this.axis.getFont();
        FontMetrics fontMetrics = this.axis.getToolkit().getFontMetrics(font);
        int n2 = this.getMaxNumberOfDivisions(fontMetrics, n);
        if (!this.labelsValid || this.labels == null || this.labels.length > n2 || this.labels.length < n2 / 2) {
            this.createNewLabels(n2);
        }
        if (this.axis.getAxisOrientation() == 1) {
            this.spaceRequirements.width = this.longestStringLength(fontMetrics, this.labels) + 7;
            this.spaceRequirements.height = Math.max(fontMetrics.getAscent() / 2 - (int)(this.labels[0].position * (double)n), 0);
            this.spaceRequirements.flowPastEnd = Math.max(fontMetrics.getMaxAscent() - fontMetrics.getAscent() / 2 - (int)((1.0 - this.labels[this.labels.length - 1].position) * (double)n), 0);
        } else {
            this.spaceRequirements.width = Math.max(fontMetrics.stringWidth(this.labels[0].text) / 2 - (int)(this.labels[0].position * (double)n), 0);
            this.spaceRequirements.height = fontMetrics.getMaxAscent() + 7;
            this.spaceRequirements.flowPastEnd = Math.max(fontMetrics.stringWidth(this.labels[this.labels.length - 1].text) / 2 - (int)((1.0 - this.labels[this.labels.length - 1].position) * (double)n), 0);
        }
    }

    int getMajorTickMarkLength() {
        return 5;
    }

    private void createNewLabels(int n) {
        this.labelsValid = true;
        this.unitIndex = this.getUnitIndex((this.dataMax - this.dataMin) / (long)n);
        long l = this.getClumpSize((this.dataMax - this.dataMin) / this.unitLengths[this.unitIndex] / (long)n);
        this.axisMin = this.useSuggestedRange ? this.dataMin - this.dataMin % l : this.dataMin;
        this.axisMax = this.useSuggestedRange && this.dataMax % l != 0L ? this.dataMax + l - this.dataMax % l : this.dataMax;
        int n2 = (int)((this.axisMax - this.axisMin) / l);
        if (this.useSuggestedRange || this.axisMin % l == 0L || this.axisMin % l > this.axisMax % l) {
            ++n2;
        }
        this.labels = new AxisLabel[n2];
        long l2 = this.useSuggestedRange || this.axisMin % l == 0L ? this.axisMin : this.axisMin + l - this.axisMin % l;
        for (int i = 0; i < n2; ++i) {
            this.labels[i] = new AxisLabel();
            this.labels[i].text = String.valueOf(l2 / this.unitLengths[this.unitIndex]);
            this.labels[i].position = (double)(l2 - this.axisMin) / (double)(this.axisMax - this.axisMin);
            l2 += l;
        }
        System.out.println("Labels are using units: ".concat(this.getUnits()));
    }

    private int getMaxNumberOfDivisions(FontMetrics fontMetrics, int n) {
        int n2 = this.axis.getAxisOrientation() == 2 ? n / (fontMetrics.charWidth('5') * 6 + 4) : n / (fontMetrics.getHeight() + 4);
        return Math.max(2, n2);
    }

    private int getUnitIndex(long l) {
        l *= 2L;
        int n = 0;
        int n2 = 0;
        while (n < this.unitLengths.length) {
            if (this.unitLengths[n] == 0L) {
                ++n;
                continue;
            }
            if (this.unitLengths[n] >= l) break;
            n2 = n++;
        }
        return n2;
    }

    private long getClumpSize(long l) {
        long[] lArray = new long[]{1L, 2L, 5L, 10L, 20L, 25L, 50L, 100L, 200L};
        long l2 = this.unitLengths[this.unitIndex];
        while (l > 100L) {
            l /= 100L;
            l2 *= 100L;
        }
        int n = 0;
        while (l >= lArray[n]) {
            ++n;
        }
        return lArray[n] * l2;
    }

    public double convert(long l) {
        int n = this.axis.getMinLocation();
        int n2 = this.axis.getMaxLocation();
        float f = (float)(l - this.axisMin) / (float)(this.axisMax - this.axisMin);
        return (float)n + f * (float)(n2 - n);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeBoolean(this.useSuggestedRange);
        objectOutput.writeObject(this.unitLengths);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.useSuggestedRange = objectInput.readBoolean();
        this.unitLengths = (long[])objectInput.readObject();
    }
}

