/*
 * Decompiled with CFR 0.152.
 */
package jas.plot.java1;

import jas.plot.SetablePlotGraphics;
import jas.plot.Transformation;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.image.ImageObserver;

public class PlotGraphics11
implements SetablePlotGraphics {
    private Transformation xt;
    private Transformation yt;
    private Graphics g;
    private Shape oldClip;
    private static final Transformation defaultTransformation = new Transformation(){

        public double convert(double d) {
            return d;
        }
    };
    private int[] ix;
    private int[] iy;
    private int bufSize;

    public void setStroke(Stroke stroke) {
    }

    public void setGraphics(Graphics graphics) {
        this.g = graphics;
        this.oldClip = graphics.getClip();
        this.clearTransformation();
    }

    public void setTransformation(Transformation transformation, Transformation transformation2) {
        this.xt = transformation == null ? defaultTransformation : transformation;
        this.yt = transformation2 == null ? defaultTransformation : transformation2;
    }

    public void clearTransformation() {
        this.xt = defaultTransformation;
        this.yt = defaultTransformation;
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.g.clipRect(n, n4, n2 - n, n3 - n4);
    }

    public void clearClip() {
        this.g.setClip(this.oldClip);
    }

    public void drawLine(double d, double d2, double d3, double d4) {
        int n = (int)this.xt.convert(d);
        int n2 = (int)this.xt.convert(d3);
        int n3 = (int)this.yt.convert(d2);
        int n4 = (int)this.yt.convert(d4);
        this.g.drawLine(n, n3, n2, n4);
    }

    public void drawPolyLine(double[] dArray, double[] dArray2, int n) {
        this.polyConvert(dArray, dArray2, n);
        this.g.drawPolyline(this.ix, this.iy, n);
    }

    public void fillRect(double d, double d2, double d3, double d4) {
        int n = (int)this.xt.convert(d);
        int n2 = (int)this.yt.convert(d2);
        int n3 = (int)this.xt.convert(d3);
        int n4 = (int)this.yt.convert(d4);
        int n5 = Math.min(n, n3);
        int n6 = Math.max(n, n3);
        int n7 = Math.min(n2, n4);
        int n8 = Math.max(n2, n4);
        this.g.fillRect(n5, n7, n6 - n5, n8 - n7);
    }

    public void drawRect(double d, double d2, double d3, double d4) {
        int n = (int)this.xt.convert(d);
        int n2 = (int)this.yt.convert(d2);
        int n3 = (int)this.xt.convert(d3);
        int n4 = (int)this.yt.convert(d4);
        int n5 = Math.min(n, n3);
        int n6 = Math.max(n, n3);
        int n7 = Math.min(n2, n4);
        int n8 = Math.max(n2, n4);
        this.g.drawRect(n5, n7, n6 - n5, n8 - n7);
    }

    public void drawOval(double d, double d2, double d3, double d4) {
        int n = (int)this.xt.convert(d);
        int n2 = (int)this.yt.convert(d2);
        int n3 = (int)this.xt.convert(d3);
        int n4 = (int)this.yt.convert(d4);
        int n5 = Math.min(n, n3);
        int n6 = Math.max(n, n3);
        int n7 = Math.min(n2, n4);
        int n8 = Math.max(n2, n4);
        this.g.drawOval(n5, n7, n6 - n5, n8 - n7);
    }

    public void setColor(Color color) {
        this.g.setColor(color);
    }

    public void drawString(String string, double d, double d2) {
        this.g.drawString(string, (int)this.xt.convert(d), (int)this.yt.convert(d2));
    }

    public FontMetrics getFontMetrics() {
        return this.g.getFontMetrics();
    }

    public void setFont(Font font) {
        this.g.setFont(font);
    }

    public Font getFont() {
        return this.g.getFont();
    }

    public void drawPolySymbol(double[] dArray, double[] dArray2, double d, int n, int n2) {
        this.polyConvert(dArray, dArray2, n2);
        int n3 = (int)d;
        for (int i = 0; i < n2; ++i) {
            this.drawSymbol(this.ix[i], this.iy[i], n3, n);
        }
    }

    public void drawSymbol(double d, double d2, double d3, int n) {
        int n2 = (int)this.xt.convert(d);
        int n3 = (int)this.yt.convert(d2);
        int n4 = (int)d3;
        this.drawSymbol(n2, n3, n4, n);
    }

    public void drawImage(Image image, double d, double d2, ImageObserver imageObserver) {
        this.g.drawImage(image, (int)this.xt.convert(d), (int)this.yt.convert(d2), imageObserver);
    }

    public void drawImage(Image image, double d, double d2, int n, int n2, ImageObserver imageObserver) {
        this.g.drawImage(image, (int)this.xt.convert(d), (int)this.yt.convert(d2), n, n2, imageObserver);
    }

    private void drawSymbol(int n, int n2, int n3, int n4) {
        PlotGraphics11.drawSymbol(this.g, n, n2, n3, n4);
    }

    public static void drawSymbol(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n - n3 / 2;
        int n6 = n2 - n3 / 2;
        switch (n4) {
            case 0: {
                graphics.fillOval(n5, n6, n3, n3);
                break;
            }
            case 1: {
                graphics.fillRect(n5, n6, n3, n3);
                break;
            }
            case 2: {
                int[] nArray = new int[]{n5, n, n5 + n3};
                int[] nArray2 = new int[]{n6 + n3, n6, n6 + n3};
                graphics.fillPolygon(nArray, nArray2, 3);
                break;
            }
            case 3: {
                int[] nArray = new int[]{n5, n, n5 + n3, n};
                int[] nArray3 = new int[]{n2, n6 + n3, n2, n6};
                graphics.fillPolygon(nArray, nArray3, 4);
                break;
            }
            case 4: {
                graphics.drawLine(n5, n2, n5 + n3, n2);
                graphics.drawLine(n5, n6, n5 + n3, n6 + n3);
                graphics.drawLine(n, n6, n, n6 + n3);
                graphics.drawLine(n5, n6 + n3, n5 + n3, n6);
                break;
            }
            case 5: {
                graphics.drawLine(n, n6, n, n6 + n3);
                break;
            }
            case 6: {
                graphics.drawLine(n5, n2, n5 + n3, n2);
                break;
            }
            case 7: {
                graphics.drawLine(n, n6, n, n6 + n3);
                graphics.drawLine(n5, n2, n5 + n3, n2);
                break;
            }
            case 8: {
                graphics.drawOval(n5, n6, n3, n3);
                break;
            }
            case 9: {
                graphics.drawRect(n5, n6, n3, n3);
            }
        }
    }

    private void polyConvert(double[] dArray, double[] dArray2, int n) {
        int n2;
        if (n > this.bufSize) {
            this.ix = new int[n];
            this.iy = new int[n];
            this.bufSize = n;
        }
        if (this.xt != defaultTransformation) {
            for (n2 = 0; n2 < n; ++n2) {
                this.ix[n2] = (int)this.xt.convert(dArray[n2]);
            }
        } else {
            for (n2 = 0; n2 < n; ++n2) {
                this.ix[n2] = (int)dArray[n2];
            }
        }
        if (this.yt != defaultTransformation) {
            for (n2 = 0; n2 < n; ++n2) {
                this.iy[n2] = (int)this.yt.convert(dArray2[n2]);
            }
        } else {
            for (n2 = 0; n2 < n; ++n2) {
                this.iy[n2] = (int)dArray2[n2];
            }
        }
    }
}

