/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.ant;

import java.io.File;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;

public class FreeHepJavaCC
extends Task {
    File javaccHome = null;
    String includes = null;

    public void setIncludes(String string) {
        this.includes = string;
    }

    public void setJavaCCHome(File file) {
        this.javaccHome = file;
    }

    public void execute() throws BuildException {
        if (this.includes == null) {
            throw new BuildException("'includes' attribute must be set!");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.includes, ", ");
        while (stringTokenizer.hasMoreTokens()) {
            File file = new File(stringTokenizer.nextToken());
            if (file == null || !file.isFile()) {
                throw new BuildException("Invalid target: " + file);
            }
            CommandlineJava commandlineJava = new CommandlineJava();
            commandlineJava.setVm("java");
            commandlineJava.setClassname("javacc");
            File file2 = new File(file.getParent());
            commandlineJava.createArgument().setValue("-OUTPUT_DIRECTORY:" + file2.getAbsolutePath());
            File file3 = this.getDstFile(file2, file);
            if (file3.exists() && file.lastModified() < file3.lastModified()) {
                this.log("Skipping " + file, 3);
                continue;
            }
            this.log("Compiling " + file, 2);
            commandlineJava.createArgument().setValue(file.getAbsolutePath());
            if (this.javaccHome == null || !this.javaccHome.isDirectory()) {
                throw new BuildException("Javacchome not set.");
            }
            Path path = commandlineJava.createClasspath(this.getProject());
            path.createPathElement().setPath(this.javaccHome.getAbsolutePath() + "/javacc.jar");
            Commandline.Argument argument = commandlineJava.createVmArgument();
            argument.setValue("-mx140M");
            argument.setValue("-Dinstall.root=" + this.javaccHome.getAbsolutePath());
            Execute.runCommand((Task)this, (String[])commandlineJava.getCommandline());
        }
    }

    private File getDstFile(File file, File file2) {
        int n;
        String string = file2.getPath();
        int n2 = string.lastIndexOf(File.separator);
        if (n2 >= 0) {
            string = string.substring(n2 + 1);
        }
        String string2 = string = (n = string.lastIndexOf(46)) < 0 ? string + ".java" : string.substring(0, n) + ".java";
        if (file != null) {
            string = file + File.separator + string;
        }
        return new File(string);
    }
}

