/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.tools;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.freehep.xml.util.XMLWriter;

public class GenerateStatus {
    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length < 4) {
            System.err.println("Usage: GenerateStatus status.xml project version srcdir(s)");
            System.exit(1);
        }
        Project project = new Project("config", stringArray[1], stringArray[2]);
        for (int i = 3; i < stringArray.length; ++i) {
            project.scan(new File(stringArray[i]));
        }
        project.printAll();
        XMLWriter xMLWriter = new XMLWriter(new FileWriter(stringArray[0]), "    ");
        xMLWriter.openDoc();
        xMLWriter.printComment("Generated by GenerateStatus, DO NOT EDIT.");
        xMLWriter.closeDoc();
        project.toXML(xMLWriter);
        xMLWriter.close();
    }

    public static class Package {
        private String name;
        private String description;
        private String status;

        public Package(String string, String string2, String string3) {
            this.name = string;
            this.description = string2;
            this.status = string3;
        }

        public String toString() {
            return "Package: " + this.name + ", " + this.status + ", " + this.description;
        }

        public void toXML(XMLWriter xMLWriter) {
            xMLWriter.setAttribute("NAME", this.name);
            xMLWriter.openTag("PACKAGE");
            xMLWriter.openTag("DESCRIPTION");
            xMLWriter.println(this.description);
            xMLWriter.closeTag();
            xMLWriter.openTag("STATUS");
            xMLWriter.println(this.status);
            xMLWriter.closeTag();
            xMLWriter.closeTag();
        }
    }

    public static class Jar {
        private String name;
        private List patterns = new ArrayList();
        private List packages = new ArrayList();

        public Jar(String string) {
            this.name = string;
        }

        public void add(String string) {
            String string2 = string.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".\\*");
            this.patterns.add(Pattern.compile(string2));
        }

        public void add(Package package_) {
            this.packages.add(package_);
        }

        public boolean find(String string) {
            Iterator iterator = this.patterns.iterator();
            while (iterator.hasNext()) {
                Pattern pattern = (Pattern)iterator.next();
                Matcher matcher = pattern.matcher(string + ".");
                if (!matcher.find()) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            Object object;
            StringBuffer stringBuffer = new StringBuffer("Jar: ");
            stringBuffer.append(this.name);
            stringBuffer.append("\n");
            stringBuffer.append("  Patterns:\n");
            Iterator iterator = this.patterns.iterator();
            while (iterator.hasNext()) {
                object = (Pattern)iterator.next();
                stringBuffer.append("    ");
                stringBuffer.append(((Pattern)object).pattern());
                stringBuffer.append("\n");
            }
            stringBuffer.append("  Packages:\n");
            iterator = this.packages.iterator();
            while (iterator.hasNext()) {
                object = (Package)iterator.next();
                stringBuffer.append("    ");
                stringBuffer.append(object);
                stringBuffer.append("\n");
            }
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }

        public void toXML(XMLWriter xMLWriter) {
            Object object;
            xMLWriter.printComment("Jar " + this.name + " ");
            xMLWriter.setAttribute("NAME", this.name);
            xMLWriter.openTag("JAR");
            Iterator iterator = this.patterns.iterator();
            while (iterator.hasNext()) {
                object = (Pattern)iterator.next();
                xMLWriter.setAttribute("NAME", ((Pattern)object).pattern().replaceAll(".\\*", "*").replaceAll("\\\\.", "."));
                xMLWriter.printTag("PATTERN");
            }
            iterator = this.packages.iterator();
            while (iterator.hasNext()) {
                object = (Package)iterator.next();
                ((Package)object).toXML(xMLWriter);
            }
            xMLWriter.closeTag();
        }
    }

    public static class Project {
        private final FileFilter filter = new FileFilter(this){
            private final /* synthetic */ Project this$0;
            {
                this.this$0 = project;
            }

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().equals("package.html");
            }
        };
        private Map jars = new TreeMap();
        private String name;
        private String version;
        private final Pattern statusPattern = Pattern.compile("@status\\s(.*)@\\S*|@status\\s(.*)</body>|@status\\s(.*)\\z", 34);
        private final Pattern eoStatusPattern = Pattern.compile("\\.\\s|\\.<|\\n");
        private final Pattern descPattern = Pattern.compile("(.*<\\s*body.*?>)?\\s*(<.>)*\\s*(.*)", 34);
        private final Pattern eoDescPattern = Pattern.compile("\\.\\s|\\.<");

        public Project(String string, String string2, String string3) throws IOException {
            this.name = string2;
            this.version = string3;
            String string4 = string + File.separator + string2 + ".properties";
            Properties properties = new Properties();
            properties.load(new BufferedInputStream(new FileInputStream(string4)));
            System.out.println("Reading config file '" + string4 + "'...");
            String string5 = properties.getProperty("jars", "");
            StringTokenizer stringTokenizer = new StringTokenizer(string5, " ,\t\n\r");
            while (stringTokenizer.hasMoreTokens()) {
                this.module(string, string2, stringTokenizer.nextToken());
            }
        }

        private void module(String string, String string2, String string3) throws IOException {
            String string4 = string + File.separator + string2 + "-" + string3 + ".properties";
            Properties properties = new Properties();
            properties.load(new BufferedInputStream(new FileInputStream(string4)));
            System.out.println("Reading config file '" + string4 + "'...");
            String string5 = properties.getProperty("name", string3);
            Jar jar = new Jar(string5);
            this.jars.put(string5, jar);
            String string6 = properties.getProperty("packages", "");
            StringTokenizer stringTokenizer = new StringTokenizer(string6, " ,\t\n\r");
            while (stringTokenizer.hasMoreTokens()) {
                jar.add(stringTokenizer.nextToken());
            }
        }

        public Jar find(String string) {
            Iterator iterator = this.jars.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Jar jar = (Jar)entry.getValue();
                if (!jar.find(string)) continue;
                return jar;
            }
            return null;
        }

        private void scan(File file) throws IOException {
            File[] fileArray = file.listFiles(this.filter);
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    this.scan(fileArray[i]);
                    continue;
                }
                this.status(fileArray[i]);
            }
        }

        private void status(File file) throws IOException {
            String string;
            Matcher matcher;
            int n;
            System.out.print("Processing " + file + "...");
            String string2 = file.getParentFile().getPath().replaceAll("\\" + File.separator, ".");
            Jar jar = this.find(string2);
            if (jar == null) {
                System.out.println("\nWarning, package '" + string2 + "' does not seem to be included in a jar file");
            }
            String string3 = "Not Available";
            String string4 = null;
            FileReader fileReader = new FileReader(file);
            StringWriter stringWriter = new StringWriter();
            char[] cArray = new char[8096];
            while ((n = fileReader.read(cArray)) >= 0) {
                stringWriter.write(cArray, 0, n);
            }
            ((Reader)fileReader).close();
            stringWriter.close();
            Matcher matcher2 = this.descPattern.matcher(stringWriter.getBuffer());
            if (matcher2.find() && (matcher = this.eoDescPattern.matcher(string = matcher2.group(3))).find()) {
                string3 = string.substring(0, matcher.start() + 1);
            }
            if ((matcher2 = this.statusPattern.matcher(stringWriter.getBuffer())).find()) {
                for (int i = 1; i <= matcher2.groupCount(); ++i) {
                    if (matcher2.group(i) == null) continue;
                    string4 = matcher2.group(i);
                    matcher = this.eoStatusPattern.matcher(string4);
                    if (!matcher.find()) break;
                    string4 = string4.substring(0, matcher.start() + 1);
                    break;
                }
            }
            if (jar != null && string4 != null) {
                System.out.println(" Added to status");
                jar.add(new Package(string2, string3, string4));
            } else {
                System.out.println(" Not added to status");
            }
        }

        public void printAll() {
            Set set = this.jars.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Jar jar = (Jar)this.jars.get(string);
                System.out.println(jar.toString());
            }
        }

        public void toXML(XMLWriter xMLWriter) throws IOException {
            xMLWriter.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            xMLWriter.setAttribute("xsi:noNamespaceSchemaLocation", "project.xsd");
            xMLWriter.setAttribute("NAME", this.name);
            xMLWriter.setAttribute("VERSION", this.version);
            xMLWriter.openTag("PROJECT");
            Set set = this.jars.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Jar jar = (Jar)this.jars.get(string);
                jar.toXML(xMLWriter);
            }
            xMLWriter.closeTag();
        }
    }
}

