/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.tools.doclet;

import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.ClassTree;
import com.sun.tools.doclets.DocletAbortException;
import java.io.IOException;
import org.freehep.tools.doclet.AbstractTreeWriter;
import org.freehep.tools.doclet.ConfigurationStandard;

public class TreeWriter
extends AbstractTreeWriter {
    private PackageDoc[] packages;
    private boolean classesonly;

    public TreeWriter(ConfigurationStandard configurationStandard, String string, ClassTree classTree) throws IOException {
        super(configurationStandard, string, classTree);
        this.packages = configurationStandard.packages;
        this.classesonly = this.packages.length == 0;
    }

    public static void generate(ConfigurationStandard configurationStandard, ClassTree classTree) {
        String string = "overview-tree.html";
        try {
            TreeWriter treeWriter = new TreeWriter(configurationStandard, string, classTree);
            treeWriter.generateTreeFile();
            treeWriter.close();
        }
        catch (IOException iOException) {
            configurationStandard.standardmessage.error("doclet.exception_encountered", iOException.toString(), string);
            throw new DocletAbortException();
        }
    }

    public void generateTreeFile() throws IOException {
        this.printHtmlHeader(this.getText("doclet.Window_Class_Hierarchy"));
        this.printTreeHeader();
        this.printPageHeading();
        this.printPackageTreeLinks();
        this.generateTree(this.classtree.baseclasses(), "doclet.Class_Hierarchy");
        this.generateTree(this.classtree.baseinterfaces(), "doclet.Interface_Hierarchy");
        this.printTreeFooter();
    }

    protected void printPackageTreeLinks() {
        if (this.packages.length == 1 && this.packages[0].name().length() == 0) {
            return;
        }
        if (!this.classesonly) {
            this.dl();
            this.dt();
            this.boldText("doclet.Package_Hierarchies");
            this.dd();
            for (int i = 0; i < this.packages.length; ++i) {
                if (this.packages[i].name().length() == 0) continue;
                String string = this.pathString(this.packages[i], "package-tree.html");
                this.printHyperLink(string, "", this.packages[i].name());
                if (i >= this.packages.length - 1) continue;
                this.print(", ");
            }
            this.dlEnd();
            this.hr();
        }
    }

    protected void printTreeHeader() {
        this.navLinks(true);
        this.hr();
    }

    protected void printTreeFooter() {
        this.hr();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void printPageHeading() {
        this.center();
        this.h2();
        this.printText("doclet.Hierarchy_For_All_Packages");
        this.h2End();
        this.centerEnd();
    }
}

