/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.PrintWriter;
import java.io.Writer;

public class IndentPrintWriter
extends PrintWriter {
    private int indent = 0;
    private boolean indented = false;
    private String indentString = "  ";

    public IndentPrintWriter(Writer writer, int n) {
        super(writer);
        this.setIndent(n);
    }

    public IndentPrintWriter(Writer writer) {
        this(writer, 0);
    }

    public void print(boolean bl) {
        this.doIndent();
        super.print(bl);
    }

    public void print(char c) {
        this.doIndent();
        super.print(c);
    }

    public void print(char[] cArray) {
        this.doIndent();
        super.print(cArray);
    }

    public void print(double d) {
        this.doIndent();
        super.print(d);
    }

    public void print(float f) {
        this.doIndent();
        super.print(f);
    }

    public void print(int n) {
        this.doIndent();
        super.print(n);
    }

    public void print(long l) {
        this.doIndent();
        super.print(l);
    }

    public void print(Object object) {
        this.doIndent();
        super.print(object);
    }

    public void print(String string) {
        this.doIndent();
        super.print(string);
    }

    public void println() {
        this.indented = false;
        super.println();
    }

    private void doIndent() {
        if (this.indented) {
            return;
        }
        this.indented = true;
        for (int i = 0; i < this.indent; ++i) {
            super.print(this.indentString);
        }
    }

    public void indent() {
        ++this.indent;
    }

    public void outdent() {
        --this.indent;
    }

    public int getIndent() {
        return this.indent;
    }

    public void setIndent(int n) {
        this.indent = n;
    }

    public String getIndentString() {
        return this.indentString;
    }

    public void setIndentString(String string) {
        this.indentString = string;
    }
}

