/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.ant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;

public class FreeHepJavah
extends MatchingTask {
    private String base;
    private String classname;
    private Path classpath = null;
    private String[] files = new String[1];

    public void setBase(String string) {
        this.base = string;
    }

    public void setClassname(String string) {
        this.classname = string;
    }

    public void setClasspath(Path path) {
        this.classpath = path;
    }

    public void execute() throws BuildException {
        File file = this.getProject().resolveFile(this.base);
        if (file == null) {
            throw new BuildException("base attribute must be set!", this.getLocation());
        }
        if (!file.exists()) {
            throw new BuildException("base does not exist!", this.getLocation());
        }
        if (this.classname == null) {
            DirectoryScanner directoryScanner = this.getDirectoryScanner(file);
            this.files = directoryScanner.getIncludedFiles();
        } else {
            this.files[0] = this.classname;
        }
        char c = System.getProperty("file.separator").charAt(0);
        int n = 0;
        if (this.files.length > 0) {
            for (int i = 0; i < this.files.length; ++i) {
                ExecTask execTask = new ExecTask();
                execTask.setProject(this.getProject());
                execTask.setExecutable("javah");
                if (this.classpath != null) {
                    execTask.createArg().setValue("-classpath");
                    execTask.createArg().setValue(this.classpath.toString());
                }
                execTask.createArg().setValue("-force");
                execTask.createArg().setValue("-jni");
                execTask.createArg().setValue("-o");
                File file2 = new File(this.files[i]);
                String string = file.getAbsolutePath() + c + this.files[i].substring(0, this.files[i].indexOf(".class")) + ".h";
                execTask.createArg().setValue(string);
                File file3 = new File(string);
                if (file2.lastModified() <= file3.lastModified()) continue;
                ++n;
                execTask.createArg().setValue(this.files[i].substring(0, this.files[i].indexOf(".class")).replace(c, '.'));
                execTask.execute();
            }
        }
        if (n > 0) {
            this.log("javah Compiled " + n + " classes...", 2);
        }
    }
}

