/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.tools.doclet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import com.sun.tools.doclets.ClassTree;
import com.sun.tools.doclets.DirectoryManager;
import com.sun.tools.doclets.DocletAbortException;
import com.sun.tools.doclets.Util;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.freehep.tools.doclet.ClassSubWriter;
import org.freehep.tools.doclet.ConfigurationStandard;
import org.freehep.tools.doclet.ConstructorSubWriter;
import org.freehep.tools.doclet.FieldSubWriter;
import org.freehep.tools.doclet.MethodSubWriter;
import org.freehep.tools.doclet.SubWriterHolderWriter;

public class ClassWriter
extends SubWriterHolderWriter {
    protected ClassDoc classdoc;
    protected ClassTree classtree;
    protected ClassDoc prev;
    protected ClassDoc next;
    protected MethodSubWriter methodSubWriter;
    protected ConstructorSubWriter constrSubWriter;
    protected FieldSubWriter fieldSubWriter;
    protected ClassSubWriter nestedSubWriter;
    protected static Set containingPackagesSeen;

    public ClassWriter(ConfigurationStandard configurationStandard, String string, String string2, ClassDoc classDoc, ClassDoc classDoc2, ClassDoc classDoc3, ClassTree classTree) throws IOException {
        super(configurationStandard, string, string2, DirectoryManager.getRelativePath((String)classDoc.containingPackage().name()));
        this.classdoc = classDoc;
        configurationStandard.currentcd = classDoc;
        this.classtree = classTree;
        this.prev = classDoc2;
        this.next = classDoc3;
        this.methodSubWriter = new MethodSubWriter(this, classDoc, configurationStandard);
        this.constrSubWriter = new ConstructorSubWriter(this, classDoc);
        this.fieldSubWriter = new FieldSubWriter(this, classDoc);
        this.nestedSubWriter = new ClassSubWriter(this, classDoc);
        if (containingPackagesSeen == null) {
            containingPackagesSeen = new HashSet();
        }
    }

    public static void generate(ConfigurationStandard configurationStandard, ClassDoc classDoc, ClassDoc classDoc2, ClassDoc classDoc3, ClassTree classTree, String string) {
        String string2 = DirectoryManager.getDirectoryPath((PackageDoc)classDoc.containingPackage());
        String string3 = classDoc.name() + ".html";
        try {
            ClassWriter classWriter = new ClassWriter(configurationStandard, string2, string3, classDoc, classDoc2, classDoc3, classTree);
            classWriter.generateClassFile(string);
            PackageDoc packageDoc = classDoc.containingPackage();
            if (!(configurationStandard.packages != null && Arrays.binarySearch(configurationStandard.packages, packageDoc) >= 0 || containingPackagesSeen.contains(packageDoc.name()))) {
                ClassWriter.copyDocFiles(configurationStandard, ClassWriter.getSourcePath(configurationStandard, classDoc.containingPackage()), string2 + "/" + "doc-files", true);
                containingPackagesSeen.add(packageDoc.name());
            }
            classWriter.close();
        }
        catch (IOException iOException) {
            configurationStandard.standardmessage.error("doclet.exception_encountered", iOException.toString(), string3);
            throw new DocletAbortException();
        }
    }

    protected void navLinkPackage() {
        this.navCellStart();
        PackageDoc packageDoc = this.classdoc.containingPackage();
        if (packageDoc != null && packageDoc.name().length() > 0) {
            this.printHyperLink("package-summary.html", "", this.getText("doclet.Package"), true, "NavBarFont1");
        } else {
            super.navLinkPackage();
        }
        this.navCellEnd();
    }

    protected void navLinkClass() {
        this.navCellRevStart();
        this.fontStyle("NavBarFont1Rev");
        this.boldText("doclet.Class");
        this.fontEnd();
        this.navCellEnd();
    }

    protected void navLinkClassUse() {
        this.navCellStart();
        this.printHyperLink("class-use/" + this.filename, "", this.getText("doclet.navClassUse"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected void navLinkPrevious() {
        if (this.prev == null) {
            this.printText("doclet.Prev_Class");
        } else {
            this.printClassLink(this.prev, this.getText("doclet.Prev_Class"), true);
        }
    }

    protected void navLinkNext() {
        if (this.next == null) {
            this.printText("doclet.Next_Class");
        } else {
            this.printClassLink(this.next, this.getText("doclet.Next_Class"), true);
        }
    }

    public void generateClassFile(String string) {
        String string2 = this.getText(this.classdoc.isInterface() ? "doclet.Interface" : "doclet.Class");
        PackageDoc packageDoc = this.classdoc.containingPackage();
        String string3 = packageDoc != null ? packageDoc.name() : "";
        String string4 = this.classdoc.name();
        String string5 = string2 + " " + string4;
        this.printHtmlHeader(string4, this.configuration.metakeywords.getMetaKeywords(this.classdoc));
        this.navLinks(true);
        this.hr();
        this.println("<!-- ======== START OF CLASS DATA ======== -->");
        this.h2();
        if (string3.length() > 0) {
            this.font("-1");
            this.print(string3);
            this.fontEnd();
            this.br();
        }
        this.print(string5);
        this.h2End();
        if (this.classdoc.isClass()) {
            this.pre();
            this.printTreeForClass(this.classdoc);
            this.preEnd();
        }
        this.printSuperImplementedInterfacesInfo();
        this.printSubClassInterfaceInfo();
        if (this.classdoc.isInterface()) {
            this.printImplementingClasses();
        }
        this.printEnclosingInfo();
        this.hr();
        this.printDeprecated();
        this.printClassDescription();
        this.p();
        if (string != null) {
            String string6 = this.classdoc.toString();
            string6 = string6.replace('.', '/');
            string6 = string6.concat(".java");
            string = string.concat("/" + string6);
        }
        if (!this.configuration.nocomment) {
            if (this.classdoc.inlineTags().length > 0) {
                this.printInlineComment((Doc)this.classdoc);
                this.p();
            }
            this.generateTagInfo((Doc)this.classdoc, string);
            this.hr();
            this.p();
        } else {
            this.hr();
        }
        this.printAllMembers();
        this.println("<!-- ========= END OF CLASS DATA ========= -->");
        this.hr();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void printAllMembers() {
        if (!this.configuration.nocomment) {
            this.println("<!-- ======== NESTED CLASS SUMMARY ======== -->");
            this.println();
            this.nestedSubWriter.printMembersSummary();
            this.nestedSubWriter.printInheritedMembersSummary();
            this.println();
            this.println("<!-- =========== FIELD SUMMARY =========== -->");
            this.println();
            this.fieldSubWriter.printMembersSummary();
            this.fieldSubWriter.printInheritedMembersSummary();
            this.println();
            this.println("<!-- ======== CONSTRUCTOR SUMMARY ======== -->");
            this.println();
            this.constrSubWriter.printMembersSummary();
            this.println();
            this.println("<!-- ========== METHOD SUMMARY =========== -->");
            this.println();
            this.methodSubWriter.printMembersSummary();
            this.methodSubWriter.printInheritedMembersSummary();
            this.p();
        }
        this.println();
        this.println("<!-- ============ FIELD DETAIL =========== -->");
        this.println();
        this.fieldSubWriter.printMembers();
        this.println();
        this.println("<!-- ========= CONSTRUCTOR DETAIL ======== -->");
        this.println();
        this.constrSubWriter.printMembers();
        this.println();
        this.println("<!-- ============ METHOD DETAIL ========== -->");
        this.println();
        this.methodSubWriter.printMembers();
    }

    protected void printClassDescription() {
        ClassDoc[] classDocArray;
        boolean bl = this.classdoc.isInterface();
        this.dl();
        this.dt();
        this.print(this.classdoc.modifiers() + " ");
        if (!bl) {
            this.print("class ");
        }
        if (this.configuration().genSrc) {
            this.printSrcLink((ProgramElementDoc)this.classdoc, this.classdoc.name());
        } else {
            this.bold(this.classdoc.name());
        }
        if (!bl && (classDocArray = this.classdoc.superclass()) != null) {
            this.dt();
            this.print("extends ");
            this.printClassLink((ClassDoc)classDocArray);
        }
        if ((classDocArray = this.classdoc.interfaces()) != null && classDocArray.length > 0) {
            this.dt();
            this.print(bl ? "extends " : "implements ");
            this.printClassLink(classDocArray[0]);
            for (int i = 1; i < classDocArray.length; ++i) {
                this.print(", ");
                this.printClassLink(classDocArray[i]);
            }
        }
        this.dlEnd();
    }

    protected void printDeprecated() {
        Tag[] tagArray = this.classdoc.tags("deprecated");
        if (tagArray.length > 0) {
            Tag[] tagArray2 = tagArray[0].inlineTags();
            if (tagArray2.length > 0) {
                this.boldText("doclet.Deprecated");
                this.space();
                this.printInlineDeprecatedComment((Doc)this.classdoc, tagArray[0]);
            }
            this.p();
        }
    }

    protected void printStep(int n) {
        this.print(this.spaces(4 * n - 2));
        String string = this.getText("doclet.extended_by");
        this.print("<IMG SRC=\"" + this.relativepathNoSlash + "/resources/inherit.gif\" " + "ALT=\"" + string + "\">");
    }

    protected int printTreeForClass(ClassDoc classDoc) {
        ClassDoc classDoc2 = classDoc.superclass();
        int n = 0;
        if (classDoc2 != null) {
            n = this.printTreeForClass(classDoc2);
            this.printStep(n);
        }
        if (classDoc.equals(this.classdoc)) {
            if (this.configuration.shouldExcludeQualifier(this.classdoc.containingPackage().name())) {
                this.bold(classDoc.name());
            } else {
                this.bold(classDoc.qualifiedName());
            }
        } else {
            this.printQualifiedClassLink(classDoc);
        }
        this.println();
        return n + 1;
    }

    protected void printSubClassInterfaceInfo() {
        List list;
        if (this.classdoc.qualifiedName().equals("java.lang.Object") || this.classdoc.qualifiedName().equals("org.omg.CORBA.Object")) {
            return;
        }
        List list2 = list = this.classdoc.isClass() ? this.classtree.subs(this.classdoc) : this.classtree.allSubs(this.classdoc);
        if (list.size() > 0) {
            this.printInfoHeader();
            if (this.classdoc.isClass()) {
                this.boldText("doclet.Subclasses");
            } else {
                this.boldText("doclet.Subinterfaces");
            }
            this.printSubClassLinkInfo(list);
        }
    }

    protected void printImplementingClasses() {
        if (this.classdoc.qualifiedName().equals("java.lang.Cloneable") || this.classdoc.qualifiedName().equals("java.io.Serializable")) {
            return;
        }
        List list = this.classtree.implementingclasses(this.classdoc);
        if (list.size() > 0) {
            this.printInfoHeader();
            this.boldText("doclet.Implementing_Classes");
            this.printSubClassLinkInfo(list);
        }
    }

    protected void printSuperImplementedInterfacesInfo() {
        Object[] objectArray = Util.getAllInterfaces((ClassDoc)this.classdoc);
        Arrays.sort(objectArray);
        if (objectArray.length > 0) {
            this.printInfoHeader();
            this.boldText(this.classdoc.isClass() ? "doclet.All_Implemented_Interfaces" : "doclet.All_Superinterfaces");
            this.printSubClassLinkInfo(Arrays.asList(objectArray));
        }
    }

    protected void printInfoHeader() {
        this.dl();
        this.dt();
    }

    protected void printSubClassLinkInfo(List list) {
        int n;
        Object[] objectArray = list.toArray();
        Arrays.sort(objectArray);
        this.print(' ');
        this.dd();
        for (n = 0; n < list.size() - 1; ++n) {
            this.printClassLink((ClassDoc)objectArray[n]);
            this.print(", ");
        }
        this.printClassLink((ClassDoc)objectArray[n]);
        this.ddEnd();
        this.dlEnd();
    }

    protected void navLinkTree() {
        this.navCellStart();
        if (this.classdoc.containingPackage().name().length() == 0) {
            this.printHyperLink(this.relativepath + "overview-tree.html", "", this.getText("doclet.Tree"), true, "NavBarFont1");
        } else {
            this.printHyperLink("package-tree.html", "", this.getText("doclet.Tree"), true, "NavBarFont1");
        }
        this.navCellEnd();
    }

    protected void printSummaryDetailLinks() {
        this.tr();
        this.tdVAlignClass("top", "NavBarCell3");
        this.font("-2");
        this.print("  ");
        this.navSummaryLinks();
        this.fontEnd();
        this.tdEnd();
        this.tdVAlignClass("top", "NavBarCell3");
        this.font("-2");
        this.navDetailLinks();
        this.fontEnd();
        this.tdEnd();
        this.trEnd();
    }

    protected void navSummaryLinks() {
        this.printText("doclet.Summary");
        this.print("&nbsp;");
        this.nestedSubWriter.navSummaryLink();
        this.navGap();
        this.fieldSubWriter.navSummaryLink();
        this.navGap();
        this.constrSubWriter.navSummaryLink();
        this.navGap();
        this.methodSubWriter.navSummaryLink();
    }

    protected void navDetailLinks() {
        this.printText("doclet.Detail");
        this.print("&nbsp;");
        this.fieldSubWriter.navDetailLink();
        this.navGap();
        this.constrSubWriter.navDetailLink();
        this.navGap();
        this.methodSubWriter.navDetailLink();
    }

    protected void navGap() {
        this.space();
        this.print('|');
        this.space();
    }

    protected void printEnclosingInfo() {
        ClassDoc classDoc = this.classdoc.containingClass();
        if (classDoc != null) {
            this.printInfoHeader();
            if (this.classdoc.isInterface()) {
                this.boldText("doclet.Enclosing_Interface");
            } else {
                this.boldText("doclet.Enclosing_Class");
            }
            this.dd();
            this.printClassLink(classDoc);
            this.ddEnd();
            this.dlEnd();
        }
    }
}

