/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.tools.doclet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.Configuration;
import com.sun.tools.doclets.DirectoryManager;
import com.sun.tools.doclets.DocletAbortException;
import com.sun.tools.doclets.Util;
import java.io.IOException;
import java.util.Arrays;
import org.freehep.tools.doclet.AbstractPackageWriter;
import org.freehep.tools.doclet.ConfigurationStandard;

public class PackageWriter
extends AbstractPackageWriter {
    protected PackageDoc prev;
    protected PackageDoc next;

    public PackageWriter(ConfigurationStandard configurationStandard, String string, String string2, PackageDoc packageDoc, PackageDoc packageDoc2, PackageDoc packageDoc3) throws IOException {
        super(configurationStandard, string, string2, packageDoc);
        this.prev = packageDoc2;
        this.next = packageDoc3;
    }

    public static void generate(ConfigurationStandard configurationStandard, PackageDoc packageDoc, PackageDoc packageDoc2, PackageDoc packageDoc3) {
        String string = DirectoryManager.getDirectoryPath((PackageDoc)packageDoc);
        String string2 = "package-summary.html";
        try {
            PackageWriter packageWriter = new PackageWriter(configurationStandard, string, string2, packageDoc, packageDoc2, packageDoc3);
            packageWriter.generatePackageFile(true);
            packageWriter.close();
            PackageWriter.copyDocFiles(configurationStandard, PackageWriter.getSourcePath(configurationStandard, packageDoc), string + "/" + "doc-files", true);
        }
        catch (IOException iOException) {
            configurationStandard.standardmessage.error("doclet.exception_encountered", iOException.toString(), string2);
            throw new DocletAbortException();
        }
    }

    protected void generateClassListing() {
        String string = this.packagedoc.name();
        Configuration configuration = this.configuration();
        if (this.packagedoc.isIncluded()) {
            this.generateClassKindListing(this.packagedoc.interfaces(), this.getText("doclet.Interface_Summary"));
            this.generateClassKindListing(this.packagedoc.ordinaryClasses(), this.getText("doclet.Class_Summary"));
            this.generateClassKindListing(this.packagedoc.exceptions(), this.getText("doclet.Exception_Summary"));
            this.generateClassKindListing(this.packagedoc.errors(), this.getText("doclet.Error_Summary"));
        } else {
            this.generateClassKindListing(configuration.classDocCatalog.interfaces(string), this.getText("doclet.Interface_Summary"));
            this.generateClassKindListing(configuration.classDocCatalog.ordinaryClasses(string), this.getText("doclet.Class_Summary"));
            this.generateClassKindListing(configuration.classDocCatalog.exceptions(string), this.getText("doclet.Exception_Summary"));
            this.generateClassKindListing(configuration.classDocCatalog.errors(string), this.getText("doclet.Error_Summary"));
        }
    }

    protected void generateClassKindListing(ClassDoc[] classDocArray, String string) {
        if (classDocArray.length > 0) {
            Arrays.sort(classDocArray);
            this.tableIndexSummary();
            boolean bl = false;
            for (int i = 0; i < classDocArray.length; ++i) {
                boolean bl2;
                if (this.documentedClasses != null && !this.documentedClasses.contains(classDocArray[i])) continue;
                if (!bl) {
                    this.printFirstRow(string);
                    bl = true;
                }
                boolean bl3 = bl2 = classDocArray[i].tags("deprecated").length > 0;
                if (!Util.isCoreClass((ClassDoc)classDocArray[i]) || !this.isGeneratedDoc((Doc)classDocArray[i])) continue;
                this.trBgcolorStyle("white", "TableRowColor");
                this.summaryRow(15);
                this.bold();
                this.print(this.getClassLink(classDocArray[i]));
                this.boldEnd();
                this.summaryRowEnd();
                this.summaryRow(0);
                if (bl2) {
                    this.boldText("doclet.Deprecated");
                    this.space();
                    this.printSummaryDeprecatedComment((Doc)classDocArray[i], classDocArray[i].tags("deprecated")[0]);
                } else {
                    this.printSummaryComment((Doc)classDocArray[i]);
                }
                this.summaryRowEnd();
                this.trEnd();
            }
            this.tableEnd();
            this.println("&nbsp;");
            this.p();
        }
    }

    protected void printFirstRow(String string) {
        this.tableHeaderStart("#CCCCFF");
        this.bold(string);
        this.tableHeaderEnd();
    }

    protected void printPackageComment() {
        if (this.configuration.nocomment) {
            return;
        }
        if (this.packagedoc.inlineTags().length > 0) {
            this.anchor("package_description");
            this.h2(this.getText("doclet.Package_Description", this.packagedoc.name()));
            this.p();
            this.printInlineComment((Doc)this.packagedoc);
            this.p();
        }
    }

    protected void printPackageDescription() throws IOException {
        if (this.configuration.nocomment) {
            return;
        }
        this.printPackageComment();
        this.generateTagInfo((Doc)this.packagedoc);
    }

    protected void printPackageHeader(String string) {
        this.navLinks(true);
        this.hr();
        this.h2(this.getText("doclet.Package") + " " + string);
        if (this.packagedoc.inlineTags().length > 0 && !this.configuration.nocomment) {
            this.printSummaryComment((Doc)this.packagedoc);
            this.p();
            this.bold(this.getText("doclet.See"));
            this.br();
            this.printNbsps();
            this.printHyperLink("", "package_description", this.getText("doclet.Description"), true);
            this.p();
        }
    }

    protected void printPackageFooter() {
        this.hr();
        this.navLinks(false);
        this.printBottom();
    }

    protected void navLinkClassUse() {
        this.navCellStart();
        this.printHyperLink("package-use.html", "", this.getText("doclet.navClassUse"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected void navLinkPrevious() {
        if (this.prev == null) {
            this.printText("doclet.Prev_Package");
        } else {
            String string = DirectoryManager.getRelativePath((String)this.packagedoc.name(), (String)this.prev.name());
            this.printHyperLink(string + "package-summary.html", "", this.getText("doclet.Prev_Package"), true);
        }
    }

    protected void navLinkNext() {
        if (this.next == null) {
            this.printText("doclet.Next_Package");
        } else {
            String string = DirectoryManager.getRelativePath((String)this.packagedoc.name(), (String)this.next.name());
            this.printHyperLink(string + "package-summary.html", "", this.getText("doclet.Next_Package"), true);
        }
    }

    protected void navLinkTree() {
        this.navCellStart();
        this.printHyperLink("package-tree.html", "", this.getText("doclet.Tree"), true, "NavBarFont1");
        this.navCellEnd();
    }
}

