/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audioengines.headspace;

import com.sun.j3d.audioengines.headspace.AudioContainerInputStream;
import com.sun.j3d.audioengines.headspace.AudioFormat;
import com.sun.j3d.audioengines.headspace.BadAudioHeaderException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;

class AudioWavInputStream
extends AudioContainerInputStream {
    static final int WAVE_FORMAT_UNKNOWN = 0;
    static final int WAVE_FORMAT_PCM = 1;
    static final int WAVE_FORMAT_ADPCM = 2;
    static final int WAVE_FORMAT_ALAW = 6;
    static final int WAVE_FORMAT_MULAW = 7;
    static final int WAVE_FORMAT_OKI_ADPCM = 16;
    static final int WAVE_FORMAT_DIGISTD = 21;
    static final int WAVE_FORMAT_DIGIFIX = 22;
    static final int WAVE_IBM_FORMAT_MULAW = 257;
    static final int WAVE_IBM_FORMAT_ALAW = 258;
    static final int WAVE_IBM_FORMAT_ADPCM = 259;

    AudioWavInputStream(byte[] byArray, InputStream inputStream) throws IOException, BadAudioHeaderException {
        super(byArray, inputStream);
    }

    AudioWavInputStream(AudioWavInputStream audioWavInputStream) {
        super(audioWavInputStream);
    }

    protected AudioFormat readFormat(byte[] byArray) throws BadAudioHeaderException, IOException {
        int n;
        String string;
        short s = 0;
        boolean bl = false;
        boolean bl2 = true;
        int n2 = -1;
        int n3 = -1;
        String string2 = null;
        int n4 = -1;
        int n5 = 1;
        int n6 = 0;
        byte[] byArray2 = new byte[4];
        DataInputStream dataInputStream = byArray == null ? new DataInputStream(this.in) : new DataInputStream(new SequenceInputStream(new ByteArrayInputStream(byArray), this.in));
        dataInputStream.read(byArray2, 0, 4);
        n6 += 4;
        if (this.DEBUG) {
            string = new String(byArray2);
            System.out.println("this should be RIFF: " + string);
        }
        int n7 = this.rllong(dataInputStream);
        n6 += 4;
        if (this.DEBUG) {
            System.out.println("total audio size including header = " + n7);
        }
        dataInputStream.read(byArray2, 0, 4);
        n6 += 4;
        string = new String(byArray2);
        if (this.DEBUG) {
            System.out.println("this should be WAVE: " + string);
        }
        if (!string.startsWith("WAVE")) {
            throw new BadAudioHeaderException("header specifies a non-WAVE format: " + string);
        }
        while (true) {
            n = dataInputStream.read(byArray2, 0, 4);
            n6 += 4;
            if (n == -1) {
                throw new BadAudioHeaderException("reached EOF before finding fmt chunk");
            }
            string = new String(byArray2);
            if (string.startsWith("fmt ")) break;
            n7 = this.rllong(dataInputStream);
            n6 += 4;
            if (n7 % 2 > 0) {
                ++n7;
            }
            n6 += dataInputStream.skipBytes(n7);
        }
        if (this.DEBUG) {
            System.out.println("found the fmt chunk");
        }
        n7 = this.rllong(dataInputStream);
        int n8 = (n6 += 4) + n7;
        if (this.DEBUG) {
            System.out.println("length of the format chunk is " + n7);
        }
        s = this.rlshort(dataInputStream);
        n6 += 2;
        if (this.DEBUG) {
            System.out.println("wav_type is " + s);
        }
        if (s == 1) {
            string2 = "JAUDIO_LINEAR";
        } else if (s == 6) {
            string2 = "JAUDIO_G711_ALAW";
        } else if (s == 7) {
            string2 = "JAUDIO_G711_ULAW";
        } else {
            throw new BadAudioHeaderException("Unsupport Encoding");
        }
        if (this.DEBUG) {
            System.out.println("Encoding: " + string2);
        }
        n3 = this.rlshort(dataInputStream);
        n6 += 2;
        if (this.DEBUG) {
            System.out.println("Channels: " + n3);
        }
        n2 = this.rllong(dataInputStream);
        n6 += 4;
        if (this.DEBUG) {
            System.out.println("Sample Rate: " + n2);
        }
        this.rllong(dataInputStream);
        n6 += 4;
        this.rlshort(dataInputStream);
        n6 += 2;
        short s2 = this.rlshort(dataInputStream);
        n6 += 2;
        if (this.DEBUG) {
            System.out.println("nbits : " + s2);
        }
        if ((n4 = s2 / 8) == 1) {
            bl2 = false;
        }
        if (n7 % 2 != 0) {
            ++n7;
        }
        if (n8 > n6) {
            n6 += dataInputStream.skipBytes(n8 - n6);
        }
        if (s == 7) {
            bl = true;
        }
        if (this.DEBUG) {
            System.out.println("Sample Size: " + n4);
        }
        while (true) {
            n = dataInputStream.read(byArray2, 0, 4);
            n6 += 4;
            if (n == -1) {
                throw new BadAudioHeaderException("reached EOF before finding data chunk");
            }
            string = new String(byArray2);
            if (string.startsWith("data")) break;
            n7 = this.rllong(dataInputStream);
            n6 += 4;
            if (n7 % 2 > 0) {
                ++n7;
            }
            n6 += dataInputStream.skipBytes(n7);
        }
        if (this.DEBUG) {
            System.out.println("found the data chunk");
        }
        this.totalBytes = this.rllong(dataInputStream);
        n6 += 4;
        if (this.DEBUG) {
            System.out.println("length of the data chunk is: " + this.totalBytes);
        }
        this.headerSize = n6;
        return new AudioFormat(n2, string2, n4, n5, n3, bl, bl2);
    }

    AudioContainerInputStream cloneInputStream() {
        return new AudioWavInputStream(this);
    }
}

