/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audioengines.headspace;

class HaeThread
extends Thread {
    private boolean paused;

    private HaeThread() {
        super(HaeThread.getTopmostThreadGroup(), "");
        int n;
        this.setDaemon(true);
        this.setPriority(10);
        String string = System.getProperty("j3d.sound.priority");
        if (string == null) {
            string = System.getProperty("parameter.j3d.sound.priority");
        }
        if (string != null && 1 <= (n = Integer.parseInt(string, 10)) && n <= 10) {
            this.setPriority(n);
            System.out.println("Priority of SoundEngine thread set to  " + n);
        }
        this.setName("HAE frame thread");
        this.paused = false;
    }

    private static ThreadGroup getTopmostThreadGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null && threadGroup.getParent().getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            this.runNative();
            HaeThread haeThread = this;
            synchronized (haeThread) {
                this.paused = true;
                while (this.paused) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private native void runNative();

    private synchronized void unPause() {
        this.paused = false;
        this.notify();
    }

    private void pause() {
        while (!this.paused) {
            Thread.yield();
        }
    }
}

