/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audioengines.headspace;

import com.sun.j3d.audioengines.headspace.AudioContainerInputStream;
import com.sun.j3d.audioengines.headspace.AudioFormat;
import com.sun.j3d.audioengines.headspace.AudioMidiInputStream;
import com.sun.j3d.audioengines.headspace.AudioRmfInputStream;
import com.sun.j3d.audioengines.headspace.Format;
import com.sun.j3d.audioengines.headspace.HaeAudioStream;
import com.sun.j3d.audioengines.headspace.HaeDevice;
import com.sun.j3d.audioengines.headspace.HaeMixer;
import com.sun.j3d.audioengines.headspace.HeadspaceParams;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;

class J3DHaeStream {
    static HaeMixer mixer = null;
    static Vector soundSamples = new Vector();
    static Vector soundContainers = new Vector();
    static Vector soundStreams = new Vector();
    static Vector soundUrls = new Vector();
    static Vector soundParams = new Vector();
    static double panLeft = 1.0;
    static double panRight = -1.0;
    static final boolean debugFlag = false;
    static final boolean internalErrors = false;

    J3DHaeStream() {
    }

    static void debugPrint(String string) {
    }

    static void debugPrintln(String string) {
    }

    static boolean initialize() {
        try {
            mixer = HaeDevice.getSystemMixer();
            mixer.reengageAudio();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    static boolean close() {
        if (mixer != null) {
            mixer.disengageAudio();
        }
        return true;
    }

    static int getTotalChannels() {
        if (mixer != null) {
            int n = mixer.getSoundVoiceCount();
            return n;
        }
        return 0;
    }

    static int initAudioContainer(InputStream inputStream, boolean bl) {
        int n;
        int n2 = -1;
        AudioContainerInputStream audioContainerInputStream = null;
        if (inputStream == null) {
            return -1;
        }
        try {
            int n3 = soundContainers.size() - 1;
            while (n3 >= 0) {
                audioContainerInputStream = (AudioContainerInputStream)soundContainers.get(n3);
                if (audioContainerInputStream.streamSrc == inputStream) {
                    audioContainerInputStream = audioContainerInputStream.cloneInputStream();
                    break;
                }
                --n3;
            }
            if (n3 < 0) {
                audioContainerInputStream = AudioContainerInputStream.getStream(inputStream);
            }
            soundContainers.addElement(audioContainerInputStream);
            n = soundContainers.indexOf(audioContainerInputStream);
        }
        catch (Exception exception) {
            return -1;
        }
        if (n < 0) {
            return -1;
        }
        n2 = audioContainerInputStream instanceof AudioMidiInputStream || audioContainerInputStream instanceof AudioRmfInputStream ? 3 : (bl ? 2 : 1);
        soundStreams.setSize(n + 1);
        soundStreams.setElementAt(inputStream, n);
        soundUrls.setSize(n + 1);
        soundUrls.setElementAt(null, n);
        HeadspaceParams headspaceParams = new HeadspaceParams();
        headspaceParams.dataType = n2;
        soundParams.setSize(n + 1);
        soundParams.setElementAt(headspaceParams, n);
        return n;
    }

    static int initAudioContainer(URL uRL, boolean bl) {
        int n;
        AudioContainerInputStream audioContainerInputStream;
        int n2 = -1;
        if (uRL == null) {
            return -1;
        }
        try {
            audioContainerInputStream = AudioContainerInputStream.getStream(uRL.openStream());
            soundContainers.addElement(audioContainerInputStream);
            n = soundContainers.indexOf(audioContainerInputStream);
        }
        catch (Exception exception) {
            return -1;
        }
        if (n < 0) {
            return -1;
        }
        n2 = audioContainerInputStream instanceof AudioMidiInputStream || audioContainerInputStream instanceof AudioRmfInputStream ? 3 : (bl ? 2 : 1);
        soundUrls.setSize(n + 1);
        soundUrls.setElementAt(uRL, n);
        soundStreams.setSize(n + 1);
        soundStreams.setElementAt(null, n);
        HeadspaceParams headspaceParams = new HeadspaceParams();
        headspaceParams.dataType = n2;
        soundParams.setSize(n + 1);
        soundParams.setElementAt(headspaceParams, n);
        return n;
    }

    static int loadSample(URL uRL, int n) {
        AudioContainerInputStream audioContainerInputStream = (AudioContainerInputStream)soundContainers.elementAt(n);
        try {
            HaeAudioStream haeAudioStream = new HaeAudioStream(audioContainerInputStream, uRL.toString());
            soundSamples.setSize(n + 1);
            soundSamples.setElementAt(haeAudioStream, n);
        }
        catch (Exception exception) {
            soundStreams.removeElementAt(n);
            soundUrls.removeElementAt(n);
            soundParams.removeElementAt(n);
            soundContainers.removeElementAt(n);
            soundSamples.removeElementAt(n);
            return -1;
        }
        return 0;
    }

    static int loadSample(InputStream inputStream, int n) {
        AudioContainerInputStream audioContainerInputStream = (AudioContainerInputStream)soundContainers.elementAt(n);
        try {
            HaeAudioStream haeAudioStream = new HaeAudioStream(audioContainerInputStream, inputStream.toString());
            soundSamples.setSize(n + 1);
            soundSamples.setElementAt(haeAudioStream, n);
        }
        catch (Exception exception) {
            soundStreams.removeElementAt(n);
            soundUrls.removeElementAt(n);
            soundParams.removeElementAt(n);
            soundContainers.removeElementAt(n);
            soundSamples.removeElementAt(n);
            return -1;
        }
        return 0;
    }

    static int getDataType(int n) {
        int n2 = soundParams.size();
        if (n >= n2 || n < 0) {
            return -1;
        }
        HeadspaceParams headspaceParams = new HeadspaceParams();
        headspaceParams = (HeadspaceParams)soundParams.elementAt(n);
        return headspaceParams.dataType;
    }

    static AudioContainerInputStream reinitAudioContainer(URL uRL, int n) {
        AudioContainerInputStream audioContainerInputStream;
        if (uRL == null) {
            return null;
        }
        try {
            audioContainerInputStream = AudioContainerInputStream.getStream(uRL.openStream());
        }
        catch (Exception exception) {
            return null;
        }
        soundContainers.setElementAt(audioContainerInputStream, n);
        return audioContainerInputStream;
    }

    static AudioContainerInputStream reinitAudioContainer(InputStream inputStream, int n) {
        AudioContainerInputStream audioContainerInputStream = null;
        if (inputStream == null) {
            return null;
        }
        try {
            int n2 = 0;
            n2 = soundContainers.size() - 1;
            while (n2 >= 0) {
                audioContainerInputStream = (AudioContainerInputStream)soundContainers.get(n2);
                if (audioContainerInputStream.streamSrc == inputStream && audioContainerInputStream.resetAudioInputStream()) break;
                --n2;
            }
            if (n2 < 0) {
                audioContainerInputStream = AudioContainerInputStream.getStream(inputStream);
            }
        }
        catch (Exception exception) {
            return null;
        }
        soundContainers.setElementAt(audioContainerInputStream, n);
        return audioContainerInputStream;
    }

    static int reloadSample(int n) {
        URL uRL = (URL)soundUrls.elementAt(n);
        InputStream inputStream = (InputStream)soundStreams.elementAt(n);
        AudioContainerInputStream audioContainerInputStream = null;
        if (uRL != null) {
            audioContainerInputStream = J3DHaeStream.reinitAudioContainer(uRL, n);
        } else if (inputStream != null) {
            audioContainerInputStream = J3DHaeStream.reinitAudioContainer(inputStream, n);
        }
        if (audioContainerInputStream == null) {
            return -1;
        }
        try {
            HaeAudioStream haeAudioStream = null;
            if (inputStream != null) {
                haeAudioStream = new HaeAudioStream(audioContainerInputStream, inputStream.toString());
            } else if (uRL != null) {
                haeAudioStream = new HaeAudioStream(audioContainerInputStream, uRL.toString());
            }
            soundSamples.setElementAt(haeAudioStream, n);
        }
        catch (Exception exception) {
            return -1;
        }
        return 0;
    }

    static long getSampleDuration(int n) {
        HaeAudioStream haeAudioStream = null;
        if (n < 0) {
            return -1L;
        }
        if (soundSamples.size() <= n) {
            return -1L;
        }
        AudioContainerInputStream audioContainerInputStream = (AudioContainerInputStream)soundContainers.elementAt(n);
        if (audioContainerInputStream == null) {
            return -1L;
        }
        haeAudioStream = (HaeAudioStream)soundSamples.elementAt(n);
        if (haeAudioStream == null) {
            return -1L;
        }
        double d = audioContainerInputStream.getTotalBytes();
        if (d <= 0.0) {
            return -1L;
        }
        Format[] formatArray = audioContainerInputStream.getFormat();
        AudioFormat audioFormat = (AudioFormat)formatArray[0];
        int n2 = audioFormat.getSampleRate();
        int n3 = audioFormat.getSampleSize();
        int n4 = audioFormat.getChannels();
        String string = audioFormat.getEncoding();
        long l = (long)(d / (double)(n3 * n4 * n2) * 1000.0);
        return l;
    }

    static int startSamples(int n, int n2, int n3, float f, float f2, int n4, int n5) {
        boolean bl;
        double d = 0.0039;
        double d2 = f;
        double d3 = f2;
        if (n < 0 || n2 < 0) {
            return -1;
        }
        if (soundSamples.size() <= n) {
            return -1;
        }
        if (soundSamples.size() <= n2) {
            return -1;
        }
        AudioContainerInputStream audioContainerInputStream = (AudioContainerInputStream)soundContainers.elementAt(n);
        if (audioContainerInputStream == null) {
            return -1;
        }
        HaeAudioStream haeAudioStream = null;
        HaeAudioStream haeAudioStream2 = null;
        haeAudioStream = (HaeAudioStream)soundSamples.elementAt(n);
        if (haeAudioStream == null) {
            return -1;
        }
        haeAudioStream2 = (HaeAudioStream)soundSamples.elementAt(n2);
        if (haeAudioStream2 == null) {
            return -1;
        }
        if (soundParams.size() <= n) {
            return -1;
        }
        if (soundParams.size() <= n2) {
            return -1;
        }
        HeadspaceParams headspaceParams = (HeadspaceParams)soundParams.elementAt(n);
        HeadspaceParams headspaceParams2 = (HeadspaceParams)soundParams.elementAt(n2);
        boolean bl2 = bl = false;
        try {
            if (n4 < n5) {
                haeAudioStream.start(d2, panLeft, bl);
                haeAudioStream2.start(d3, panRight, bl2);
            } else {
                haeAudioStream2.start(d3, panRight, bl2);
                haeAudioStream.start(d2, panLeft, bl);
            }
            headspaceParams.startTime = System.currentTimeMillis();
        }
        catch (Exception exception) {
            headspaceParams.startTime = 0L;
            return -1;
        }
        return 0;
    }

    static int startSample(int n, int n2, float f) {
        double d = 0.0039;
        double d2 = f;
        if (n < 0) {
            return -1;
        }
        if (soundSamples.size() <= n) {
            return -1;
        }
        AudioContainerInputStream audioContainerInputStream = (AudioContainerInputStream)soundContainers.elementAt(n);
        if (audioContainerInputStream == null) {
            return -1;
        }
        if (soundParams.size() <= n) {
            return -1;
        }
        HeadspaceParams headspaceParams = (HeadspaceParams)soundParams.elementAt(n);
        boolean bl = headspaceParams.getReverbFlag();
        float f2 = 0.0f;
        try {
            HaeAudioStream haeAudioStream = (HaeAudioStream)soundSamples.elementAt(n);
            if (haeAudioStream == null) {
                return -1;
            }
            haeAudioStream.start(d2, f2, bl);
        }
        catch (Exception exception) {
            headspaceParams.startTime = 0L;
            return -1;
        }
        headspaceParams.startTime = System.currentTimeMillis();
        return 0;
    }

    static int stopSample(int n) {
        if (n < 0) {
            return -1;
        }
        if (soundSamples.size() <= n) {
            return -1;
        }
        HaeAudioStream haeAudioStream = null;
        haeAudioStream = (HaeAudioStream)soundSamples.elementAt(n);
        if (haeAudioStream == null) {
            return -1;
        }
        haeAudioStream.stop(false);
        haeAudioStream.close();
        if (J3DHaeStream.reloadSample(n) != 0) {
            return -1;
        }
        HeadspaceParams headspaceParams = (HeadspaceParams)soundParams.elementAt(n);
        headspaceParams.startTime = 0L;
        return 0;
    }

    static int stopSamples(int n, int n2) {
        if (n < 0 || n2 < 0) {
            return -1;
        }
        if (soundSamples.size() <= n) {
            return -1;
        }
        if (soundSamples.size() <= n2) {
            return -1;
        }
        HaeAudioStream haeAudioStream = null;
        HaeAudioStream haeAudioStream2 = null;
        haeAudioStream = (HaeAudioStream)soundSamples.elementAt(n);
        if (haeAudioStream == null) {
            return -1;
        }
        haeAudioStream2 = (HaeAudioStream)soundSamples.elementAt(n2);
        if (haeAudioStream2 == null) {
            return -1;
        }
        haeAudioStream.stop(false);
        haeAudioStream2.stop(false);
        haeAudioStream.close();
        haeAudioStream2.close();
        if (J3DHaeStream.reloadSample(n) != 0) {
            return -1;
        }
        if (J3DHaeStream.reloadSample(n2) != 0) {
            return -1;
        }
        HeadspaceParams headspaceParams = (HeadspaceParams)soundParams.elementAt(n);
        HeadspaceParams headspaceParams2 = (HeadspaceParams)soundParams.elementAt(n2);
        headspaceParams.startTime = 0L;
        headspaceParams2.startTime = 0L;
        return 0;
    }

    static void setSampleGain(int n, float f) {
        if (n < 0) {
            return;
        }
        if (soundSamples.size() <= n) {
            return;
        }
        HaeAudioStream haeAudioStream = null;
        double d = f;
        haeAudioStream = (HaeAudioStream)soundSamples.elementAt(n);
        if (haeAudioStream == null) {
            return;
        }
        haeAudioStream.setVolume(d);
    }

    static void setSampleDelay(int n, int n2) {
    }

    static long getStartTime(int n) {
        if (soundParams.size() <= n) {
            return 0L;
        }
        HeadspaceParams headspaceParams = (HeadspaceParams)soundParams.elementAt(n);
        return headspaceParams.startTime;
    }

    static void setReverb(int n, int n2, boolean bl) {
        boolean bl2 = false;
        HeadspaceParams headspaceParams = (HeadspaceParams)soundParams.elementAt(n);
        if (headspaceParams.getReverbType() != n2) {
            try {
                mixer.setReverbType(n2 + 1);
            }
            catch (Exception exception) {
                return;
            }
            headspaceParams.setReverbType(n2);
            bl2 = true;
        }
        HaeAudioStream haeAudioStream = null;
        if (bl2 || headspaceParams.getReverbFlag() != bl) {
            try {
                haeAudioStream = (HaeAudioStream)soundSamples.elementAt(n);
                if (haeAudioStream == null) {
                    return;
                }
                haeAudioStream.setReverb(bl);
            }
            catch (Exception exception) {
                return;
            }
            headspaceParams.setReverbFlag(bl);
        }
    }

    static int getSampleRate(int n) {
        HaeAudioStream haeAudioStream = null;
        if (n < 0) {
            return -1;
        }
        if (soundSamples.size() <= n) {
            return -1;
        }
        AudioContainerInputStream audioContainerInputStream = (AudioContainerInputStream)soundContainers.elementAt(n);
        if (audioContainerInputStream == null) {
            return -1;
        }
        haeAudioStream = (HaeAudioStream)soundSamples.elementAt(n);
        if (haeAudioStream == null) {
            return -1;
        }
        Format[] formatArray = audioContainerInputStream.getFormat();
        AudioFormat audioFormat = (AudioFormat)formatArray[0];
        int n2 = audioFormat.getSampleRate();
        return n2;
    }

    static void scaleSampleRate(int n, float f) {
        AudioContainerInputStream audioContainerInputStream = (AudioContainerInputStream)soundContainers.elementAt(n);
        if (audioContainerInputStream == null) {
            return;
        }
        HaeAudioStream haeAudioStream = (HaeAudioStream)soundSamples.elementAt(n);
        if (haeAudioStream == null) {
            return;
        }
        Format[] formatArray = audioContainerInputStream.getFormat();
        AudioFormat audioFormat = (AudioFormat)formatArray[0];
        int n2 = audioFormat.getSampleRate();
        double d = (float)n2 * f;
        if (d > 48000.0) {
            d = 48000.0;
        }
        haeAudioStream.setSampleRate(d);
    }

    static int pauseSamples(int n, int n2) {
        HaeAudioStream haeAudioStream = (HaeAudioStream)soundSamples.elementAt(n);
        HaeAudioStream haeAudioStream2 = (HaeAudioStream)soundSamples.elementAt(n2);
        if (haeAudioStream == null) {
            return -1;
        }
        if (haeAudioStream2 == null) {
            return -1;
        }
        haeAudioStream.pause();
        haeAudioStream2.pause();
        return 0;
    }

    static int pauseSample(int n) {
        HaeAudioStream haeAudioStream = (HaeAudioStream)soundSamples.elementAt(n);
        if (haeAudioStream == null) {
            return -1;
        }
        haeAudioStream.pause();
        return 0;
    }

    static int unpauseSamples(int n, int n2) {
        HaeAudioStream haeAudioStream = (HaeAudioStream)soundSamples.elementAt(n);
        HaeAudioStream haeAudioStream2 = (HaeAudioStream)soundSamples.elementAt(n2);
        if (haeAudioStream == null) {
            return -1;
        }
        if (haeAudioStream2 == null) {
            return -1;
        }
        haeAudioStream.resume();
        haeAudioStream2.resume();
        return 0;
    }

    static int unpauseSample(int n) {
        HaeAudioStream haeAudioStream = (HaeAudioStream)soundSamples.elementAt(n);
        if (haeAudioStream == null) {
            return -1;
        }
        haeAudioStream.resume();
        return 0;
    }

    static void setFiltering(int n, boolean bl, float f) {
        AudioContainerInputStream audioContainerInputStream = (AudioContainerInputStream)soundContainers.elementAt(n);
        if (audioContainerInputStream == null) {
            return;
        }
        audioContainerInputStream.setFiltering(bl, f);
    }
}

