/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audioengines.headspace;

import com.sun.j3d.audioengines.headspace.AudioData;
import com.sun.j3d.audioengines.headspace.AudioDataStream;
import com.sun.j3d.audioengines.headspace.AudioPlayer;
import com.sun.j3d.audioengines.headspace.AudioStream;
import com.sun.j3d.audioengines.headspace.ContinuousAudioDataStream;
import java.applet.AudioClip;
import java.io.IOException;
import java.io.InputStream;

public class SunAudioClip
implements AudioClip {
    AudioData data;
    AudioDataStream stream;
    boolean DEBUG = false;

    public SunAudioClip(InputStream inputStream) throws IOException {
        if (this.DEBUG) {
            System.out.println("Instantiating com.sun.j3d.audio.SunAudioClip");
        }
        AudioStream audioStream = new AudioStream(inputStream);
        this.data = audioStream.getData();
    }

    public synchronized void play() {
        if (this.data != null) {
            this.stop();
            this.stream = new AudioDataStream(this.data);
            AudioPlayer.player.start(this.stream);
            if (this.DEBUG) {
                System.err.println("Clip should be playing");
            }
        }
    }

    public synchronized void loop() {
        if (this.data != null) {
            this.stop();
            this.stream = new ContinuousAudioDataStream(this.data);
            AudioPlayer.player.start(this.stream);
            if (this.DEBUG) {
                System.err.println("Clip should be looping");
            }
        }
    }

    public synchronized void stop() {
        if (this.stream != null) {
            AudioPlayer.player.stop(this.stream);
        }
        if (this.DEBUG) {
            System.err.println("Clip should be stopped");
        }
    }

    public String toString() {
        return this.getClass().toString();
    }

    protected void finalize() {
        if (this.stream != null) {
            AudioPlayer.player.stop(this.stream);
            try {
                this.stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

