/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audioengines.headspace;

class HaeWaveStreamBuffer {
    private int m_bytesPerFrame;
    private byte[] m_byteData;
    private short[] m_shortData;
    private int m_frameCount;

    public void set(byte[] byArray, int n) {
        if (byArray != null) {
            int n2 = this.getFrameCount(byArray.length);
            if (n > n2) {
                n = n2;
            }
        } else {
            System.err.println("null \"byteData\" passed to HaeWaveStreamBuffer.set()");
            n = 0;
        }
        this.m_byteData = byArray;
        this.m_shortData = null;
        this.m_frameCount = n;
    }

    public void set(short[] sArray, int n) {
        if (sArray != null) {
            int n2 = this.getFrameCount(sArray.length * 2);
            if (n > n2) {
                n = n2;
            }
        } else {
            System.err.println("null \"shortData\" passed to HaeWaveStreamBuffer.set()");
            n = 0;
        }
        this.m_byteData = null;
        this.m_shortData = sArray;
        this.m_frameCount = n;
    }

    public byte[] allocateByte(int n) {
        int n2 = this.getByteCount(n);
        this.m_shortData = null;
        if (this.m_byteData == null || this.m_byteData.length < n2) {
            this.m_byteData = null;
            if (n2 > 0) {
                this.m_byteData = new byte[n2];
            }
        }
        this.m_frameCount = n;
        return this.m_byteData;
    }

    public short[] allocateShort(int n) {
        int n2 = this.getByteCount(n) * 2;
        this.m_byteData = null;
        if (this.m_shortData == null || this.m_shortData.length < n2) {
            this.m_shortData = null;
            if (n2 > 0) {
                this.m_shortData = new short[n2];
            }
        }
        this.m_frameCount = n;
        return this.m_shortData;
    }

    public void reduceFrameCount(int n) {
        if (n <= this.m_frameCount) {
            this.m_frameCount = n;
        } else {
            System.err.println("HaeWaveStreamBuffer.reduceFrameCount() bad frameCount: " + n + ", created with: " + this.m_frameCount);
        }
    }

    public int getFrameCount(int n) {
        return n / this.m_bytesPerFrame;
    }

    public int getByteCount(int n) {
        return n * this.m_bytesPerFrame;
    }

    public int getValidFrameCount() {
        return this.m_frameCount;
    }

    protected HaeWaveStreamBuffer(int n) {
        this.m_bytesPerFrame = n;
    }
}

