/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders;

import com.sun.j3d.loaders.Scene;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.j3d.Background;
import javax.media.j3d.Behavior;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Fog;
import javax.media.j3d.Light;
import javax.media.j3d.Sound;
import javax.media.j3d.TransformGroup;

public class SceneBase
implements Scene {
    BranchGroup sceneGroup = null;
    BranchGroup behaviorGroup = null;
    Hashtable namedObjects = new Hashtable();
    String description = null;
    Vector viewVector = new Vector();
    Vector hfovVector = new Vector();
    Vector behaviorVector = new Vector();
    Vector lightVector = new Vector();
    Vector fogVector = new Vector();
    Vector backgroundVector = new Vector();
    Vector soundVector = new Vector();

    public void setSceneGroup(BranchGroup branchGroup) {
        this.sceneGroup = branchGroup;
    }

    public void addViewGroup(TransformGroup transformGroup) {
        this.viewVector.addElement(transformGroup);
    }

    public void addHorizontalFOV(float f) {
        this.hfovVector.addElement(new Float(f));
    }

    public void addBehaviorNode(Behavior behavior) {
        this.behaviorVector.addElement(behavior);
    }

    public void addLightNode(Light light) {
        this.lightVector.addElement(light);
    }

    public void addBackgroundNode(Background background) {
        this.backgroundVector.addElement(background);
    }

    public void addSoundNode(Sound sound) {
        this.soundVector.addElement(sound);
    }

    public void addFogNode(Fog fog) {
        this.fogVector.addElement(fog);
    }

    public void addDescription(String string) {
        this.description = string;
    }

    public void addNamedObject(String string, Object object) {
        if (this.namedObjects.get(string) == null) {
            this.namedObjects.put(string, object);
        } else {
            int n = 1;
            boolean bl = false;
            while (!bl) {
                String string2 = string + "[" + n + "]";
                if (this.namedObjects.get(string2) == null) {
                    this.namedObjects.put(string2, object);
                    bl = true;
                }
                ++n;
            }
        }
    }

    public BranchGroup getSceneGroup() {
        return this.sceneGroup;
    }

    public TransformGroup[] getViewGroups() {
        if (this.viewVector.isEmpty()) {
            return null;
        }
        Object[] objectArray = new TransformGroup[this.viewVector.size()];
        this.viewVector.copyInto(objectArray);
        return objectArray;
    }

    public float[] getHorizontalFOVs() {
        if (this.hfovVector.isEmpty()) {
            return null;
        }
        int n = this.hfovVector.size();
        float[] fArray = new float[n];
        Object[] objectArray = new Float[this.hfovVector.size()];
        this.hfovVector.copyInto(objectArray);
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = ((Float)objectArray[n2]).floatValue();
            objectArray[n2] = null;
            ++n2;
        }
        return fArray;
    }

    public Light[] getLightNodes() {
        if (this.lightVector.isEmpty()) {
            return null;
        }
        Object[] objectArray = new Light[this.lightVector.size()];
        this.lightVector.copyInto(objectArray);
        return objectArray;
    }

    public Hashtable getNamedObjects() {
        return this.namedObjects;
    }

    public Background[] getBackgroundNodes() {
        if (this.backgroundVector.isEmpty()) {
            return null;
        }
        Object[] objectArray = new Background[this.backgroundVector.size()];
        this.backgroundVector.copyInto(objectArray);
        return objectArray;
    }

    public Fog[] getFogNodes() {
        if (this.fogVector.isEmpty()) {
            return null;
        }
        Object[] objectArray = new Fog[this.fogVector.size()];
        this.fogVector.copyInto(objectArray);
        return objectArray;
    }

    public Behavior[] getBehaviorNodes() {
        if (this.behaviorVector.isEmpty()) {
            return null;
        }
        Object[] objectArray = new Behavior[this.behaviorVector.size()];
        this.behaviorVector.copyInto(objectArray);
        return objectArray;
    }

    public Sound[] getSoundNodes() {
        if (this.soundVector.isEmpty()) {
            return null;
        }
        Object[] objectArray = new Sound[this.soundVector.size()];
        this.soundVector.copyInto(objectArray);
        return objectArray;
    }

    public String getDescription() {
        return this.description;
    }
}

