/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.lw3d;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

class ImageScaler {
    int origW;
    int origH;
    Image origImage;

    ImageScaler(Image image, int n, int n2) {
        this.origImage = image;
        this.origW = n;
        this.origH = n2;
    }

    ImageScaler(BufferedImage bufferedImage) {
        this.origImage = bufferedImage;
        this.origW = bufferedImage.getWidth();
        this.origH = bufferedImage.getHeight();
    }

    int getClosestPowerOf2(int n) {
        if (n < 1) {
            return n;
        }
        int n2 = 1;
        int n3 = 1;
        while (n3 < 20) {
            if (n < (n2 *= 2)) {
                int n4 = n2 / 2;
                if (n2 - n > n - n4) {
                    return n4;
                }
                return n2;
            }
            ++n3;
        }
        return 1;
    }

    Image getScaledImage() {
        int n = this.getClosestPowerOf2(this.origW);
        int n2 = this.getClosestPowerOf2(this.origH);
        if (n == this.origW && n2 == this.origH) {
            return this.origImage;
        }
        Image image = null;
        if (this.origImage instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)this.origImage;
            image = new BufferedImage(n, n2, bufferedImage.getType());
            BufferedImage bufferedImage2 = (BufferedImage)image;
            float f = (float)this.origW / (float)n;
            float f2 = (float)this.origH / (float)n2;
            int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            int[] nArray2 = ((DataBufferInt)bufferedImage2.getRaster().getDataBuffer()).getData();
            int n3 = 0;
            while (n3 < n2) {
                int n4 = 0;
                while (n4 < n) {
                    int n5 = Math.min(this.origH - 1, (int)((float)n3 * f2 + 0.5f));
                    int n6 = Math.min(this.origW - 1, (int)((float)n4 * f + 0.5f));
                    nArray2[n3 * n + n4] = nArray[n5 * this.origW + n6];
                    ++n4;
                }
                ++n3;
            }
        } else {
            image = this.origImage.getScaledInstance(n, n2, 1);
        }
        return image;
    }
}

