/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.lw3d;

import com.sun.j3d.internal.J3dUtilsI18N;
import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.lw3d.LwsFrame;
import com.sun.j3d.loaders.lw3d.TextfileParser;
import com.sun.j3d.utils.behaviors.interpolators.KBKeyFrame;
import com.sun.j3d.utils.behaviors.interpolators.KBRotPosScaleSplinePathInterpolator;
import java.io.StreamTokenizer;
import java.util.Vector;
import javax.media.j3d.Alpha;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4f;

class LwsMotion
extends TextfileParser {
    String motionName;
    LwsFrame[] frames;
    int numFrames;
    int numChannels;
    boolean loop;
    float totalTime;
    int firstFrame;
    int totalFrames;
    Behavior behaviors;

    LwsMotion(StreamTokenizer streamTokenizer, int n, float f) {
        this(streamTokenizer, 0, n, f, 16);
    }

    LwsMotion(StreamTokenizer streamTokenizer, int n, int n2, float f, int n3) throws ParsingErrorException, IncorrectFormatException {
        this.debugPrinter.setValidOutput(n3);
        this.numFrames = 0;
        this.totalTime = f;
        this.firstFrame = n;
        this.totalFrames = n2;
        this.debugOutputLn(8, "about to get motion name");
        this.motionName = this.getName(streamTokenizer);
        this.debugOutputLn(8, "about to get motion");
        this.getMotion(streamTokenizer);
    }

    void getMotion(StreamTokenizer streamTokenizer) throws ParsingErrorException, IncorrectFormatException {
        this.debugOutputLn(1, "getMotion()");
        this.numChannels = (int)this.getNumber(streamTokenizer);
        if (this.numChannels != 9) {
            throw new IncorrectFormatException(J3dUtilsI18N.getString("LwsMotion0"));
        }
        this.debugOutputLn(8, "got channels");
        this.numFrames = (int)this.getNumber(streamTokenizer);
        this.frames = new LwsFrame[this.numFrames];
        this.debugOutputLn(2, "got frames" + this.numFrames);
        int n = 0;
        while (n < this.numFrames) {
            this.frames[n] = new LwsFrame(streamTokenizer);
            ++n;
        }
        this.debugOutput(8, "got all frames");
        this.getAndCheckString(streamTokenizer, "EndBehavior");
        int n2 = (int)this.getNumber(streamTokenizer);
        this.loop = n2 != 1;
    }

    void fixFrames() {
        Object object;
        Object object2;
        boolean bl = false;
        Vector<Object> vector = new Vector<Object>();
        double d = 1.5707963705062866;
        LwsFrame lwsFrame = null;
        int n = 1;
        while (n < this.numFrames) {
            LwsFrame lwsFrame2;
            object2 = this.frames[n - 1];
            lwsFrame = lwsFrame2 = this.frames[n];
            vector.add(object2);
            double d2 = 0.0;
            double d3 = lwsFrame2.getHeading();
            double d4 = ((LwsFrame)object2).getHeading();
            double d5 = Math.abs(d3 - d4);
            if (d5 > d2) {
                d2 = d5;
            }
            if ((d5 = Math.abs((d3 = lwsFrame2.getPitch()) - (d4 = ((LwsFrame)object2).getPitch()))) > d2) {
                d2 = d5;
            }
            if ((d5 = Math.abs((d3 = lwsFrame2.getBank()) - (d4 = ((LwsFrame)object2).getBank()))) > d2) {
                d2 = d5;
            }
            if (d2 > d) {
                double d6;
                LwsFrame lwsFrame3;
                double d7;
                double d8;
                bl = true;
                int n2 = (int)(d2 / d);
                double d9 = d8 = 1.0 / (double)(n2 + 1);
                double d10 = this.frames[this.numFrames - 1].getFrameNum();
                double d11 = (lwsFrame2.getFrameNum() - ((LwsFrame)object2).getFrameNum()) / d10;
                if (n - 1 < 1) {
                    object = this.frames[n - 1];
                    d7 = 0.0;
                } else {
                    object = this.frames[n - 2];
                    d7 = d11 / ((lwsFrame2.getFrameNum() - ((LwsFrame)object).getFrameNum()) / d10);
                }
                if (n + 1 < this.numFrames) {
                    lwsFrame3 = this.frames[n + 1];
                    d6 = d11 / ((lwsFrame3.getFrameNum() - ((LwsFrame)object2).getFrameNum()) / d10);
                } else {
                    lwsFrame3 = this.frames[n];
                    d6 = 1.0;
                }
                int n3 = 0;
                while (n3 < n2) {
                    LwsFrame lwsFrame4 = lwsFrame2.linearValue == 1 ? new LwsFrame((LwsFrame)object2, lwsFrame2, d9) : new LwsFrame((LwsFrame)object, (LwsFrame)object2, lwsFrame2, lwsFrame3, d9, d7, d6);
                    d9 += d8;
                    vector.add(lwsFrame4);
                    ++n3;
                }
            }
            ++n;
        }
        if (lwsFrame != null) {
            vector.add(lwsFrame);
        }
        if (bl) {
            object = new LwsFrame[vector.size()];
            object2 = vector.elements();
            int n4 = 0;
            while (object2.hasMoreElements()) {
                object[n4++] = (LwsFrame)object2.nextElement();
            }
            this.frames = object;
            this.numFrames = this.frames.length;
            int n5 = 0;
            while (n5 < this.numFrames) {
                this.debugOutputLn(2, "frame " + n5 + " = " + this.frames[n5]);
                this.frames[n5].printVals();
                ++n5;
            }
        }
    }

    int intMod(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (n3 < 0) {
            n3 = -n3;
        }
        if (n4 < 0) {
            n4 = -n4;
        }
        while (n3 > n4) {
            n3 -= n4;
        }
        return n3;
    }

    void playWithFrameTimes(Vector vector) {
        this.debugOutputLn(1, "playWithFrameTimes: firstFrame = " + this.firstFrame);
        if (this.firstFrame == 1) {
            return;
        }
        if (this.frames[this.numFrames - 1].getFrameNum() < (double)this.totalFrames) {
            int n = (int)(this.frames[this.numFrames - 1].getFrameNum() + 0.4999999);
            int n2 = this.intMod(this.firstFrame, n);
            int n3 = this.intMod(this.totalFrames, n);
            int n4 = 0;
            while (n4 < this.numFrames) {
                if (this.frames[n4].getFrameNum() >= (double)n2) break;
                ++n4;
            }
            int n5 = n4;
            if (this.frames[n5].getFrameNum() > (double)this.firstFrame && n5 > 0) {
                --n5;
            }
            n4 = n5;
            if (n2 < n3) {
                while (n4 < this.numFrames && this.frames[n4].getFrameNum() <= (double)n3) {
                    FrameHolder frameHolder = new FrameHolder(this.frames[n4], this.frames[n4].getFrameNum() - (double)n2);
                    vector.addElement(frameHolder);
                    ++n4;
                }
            } else {
                Object object;
                double d = -1.0;
                while (n4 < this.numFrames) {
                    d = this.frames[n4].getFrameNum() - (double)n2;
                    object = new FrameHolder(this.frames[n4], d);
                    vector.addElement(object);
                    ++n4;
                }
                n4 = 0;
                while (n4 <= n5 && this.frames[n4].getFrameNum() <= (double)n3) {
                    if (n4 == 0) {
                        object = new LwsFrame(this.frames[n4], this.frames[n4 + 1], 1.0 / (this.frames[n4 + 1].getFrameNum() - this.frames[n4].getFrameNum()));
                        FrameHolder frameHolder = new FrameHolder((LwsFrame)object, ((LwsFrame)object).getFrameNum() + d);
                        vector.addElement(frameHolder);
                    } else {
                        object = new FrameHolder(this.frames[n4], this.frames[n4].getFrameNum() + d);
                        vector.addElement(object);
                    }
                    ++n4;
                }
            }
        } else {
            FrameHolder frameHolder;
            LwsFrame lwsFrame;
            int n = 0;
            while (n < this.numFrames) {
                if (this.frames[n].getFrameNum() >= (double)this.firstFrame) break;
                ++n;
            }
            int n6 = n;
            if (this.frames[n6].getFrameNum() > (double)this.firstFrame && n6 > 0) {
                double d = (double)this.firstFrame / (this.frames[n6].getFrameNum() - this.frames[n6 - 1].getFrameNum());
                lwsFrame = new LwsFrame(this.frames[n6 - 1], this.frames[n6], d);
                frameHolder = new FrameHolder(lwsFrame, lwsFrame.getFrameNum() - (double)this.firstFrame);
                vector.addElement(frameHolder);
            }
            n = n6;
            while (n < this.numFrames && this.frames[n].getFrameNum() <= (double)this.totalFrames) {
                FrameHolder frameHolder2 = new FrameHolder(this.frames[n], this.frames[n].getFrameNum() - (double)this.firstFrame);
                vector.addElement(frameHolder2);
                ++n;
            }
            if (this.frames[n - 1].getFrameNum() < (double)this.totalFrames) {
                double d = ((double)this.totalFrames - this.frames[n - 1].getFrameNum()) / (this.frames[n].getFrameNum() - this.frames[n - 1].getFrameNum());
                lwsFrame = new LwsFrame(this.frames[n - 1], this.frames[n], d);
                frameHolder = new FrameHolder(lwsFrame, this.totalFrames - this.firstFrame);
                vector.addElement(frameHolder);
            }
        }
    }

    void createJava3dBehaviorsForFramesSubset(TransformGroup transformGroup) {
        LwsFrame lwsFrame;
        Object object;
        this.debugOutputLn(1, "createJava3dBehaviorsForFramesSubset");
        Vector vector = new Vector();
        this.playWithFrameTimes(vector);
        long l = 0L;
        int n = this.loop ? -1 : 1;
        n = -1;
        int n2 = vector.size();
        this.debugOutputLn(2, "totalTime = " + this.totalTime);
        this.debugOutputLn(2, "loopCount = " + n);
        FrameHolder frameHolder = (FrameHolder)vector.elementAt(vector.size() - 1);
        LwsFrame lwsFrame2 = frameHolder.frame;
        float f = 1000.0f * this.totalTime * (float)(frameHolder.frameNumber / (double)(this.totalFrames - this.firstFrame));
        this.debugOutputLn(2, " anim time: " + f);
        this.debugOutputLn(2, " totalFrames = " + this.totalFrames);
        if (!this.loop) {
            l = (long)(1000.0 * (double)this.totalTime - (double)f);
        }
        Alpha alpha = new Alpha(n, 1, 0L, 0L, (long)f, 0L, l, 0L, 0L, 0L);
        float[] fArray = new float[n2];
        Point3f[] point3fArray = new Point3f[n2];
        Quat4f[] quat4fArray = new Quat4f[n2];
        Point3f[] point3fArray2 = new Point3f[n2];
        Transform3D transform3D = new Transform3D();
        Matrix4d matrix4d = new Matrix4d();
        KBKeyFrame[] kBKeyFrameArray = new KBKeyFrame[n2];
        int n3 = 0;
        while (n3 < n2) {
            object = (FrameHolder)vector.elementAt(n3);
            lwsFrame = object.frame;
            point3fArray[n3] = lwsFrame.getPosition();
            point3fArray2[n3] = lwsFrame.getScale();
            lwsFrame.setRotationMatrix(matrix4d);
            this.debugOutputLn(2, "LwsMotion::createj3dbeh, mat = " + matrix4d);
            quat4fArray[n3] = new Quat4f();
            quat4fArray[n3].set(matrix4d);
            this.debugOutputLn(2, " and quat = " + quat4fArray[n3]);
            fArray[n3] = n3 == 0 ? 0.0f : (float)object.frameNumber / (float)frameHolder.frameNumber;
            kBKeyFrameArray[n3] = new KBKeyFrame(fArray[n3], lwsFrame.linearValue, point3fArray[n3], (float)lwsFrame.heading, (float)lwsFrame.pitch, (float)lwsFrame.bank, point3fArray2[n3], (float)lwsFrame.tension, (float)lwsFrame.continuity, (float)lwsFrame.bias);
            this.debugOutputLn(2, "pos, knots, quat = " + point3fArray[n3] + fArray[n3] + quat4fArray[n3]);
            ++n3;
        }
        object = new KBRotPosScaleSplinePathInterpolator(alpha, transformGroup, transform3D, kBKeyFrameArray);
        if (object != null) {
            this.behaviors = object;
            lwsFrame = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000000.0);
            object.setSchedulingBounds((Bounds)lwsFrame);
            transformGroup.setCapability(18);
            transformGroup.addChild((Node)this.behaviors);
        }
    }

    void createJava3dBehaviors(TransformGroup transformGroup) {
        if (this.numFrames <= 1) {
            this.behaviors = null;
        } else {
            if (this.firstFrame > 1) {
                this.createJava3dBehaviorsForFramesSubset(transformGroup);
                return;
            }
            long l = 0L;
            int n = this.loop ? -1 : 1;
            n = -1;
            this.debugOutputLn(2, "totalTime = " + this.totalTime);
            this.debugOutputLn(2, "loopCount = " + n);
            float f = 1000.0f * this.totalTime * (float)(this.frames[this.numFrames - 1].getFrameNum() / (double)this.totalFrames);
            this.debugOutputLn(2, " anim time: " + f);
            this.debugOutputLn(2, " totalFrames = " + this.totalFrames);
            this.debugOutputLn(2, " lastFrame = " + this.frames[this.numFrames - 1].getFrameNum());
            if (!this.loop) {
                l = (long)(1000.0 * (double)this.totalTime - (double)f);
            }
            Alpha alpha = new Alpha(n, 1, 0L, 0L, (long)f, 0L, l, 0L, 0L, 0L);
            float[] fArray = new float[this.numFrames];
            Point3f[] point3fArray = new Point3f[this.numFrames];
            Quat4f[] quat4fArray = new Quat4f[this.numFrames];
            Point3f[] point3fArray2 = new Point3f[this.numFrames];
            Transform3D transform3D = new Transform3D();
            Matrix4d matrix4d = new Matrix4d();
            KBKeyFrame[] kBKeyFrameArray = new KBKeyFrame[this.numFrames];
            int n2 = 0;
            while (n2 < this.numFrames) {
                point3fArray[n2] = this.frames[n2].getPosition();
                point3fArray2[n2] = this.frames[n2].getScale();
                this.frames[n2].setRotationMatrix(matrix4d);
                this.debugOutputLn(2, "LwsMotion::createj3dbeh, mat = " + matrix4d);
                quat4fArray[n2] = new Quat4f();
                quat4fArray[n2].set(matrix4d);
                this.debugOutputLn(2, " and quat = " + quat4fArray[n2]);
                fArray[n2] = n2 == 0 ? 0.0f : (float)this.frames[n2].getFrameNum() / (float)this.frames[this.numFrames - 1].getFrameNum();
                kBKeyFrameArray[n2] = new KBKeyFrame(fArray[n2], this.frames[n2].linearValue, point3fArray[n2], (float)this.frames[n2].heading, (float)this.frames[n2].pitch, (float)this.frames[n2].bank, point3fArray2[n2], (float)this.frames[n2].tension, (float)this.frames[n2].continuity, (float)this.frames[n2].bias);
                this.debugOutputLn(2, "pos, knots, quat = " + point3fArray[n2] + fArray[n2] + quat4fArray[n2]);
                ++n2;
            }
            KBRotPosScaleSplinePathInterpolator kBRotPosScaleSplinePathInterpolator = new KBRotPosScaleSplinePathInterpolator(alpha, transformGroup, transform3D, kBKeyFrameArray);
            if (kBRotPosScaleSplinePathInterpolator != null) {
                this.behaviors = kBRotPosScaleSplinePathInterpolator;
                BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000000.0);
                kBRotPosScaleSplinePathInterpolator.setSchedulingBounds((Bounds)boundingSphere);
                transformGroup.setCapability(18);
                transformGroup.addChild((Node)this.behaviors);
            }
        }
    }

    Behavior getBehaviors() {
        return this.behaviors;
    }

    LwsFrame getFirstFrame() {
        if (this.numFrames > 0) {
            return this.frames[0];
        }
        return null;
    }

    void printVals() {
        this.debugOutputLn(2, "   motionName = " + this.motionName);
        this.debugOutputLn(2, "   numChannels = " + this.numChannels);
        this.debugOutputLn(2, "   numFrames = " + this.numFrames);
        this.debugOutputLn(2, "   loop = " + this.loop);
        int n = 0;
        while (n < this.numFrames) {
            this.debugOutputLn(2, "       FRAME " + n);
            this.frames[n].printVals();
            ++n;
        }
    }

    class FrameHolder {
        double frameNumber;
        LwsFrame frame;

        FrameHolder(LwsFrame lwsFrame, double d) {
            this.frame = lwsFrame;
            this.frameNumber = d;
        }
    }
}

