/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.GeomBuffer;
import com.sun.j3d.utils.geometry.Primitive;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.vecmath.Vector3f;

public class Box
extends Primitive {
    public static final int FRONT = 0;
    public static final int BACK = 1;
    public static final int RIGHT = 2;
    public static final int LEFT = 3;
    public static final int TOP = 4;
    public static final int BOTTOM = 5;
    float xDim;
    float yDim;
    float zDim;
    int numTexUnit = 1;
    private static final float[] verts = new float[]{1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f};
    private static final double[] tcoords = new double[]{1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0};
    private static final Vector3f[] normals = new Vector3f[]{new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, -1.0f, 0.0f)};

    public Box() {
        this(1.0f, 1.0f, 1.0f, 1, null);
    }

    public Box(float f, float f2, float f3, Appearance appearance) {
        this(f, f2, f3, 1, appearance);
    }

    public Box(float f, float f2, float f3, int n, Appearance appearance, int n2) {
        this.xDim = f;
        this.yDim = f2;
        this.zDim = f3;
        this.flags = n;
        double d = (this.flags & 4) != 0 ? -1.0 : 1.0;
        Shape3D[] shape3DArray = new Shape3D[6];
        GeomBuffer geomBuffer = null;
        int n3 = 0;
        while (n3 <= 5) {
            geomBuffer = this.getCachedGeometry(8, f, f2, f3, n3, n3, n);
            if (geomBuffer != null) {
                shape3DArray[n3] = new Shape3D((Geometry)geomBuffer.getComputedGeometry());
                this.numVerts += geomBuffer.getNumVerts();
                this.numTris += geomBuffer.getNumTris();
            } else {
                GeomBuffer geomBuffer2 = new GeomBuffer(4, n2);
                geomBuffer2.begin(1);
                int n4 = 0;
                while (n4 < 2) {
                    geomBuffer2.normal3d((double)Box.normals[n3].x * d, (double)Box.normals[n3].y * d, (double)Box.normals[n3].z * d);
                    geomBuffer2.texCoord2d(tcoords[n3 * 8 + n4 * 2], tcoords[n3 * 8 + n4 * 2 + 1]);
                    geomBuffer2.vertex3d((double)verts[n3 * 12 + n4 * 3] * (double)f, (double)verts[n3 * 12 + n4 * 3 + 1] * (double)f2, (double)verts[n3 * 12 + n4 * 3 + 2] * (double)f3);
                    ++n4;
                }
                int n5 = 3;
                while (n5 > 1) {
                    geomBuffer2.normal3d((double)Box.normals[n3].x * d, (double)Box.normals[n3].y * d, (double)Box.normals[n3].z * d);
                    geomBuffer2.texCoord2d(tcoords[n3 * 8 + n5 * 2], tcoords[n3 * 8 + n5 * 2 + 1]);
                    geomBuffer2.vertex3d((double)verts[n3 * 12 + n5 * 3] * (double)f, (double)verts[n3 * 12 + n5 * 3 + 1] * (double)f2, (double)verts[n3 * 12 + n5 * 3 + 2] * (double)f3);
                    --n5;
                }
                geomBuffer2.end();
                shape3DArray[n3] = new Shape3D((Geometry)geomBuffer2.getGeom(this.flags));
                this.numVerts = geomBuffer2.getNumVerts();
                this.numTris = geomBuffer2.getNumTris();
                if ((n & 0x10) == 0) {
                    this.cacheGeometry(8, f, f2, f3, n3, n3, n, geomBuffer2);
                }
            }
            if ((this.flags & 0x40) != 0) {
                shape3DArray[n3].setCapability(14);
                shape3DArray[n3].setCapability(15);
            }
            if ((this.flags & 0x20) != 0) {
                shape3DArray[n3].setCapability(12);
            }
            this.addChild((Node)shape3DArray[n3]);
            ++n3;
        }
        if (appearance == null) {
            this.setAppearance();
        } else {
            this.setAppearance(appearance);
        }
    }

    public Box(float f, float f2, float f3, int n, Appearance appearance) {
        this(f, f2, f3, n, appearance, 1);
    }

    public Shape3D getShape(int n) {
        if (n >= 0 && n <= 5) {
            return (Shape3D)this.getChild(n);
        }
        return null;
    }

    public void setAppearance(Appearance appearance) {
        ((Shape3D)this.getChild(4)).setAppearance(appearance);
        ((Shape3D)this.getChild(3)).setAppearance(appearance);
        ((Shape3D)this.getChild(2)).setAppearance(appearance);
        ((Shape3D)this.getChild(0)).setAppearance(appearance);
        ((Shape3D)this.getChild(1)).setAppearance(appearance);
        ((Shape3D)this.getChild(5)).setAppearance(appearance);
    }

    public Appearance getAppearance(int n) {
        if (n > 5 || n < 0) {
            return null;
        }
        return this.getShape(n).getAppearance();
    }

    public Node cloneNode(boolean bl) {
        Box box = new Box(this.xDim, this.yDim, this.zDim, this.flags, this.getAppearance());
        box.duplicateNode((Node)this, bl);
        return box;
    }

    public void duplicateNode(Node node, boolean bl) {
        super.duplicateNode(node, bl);
    }

    public float getXdimension() {
        return this.xDim;
    }

    public float getYdimension() {
        return this.yDim;
    }

    public float getZdimension() {
        return this.zDim;
    }
}

