/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.SceneGraphObjectState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.Fog;
import javax.media.j3d.Group;
import javax.media.j3d.SceneGraphObject;
import javax.vecmath.Color3f;

public abstract class FogState
extends SceneGraphObjectState {
    protected int[] scopes;
    protected int boundingLeaf;

    public FogState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        this.control.writeBounds(dataOutput, ((Fog)this.node).getInfluencingBounds());
        dataOutput.writeInt(((Fog)this.node).numScopes());
        int n = 0;
        while (n < ((Fog)this.node).numScopes()) {
            dataOutput.writeInt(this.control.getSymbolTable().addReference((SceneGraphObject)((Fog)this.node).getScope(n)));
            ++n;
        }
        dataOutput.writeInt(this.control.getSymbolTable().addReference((SceneGraphObject)((Fog)this.node).getInfluencingBoundingLeaf()));
        Color3f color3f = new Color3f();
        ((Fog)this.node).getColor(color3f);
        this.control.writeColor3f(dataOutput, color3f);
    }

    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        ((Fog)this.node).setInfluencingBounds(this.control.readBounds(dataInput));
        this.scopes = new int[dataInput.readInt()];
        int n = 0;
        while (n < this.scopes.length) {
            this.scopes[n] = dataInput.readInt();
            ++n;
        }
        this.boundingLeaf = dataInput.readInt();
        ((Fog)this.node).setColor(this.control.readColor3f(dataInput));
    }

    public void buildGraph() {
        int n = 0;
        while (n < this.scopes.length) {
            ((Fog)this.node).addScope((Group)this.control.getSymbolTable().getJ3dNode(this.scopes[n]));
            ++n;
        }
        ((Fog)this.node).setInfluencingBoundingLeaf((BoundingLeaf)this.control.getSymbolTable().getJ3dNode(this.boundingLeaf));
        super.buildGraph();
    }
}

