/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Iterator;
import org.freehep.math.minuit.ContoursError;
import org.freehep.math.minuit.FunctionMinimum;
import org.freehep.math.minuit.MinimumState;
import org.freehep.math.minuit.MinosError;
import org.freehep.math.minuit.MinuitParameter;
import org.freehep.math.minuit.MnAlgebraicSymMatrix;
import org.freehep.math.minuit.MnAlgebraicVector;
import org.freehep.math.minuit.MnGlobalCorrelationCoeff;
import org.freehep.math.minuit.MnPlot;
import org.freehep.math.minuit.MnUserCovariance;
import org.freehep.math.minuit.MnUserParameterState;
import org.freehep.math.minuit.MnUserParameters;
import org.freehep.math.minuit.Point;

public abstract class MnPrint {
    private static final NumberFormat format = new DecimalFormat("0.#######E00");

    private MnPrint() {
    }

    static String toString(MnAlgebraicVector x) {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        MnPrint.print(pw, x);
        pw.close();
        return writer.toString();
    }

    public static void print(PrintWriter os, MnAlgebraicVector vec) {
        os.println("LAVector parameters:");
        os.println();
        int nrow = vec.size();
        for (int i = 0; i < nrow; ++i) {
            os.print(format.format(vec.get(i)));
            os.print(' ');
        }
        os.println();
    }

    static String toString(MnAlgebraicSymMatrix x) {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        MnPrint.print(pw, x);
        pw.close();
        return writer.toString();
    }

    public static void print(PrintWriter os, MnAlgebraicSymMatrix matrix) {
        os.println("LASymMatrix parameters:");
        os.println();
        int n = matrix.nrow();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                os.print(format.format(matrix.get(i, j)));
                os.print(' ');
            }
            os.println();
        }
    }

    static String toString(FunctionMinimum min) {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        MnPrint.print(pw, min);
        pw.close();
        return writer.toString();
    }

    public static void print(PrintWriter os, FunctionMinimum min) {
        os.println();
        if (!min.isValid()) {
            os.println();
            os.println("WARNING: Minuit did not converge.");
            os.println();
        } else {
            os.println();
            os.println("Minuit did successfully converge.");
            os.println();
        }
        os.println("# of function calls: " + min.nfcn());
        os.println("minimum function value: " + format.format(min.fval()));
        os.println("minimum edm: " + format.format(min.edm()));
        os.println("minimum internal state vector: " + min.parameters().vec());
        if (min.hasValidCovariance()) {
            os.println("minimum internal covariance matrix: " + min.error().matrix());
        }
        os.println(min.userParameters());
        os.println(min.userCovariance());
        os.println(min.userState().globalCC());
        if (!min.isValid()) {
            os.println("WARNING: FunctionMinimum is invalid.");
        }
        os.println();
    }

    static String toString(MinimumState x) {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        MnPrint.print(pw, x);
        pw.close();
        return writer.toString();
    }

    public static void print(PrintWriter os, MinimumState min) {
        os.println();
        os.println("minimum function value: " + format.format(min.fval()));
        os.println("minimum edm: " + format.format(min.edm()));
        os.println("minimum internal state vector: " + min.vec());
        os.println("minimum internal gradient vector: " + min.gradient().vec());
        if (min.hasCovariance()) {
            os.println("minimum internal covariance matrix: " + min.error().matrix());
        }
        os.println();
    }

    static String toString(MnUserParameters x) {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        MnPrint.print(pw, x);
        pw.close();
        return writer.toString();
    }

    public static void print(PrintWriter os, MnUserParameters par) {
        os.println();
        os.println("# ext. ||   name    ||   type  ||   value   ||  error +/- ");
        os.println();
        boolean atLoLim = false;
        boolean atHiLim = false;
        Iterator iter = par.parameters().iterator();
        while (iter.hasNext()) {
            MinuitParameter ipar = (MinuitParameter)iter.next();
            os.print(" " + ipar.number() + " || " + ipar.name() + " || ");
            if (ipar.isConst()) {
                os.print("         || " + format.format(ipar.value()) + "   ||");
                continue;
            }
            if (ipar.isFixed()) {
                os.println("  fixed  || " + format.format(ipar.value()) + "   ||");
                continue;
            }
            if (ipar.hasLimits()) {
                if (ipar.error() > 0.0) {
                    os.print(" limited || " + format.format(ipar.value()));
                    if (Math.abs(ipar.value() - ipar.lowerLimit()) < par.precision().eps2()) {
                        os.print("* ");
                        atLoLim = true;
                    }
                    if (Math.abs(ipar.value() - ipar.upperLimit()) < par.precision().eps2()) {
                        os.print("**");
                        atHiLim = true;
                    }
                    os.println(" || " + format.format(ipar.error()));
                    continue;
                }
                os.println("  free   || " + format.format(ipar.value()) + " || no");
                continue;
            }
            if (ipar.error() > 0.0) {
                os.println("  free   || " + format.format(ipar.value()) + " || " + format.format(ipar.error()));
                continue;
            }
            os.println("  free   || " + format.format(ipar.value()) + " || no");
        }
        os.println();
        if (atLoLim) {
            os.print("* parameter is at lower limit");
        }
        if (atHiLim) {
            os.print("** parameter is at upper limit");
        }
        os.println();
    }

    static String toString(MnUserCovariance x) {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        MnPrint.print(pw, x);
        pw.close();
        return writer.toString();
    }

    public static void print(PrintWriter os, MnUserCovariance matrix) {
        int i;
        os.println();
        os.println("MnUserCovariance: ");
        os.println();
        int n = matrix.nrow();
        for (i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                os.print(format.format(matrix.get(i, j)));
                os.print(' ');
            }
            os.println();
        }
        os.println();
        os.println("MnUserCovariance parameter correlations: ");
        os.println();
        n = matrix.nrow();
        for (i = 0; i < n; ++i) {
            double di = matrix.get(i, i);
            for (int j = 0; j < n; ++j) {
                double dj = matrix.get(j, j);
                os.print(format.format(matrix.get(i, j) / Math.sqrt(Math.abs(di * dj))));
                os.print(' ');
            }
            os.println();
        }
    }

    static String toString(MnGlobalCorrelationCoeff x) {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        MnPrint.print(pw, x);
        pw.close();
        return writer.toString();
    }

    public static void print(PrintWriter os, MnGlobalCorrelationCoeff coeff) {
        os.println();
        os.println("MnGlobalCorrelationCoeff: ");
        os.println();
        for (int i = 0; i < coeff.globalCC().length; ++i) {
            os.println(format.format(coeff.globalCC()[i]));
        }
    }

    static String toString(MnUserParameterState x) {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        MnPrint.print(pw, x);
        pw.close();
        return writer.toString();
    }

    public static void print(PrintWriter os, MnUserParameterState state) {
        os.println();
        if (!state.isValid()) {
            os.println();
            os.println("WARNING: MnUserParameterState is not valid.");
            os.println();
        }
        os.println("# of function calls: " + state.nfcn());
        os.println("function value: " + state.fval());
        os.println("expected distance to the minimum (edm): " + state.edm());
        os.println("external parameters: " + state.parameters());
        if (state.hasCovariance()) {
            os.println("covariance matrix: " + state.covariance());
        }
        if (state.hasGlobalCC()) {
            os.println("global correlation coefficients : " + state.globalCC());
        }
        if (!state.isValid()) {
            os.println("WARNING: MnUserParameterState is not valid.");
        }
        os.println();
    }

    static String toString(MinosError x) {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        MnPrint.print(pw, x);
        pw.close();
        return writer.toString();
    }

    public static void print(PrintWriter os, MinosError me) {
        os.println();
        os.println("Minos # of function calls: " + me.nfcn());
        if (!me.isValid()) {
            os.println("Minos error is not valid.");
        }
        if (!me.lowerValid()) {
            os.println("lower Minos error is not valid.");
        }
        if (!me.upperValid()) {
            os.println("upper Minos error is not valid.");
        }
        if (me.atLowerLimit()) {
            os.println("Minos error is lower limit of parameter " + me.parameter());
        }
        if (me.atUpperLimit()) {
            os.println("Minos error is upper limit of parameter " + me.parameter());
        }
        if (me.atLowerMaxFcn()) {
            os.println("Minos number of function calls for lower error exhausted.");
        }
        if (me.atUpperMaxFcn()) {
            os.println("Minos number of function calls for upper error exhausted.");
        }
        if (me.lowerNewMin()) {
            os.println("Minos found a new minimum in negative direction.");
            os.println(me.lowerState());
        }
        if (me.upperNewMin()) {
            os.println("Minos found a new minimum in positive direction.");
            os.println(me.upperState());
        }
        os.println("# ext. ||   name    || value@min ||  negative || positive  ");
        os.println(me.parameter() + "||" + me.lowerState().name(me.parameter()) + "||" + format.format(me.min()) + "||" + format.format(me.lower()) + "||" + format.format(me.upper()));
        os.println();
    }

    static String toString(ContoursError x) {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        MnPrint.print(pw, x);
        pw.close();
        return writer.toString();
    }

    public static void print(PrintWriter os, ContoursError ce) {
        os.println();
        os.println("Contours # of function calls: " + ce.nfcn());
        os.println("MinosError in x: ");
        os.println(ce.xMinosError());
        os.println("MinosError in y: ");
        os.println(ce.yMinosError());
        MnPlot plot = new MnPlot();
        plot.plot(ce.xmin(), ce.ymin(), ce.points());
        int i = 0;
        Iterator iter = ce.points().iterator();
        while (iter.hasNext()) {
            Point ipoint = (Point)iter.next();
            os.println(i++ + " " + format.format(ipoint.first) + " " + format.format(ipoint.second));
        }
        os.println();
    }
}

