/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphics2d.font;

import org.freehep.graphics2d.font.CharTable;
import org.freehep.graphics2d.font.Expert;
import org.freehep.graphics2d.font.ISOLatin;
import org.freehep.graphics2d.font.MACLatin;
import org.freehep.graphics2d.font.PDFLatin;
import org.freehep.graphics2d.font.STDLatin;
import org.freehep.graphics2d.font.Symbol;
import org.freehep.graphics2d.font.WINLatin;
import org.freehep.graphics2d.font.Zapfdingbats;

public class Lookup {
    private static Lookup instance;
    private CharTable[] tables = new CharTable[this.ntables];
    private int ntables = 8;

    public static Lookup getInstance() {
        if (instance == null) {
            instance = new Lookup();
        }
        return instance;
    }

    private Lookup() {
        this.tables[0] = new Symbol();
        this.tables[1] = new Expert();
        this.tables[2] = new Zapfdingbats();
        this.tables[3] = new STDLatin();
        this.tables[4] = new MACLatin();
        this.tables[5] = new WINLatin();
        this.tables[6] = new PDFLatin();
        this.tables[7] = new ISOLatin();
    }

    public char toUnicode(String name) {
        for (int i = 0; i < this.ntables; ++i) {
            char uc = this.tables[i].toUnicode(name);
            if (uc == '\uffff') continue;
            return uc;
        }
        return '\uffff';
    }

    public String toName(char uc) {
        for (int i = 0; i < this.ntables; ++i) {
            String name = this.tables[i].toName(uc);
            if (name == null) continue;
            return name;
        }
        return null;
    }

    public String toName(Character uc) {
        for (int i = 0; i < this.ntables; ++i) {
            String name = this.tables[i].toName(uc);
            if (name == null) continue;
            return name;
        }
        return null;
    }

    public CharTable getTable(String tableName) {
        for (int i = 0; i < this.ntables; ++i) {
            String tblName = this.tables[i].getEncoding() + this.tables[i].getName();
            if (!tblName.equalsIgnoreCase(tableName)) continue;
            return this.tables[i];
        }
        return null;
    }

    public int getNumberOfTables() {
        return this.ntables;
    }

    public String[] getTableNames() {
        String[] tblnames = new String[this.ntables];
        for (int i = 0; i < this.ntables; ++i) {
            tblnames[i] = this.tables[i].getEncoding() + this.tables[i].getName();
        }
        return tblnames;
    }
}

