/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.ps;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import org.freehep.graphics2d.GenericTagHandler;
import org.freehep.graphics2d.PrintColor;
import org.freehep.graphics2d.TagString;
import org.freehep.graphics2d.font.CharTable;
import org.freehep.graphicsio.AbstractVectorGraphicsIO;
import org.freehep.graphicsio.ImageGraphics2D;
import org.freehep.graphicsio.MultiPageDocument;
import org.freehep.graphicsio.PageConstants;
import org.freehep.graphicsio.font.FontUtilities;
import org.freehep.graphicsio.ps.EPSIEncoder;
import org.freehep.graphicsio.ps.MappedColor;
import org.freehep.graphicsio.ps.PSFontTable;
import org.freehep.graphicsio.ps.PSPathConstructor;
import org.freehep.graphicsio.raw.RawImageWriteParam;
import org.freehep.util.ScientificFormat;
import org.freehep.util.UserProperties;
import org.freehep.util.images.ImageUtilities;
import org.freehep.util.io.ASCII85OutputStream;
import org.freehep.util.io.FlateOutputStream;

public class PSGraphics2D
extends AbstractVectorGraphicsIO
implements MultiPageDocument,
FontUtilities.ShowString {
    private static final String rootKey;
    public static final String BACKGROUND;
    public static final String BACKGROUND_COLOR;
    public static final String PAGE_SIZE;
    public static final String PAGE_MARGINS;
    public static final String ORIENTATION;
    public static final String FIT_TO_PAGE;
    public static final String EMBED_FONTS;
    public static final String EMBED_FONTS_AS;
    public static final String FOR;
    public static final String TITLE;
    public static final String PREVIEW;
    public static final String PREVIEW_BITS;
    public static final String WRITE_IMAGES_AS;
    private static final UserProperties defaultProperties;
    public static final String version = "$Revision: 1.26 $";
    public static final int LEVEL_2 = 2;
    public static final int LEVEL_3 = 3;
    private static final double FONTSIZE_CORRECTION = 1.0;
    private static boolean enableClip;
    private PSFontTable fontTable;
    protected OutputStream ros;
    protected PrintStream os;
    private boolean fontSet = false;
    private boolean multiPage;
    private int currentPage;
    private int postscriptLevel = 3;
    private static String[] psSymbolNames;
    private static Hashtable compositeFonts;
    private static String[][] psAlignments;
    private ScientificFormat scientific = new ScientificFormat(6, 9, false);

    public static Properties getDefaultProperties() {
        return defaultProperties;
    }

    public PSGraphics2D(File file, Dimension size) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), size);
    }

    public PSGraphics2D(File file, Component component) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), component);
    }

    public PSGraphics2D(OutputStream os, Dimension size) {
        super(size, false);
        this.init(os);
    }

    public PSGraphics2D(OutputStream os, Component component) {
        super(component, false);
        this.init(os);
    }

    private void init(OutputStream os) {
        this.ros = new BufferedOutputStream(os);
        this.initProperties((Properties)defaultProperties);
        this.fontTable = new PSFontTable(this.ros, this.getFontRenderContext());
        this.multiPage = false;
        this.currentPage = 0;
        this.fontSet = false;
    }

    protected PSGraphics2D(PSGraphics2D graphics, boolean doRestoreOnDispose) {
        super((AbstractVectorGraphicsIO)graphics, doRestoreOnDispose);
        this.ros = graphics.ros;
        this.os = graphics.os;
        this.fontSet = graphics.fontSet;
        this.fontTable = graphics.fontTable;
        this.multiPage = graphics.multiPage;
        this.currentPage = graphics.currentPage;
    }

    public void setMultiPage(boolean multiPage) {
        this.multiPage = multiPage;
    }

    public boolean isMultiPage() {
        return this.multiPage;
    }

    public static void setClipEnabled(boolean enabled) {
        enableClip = enabled;
    }

    private Rectangle getBoundingBox() {
        Dimension pageSize = PageConstants.getSize((String)this.getProperty(PAGE_SIZE));
        Insets margins = this.getPropertyInsets(PAGE_MARGINS);
        boolean isPortrait = this.getProperty(ORIENTATION).equals("Portrait");
        double awidth = pageSize.width - margins.left - margins.right;
        double aheight = pageSize.height - margins.top - margins.bottom;
        Dimension size = this.getSize();
        double iwidth = isPortrait ? size.width : size.height;
        double iheight = isPortrait ? size.height : size.width;
        double sf = Math.min(awidth / iwidth, aheight / iheight);
        if (!this.isProperty(FIT_TO_PAGE)) {
            sf = Math.min(sf, 1.0);
        }
        double x0 = awidth / 2.0 + (double)margins.left - sf * iwidth / 2.0;
        double y0 = aheight / 2.0 + (double)margins.bottom - sf * iheight / 2.0;
        double x1 = x0 + sf * iwidth;
        double y1 = y0 + sf * iheight;
        int llx = (int)x0;
        int lly = (int)y0;
        int urx = (int)Math.ceil(x1);
        int ury = (int)Math.ceil(y1);
        return new Rectangle(llx, lly, urx - llx, ury - lly);
    }

    public void writeHeader() throws IOException {
        this.os = new PrintStream(this.ros, true);
        if (!this.isMultiPage()) {
            Dimension size = this.getSize();
            this.resetClip(new Rectangle(0, 0, size.width, size.height));
        }
        this.os.println("%!PS-Adobe-3.0" + (this.isMultiPage() ? "" : " EPSF-3.0"));
        if (!this.isMultiPage()) {
            Rectangle bbox = this.getBoundingBox();
            this.os.println("%%BoundingBox: " + bbox.x + " " + bbox.y + " " + (bbox.x + bbox.width) + " " + (bbox.y + bbox.height));
        }
        String producer = ((Object)((Object)this)).getClass().getName();
        if (!this.isDeviceIndependent()) {
            producer = producer + " " + version.substring(1, version.length() - 1);
        }
        this.os.println("%%Creator: " + this.getCreator());
        this.os.println("%%Producer: " + producer);
        this.os.println("%%For: " + this.getProperty(FOR));
        this.os.println("%%Title: " + this.getProperty(TITLE));
        if (!this.isDeviceIndependent()) {
            this.os.println("%%CreationDate: " + DateFormat.getDateTimeInstance(0, 0).format(new Date()));
        }
        this.os.println("%%LanguageLevel: " + this.postscriptLevel);
        this.os.println("%%EndComments");
        if (this.isProperty(PREVIEW) && this.getComponent() != null) {
            Rectangle size = this.getComponent().getBounds();
            BufferedImage image = new BufferedImage(size.width, size.height, 2);
            Graphics imageGraphics = image.getGraphics();
            this.getComponent().print(imageGraphics);
            EPSIEncoder encoder = new EPSIEncoder(image, this.ros, this.getPropertyInt(PREVIEW_BITS), this.getProperty(ORIENTATION).equals("Portrait"));
            encoder.encode();
        }
        this.writeProlog();
    }

    private void writeProlog() {
        this.os.println("%%BeginProlog");
        PSGraphics2D.copyResourceTo((Object)((Object)this), (String)"PSProlog.txt", (PrintStream)this.os);
        this.os.println("%%EndProlog");
        this.os.println();
        if (!this.isMultiPage()) {
            this.openPage(this.getSize(), null, this.getComponent());
        }
    }

    public void writeBackground() throws IOException {
        if (this.isProperty(BACKGROUND)) {
            this.setBackground(this.getPropertyColor(BACKGROUND_COLOR));
            this.clearRect(0.0, 0.0, this.getSize().width, this.getSize().height);
        } else {
            this.setBackground(this.getComponent() != null ? this.getComponent().getBackground() : Color.WHITE);
            this.clearRect(0.0, 0.0, this.getSize().width, this.getSize().height);
        }
    }

    public void writeTrailer() throws IOException {
        if (!this.isMultiPage()) {
            this.closePage();
        }
        this.os.println();
        this.os.println("%%Trailer");
        if (this.isMultiPage()) {
            this.os.println("%%Pages: " + this.currentPage);
        }
        this.os.println("%%EOF");
    }

    public void closeStream() throws IOException {
        this.ros.close();
        this.os.close();
    }

    public void openPage(Component component) throws IOException {
        this.openPage(component.getSize(), component.getName(), component);
    }

    public void openPage(Dimension size, String title) throws IOException {
        this.openPage(size, title, null);
    }

    private void openPage(Dimension size, String title, Component component) {
        if (size == null) {
            size = component.getSize();
        }
        ++this.currentPage;
        this.resetClip(new Rectangle(0, 0, size.width, size.height));
        Dimension pageSize = PageConstants.getSize((String)this.getProperty(PAGE_SIZE));
        Insets margins = this.getPropertyInsets(PAGE_MARGINS);
        String string = title = title == null ? "" + this.currentPage : "(" + title + ")";
        if (this.isMultiPage()) {
            this.os.println("%%Page: " + title + " " + this.currentPage);
        }
        this.os.println(this.isMultiPage() ? "%%BeginPageSetup" : "%%BeginSetup");
        this.os.println("save");
        this.os.println("procDict begin");
        this.os.println("printColorMap begin");
        this.os.println(pageSize.width + " " + pageSize.height + " setpagesize");
        this.os.println(margins.left + " " + margins.bottom + " " + margins.top + " " + margins.right + " setmargins");
        this.os.println("0 0 setorigin");
        this.os.println(size.width + " " + size.height + " setsize");
        this.os.println(this.isProperty(FIT_TO_PAGE) ? "fittopage" : "naturalsize");
        this.os.println(this.getProperty(ORIENTATION).equals("Portrait") ? "portrait" : "landscape");
        this.os.println("imagescale");
        this.os.println("cliptobounds");
        this.os.println("setbasematrix");
        this.os.println("/Helvetica 10 sf");
        this.os.println("defaultGraphicsState");
        this.os.println(this.isMultiPage() ? "%%EndPageSetup" : "%%EndSetup");
        this.os.println();
        try {
            this.writeGraphicsState();
            this.writeBackground();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void closePage() {
        this.os.println("end end restore showpage");
        if (this.isMultiPage()) {
            this.os.println("%%PageTrailer");
        }
    }

    public void setHeader(Font font, TagString left, TagString center, TagString right, int underlineThickness) {
    }

    public void setFooter(Font font, TagString left, TagString center, TagString right, int underlineThickness) {
    }

    public Graphics create() {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException e) {
            this.handleException(e);
        }
        return new PSGraphics2D(this, true);
    }

    public Graphics create(double x, double y, double width, double height) {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException e) {
            this.handleException(e);
        }
        PSGraphics2D graphics = new PSGraphics2D(this, true);
        graphics.translate(x, y);
        graphics.clipRect(0.0, 0.0, width, height);
        return graphics;
    }

    protected void writeGraphicsSave() throws IOException {
        this.os.println("q");
    }

    protected void writeGraphicsRestore() throws IOException {
        this.os.println("Q");
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        this.os.println(this.fixedPrecision(x2) + " " + this.fixedPrecision(y2) + " " + this.fixedPrecision(x1) + " " + this.fixedPrecision(y1) + " L");
    }

    public void drawRect(double x, double y, double width, double height) {
        this.os.println("bias " + this.fixedPrecision(x) + " " + this.fixedPrecision(y) + " " + this.fixedPrecision(width) + " " + this.fixedPrecision(height) + " rs unbias");
    }

    public void fillRect(double x, double y, double width, double height) {
        this.os.println(this.fixedPrecision(x) + " " + this.fixedPrecision(y) + " " + this.fixedPrecision(width) + " " + this.fixedPrecision(height) + " rf");
    }

    public void drawArc(double x, double y, double width, double height, double startAngle, double arcAngle) {
        this.os.println(this.fixedPrecision(startAngle) + " " + this.fixedPrecision(startAngle + arcAngle) + " " + this.fixedPrecision(x) + " " + this.fixedPrecision(y) + " " + this.fixedPrecision(width) + " " + this.fixedPrecision(height) + " OVL");
    }

    public void fillArc(double x, double y, double width, double height, double startAngle, double arcAngle) {
        this.os.println(this.fixedPrecision(startAngle) + " " + this.fixedPrecision(startAngle + arcAngle) + " " + this.fixedPrecision(x) + " " + this.fixedPrecision(y) + " " + this.fixedPrecision(width) + " " + this.fixedPrecision(height) + " FOVL");
    }

    public void drawOval(double x, double y, double width, double height) {
        this.os.println("0 360 " + this.fixedPrecision(x) + " " + this.fixedPrecision(y) + " " + this.fixedPrecision(width) + " " + this.fixedPrecision(height) + " OVL");
    }

    public void fillOval(double x, double y, double width, double height) {
        this.os.println("0 360 " + this.fixedPrecision(x) + " " + this.fixedPrecision(y) + " " + this.fixedPrecision(width) + " " + this.fixedPrecision(height) + " FOVL");
    }

    public void drawRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        this.os.println(this.fixedPrecision(x) + " " + this.fixedPrecision(y) + " " + this.fixedPrecision(width) + " " + this.fixedPrecision(height) + " " + this.fixedPrecision(arcWidth) + " " + this.fixedPrecision(arcHeight) + " RREC");
    }

    public void fillRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        this.os.println(this.fixedPrecision(x) + " " + this.fixedPrecision(y) + " " + this.fixedPrecision(width) + " " + this.fixedPrecision(height) + " " + this.fixedPrecision(arcWidth) + " " + this.fixedPrecision(arcHeight) + " FRREC");
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints > 1) {
            this.os.println(nPoints - 1 + " " + xPoints[0] + " " + yPoints[0] + " OPL");
            for (int i = 1; i < nPoints; ++i) {
                this.os.println(xPoints[i] + " " + yPoints[i]);
            }
        }
    }

    public void drawPolyline(double[] xPoints, double[] yPoints, int nPoints) {
        if (nPoints > 1) {
            this.os.println(nPoints - 1 + " " + xPoints[0] + " " + yPoints[0] + " OPL");
            for (int i = 1; i < nPoints; ++i) {
                this.os.println(this.fixedPrecision(xPoints[i]) + " " + this.fixedPrecision(yPoints[i]));
            }
        }
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints > 1) {
            this.os.println(nPoints - 1 + " " + xPoints[0] + " " + yPoints[0] + " CPL");
            for (int i = 1; i < nPoints; ++i) {
                this.os.println(xPoints[i] + " " + yPoints[i]);
            }
        }
    }

    public void drawPolygon(double[] xPoints, double[] yPoints, int nPoints) {
        if (nPoints > 1) {
            this.os.println(nPoints - 1 + " " + xPoints[0] + " " + yPoints[0] + " CPL");
            for (int i = 1; i < nPoints; ++i) {
                this.os.println(this.fixedPrecision(xPoints[i]) + " " + this.fixedPrecision(yPoints[i]));
            }
        }
    }

    public void drawPolygon(Polygon p) {
        this.drawPolygon(p.xpoints, p.ypoints, p.npoints);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints > 1) {
            this.os.println(nPoints - 1 + " " + xPoints[0] + " " + yPoints[0] + " FPL");
            for (int i = 1; i < nPoints; ++i) {
                this.os.println(xPoints[i] + " " + yPoints[i]);
            }
        }
    }

    public void fillPolygon(double[] xPoints, double[] yPoints, int nPoints) {
        if (nPoints > 1) {
            this.os.println(nPoints - 1 + " " + xPoints[0] + " " + yPoints[0] + " FPL");
            for (int i = 1; i < nPoints; ++i) {
                this.os.println(this.fixedPrecision(xPoints[i]) + " " + this.fixedPrecision(yPoints[i]));
            }
        }
    }

    public void fillPolygon(Polygon p) {
        this.fillPolygon(p.xpoints, p.ypoints, p.npoints);
    }

    private String escapeString(String str) {
        if (!this.isProperty(EMBED_FONTS) && PSGraphics2D.isComposite(this.fontTable.fontReference(this.getFont(), this.isProperty(EMBED_FONTS), this.getProperty(EMBED_FONTS_AS)))) {
            return this.convertToUnicodeString(str);
        }
        StringBuffer temp = new StringBuffer(str);
        for (int i = 0; i < temp.length(); ++i) {
            char c = temp.charAt(i);
            if (c == '(' || c == ')' || c == '\\' || c == '%') {
                temp.insert(i++, '\\');
            }
            if (c != '\u0000') continue;
            temp.setCharAt(i, '?');
        }
        return temp.toString();
    }

    public void drawSymbol(double x, double y, double size, int symbol) {
        if (size <= 0.0) {
            return;
        }
        this.os.print(this.fixedPrecision(x) + " " + this.fixedPrecision(y) + " " + this.fixedPrecision(size) + " ");
        this.os.println(symbol < 0 || symbol >= 10 ? "plus" : psSymbolNames[symbol]);
    }

    public void fillSymbol(double x, double y, double size, int symbol) {
        if (size <= 0.0) {
            return;
        }
        this.os.print(this.fixedPrecision(x) + " " + this.fixedPrecision(y) + " " + this.fixedPrecision(size) + " ");
        if (symbol < 0 || symbol >= 10) {
            this.os.println("plus");
            return;
        }
        if (symbol >= 5) {
            this.os.print("f");
        }
        this.os.println(psSymbolNames[symbol]);
    }

    public void draw(Shape shape) {
        try {
            this.writePath(shape);
            this.os.println("S");
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void fill(Shape shape) {
        try {
            boolean eofill = this.writePath(shape);
            this.os.println(eofill ? "f*" : "f");
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void fillAndDraw(Shape shape, Color fillColor) {
        try {
            this.setPSColor(fillColor, true);
            boolean eofill = this.writePath(shape);
            this.os.println(eofill ? "B*" : "B");
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.writeWarning(((Object)((Object)this)).getClass() + ": copyArea(int, int, int, int, int, int) not implemented.");
    }

    protected void writeImage(RenderedImage image, AffineTransform xform, Color bkg) throws IOException {
        byte[] imageBytes;
        String encode;
        if (bkg == null) {
            bkg = this.getBackground();
        }
        image = ImageUtilities.createRenderedImage((RenderedImage)image, (Color)bkg);
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        AffineTransform imageTransform = new AffineTransform((double)imageWidth, 0.0, 0.0, (double)imageHeight, 0.0, 0.0);
        xform.concatenate(imageTransform);
        this.os.println("gsave /DeviceRGB setcolorspace");
        this.transform(xform);
        this.os.println("<<");
        this.os.println("/ImageType 1");
        this.os.println("/Width " + imageWidth + "  /Height " + imageHeight);
        this.os.println("/BitsPerComponent 8");
        this.os.println("/Decode [0 1 0 1 0 1]");
        this.os.println("/ImageMatrix [" + imageWidth + " 0 0 " + imageHeight + " 0 0]");
        String writeAs = this.getProperty(WRITE_IMAGES_AS);
        byte[] flateBytes = null;
        if (writeAs.equals("ZLIB") || writeAs.equals("Smallest Size")) {
            ByteArrayOutputStream flate = new ByteArrayOutputStream();
            ASCII85OutputStream flate85 = new ASCII85OutputStream((OutputStream)flate);
            FlateOutputStream fos = new FlateOutputStream((OutputStream)flate85);
            UserProperties props = new UserProperties();
            props.setProperty(RawImageWriteParam.BACKGROUND, bkg);
            props.setProperty(RawImageWriteParam.CODE, "RGB");
            props.setProperty(RawImageWriteParam.PAD, 1);
            ImageGraphics2D.writeImage((RenderedImage)image, (String)"raw", (Properties)props, (OutputStream)fos);
            fos.close();
            flateBytes = flate.toByteArray();
        }
        byte[] jpgBytes = null;
        if (writeAs.equals("JPG") || writeAs.equals("Smallest Size")) {
            ByteArrayOutputStream jpg = new ByteArrayOutputStream();
            ASCII85OutputStream jpg85 = new ASCII85OutputStream((OutputStream)jpg);
            ImageGraphics2D.writeImage((RenderedImage)image, (String)"jpg", (Properties)new Properties(), (OutputStream)jpg85);
            jpg85.close();
            jpgBytes = jpg.toByteArray();
        }
        if (writeAs.equals("ZLIB")) {
            encode = "Flate";
            imageBytes = flateBytes;
        } else if (writeAs.equals("JPG")) {
            encode = "DCT";
            imageBytes = jpgBytes;
        } else {
            encode = (double)jpgBytes.length < 0.5 * (double)flateBytes.length ? "DCT" : "Flate";
            imageBytes = encode.equals("DCT") ? jpgBytes : flateBytes;
        }
        this.os.println("/DataSource currentfile /ASCII85Decode filter /" + encode + "Decode filter ");
        this.os.println(">> image");
        this.os.write(imageBytes);
        this.os.println("");
        this.os.println("grestore");
    }

    protected void writeString(String str, double x, double y) throws IOException {
        this.showCharacterCodes(str, x, y);
    }

    public void drawString(String str, double x, double y, int horizontal, int vertical, boolean framed, Color frameColor, double frameWidth, boolean banner, Color bannerColor) {
        try {
            LineMetrics metrics = this.getFont().getLineMetrics(str, this.getFontRenderContext());
            double width = this.getFont().getStringBounds(str, this.getFontRenderContext()).getWidth();
            double height = metrics.getHeight();
            double descent = metrics.getDescent();
            Rectangle2D.Double textSize = new Rectangle2D.Double(0.0, descent - height, width, height);
            double adjustment = this.getFont().getSize2D() * 2.0f / 10.0f;
            Point2D textUL = this.drawFrameAndBanner(x, y, textSize, adjustment, framed, frameColor, frameWidth, banner, bannerColor, horizontal, vertical);
            this.drawString(str, textUL.getX(), textUL.getY());
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void drawString(TagString str, double x, double y, int horizontal, int vertical, boolean framed, Color frameColor, double frameWidth, boolean banner, Color bannerColor) {
        try {
            GenericTagHandler tagHandler = new GenericTagHandler((Graphics2D)((Object)this));
            Rectangle2D r = tagHandler.stringSize(str);
            double adjustment = this.getFont().getSize2D() * 2.0f / 10.0f;
            Point2D textUL = this.drawFrameAndBanner(x, y, r, adjustment, framed, frameColor, frameWidth, banner, bannerColor, horizontal, vertical);
            tagHandler.print(str, textUL.getX(), textUL.getY());
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void setTransform(AffineTransform tx) {
        super.setTransform(tx);
        if (tx == null) {
            tx = new AffineTransform();
        }
        this.os.println("[ " + this.fixedPrecision(tx.getScaleX()) + " " + this.fixedPrecision(tx.getShearY()) + " " + this.fixedPrecision(tx.getShearX()) + " " + this.fixedPrecision(tx.getScaleY()) + " " + this.fixedPrecision(tx.getTranslateX()) + " " + this.fixedPrecision(tx.getTranslateY()) + " ] defaultmatrix matrix concatmatrix setmatrix");
    }

    public void transform(AffineTransform transform) {
        super.transform(transform);
        this.os.println("[ " + this.fixedPrecision(transform.getScaleX()) + " " + this.fixedPrecision(transform.getShearY()) + " " + this.fixedPrecision(transform.getShearX()) + " " + this.fixedPrecision(transform.getScaleY()) + " " + this.fixedPrecision(transform.getTranslateX()) + " " + this.fixedPrecision(transform.getTranslateY()) + " ] concat");
    }

    public void translate(double x, double y) {
        super.translate(x, y);
        this.os.println(this.fixedPrecision(x) + " " + this.fixedPrecision(y) + " translate");
    }

    public void rotate(double theta) {
        super.rotate(theta);
        this.os.println(this.fixedPrecision(Math.toDegrees(theta)) + " rotate");
    }

    public void scale(double sx, double sy) {
        super.scale(sx, sy);
        this.os.println(this.fixedPrecision(sx) + " " + this.fixedPrecision(sy) + " scale");
    }

    public void shear(double shx, double shy) {
        super.shear(shx, shy);
        this.os.println("[ 1.0 " + this.fixedPrecision(shy) + " " + this.fixedPrecision(shx) + " 1.0 0.0 0.0 ] concat");
    }

    protected void writeTransform(AffineTransform tx) throws IOException {
    }

    public void setClip(Shape shape) {
        this.clip(shape);
    }

    protected void writeClip(Rectangle r) throws IOException {
        if (r == null) {
            return;
        }
        if (enableClip) {
            this.os.println(r.x + " " + r.y + " " + r.width + " " + r.height + " rc");
        }
    }

    protected void writeClip(Rectangle2D r2d) throws IOException {
        if (r2d == null) {
            return;
        }
        if (enableClip) {
            this.os.println(this.fixedPrecision(r2d.getX()) + " " + this.fixedPrecision(r2d.getY()) + " " + this.fixedPrecision(r2d.getWidth()) + " " + this.fixedPrecision(r2d.getHeight()) + " rc");
        }
    }

    protected void writeClip(Shape s) throws IOException {
        if (s == null) {
            return;
        }
        boolean eofill = this.writePath(s);
        this.os.println(eofill ? "W*" : "W");
    }

    private boolean writePath(Shape s) throws IOException {
        this.os.println("newpath");
        PSPathConstructor path = new PSPathConstructor(this.os, true, false);
        return path.addPath(s);
    }

    protected void writeWidth(float width) throws IOException {
        this.os.println(this.fixedPrecision(width) + " w");
    }

    protected void writeCap(int cap) throws IOException {
        switch (cap) {
            default: {
                this.os.println("0 J");
                break;
            }
            case 1: {
                this.os.println("1 J");
                break;
            }
            case 2: {
                this.os.println("2 J");
            }
        }
    }

    protected void writeJoin(int join) throws IOException {
        switch (join) {
            default: {
                this.os.println("0 j");
                break;
            }
            case 1: {
                this.os.println("1 j");
                break;
            }
            case 2: {
                this.os.println("2 j");
            }
        }
    }

    protected void writeMiterLimit(float limit) throws IOException {
        this.os.println(this.fixedPrecision(limit) + " M");
    }

    protected void writeDash(double[] dash, double phase) throws IOException {
        this.os.print("[ ");
        for (int i = 0; i < dash.length; ++i) {
            this.os.print(this.fixedPrecision(dash[i]) + " ");
        }
        this.os.println("] " + this.fixedPrecision(phase) + " d");
    }

    public void setPaintMode() {
        this.writeWarning(((Object)((Object)this)).getClass() + ": setPaintMode() not implemented.");
    }

    public void setXORMode(Color c1) {
        this.writeWarning(((Object)((Object)this)).getClass() + ": setXORMode(Color) not implemented.");
    }

    protected void writePaint(Color c) throws IOException {
        this.setPSColor(c, false);
    }

    protected void writePaint(GradientPaint paint) throws IOException {
        if (this.postscriptLevel >= 3) {
            float[] rgb1 = paint.getColor1().getRGBColorComponents(null);
            float[] rgb2 = paint.getColor2().getRGBColorComponents(null);
            Point2D p1 = paint.getPoint1();
            Point2D p2 = paint.getPoint2();
            this.os.println("<< /PatternType 2");
            this.os.println("   /Shading");
            this.os.println("   << /ShadingType 2");
            this.os.println("      /ColorSpace /DeviceRGB");
            this.os.println("      /Coords [" + p1.getX() + " " + p1.getY() + " " + p2.getX() + " " + p2.getY() + "]");
            this.os.println("      /Function");
            this.os.println("      << /FunctionType 2");
            this.os.println("         /Domain [0 1]");
            this.os.println("         /Range [0 1 0 1 0 1]");
            this.os.println("         /C0 [" + rgb1[0] + " " + rgb1[1] + " " + rgb1[2] + "]");
            this.os.println("         /C1 [" + rgb2[0] + " " + rgb2[1] + " " + rgb2[2] + "]");
            this.os.println("         /N 1");
            this.os.println("      >>");
            this.os.println("      /Extend [true true]");
            this.os.println("   >>");
            this.os.println(">>");
            this.os.println("matrix makepattern setpattern");
        } else {
            this.writeComment("Gradient fill not supported by ps level 2. Replacing with intermediate color.");
            this.setColor(PrintColor.mixColor((Color)paint.getColor1(), (Color)paint.getColor2()));
        }
    }

    protected void writePaint(TexturePaint paint) throws IOException {
        BufferedImage img = paint.getImage();
        this.os.println("<< /PatternType 1");
        this.os.println("   /PaintType 1");
        this.os.println("   /TilingType 1");
        this.os.println("   /BBox [0 0 " + img.getWidth() + " " + img.getHeight() + "]");
        this.os.println("   /XStep " + paint.getAnchorRect().getWidth());
        this.os.println("   /YStep " + paint.getAnchorRect().getHeight());
        this.os.println("   /PaintProc");
        this.os.println("   {");
        this.os.println("     begin");
        this.os.println("     /DeviceRGB setcolorspace");
        this.os.println("     0 0 translate");
        this.os.println("     " + img.getWidth() + " " + img.getHeight() + " scale");
        this.os.println("     <<");
        this.os.println("     /ImageType 1");
        this.os.println("     /Width " + img.getWidth());
        this.os.println("     /Height " + img.getWidth());
        this.os.println("     /BitsPerComponent 8");
        this.os.println("     /Decode [0 1 0 1 0 1]");
        this.os.println("     /ImageMatrix [" + img.getWidth() + " 0 0 " + img.getHeight() + " 0 0]");
        this.os.println("     /DataSource ( Z  Z  Z  Z  Z  Z  Z  Z Z ZZ ZZ ZZ ZZ ZZ ZZ ZZ Z)");
        this.os.println("     >> image");
        this.os.println("     end");
        this.os.println("   } bind");
        this.os.println(">>");
        this.os.println("matrix makepattern setpattern");
    }

    protected void writePaint(Paint p) throws IOException {
        this.writeWarning(((Object)((Object)this)).getClass() + ": writePaint(Paint) not implemented for " + p.getClass());
    }

    public void setFont(Font font) {
        if (!font.equals(this.getFont())) {
            this.fontSet = false;
        }
        super.setFont(font);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        this.writeWarning(((Object)((Object)this)).getClass() + ": getDeviceConfiguration() not implemented.");
        return null;
    }

    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        this.writeWarning(((Object)((Object)this)).getClass() + ": hit(Rectangle, Shape, boolean) not implemented.");
        return false;
    }

    public void writeComment(String s) throws IOException {
        this.os.println("% " + s);
    }

    public String toString() {
        return "PSGraphics2D";
    }

    private String convertToUnicodeString(String str) {
        StringBuffer codedString = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            int j;
            char chr = str.charAt(i);
            int cvalue = chr & 0xFF;
            int fvalue = (chr & 0xFF00) >>> 8;
            String cbyte = Integer.toOctalString(cvalue);
            String fbyte = Integer.toOctalString(fvalue);
            codedString.append('\\');
            for (j = 0; j < 3 - fbyte.length(); ++j) {
                codedString.append('0');
            }
            codedString.append(fbyte);
            if (cvalue < 32 || cvalue > 126 || cvalue == 92 || cvalue == 37 || cvalue == 40 || cvalue == 41) {
                codedString.append('\\');
                for (j = 0; j < 3 - cbyte.length(); ++j) {
                    codedString.append('0');
                }
                codedString.append(cbyte);
                continue;
            }
            codedString.append((char)cvalue);
        }
        return codedString.toString();
    }

    private TagString escapeTagString(TagString str) {
        return str;
    }

    private Point2D drawFrameAndBanner(double x, double y, Rectangle2D textSize, double adjustment, boolean framed, Color frameColor, double frameWidth, boolean banner, Color bannerColor, int horizontal, int vertical) throws IOException {
        Paint paint;
        double descent = textSize.getY() + textSize.getHeight();
        x = PSGraphics2D.getXalignment((double)x, (double)textSize.getWidth(), (int)horizontal);
        y = PSGraphics2D.getYalignment((double)y, (double)textSize.getHeight(), (double)descent, (int)vertical);
        double rx = x - adjustment;
        double ry = y - textSize.getHeight() + descent - adjustment;
        double rw = textSize.getWidth() + 2.0 * adjustment;
        double rh = textSize.getHeight() + 2.0 * adjustment;
        if (banner) {
            paint = this.getPaint();
            this.setPaint(bannerColor);
            this.fillRect(rx, ry, rw, rh);
            this.setPaint(paint);
        }
        if (framed) {
            paint = this.getPaint();
            Stroke stroke = this.getStroke();
            this.setPaint(frameColor);
            this.setLineWidth(frameWidth);
            this.drawRect(rx, ry, rw, rh);
            this.setPaint(paint);
            this.setStroke(stroke);
        }
        return new Point2D.Double(x, y);
    }

    private void writeFont() {
        if (this.fontSet) {
            return;
        }
        this.fontSet = true;
        this.writeFont(this.getFont());
    }

    private void writeFont(Font font) {
        String fontName = this.fontTable.fontReference(font, this.isProperty(EMBED_FONTS), this.getProperty(EMBED_FONTS_AS));
        this.os.println("/" + fontName + " findfont " + (double)font.getSize() * 1.0 + " scalefont setfont");
    }

    public void showString(Font font, String str) {
        this.writeFont(font);
        AffineTransform t = font.getTransform();
        if (!t.isIdentity()) {
            this.os.println("gsave");
            this.os.println("[ " + this.fixedPrecision(t.getScaleY()) + " " + this.fixedPrecision(t.getShearX()) + " " + this.fixedPrecision(t.getShearY()) + " " + this.fixedPrecision(t.getScaleX()) + " " + this.fixedPrecision(t.getTranslateX()) + " " + this.fixedPrecision(t.getTranslateY()) + " ] concat");
        }
        this.os.println("(" + this.escapeString(str) + ") show");
        if (!t.isIdentity()) {
            this.os.println("grestore");
        }
    }

    private void showCharacterCodes(String str, double x, double y) {
        try {
            this.os.println(this.fixedPrecision(x) + " " + this.fixedPrecision(y) + " moveto");
            this.os.println("q 1 -1 scale");
            if (!this.isProperty(EMBED_FONTS) && PSGraphics2D.isComposite(this.fontTable.fontReference(this.getFont(), this.isProperty(EMBED_FONTS), this.getProperty(EMBED_FONTS_AS)))) {
                this.showString(this.getFont(), str);
            } else {
                FontUtilities.showString((Font)this.getFont(), (String)str, (CharTable)this.fontTable.getEncodingTable(), (FontUtilities.ShowString)this);
            }
            this.os.println("Q");
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    private void setPSColor(Color c, boolean fillColor) {
        if (c != null) {
            if (c instanceof MappedColor) {
                MappedColor mc = (MappedColor)c;
                if (!fillColor) {
                    if (mc.getBrightness() == 0) {
                        this.os.println(mc.getColorTag() + " vg&C");
                    } else {
                        this.os.println(mc.getColorTag() + " " + mc.getBrightness() + " darken vg&C");
                    }
                } else if (mc.getBrightness() == 0) {
                    this.os.println(mc.getColorTag() + " vg&DFC");
                } else {
                    this.os.println(mc.getColorTag() + " " + mc.getBrightness() + " darken vg&DFC");
                }
            } else {
                Color pc = this.getPrintColor(c);
                double red = (double)pc.getRed() / 255.0;
                double green = (double)pc.getGreen() / 255.0;
                double blue = (double)pc.getBlue() / 255.0;
                this.os.print(this.fixedPrecision(red) + " " + this.fixedPrecision(green) + " " + this.fixedPrecision(blue) + " ");
                this.os.println(fillColor ? "rg" : "RG");
            }
        }
    }

    private String getPSAlignment(int vertical, int horizontal) {
        if (vertical >= 0 && vertical < 4 && horizontal >= 0 && horizontal < 4) {
            return psAlignments[horizontal][vertical];
        }
        return "0";
    }

    private static boolean isComposite(String name) {
        return compositeFonts.containsKey(name);
    }

    public String fixedPrecision(double d) {
        return this.scientific.format(d);
    }

    static {
        int i;
        rootKey = PSGraphics2D.class.getName();
        BACKGROUND = rootKey + "." + "Background";
        BACKGROUND_COLOR = rootKey + "." + "BackgroundColor";
        PAGE_SIZE = rootKey + "." + "PageSize";
        PAGE_MARGINS = rootKey + "." + "PageMargins";
        ORIENTATION = rootKey + "." + "Orientation";
        FIT_TO_PAGE = rootKey + "." + "FitToPage";
        EMBED_FONTS = rootKey + "." + "EmbedFonts";
        EMBED_FONTS_AS = rootKey + "." + "EmbedFontsAs";
        FOR = rootKey + "." + "For";
        TITLE = rootKey + "." + "Title";
        PREVIEW = rootKey + ".Preview";
        PREVIEW_BITS = rootKey + ".PreviewBits";
        WRITE_IMAGES_AS = rootKey + "." + "WriteImagesAs";
        defaultProperties = new UserProperties();
        defaultProperties.setProperty(BACKGROUND, false);
        defaultProperties.setProperty(BACKGROUND_COLOR, Color.GRAY);
        defaultProperties.setProperty(PAGE_SIZE, "International");
        defaultProperties.setProperty(PAGE_MARGINS, PageConstants.getMargins((String)"Small"));
        defaultProperties.setProperty(ORIENTATION, "Portrait");
        defaultProperties.setProperty(FIT_TO_PAGE, true);
        defaultProperties.setProperty(EMBED_FONTS, false);
        defaultProperties.setProperty(EMBED_FONTS_AS, "Type3");
        defaultProperties.setProperty(FOR, "");
        defaultProperties.setProperty(TITLE, "");
        defaultProperties.setProperty(PREVIEW, false);
        defaultProperties.setProperty(PREVIEW_BITS, 8);
        defaultProperties.setProperty(WRITE_IMAGES_AS, "Smallest Size");
        enableClip = true;
        psSymbolNames = new String[10];
        compositeFonts = new Hashtable();
        for (i = 0; i < 10; ++i) {
            PSGraphics2D.psSymbolNames[i] = "plus";
        }
        PSGraphics2D.psSymbolNames[0] = "vline";
        PSGraphics2D.psSymbolNames[1] = "hline";
        PSGraphics2D.psSymbolNames[2] = "plus";
        PSGraphics2D.psSymbolNames[3] = "cross";
        PSGraphics2D.psSymbolNames[4] = "star";
        PSGraphics2D.psSymbolNames[5] = "dot";
        PSGraphics2D.psSymbolNames[6] = "box";
        PSGraphics2D.psSymbolNames[7] = "triup";
        PSGraphics2D.psSymbolNames[8] = "tridn";
        PSGraphics2D.psSymbolNames[9] = "diamond";
        compositeFonts.put("SansSerif", "");
        compositeFonts.put("SansSerif-Bold", "");
        compositeFonts.put("SansSerif-Italic", "");
        compositeFonts.put("SansSerif-BoldItalic", "");
        compositeFonts.put("Serif", "");
        compositeFonts.put("Serif-Bold", "");
        compositeFonts.put("Serif-Italic", "");
        compositeFonts.put("Serif-BoldItalic", "");
        compositeFonts.put("Monospaced", "");
        compositeFonts.put("Monospaced-Bold", "");
        compositeFonts.put("Monospaced-Italic", "");
        compositeFonts.put("Monospaced-BoldItalic", "");
        compositeFonts.put("Dialog", "");
        compositeFonts.put("Dialog-Bold", "");
        compositeFonts.put("Dialog-Italic", "");
        compositeFonts.put("Dialog-BoldItalic", "");
        compositeFonts.put("DialogInput", "");
        compositeFonts.put("DialogInput-Bold", "");
        compositeFonts.put("DialogInput-Italic", "");
        compositeFonts.put("DialogInput-BoldItalic", "");
        compositeFonts.put("Typewriter", "");
        compositeFonts.put("Typewriter-Bold", "");
        compositeFonts.put("Typewriter-Italic", "");
        compositeFonts.put("Typewriter-BoldItalic", "");
        psAlignments = new String[4][4];
        for (i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                PSGraphics2D.psAlignments[i][j] = "0";
            }
        }
        PSGraphics2D.psAlignments[1][1] = "0";
        PSGraphics2D.psAlignments[1][2] = "1";
        PSGraphics2D.psAlignments[1][0] = "2";
        PSGraphics2D.psAlignments[1][3] = "3";
        PSGraphics2D.psAlignments[3][1] = "4";
        PSGraphics2D.psAlignments[3][2] = "5";
        PSGraphics2D.psAlignments[3][0] = "6";
        PSGraphics2D.psAlignments[3][3] = "7";
        PSGraphics2D.psAlignments[2][1] = "8";
        PSGraphics2D.psAlignments[2][2] = "9";
        PSGraphics2D.psAlignments[2][0] = "10";
        PSGraphics2D.psAlignments[2][3] = "11";
    }
}

