/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AidaUtils {
    private static Pattern pattern = Pattern.compile("(\\w+)\\s*((=\\s*(\"(.*?)\"|([^,;$]*)))\\s*)?(,|;|$)");

    public static Map parseOptions(String options) {
        if (options == null || options.trim().length() == 0) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> hashValues = new HashMap<String, String>();
        Matcher matcher = pattern.matcher(options);
        while (matcher.find()) {
            String key = matcher.group(1);
            String value = matcher.group(5);
            if (value == null && (value = matcher.group(6)) != null) {
                value = value.trim();
            }
            if (value == null) {
                value = "true";
            }
            hashValues.put(key, value);
            if (matcher.end() != options.length()) continue;
            return hashValues;
        }
        throw new IllegalArgumentException("Invalid options: " + options);
    }

    public static String[] stringToArray(String path) {
        String[] result = null;
        if (path == null || path.equals("")) {
            return result;
        }
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        ArrayList<String> list = new ArrayList<String>(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            while (token.endsWith("\\")) {
                token = token.substring(0, token.length() - 1) + "/";
                if (!tokenizer.hasMoreTokens()) continue;
                token = token + tokenizer.nextToken();
            }
            list.add(token);
        }
        result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    public static String modifyName(String name) {
        if (name.indexOf(47) < 0) {
            return name;
        }
        String newName = "";
        int index = -1;
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) != '/' || i > 0 && name.charAt(i - 1) == '\\') continue;
            if (i > index) {
                newName = newName + name.substring(index + 1, i) + "\\/";
                index = i;
                continue;
            }
            if (i != index) continue;
            newName = newName + "\\/";
        }
        newName = newName + name.substring(index + 1);
        return newName;
    }

    public static String parseName(String pathString) {
        if (pathString == null || pathString.equals("/")) {
            return "";
        }
        String[] path = AidaUtils.stringToArray(pathString);
        String name = path[path.length - 1];
        return name;
    }

    public static String parseDirName(String pathString) {
        if (pathString == null || pathString.equals("/")) {
            return pathString;
        }
        String dirName = "";
        String[] path = AidaUtils.stringToArray(pathString);
        if (path.length <= 1) {
            return dirName;
        }
        dirName = "/";
        for (int i = 0; i < path.length - 1; ++i) {
            dirName = dirName + path[i] + "/";
        }
        return dirName;
    }
}

