/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.ref.function.AbstractDevModelFunction;

public class ExponentModelFunction
extends AbstractDevModelFunction {
    public ExponentModelFunction(String str) {
        if (!str.toLowerCase().startsWith("e")) {
            throw new IllegalArgumentException("Exponent Function Qualifier must start with \"e\"");
        }
        int dim = Integer.parseInt(str.substring(1));
        this.setDimension(dim);
        this.setNumberOfParameters(dim + 1);
        this.setCodeletString("ExponentModelFunction");
        this.setNormalization(true, false);
    }

    public int dimension() {
        return this.dimension;
    }

    public int numberOfParameters() {
        return this.p.length;
    }

    public double functionValue(double[] var) {
        double val = 1.0;
        for (int i = 0; i < this.dimension; ++i) {
            val *= Math.exp(this.p[i] * var[i]);
        }
        return val * this.p[this.numberOfParameters() - 1];
    }

    public static void main(String[] args) {
        System.out.println("ExponentModelFunction.main: creating Exponential Function:: " + args[0]);
        ExponentModelFunction exp = new ExponentModelFunction(args[0]);
        double[] pars = new double[]{1.0, 2.0};
        exp.setParameters(pars);
        for (int i = 0; i < 10; ++i) {
            System.out.println("x = " + i + ", f = " + exp.value(new double[]{(double)i * 1.0}));
        }
    }
}

