/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.IAnalysisFactory;
import hep.aida.IBaseHistogram;
import hep.aida.IFunction;
import hep.aida.IFunctionFactory;
import hep.aida.IHistogram1D;
import hep.aida.IHistogramFactory;
import hep.aida.IModelFunction;
import hep.aida.IPlotter;
import hep.aida.IPlotterFactory;
import hep.aida.ITree;
import hep.aida.ref.fitter.Fitter;
import hep.aida.ref.function.AbstractDevModelFunction;
import java.io.IOException;
import java.util.Random;

public class PolynomialModelFunction
extends AbstractDevModelFunction {
    public PolynomialModelFunction(String str) {
        if (!str.toLowerCase().startsWith("p")) {
            throw new IllegalArgumentException("PolynomialModelFunction Function Qualifier must start with \"P\"");
        }
        int dim = Integer.parseInt(str.substring(1));
        this.setDimension(1);
        this.setNumberOfParameters(dim + 1);
        this.setCodeletString("PolynomialModelFunction of power " + dim);
        this.setTitle(str);
    }

    public int dimension() {
        return this.dimension;
    }

    public int numberOfParameters() {
        return this.p.length;
    }

    public double functionValue(double[] var) {
        double val = 0.0;
        for (int i = 1; i < this.numberOfParameters(); ++i) {
            val += this.p[i] * Math.pow(var[0], i);
        }
        return val + this.p[0];
    }

    public static void main(String[] args) throws IOException {
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree = af.createTreeFactory().create();
        IHistogramFactory hf = af.createHistogramFactory(tree);
        IFunctionFactory ff = af.createFunctionFactory(tree);
        IPlotterFactory pf = af.createPlotterFactory();
        IPlotter plotter = pf.create("JAS Plotter");
        plotter.createRegions(2, 2);
        IHistogram1D hist1 = hf.createHistogram1D("hist1", "hist1", 100, -5.0, 5.0);
        IHistogram1D hist2 = hf.createHistogram1D("hist2", "hist2", 100, -5.0, 5.0);
        Random r = new Random();
        for (int i = 0; i < 40000; ++i) {
            double y;
            double x = 10.0 * (r.nextDouble() - 0.5);
            double poly = x * x - 4.0 * x + 5.5;
            if (!(poly >= (y = r.nextDouble() * 50.5))) continue;
            hist1.fill(x);
            hist2.fill(x);
        }
        IModelFunction f1 = (IModelFunction)ff.createFunctionByName("f1", "p2");
        IModelFunction f2 = (IModelFunction)ff.createFunctionByName("f2", "p2");
        IModelFunction f3 = (IModelFunction)ff.createFunctionByName("f3", "p2");
        IModelFunction f4 = (IModelFunction)ff.createFunctionByName("f4", "p2");
        double[] chi2Pars = new double[]{380.0, 0.1, -20.0};
        f1.setParameters(chi2Pars);
        f2.setParameters(chi2Pars);
        for (int i = -5; i < 10; ++i) {
            System.out.println("x =\t" + i + "  \tf = " + f1.value(new double[]{(double)i * 1.0}) + "  \tgrad = " + f1.gradient(new double[]{(double)i * 1.0})[0] + "  \tparGrad = " + f1.parameterGradient(new double[]{(double)i * 1.0})[0] + "   " + f1.parameterGradient(new double[]{(double)i * 1.0})[1] + "   " + f1.parameterGradient(new double[]{(double)i * 1.0})[2]);
        }
        plotter.currentRegion().plot((IBaseHistogram)hist1);
        plotter.currentRegion().plot((IFunction)f1);
        Fitter fitter = new Fitter("chi2", "minuit", null);
        fitter.fitParameterSettings("p0").setStepSize(10.0);
        fitter.fitParameterSettings("p1").setStepSize(1.0);
        fitter.fitParameterSettings("p2").setStepSize(5.0);
        fitter.fit((IBaseHistogram)hist1, (IFunction)f2);
        plotter.next();
        plotter.currentRegion().plot((IBaseHistogram)hist1);
        plotter.currentRegion().plot((IFunction)f2);
        f3.normalize(true);
        f4.normalize(true);
        double[] MLPars = new double[]{0.1, -20.0};
        f3.setParameters(MLPars);
        f4.setParameters(MLPars);
        for (int i = -5; i < 10; ++i) {
            System.out.println("x =\t" + i + "  \tf = " + f3.value(new double[]{(double)i * 1.0}) + "  \tgrad = " + f3.gradient(new double[]{(double)i * 1.0})[0] + "  \tparGrad = " + f3.parameterGradient(new double[]{(double)i * 1.0})[0] + "   " + f3.parameterGradient(new double[]{(double)i * 1.0})[1] + "   " + f3.parameterGradient(new double[]{(double)i * 1.0})[2]);
        }
        plotter.next();
        plotter.currentRegion().plot((IBaseHistogram)hist2);
        plotter.currentRegion().plot((IFunction)f3);
        plotter.next();
        plotter.currentRegion().plot((IBaseHistogram)hist2);
        plotter.currentRegion().plot((IFunction)f4);
        plotter.show();
    }
}

