/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.histogram;

import hep.aida.IAxis;
import hep.aida.IHistogram1D;
import hep.aida.ref.AidaUtils;
import hep.aida.ref.event.IsObservable;
import hep.aida.ref.histogram.Histogram;
import hep.aida.ref.histogram.UnfillableHistogramException;
import hep.aida.ref.histogram.binner.BasicBinner1D;
import hep.aida.ref.histogram.binner.Binner1D;
import hep.aida.ref.histogram.binner.EfficiencyBinner1D;
import java.util.Map;

public class Histogram1D
extends Histogram
implements IHistogram1D,
IsObservable {
    private double mean = 0.0;
    private double rms = 0.0;
    private IAxis xAxis;
    private Binner1D binner1D;

    public Histogram1D() {
        super("", "", 1, "");
    }

    public Histogram1D(String name, String title, IAxis axis) {
        this(name, title, axis, "");
    }

    protected Histogram1D(String name, String title, IAxis axis, String options) {
        super(name, title, 1, options);
        this.initHistogram1D(axis, options);
    }

    public void fill(double x) {
        this.fill(x, 1.0);
    }

    public void fill(double x, double weight) {
        if (!this.isFillable()) {
            throw new UnfillableHistogramException();
        }
        ++this.allEntries;
        if (!Double.isNaN(x) && !Double.isNaN(weight)) {
            int coordToIndex = this.xAxis.coordToIndex(x);
            int bin = this.mapBinNumber(coordToIndex, this.axis());
            this.binner1D.fill(bin, x, weight);
            if (coordToIndex >= 0 || this.useOutflows()) {
                ++this.validEntries;
                this.mean += x * weight;
                this.rms += x * x * weight;
                this.sumOfWeights += weight;
                this.sumOfWeightsSquared += weight * weight;
            }
        }
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public void reset() {
        this.binner1D.clear();
        this.mean = 0.0;
        this.rms = 0.0;
        super.reset();
    }

    public int extraEntries() {
        return this.binEntries(-2) + this.binEntries(-1);
    }

    public double sumAllBinHeights() {
        double sum = 0.0;
        int i = this.xAxis.bins();
        while (--i >= -2) {
            sum += this.binHeight(i);
        }
        return sum;
    }

    public double sumExtraBinHeights() {
        return this.binHeight(-2) + this.binHeight(-1);
    }

    public double minBinHeight() {
        double min = Double.NaN;
        for (int i = 0; i < this.xAxis.bins(); ++i) {
            if (!Double.isNaN(min) && !(this.binHeight(i) <= min)) continue;
            min = this.binHeight(i);
        }
        return min;
    }

    public double maxBinHeight() {
        double max = Double.NaN;
        for (int i = 0; i < this.xAxis.bins(); ++i) {
            if (!Double.isNaN(max) && !(this.binHeight(i) >= max)) continue;
            max = this.binHeight(i);
        }
        return max;
    }

    public int binEntries(int index) {
        return this.binner1D.entries(this.mapBinNumber(index, this.axis()));
    }

    public double binHeight(int index) {
        return this.binner1D.height(this.mapBinNumber(index, this.axis()));
    }

    public double binError(int index) {
        return this.binner1D.plusError(this.mapBinNumber(index, this.axis()));
    }

    public double mean() {
        if (this.validEntries != 0) {
            return this.mean / this.sumOfWeights;
        }
        return 0.0;
    }

    public double rms() {
        if (this.validEntries != 0) {
            return Math.sqrt(this.rms / this.sumOfWeights - this.mean * this.mean / this.sumOfWeights / this.sumOfWeights);
        }
        return 0.0;
    }

    public IAxis axis() {
        return this.xAxis;
    }

    public int coordToIndex(double coord) {
        return this.axis().coordToIndex(coord);
    }

    public void scale(double scaleFactor) throws IllegalArgumentException {
        if (scaleFactor <= 0.0) {
            throw new IllegalArgumentException("Illegal scale factor " + scaleFactor + " it has to be positive");
        }
        this.binner1D.scale(scaleFactor);
        this.mean *= scaleFactor;
        this.rms *= scaleFactor;
        this.sumOfWeights *= scaleFactor;
        this.sumOfWeightsSquared *= scaleFactor * scaleFactor;
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public void add(IHistogram1D hist) throws IllegalArgumentException {
        if (!this.axis().equals(hist.axis())) {
            throw new IllegalArgumentException("Cannot add. Incompatible histogram binning!");
        }
        int bins = this.axis().bins() + 2;
        double[] newHeights = new double[bins];
        double[] newErrors = new double[bins];
        double[] newMeans = new double[bins];
        double[] newRmss = new double[bins];
        int[] newEntries = new int[bins];
        for (int i = -2; i < bins - 2; ++i) {
            double height1 = this.binHeight(i);
            double height2 = hist.binHeight(i);
            double h = height1 + height2;
            double mean1 = this.binMean(i);
            double mean2 = hist.binMean(i);
            double m = 0.0;
            double rms1 = this.binRms(i);
            double rms2 = ((Histogram1D)hist).binRms(i);
            double r = 0.0;
            if (h != 0.0) {
                m = (mean1 * height1 + mean2 * height2) / (height1 + height2);
                r = Math.sqrt((rms1 * rms1 * height1 + mean1 * mean1 * height1 + (rms2 * rms2 * height2 + mean2 * mean2 * height2)) / h - m * m);
            }
            int bin = this.mapBinNumber(i, this.axis());
            newHeights[bin] = h;
            newErrors[bin] = Math.sqrt(Math.pow(this.binError(i), 2.0) + Math.pow(hist.binError(i), 2.0));
            newEntries[bin] = this.binEntries(i) + hist.binEntries(i);
            newMeans[bin] = m;
            newRmss[bin] = r;
        }
        this.setContents(newHeights, newErrors, newEntries, newMeans, newRmss);
    }

    public void setRms(double rms) {
        this.rms = rms * rms * this.sumOfWeights + this.mean() * this.mean() * this.sumOfWeights;
    }

    public void setMean(double mean) {
        this.mean = mean * this.sumOfWeights;
    }

    public double binMean(int index) {
        return this.binner1D.mean(this.mapBinNumber(index, this.axis()));
    }

    public double binRms(int index) {
        return this.binner1D.rms(this.mapBinNumber(index, this.axis()));
    }

    public void setBinError(int bin, double error) {
        this.binner1D.setBinContent(this.mapBinNumber(bin, this.axis()), this.binEntries(bin), this.binHeight(bin), error, error, this.binMean(bin), this.binRms(bin));
    }

    public void setContents(double[] heights, double[] errors, int[] entries, double[] means, double[] rmss) {
        this.reset();
        for (int i = 0; i < this.axis().bins() + 2; ++i) {
            int mi = i == 0 ? -2 : (i == this.axis().bins() + 1 ? -1 : i - 1);
            double h = heights[i];
            int e = entries != null ? entries[i] : (int)h;
            double m = means != null ? means[i] : (this.axis().binLowerEdge(mi) + this.axis().binUpperEdge(mi)) / 2.0;
            double r = rmss != null ? rmss[i] : (this.axis().binUpperEdge(mi) - this.axis().binLowerEdge(mi)) / Math.sqrt(12.0);
            this.binner1D.setBinContent(i, e, h, errors[i], errors[i], m, r);
            this.allEntries += e;
            if (mi < 0 && !this.useOutflows()) continue;
            if (!Double.isNaN(m) && !Double.isInfinite(m)) {
                this.mean += m * h;
                this.rms += r * r * h + m * m * h;
            }
            this.validEntries += e;
            this.sumOfWeights += h;
            this.sumOfWeightsSquared += h * h;
        }
    }

    public void initHistogram1D(IAxis xAxis, String options) {
        this.xAxis = xAxis;
        Map optionMap = AidaUtils.parseOptions(options);
        String type = (String)optionMap.get("type");
        if (type == null || type.equals("default")) {
            this.binner1D = new BasicBinner1D(xAxis.bins() + 2);
        } else if (type.equals("efficiency")) {
            this.binner1D = new EfficiencyBinner1D(xAxis.bins() + 2);
        } else {
            throw new IllegalArgumentException("Wrong histogram type " + type);
        }
        String useOutflowsString = (String)optionMap.get("useOutflowsInStatistics");
        if (useOutflowsString != null) {
            this.setUseOutflows(Boolean.valueOf(useOutflowsString));
        }
        this.reset();
    }
}

