/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.histogram;

import hep.aida.IAxis;
import java.util.Arrays;

public class VariableAxis
implements IAxis {
    private double min;
    private int bins;
    private double[] edges;

    public VariableAxis(double[] edges) {
        if (edges.length < 1) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < edges.length - 1; ++i) {
            if (!(edges[i + 1] <= edges[i])) continue;
            throw new IllegalArgumentException("edges must be sorted ascending and must not contain multiple identical values");
        }
        this.min = edges[0];
        this.bins = edges.length - 1;
        this.edges = (double[])edges.clone();
    }

    public double binCentre(int index) {
        return (this.binLowerEdge(index) + this.binUpperEdge(index)) / 2.0;
    }

    public double binLowerEdge(int index) {
        if (index == -2) {
            return Double.NEGATIVE_INFINITY;
        }
        if (index == -1) {
            return this.upperEdge();
        }
        return this.edges[index];
    }

    public int bins() {
        return this.bins;
    }

    public double binUpperEdge(int index) {
        if (index == -2) {
            return this.lowerEdge();
        }
        if (index == -1) {
            return Double.POSITIVE_INFINITY;
        }
        return this.edges[index + 1];
    }

    public double binWidth(int index) {
        return this.binUpperEdge(index) - this.binLowerEdge(index);
    }

    public int coordToIndex(double coord) {
        if (coord < this.min) {
            return -2;
        }
        int index = Arrays.binarySearch(this.edges, coord);
        if (index < 0) {
            index = -index - 1 - 1;
        }
        if (index >= this.bins) {
            return -1;
        }
        return index;
    }

    public double lowerEdge() {
        return this.min;
    }

    protected static String toString(double[] array) {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        int maxIndex = array.length - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            buf.append(array[i]);
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public double upperEdge() {
        return this.edges[this.edges.length - 1];
    }

    public boolean isFixedBinning() {
        return false;
    }

    public boolean equals(Object o) {
        if (!(o instanceof VariableAxis)) {
            return false;
        }
        VariableAxis other = (VariableAxis)o;
        if (this.bins != other.bins) {
            return false;
        }
        for (int i = 0; i < this.bins; ++i) {
            if (this.binUpperEdge(i) == other.binUpperEdge(i) && this.binLowerEdge(i) == other.binLowerEdge(i)) continue;
            return false;
        }
        return true;
    }
}

