/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.histogram.binner;

import hep.aida.ref.histogram.binner.Binner3D;

public class BasicBinner3D
implements Binner3D {
    private int[][][] entries;
    private double[][][] heights;
    private double[][][] plusErrors;
    private double[][][] meansX;
    private double[][][] rmssX;
    private double[][][] meansY;
    private double[][][] rmssY;
    private double[][][] meansZ;
    private double[][][] rmssZ;
    private int xBins;
    private int yBins;
    private int zBins;

    public BasicBinner3D(int xBins, int yBins, int zBins) {
        if (xBins < 0) {
            throw new IllegalArgumentException("Number of bins cannot be negative!!! " + xBins);
        }
        if (yBins < 0) {
            throw new IllegalArgumentException("Number of bins cannot be negative!!! " + yBins);
        }
        if (zBins < 0) {
            throw new IllegalArgumentException("Number of bins cannot be negative!!! " + zBins);
        }
        this.setNumberOfBins(xBins, yBins, zBins);
    }

    public void fill(int xBin, int yBin, int zBin, double x, double y, double z, double weight) {
        int[] nArray = this.entries[xBin][yBin];
        int n = zBin;
        nArray[n] = nArray[n] + 1;
        double[] dArray = this.heights[xBin][yBin];
        int n2 = zBin;
        dArray[n2] = dArray[n2] + weight;
        double[] dArray2 = this.plusErrors[xBin][yBin];
        int n3 = zBin;
        dArray2[n3] = dArray2[n3] + weight * weight;
        double[] dArray3 = this.meansX[xBin][yBin];
        int n4 = zBin;
        dArray3[n4] = dArray3[n4] + x * weight;
        double[] dArray4 = this.rmssX[xBin][yBin];
        int n5 = zBin;
        dArray4[n5] = dArray4[n5] + x * x * weight;
        double[] dArray5 = this.meansY[xBin][yBin];
        int n6 = zBin;
        dArray5[n6] = dArray5[n6] + y * weight;
        double[] dArray6 = this.rmssY[xBin][yBin];
        int n7 = zBin;
        dArray6[n7] = dArray6[n7] + y * y * weight;
        double[] dArray7 = this.meansZ[xBin][yBin];
        int n8 = zBin;
        dArray7[n8] = dArray7[n8] + z * weight;
        double[] dArray8 = this.rmssZ[xBin][yBin];
        int n9 = zBin;
        dArray8[n9] = dArray8[n9] + z * z * weight;
    }

    public void clear() {
        this.createArrays(this.xBins, this.yBins, this.zBins);
    }

    private void setNumberOfBins(int xBins, int yBins, int zBins) {
        this.xBins = xBins;
        this.yBins = yBins;
        this.zBins = zBins;
        this.createArrays(xBins, yBins, zBins);
    }

    public int entries(int xBin, int yBin, int zBin) {
        return this.entries[xBin][yBin][zBin];
    }

    public double height(int xBin, int yBin, int zBin) {
        return this.heights[xBin][yBin][zBin];
    }

    public double plusError(int xBin, int yBin, int zBin) {
        return Math.sqrt(this.plusErrors[xBin][yBin][zBin]);
    }

    public double minusError(int xBin, int yBin, int zBin) {
        return this.plusError(xBin, yBin, zBin);
    }

    public double meanX(int xBin, int yBin, int zBin) {
        double h = this.height(xBin, yBin, zBin);
        if (h != 0.0) {
            return this.meansX[xBin][yBin][zBin] / h;
        }
        return 0.0;
    }

    public double meanY(int xBin, int yBin, int zBin) {
        double h = this.height(xBin, yBin, zBin);
        if (h != 0.0) {
            return this.meansY[xBin][yBin][zBin] / h;
        }
        return 0.0;
    }

    public double meanZ(int xBin, int yBin, int zBin) {
        double h = this.height(xBin, yBin, zBin);
        if (h != 0.0) {
            return this.meansZ[xBin][yBin][zBin] / h;
        }
        return 0.0;
    }

    public double rmsX(int xBin, int yBin, int zBin) {
        double h = this.height(xBin, yBin, zBin);
        double m = this.meanX(xBin, yBin, zBin);
        if (h != 0.0) {
            return Math.sqrt(Math.abs(this.rmssX[xBin][yBin][zBin] / h - m * m));
        }
        return 0.0;
    }

    public double rmsY(int xBin, int yBin, int zBin) {
        double h = this.height(xBin, yBin, zBin);
        double m = this.meanY(xBin, yBin, zBin);
        if (h != 0.0) {
            return Math.sqrt(Math.abs(this.rmssY[xBin][yBin][zBin] / h - m * m));
        }
        return 0.0;
    }

    public double rmsZ(int xBin, int yBin, int zBin) {
        double h = this.height(xBin, yBin, zBin);
        double m = this.meanZ(xBin, yBin, zBin);
        if (h != 0.0) {
            return Math.sqrt(Math.abs(this.rmssZ[xBin][yBin][zBin] / h - m * m));
        }
        return 0.0;
    }

    public void setBinContent(int xBin, int yBin, int zBin, int entries, double height, double plusError, double minusError, double meanX, double rmsX, double meanY, double rmsY, double meanZ, double rmsZ) {
        this.heights[xBin][yBin][zBin] = height;
        this.entries[xBin][yBin][zBin] = entries;
        this.plusErrors[xBin][yBin][zBin] = plusError * plusError;
        this.meansX[xBin][yBin][zBin] = 0.0;
        this.rmssX[xBin][yBin][zBin] = 0.0;
        this.meansY[xBin][yBin][zBin] = 0.0;
        this.rmssY[xBin][yBin][zBin] = 0.0;
        this.meansZ[xBin][yBin][zBin] = 0.0;
        this.rmssZ[xBin][yBin][zBin] = 0.0;
        if (height != 0.0) {
            this.meansX[xBin][yBin][zBin] = meanX * height;
            this.rmssX[xBin][yBin][zBin] = rmsX * rmsX * height + meanX * meanX * height;
            this.meansY[xBin][yBin][zBin] = meanY * height;
            this.rmssY[xBin][yBin][zBin] = rmsY * rmsY * height + meanY * meanY * height;
            this.meansZ[xBin][yBin][zBin] = meanZ * height;
            this.rmssZ[xBin][yBin][zBin] = rmsZ * rmsZ * height + meanZ * meanZ * height;
        }
    }

    public void scale(double scaleFactor) {
        for (int xBin = 0; xBin < this.xBins; ++xBin) {
            for (int yBin = 0; yBin < this.yBins; ++yBin) {
                int zBin = 0;
                while (zBin < this.zBins) {
                    double[] dArray = this.heights[xBin][yBin];
                    int n = zBin;
                    dArray[n] = dArray[n] * scaleFactor;
                    double[] dArray2 = this.plusErrors[xBin][yBin];
                    int n2 = zBin;
                    dArray2[n2] = dArray2[n2] * (scaleFactor * scaleFactor);
                    double[] dArray3 = this.meansX[xBin][yBin];
                    int n3 = zBin;
                    dArray3[n3] = dArray3[n3] * scaleFactor;
                    double[] dArray4 = this.rmssX[xBin][yBin];
                    int n4 = zBin;
                    dArray4[n4] = dArray4[n4] * scaleFactor;
                    double[] dArray5 = this.meansY[xBin][yBin];
                    int n5 = zBin;
                    dArray5[n5] = dArray5[n5] * scaleFactor;
                    double[] dArray6 = this.rmssY[xBin][yBin];
                    int n6 = zBin;
                    dArray6[n6] = dArray6[n6] * scaleFactor;
                    double[] dArray7 = this.meansZ[xBin][yBin];
                    int n7 = zBin;
                    dArray7[n7] = dArray7[n7] * scaleFactor;
                    double[] dArray8 = this.rmssZ[xBin][yBin];
                    int n8 = zBin++;
                    dArray8[n8] = dArray8[n8] * scaleFactor;
                }
            }
        }
    }

    private void createArrays(int xBins, int yBins, int zBins) {
        this.entries = new int[xBins][yBins][zBins];
        this.heights = new double[xBins][yBins][zBins];
        this.plusErrors = new double[xBins][yBins][zBins];
        this.meansX = new double[xBins][yBins][zBins];
        this.rmssX = new double[xBins][yBins][zBins];
        this.meansY = new double[xBins][yBins][zBins];
        this.rmssY = new double[xBins][yBins][zBins];
        this.meansZ = new double[xBins][yBins][zBins];
        this.rmssZ = new double[xBins][yBins][zBins];
    }
}

