/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.optimizer.minuit;

import hep.aida.IFunction;
import hep.aida.ref.optimizer.AbstractOptimizer;
import hep.aida.ref.optimizer.OptimizerResult;
import hep.aida.ref.optimizer.minuit.MinuitCommands;
import hep.aida.ref.optimizer.minuit.MinuitOptimizerConfiguration;

public class MinuitOptimizer
extends AbstractOptimizer {
    private MinuitCommands minuitCommands;

    public MinuitOptimizer() {
        this.configuration = new MinuitOptimizerConfiguration(this);
        this.minuitCommands = new MinuitCommands(this);
        this.result = new OptimizerResult();
        this.domainConstraint = null;
    }

    public void optimize() {
        this.minuitCommands.resetMinuit();
        if (this.function == null) {
            throw new IllegalArgumentException("Cannot optimize!! The function was not set correctely!");
        }
        this.minuitCommands.setFunction(this.function, this);
        String method = this.configuration.method();
        int maxIterations = this.configuration.maxIterations();
        double tolerance = this.configuration.tolerance();
        this.minuitCommands.optimize(method, maxIterations, tolerance);
        this.minuitCommands.updateFunction(this);
        String[] varNames = this.function.variableNames();
        double[] pars = new double[varNames.length];
        for (int i = 0; i < varNames.length; ++i) {
            pars[i] = this.variableSettings(varNames[i]).value();
        }
        this.result.setParameters(pars);
        this.result.setCovarianceMatrix(this.minuitCommands.getCovarianceMatrix());
        this.result.setOptimizationStatus(this.minuitCommands.getStatus());
    }

    public void minosAnalysis() {
        this.minuitCommands.minos();
    }

    public void setFunction(IFunction function) {
        super.setFunction(function);
        this.minuitCommands.setFunction(function, this);
    }

    protected MinuitCommands commands() {
        return this.minuitCommands;
    }

    public boolean canCalculateContours() {
        return true;
    }

    public double[][] calculateContour(String parName1, String parName2, int nPoints, double nSigmas) {
        return this.commands().calculateContour(parName1, parName2, nPoints, nSigmas);
    }

    public void reset() {
        super.reset();
        this.minuitCommands.resetMinuit();
    }

    public boolean acceptsConstraints() {
        return true;
    }
}

