/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.adapter;

import hep.aida.IHistogram;
import hep.aida.IHistogram2D;
import hep.aida.ref.plotter.adapter.AIDAHistogramAdapter;
import hep.aida.ref.plotter.adapter.AIDAHistogramStatistics2D;
import jas.hist.HasStatistics;
import jas.hist.Rebinnable2DHistogramData;
import jas.hist.Statistics;

class AIDAHistogramAdapter2D
extends AIDAHistogramAdapter
implements Rebinnable2DHistogramData,
HasStatistics {
    private IHistogram2D histo;

    AIDAHistogramAdapter2D(IHistogram2D histo) {
        super((IHistogram)histo);
        this.histo = histo;
    }

    public double[][][] rebin(int xbins, double xmin, double xmax, int ybins, double ymin, double ymax, boolean wantErrors, boolean hurry, boolean overflow) {
        this.setValid();
        double[][][] data = new double[2][this.histo.xAxis().bins()][this.histo.yAxis().bins()];
        for (int i = 0; i < this.histo.xAxis().bins(); ++i) {
            for (int j = 0; j < this.histo.yAxis().bins(); ++j) {
                data[0][i][j] = this.histo.binHeight(i, j);
                if (Double.isInfinite(data[0][i][j])) {
                    data[0][i][j] = Double.NaN;
                }
                data[1][i][j] = this.histo.binError(i, j);
            }
        }
        return data;
    }

    public double getXMin() {
        return this.histo.xAxis().lowerEdge();
    }

    public double getXMax() {
        return this.histo.xAxis().upperEdge();
    }

    public double getYMin() {
        return this.histo.yAxis().lowerEdge();
    }

    public double getYMax() {
        return this.histo.yAxis().upperEdge();
    }

    public int getXBins() {
        return this.histo.xAxis().bins();
    }

    public int getYBins() {
        return this.histo.yAxis().bins();
    }

    public boolean isRebinnable() {
        return false;
    }

    public int getXAxisType() {
        return 1;
    }

    public int getYAxisType() {
        return 1;
    }

    public String[] getXAxisLabels() {
        return null;
    }

    public String[] getYAxisLabels() {
        return null;
    }

    public String getTitle() {
        return this.histo.title();
    }

    public Statistics getStatistics() {
        return new AIDAHistogramStatistics2D(this.histo);
    }
}

