/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote;

import hep.aida.ref.Annotation;

public class RemoteAnnotation
extends Annotation {
    public void addItem(String key, String value) {
        this.addItem(key, value, false);
    }

    public void addItem(String key, String value, boolean sticky) {
        if (this.keyVector.contains(key)) {
            throw new IllegalArgumentException("Item " + key + " already exists");
        }
        this.keyVector.add(key);
        this.valVector.add(value);
        this.stkVector.add(new Boolean(sticky));
    }

    public void removeItem(String key) {
        if (!this.keyVector.contains(key)) {
            throw new IllegalArgumentException("Item " + key + " does not exist");
        }
        int index = this.keyVector.indexOf(key);
        if (this.isSticky(index)) {
            throw new IllegalArgumentException("Item " + key + " is sticky; it cannot be removed");
        }
        this.keyVector.remove(index);
        this.valVector.remove(index);
        this.stkVector.remove(index);
    }

    public String value(String key) {
        if (!this.keyVector.contains(key)) {
            throw new IllegalArgumentException("Item " + key + " does not exist");
        }
        int index = this.keyVector.indexOf(key);
        return (String)this.valVector.get(index);
    }

    public void setValue(String key, String value) {
        if (!this.keyVector.contains(key)) {
            throw new IllegalArgumentException("Item " + key + " does not exist");
        }
        int index = this.keyVector.indexOf(key);
        this.valVector.set(index, value);
    }

    public void setSticky(String key, boolean sticky) {
        if (!this.keyVector.contains(key)) {
            throw new IllegalArgumentException("Item " + key + " does not exist");
        }
        int index = this.keyVector.indexOf(key);
        this.stkVector.set(index, new Boolean(sticky));
    }
}

